/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.vcs.commit.CommitWorkflowManager;
import git4idea.GitVcs;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.index.GitStagingAreaSettingsListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0006\u0010\b\u001a\u00020\u0001\u001a\u000b\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u001a\u000b\u0010\f\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u00a8\u0006\r"}, d2={"canEnableStagingArea", "", "enableStagingArea", "", "enabled", "isStagingAreaAvailable", "project", "Lcom/intellij/openapi/project/Project;", "isStagingAreaEnabled", "stageLineStatusTrackerRegistryOption", "Lcom/intellij/openapi/util/registry/RegistryValue;", "Lorg/jetbrains/annotations/NotNull;", "stageLocalChangesRegistryOption", "intellij.vcs.git"})
public final class GitStageManagerKt {
    @NotNull
    public static final RegistryValue stageLineStatusTrackerRegistryOption() {
        RegistryValue registryValue = Registry.get((String)"git.enable.stage.line.status.tracker");
        Intrinsics.checkNotNullExpressionValue((Object)registryValue, (String)"Registry.get(\"git.enable\u2026age.line.status.tracker\")");
        return registryValue;
    }

    @NotNull
    public static final RegistryValue stageLocalChangesRegistryOption() {
        RegistryValue registryValue = Registry.get((String)"git.enable.stage.disable.local.changes");
        Intrinsics.checkNotNullExpressionValue((Object)registryValue, (String)"Registry.get(\"git.enable\u2026e.disable.local.changes\")");
        return registryValue;
    }

    public static final boolean isStagingAreaEnabled() {
        GitVcsApplicationSettings gitVcsApplicationSettings = GitVcsApplicationSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)gitVcsApplicationSettings, (String)"GitVcsApplicationSettings.getInstance()");
        return gitVcsApplicationSettings.isStagingAreaEnabled();
    }

    public static final void enableStagingArea(boolean enabled) {
        GitVcsApplicationSettings applicationSettings;
        GitVcsApplicationSettings gitVcsApplicationSettings = applicationSettings = GitVcsApplicationSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)gitVcsApplicationSettings, (String)"applicationSettings");
        if (enabled == gitVcsApplicationSettings.isStagingAreaEnabled()) {
            return;
        }
        applicationSettings.setStagingAreaEnabled(enabled);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        ((GitStagingAreaSettingsListener)application.getMessageBus().syncPublisher(GitStagingAreaSettingsListener.TOPIC)).settingsChanged();
    }

    public static final boolean canEnableStagingArea() {
        return CommitWorkflowManager.Companion.isNonModalInSettings();
    }

    public static final boolean isStagingAreaAvailable() {
        return GitStageManagerKt.isStagingAreaEnabled() && GitStageManagerKt.canEnableStagingArea();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isStagingAreaAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!GitStageManagerKt.isStagingAreaAvailable()) return false;
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectLevelVcsManager, (String)"ProjectLevelVcsManager.getInstance(project)");
        AbstractVcs abstractVcs = projectLevelVcsManager.getSingleVCS();
        if (!Intrinsics.areEqual((Object)(abstractVcs != null ? abstractVcs.getKeyInstanceMethod() : null), (Object)GitVcs.getKey())) return false;
        return true;
    }
}

