/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffRequestFactoryImpl;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.actions.diff.UnversionedDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.i18n.GitBundle;
import git4idea.index.ContentVersion;
import git4idea.index.GitFileStatus;
import git4idea.index.GitFileStatusKt;
import git4idea.index.GitFileStatusNodeProducerBase;
import git4idea.index.GitIndexUtil;
import git4idea.index.GitStageDiffUtilKt$WhenMappings;
import git4idea.index.HeadContentRevision;
import git4idea.index.KindTag;
import git4idea.index.MergedProducer;
import git4idea.index.StagedContentRevision;
import git4idea.index.StagedProducer;
import git4idea.index.ThreeSidesProducer;
import git4idea.index.UnStagedProducer;
import git4idea.index.ui.GitFileStatusNode;
import git4idea.index.ui.NodeKind;
import git4idea.index.vfs.GitIndexFileSystemRefresher;
import git4idea.repo.GitSubmodule;
import git4idea.util.GitFileUtils;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u001a*\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\tH\u0002\u001a\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0003\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0003\u001a \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0014\u0010\u001c\u001a\u00020\u001d*\u00020\u00112\u0006\u0010\u001e\u001a\u00020\tH\u0002\u001a\u0014\u0010\u001f\u001a\u00020 *\u00020\u00112\u0006\u0010\u001e\u001a\u00020\tH\u0002\u00a8\u0006!"}, d2={"createChange", "Lcom/intellij/openapi/vcs/changes/Change;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "status", "Lgit4idea/index/GitFileStatus;", "beforeVersion", "Lgit4idea/index/ContentVersion;", "afterVersion", "createContentRevision", "Lcom/intellij/openapi/vcs/changes/ContentRevision;", "version", "createThreeSidesDiffRequestProducer", "Lcom/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain$Producer;", "statusNode", "Lgit4idea/index/ui/GitFileStatusNode;", "createTwoSidesDiffRequestProducer", "getTitle", "", "headContentBytes", "", "headDiffContent", "Lcom/intellij/diff/contents/DiffContent;", "localDiffContent", "stagedContentFile", "stagedDiffContent", "has", "", "contentVersion", "path", "Lcom/intellij/openapi/vcs/FilePath;", "intellij.vcs.git"})
public final class GitStageDiffUtilKt {
    @Nullable
    public static final ChangeDiffRequestChain.Producer createTwoSidesDiffRequestProducer(@NotNull Project project, @NotNull GitFileStatusNode statusNode) {
        ChangeDiffRequestChain.Producer producer;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)statusNode, (String)"statusNode");
        switch (GitStageDiffUtilKt$WhenMappings.$EnumSwitchMapping$0[statusNode.getKind().ordinal()]) {
            case 1: {
                producer = new StagedProducer(project, statusNode);
                break;
            }
            case 2: {
                producer = new UnStagedProducer(project, statusNode);
                break;
            }
            case 3: {
                producer = new MergedProducer(project, statusNode);
                break;
            }
            case 4: {
                producer = (ChangeDiffRequestChain.Producer)UnversionedDiffRequestProducer.create((Project)project, (FilePath)statusNode.getFilePath(), (Object)KindTag.Companion.getTag$intellij_vcs_git(NodeKind.UNSTAGED));
                break;
            }
            case 5: {
                producer = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return producer;
    }

    @Nullable
    public static final ChangeDiffRequestChain.Producer createThreeSidesDiffRequestProducer(@NotNull Project project, @NotNull GitFileStatusNode statusNode) {
        ChangeDiffRequestChain.Producer producer;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)statusNode, (String)"statusNode");
        boolean hasThreeSides = GitStageDiffUtilKt.has(statusNode, ContentVersion.HEAD) && GitStageDiffUtilKt.has(statusNode, ContentVersion.STAGED) && GitStageDiffUtilKt.has(statusNode, ContentVersion.LOCAL);
        switch (GitStageDiffUtilKt$WhenMappings.$EnumSwitchMapping$1[statusNode.getKind().ordinal()]) {
            case 1: {
                producer = hasThreeSides ? (GitFileStatusNodeProducerBase)new ThreeSidesProducer(project, statusNode) : (GitFileStatusNodeProducerBase)new StagedProducer(project, statusNode);
                break;
            }
            case 2: {
                producer = hasThreeSides ? (GitFileStatusNodeProducerBase)new ThreeSidesProducer(project, statusNode) : (GitFileStatusNodeProducerBase)new UnStagedProducer(project, statusNode);
                break;
            }
            case 3: {
                producer = new MergedProducer(project, statusNode);
                break;
            }
            case 4: {
                producer = (ChangeDiffRequestChain.Producer)UnversionedDiffRequestProducer.create((Project)project, (FilePath)statusNode.getFilePath(), (Object)KindTag.Companion.getTag$intellij_vcs_git(NodeKind.UNSTAGED));
                break;
            }
            case 5: {
                producer = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return producer;
    }

    @Nullable
    public static final Change createChange(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitFileStatus status, @NotNull ContentVersion beforeVersion, @NotNull ContentVersion afterVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)((Object)beforeVersion), (String)"beforeVersion");
        Intrinsics.checkNotNullParameter((Object)((Object)afterVersion), (String)"afterVersion");
        ContentRevision bRev = GitStageDiffUtilKt.createContentRevision(project, root, status, beforeVersion);
        ContentRevision aRev = GitStageDiffUtilKt.createContentRevision(project, root, status, afterVersion);
        return bRev != null || aRev != null ? new Change(bRev, aRev) : null;
    }

    private static final ContentRevision createContentRevision(Project project, VirtualFile root, GitFileStatus status, ContentVersion version) {
        ContentRevision contentRevision;
        if (!GitFileStatusKt.has(status, version)) {
            return null;
        }
        switch (GitStageDiffUtilKt$WhenMappings.$EnumSwitchMapping$2[version.ordinal()]) {
            case 1: {
                contentRevision = (ContentRevision)new HeadContentRevision(project, root, status);
                break;
            }
            case 2: {
                contentRevision = (ContentRevision)new StagedContentRevision(project, root, status);
                break;
            }
            case 3: {
                contentRevision = (ContentRevision)new CurrentContentRevision(GitFileStatusKt.path(status, version));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return contentRevision;
    }

    private static final DiffContent headDiffContent(Project project, GitFileStatusNode statusNode) throws VcsException, IOException {
        if (!GitStageDiffUtilKt.has(statusNode, ContentVersion.HEAD)) {
            EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
            Intrinsics.checkNotNullExpressionValue((Object)emptyContent, (String)"DiffContentFactory.getInstance().createEmpty()");
            return (DiffContent)emptyContent;
        }
        GitSubmodule submodule = GitContentRevision.getRepositoryIfSubmodule(project, statusNode.getStatus().getPath());
        if (submodule != null) {
            Hash hash = GitIndexUtil.loadSubmoduleHashAt(submodule.getRepository(), submodule.getParent(), (VcsRevisionNumber)GitRevisionNumber.HEAD);
            if (hash == null) {
                throw (Throwable)new VcsException(DiffBundle.message((String)"error.cant.show.diff.cant.load.revision.content", (Object[])new Object[0]));
            }
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"GitIndexUtil.loadSubmodu\u2026.load.revision.content\"))");
            Hash hash2 = hash;
            DocumentContent documentContent = DiffContentFactory.getInstance().create(project, hash2.asString());
            Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"DiffContentFactory.getIn\u2026project, hash.asString())");
            return (DiffContent)documentContent;
        }
        byte[] headContent = GitStageDiffUtilKt.headContentBytes(project, statusNode.getRoot(), statusNode.getStatus());
        DiffContent diffContent = DiffContentFactoryEx.getInstanceEx().createFromBytes(project, headContent, statusNode.getFilePath());
        Intrinsics.checkNotNullExpressionValue((Object)diffContent, (String)"DiffContentFactoryEx.get\u2026ent, statusNode.filePath)");
        return diffContent;
    }

    private static final DiffContent stagedDiffContent(Project project, GitFileStatusNode statusNode) throws VcsException {
        if (!GitStageDiffUtilKt.has(statusNode, ContentVersion.STAGED)) {
            EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
            Intrinsics.checkNotNullExpressionValue((Object)emptyContent, (String)"DiffContentFactory.getInstance().createEmpty()");
            return (DiffContent)emptyContent;
        }
        GitSubmodule submodule = GitContentRevision.getRepositoryIfSubmodule(project, statusNode.getStatus().getPath());
        if (submodule != null) {
            Hash hash = GitIndexUtil.loadStagedSubmoduleHash(submodule.getRepository(), submodule.getParent());
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"GitIndexUtil.loadStagedS\u2026sitory, submodule.parent)");
            Hash hash2 = hash;
            DocumentContent documentContent = DiffContentFactory.getInstance().create(project, hash2.asString());
            Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"DiffContentFactory.getIn\u2026project, hash.asString())");
            return (DiffContent)documentContent;
        }
        VirtualFile indexFile = GitStageDiffUtilKt.stagedContentFile(project, statusNode.getRoot(), statusNode.getStatus());
        DiffContent diffContent = DiffContentFactory.getInstance().create(project, indexFile);
        Intrinsics.checkNotNullExpressionValue((Object)diffContent, (String)"DiffContentFactory.getIn\u2026reate(project, indexFile)");
        return diffContent;
    }

    private static final DiffContent localDiffContent(Project project, GitFileStatusNode statusNode) throws VcsException {
        if (!GitStageDiffUtilKt.has(statusNode, ContentVersion.LOCAL)) {
            EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
            Intrinsics.checkNotNullExpressionValue((Object)emptyContent, (String)"DiffContentFactory.getInstance().createEmpty()");
            return (DiffContent)emptyContent;
        }
        GitSubmodule submodule = GitContentRevision.getRepositoryIfSubmodule(project, statusNode.getStatus().getPath());
        if (submodule != null) {
            String string = submodule.getRepository().getCurrentRevision();
            if (string == null) {
                throw (Throwable)new VcsException(DiffBundle.message((String)"error.cant.show.diff.cant.load.revision.content", (Object[])new Object[0]));
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"submodule.repository.cur\u2026.load.revision.content\"))");
            String revision = string;
            DocumentContent documentContent = DiffContentFactory.getInstance().create(project, revision);
            Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"DiffContentFactory.getIn\u2026create(project, revision)");
            return (DiffContent)documentContent;
        }
        VirtualFile virtualFile = GitStageDiffUtilKt.path(statusNode, ContentVersion.LOCAL).getVirtualFile();
        if (virtualFile == null) {
            throw (Throwable)new VcsException(GitBundle.message("stage.diff.local.content.exception.message", statusNode.getFilePath()));
        }
        VirtualFile localFile = virtualFile;
        DiffContent diffContent = DiffContentFactory.getInstance().create(project, localFile);
        Intrinsics.checkNotNullExpressionValue((Object)diffContent, (String)"DiffContentFactory.getIn\u2026reate(project, localFile)");
        return diffContent;
    }

    private static final byte[] headContentBytes(Project project, VirtualFile root, GitFileStatus status) throws VcsException {
        FilePath filePath = GitFileStatusKt.path(status, ContentVersion.HEAD);
        byte[] byArray = GitFileUtils.getFileContent(project, root, "HEAD", VcsFileUtil.relativePath((VirtualFile)root, (FilePath)filePath));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"GitFileUtils.getFileCont\u2026tivePath(root, filePath))");
        return byArray;
    }

    private static final VirtualFile stagedContentFile(Project project, VirtualFile root, GitFileStatus statusNode) throws VcsException {
        FilePath filePath = GitFileStatusKt.path(statusNode, ContentVersion.STAGED);
        return GitIndexFileSystemRefresher.Companion.getInstance(project).getFile(root, filePath);
    }

    private static final boolean has(GitFileStatusNode $this$has, ContentVersion contentVersion) {
        return GitFileStatusKt.has($this$has.getStatus(), contentVersion);
    }

    private static final FilePath path(GitFileStatusNode $this$path, ContentVersion contentVersion) {
        return GitFileStatusKt.path($this$path.getStatus(), contentVersion);
    }

    @Nls
    private static final String getTitle(GitFileStatusNode statusNode) {
        String string = DiffRequestFactoryImpl.getTitle((FilePath)statusNode.getFilePath(), (FilePath)statusNode.getOrigPath(), (String)" -> ");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DiffRequestFactoryImpl.g\u2026F_TITLE_RENAME_SEPARATOR)");
        return string;
    }

    @Nls
    private static final String getTitle(GitFileStatus status) {
        String string = DiffRequestFactoryImpl.getTitle((FilePath)status.getPath(), (FilePath)status.getOrigPath(), (String)" -> ");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DiffRequestFactoryImpl.g\u2026F_TITLE_RENAME_SEPARATOR)");
        return string;
    }

    public static final /* synthetic */ DiffContent access$stagedDiffContent(Project project, GitFileStatusNode statusNode) {
        return GitStageDiffUtilKt.stagedDiffContent(project, statusNode);
    }

    public static final /* synthetic */ DiffContent access$localDiffContent(Project project, GitFileStatusNode statusNode) {
        return GitStageDiffUtilKt.localDiffContent(project, statusNode);
    }

    public static final /* synthetic */ String access$getTitle(GitFileStatusNode statusNode) {
        return GitStageDiffUtilKt.getTitle(statusNode);
    }

    public static final /* synthetic */ DiffContent access$headDiffContent(Project project, GitFileStatusNode statusNode) {
        return GitStageDiffUtilKt.headDiffContent(project, statusNode);
    }

    public static final /* synthetic */ String access$getTitle(GitFileStatus status) {
        return GitStageDiffUtilKt.getTitle(status);
    }

    public static final /* synthetic */ byte[] access$headContentBytes(Project project, VirtualFile root, GitFileStatus status) {
        return GitStageDiffUtilKt.headContentBytes(project, root, status);
    }

    public static final /* synthetic */ VirtualFile access$stagedContentFile(Project project, VirtualFile root, GitFileStatus statusNode) {
        return GitStageDiffUtilKt.stagedContentFile(project, root, statusNode);
    }
}

