/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableConsumer;
import git4idea.checkin.GitCheckinEnvironment;
import git4idea.checkin.GitCommitOptions;
import git4idea.checkin.GitRepositoryCommitterKt;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.repo.GitRepository;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lgit4idea/checkin/GitRepositoryCommitter;", "", "repository", "Lgit4idea/repo/GitRepository;", "commitOptions", "Lgit4idea/checkin/GitCommitOptions;", "(Lgit4idea/repo/GitRepository;Lgit4idea/checkin/GitCommitOptions;)V", "getCommitOptions", "()Lgit4idea/checkin/GitCommitOptions;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRepository", "()Lgit4idea/repo/GitRepository;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "commitStaged", "", "messageFile", "Ljava/io/File;", "commitMessage", "", "intellij.vcs.git"})
public final class GitRepositoryCommitter {
    @NotNull
    private final GitRepository repository;
    @NotNull
    private final GitCommitOptions commitOptions;

    @NotNull
    public final Project getProject() {
        Project project = this.repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"repository.project");
        return project;
    }

    @NotNull
    public final VirtualFile getRoot() {
        VirtualFile virtualFile = this.repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repository.root");
        return virtualFile;
    }

    public final void commitStaged(@NotNull String commitMessage) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
        GitCheckinEnvironment.runWithMessageFile(this.getProject(), this.getRoot(), commitMessage, (ThrowableConsumer<? super File, ? extends VcsException>)((ThrowableConsumer)new ThrowableConsumer<File, VcsException>(this){
            final /* synthetic */ GitRepositoryCommitter this$0;

            public final void consume(File messageFile) {
                File file = messageFile;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"messageFile");
                this.this$0.commitStaged(file);
            }
            {
                this.this$0 = gitRepositoryCommitter;
            }
        }));
    }

    public final void commitStaged(@NotNull File messageFile) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)messageFile, (String)"messageFile");
        GitLineHandler handler = new GitLineHandler(this.getProject(), this.getRoot(), GitCommand.COMMIT);
        handler.setStdoutSuppressed(false);
        GitRepositoryCommitterKt.access$setCommitMessage(handler, messageFile);
        GitRepositoryCommitterKt.access$setCommitOptions(handler, this.commitOptions);
        handler.endOptions();
        Git.getInstance().runCommand(handler).throwOnError(new int[0]);
    }

    @NotNull
    public final GitRepository getRepository() {
        return this.repository;
    }

    @NotNull
    public final GitCommitOptions getCommitOptions() {
        return this.commitOptions;
    }

    public GitRepositoryCommitter(@NotNull GitRepository repository, @NotNull GitCommitOptions commitOptions) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commitOptions, (String)"commitOptions");
        this.repository = repository;
        this.commitOptions = commitOptions;
    }
}

