/*
 * Decompiled with CFR 0.152.
 */
package processing.app.linux;

import java.io.File;
import javax.swing.UIManager;
import processing.app.Base;
import processing.app.Preferences;

public class Platform
extends processing.app.Platform {
    public void init(Base base) {
        super.init(base);
        String javaVendor = System.getProperty("java.vendor");
        String javaVM = System.getProperty("java.vm.name");
        if (javaVendor == null || !javaVendor.contains("Sun") && !javaVendor.contains("Oracle") || javaVM == null || !javaVM.contains("Java")) {
            Base.showWarning("Not fond of this Java VM", "Processing requires Java 6 from Sun (i.e. the sun-java-jdk\npackage on Ubuntu). Other versions such as OpenJDK, IcedTea,\nand GCJ are strongly discouraged. Among other things, you're\nlikely to run into problems with sketch window size and\nplacement. For more background, please read the wiki:\nhttp://wiki.processing.org/w/Supported_Platforms#Linux", null);
        }
    }

    public void setLookAndFeel() throws Exception {
        UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
    }

    public void openURL(String url) throws Exception {
        String launcher;
        if (this.openFolderAvailable() && (launcher = Preferences.get("launcher")) != null) {
            Runtime.getRuntime().exec(new String[]{launcher, url});
        }
    }

    public boolean openFolderAvailable() {
        if (Preferences.get("launcher") != null) {
            return true;
        }
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"xdg-open"});
            p.waitFor();
            Preferences.set("launcher", "xdg-open");
            return true;
        }
        catch (Exception e) {
            try {
                Process p = Runtime.getRuntime().exec(new String[]{"gnome-open"});
                p.waitFor();
                Preferences.set("launcher", "gnome-open");
                return true;
            }
            catch (Exception e2) {
                try {
                    Process p = Runtime.getRuntime().exec(new String[]{"kde-open"});
                    p.waitFor();
                    Preferences.set("launcher", "kde-open");
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
    }

    public void openFolder(File file) throws Exception {
        if (this.openFolderAvailable()) {
            String lunch = Preferences.get("launcher");
            try {
                String[] params = new String[]{lunch, file.getAbsolutePath()};
                Runtime.getRuntime().exec(params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("No launcher set, cannot open " + file.getAbsolutePath());
        }
    }
}

