/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Library;
import processing.app.Preferences;
import processing.app.Settings;
import processing.app.SketchCode;
import processing.app.SketchReference;
import processing.app.syntax.PdeKeywords;
import processing.app.syntax.SyntaxStyle;
import processing.app.syntax.TokenMarker;

public abstract class Mode {
    protected Base base;
    protected File folder;
    protected HashMap<String, String> keywordToReference;
    protected PdeKeywords tokenMarker;
    protected Settings theme;
    protected HashMap<String, Library> importToLibraryTable;
    protected JMenu examplesMenu;
    protected JMenu importMenu;
    protected JFrame examplesFrame;
    protected JMenu toolbarMenu;
    protected File examplesFolder;
    protected File librariesFolder;
    protected File referenceFolder;
    protected ArrayList<Library> coreLibraries;
    protected ArrayList<Library> contribLibraries;

    public Mode(Base base, File folder) {
        this.base = base;
        this.folder = folder;
        this.examplesFolder = new File(folder, "examples");
        this.librariesFolder = new File(folder, "libraries");
        this.referenceFolder = new File(folder, "reference");
        this.rebuildLibraryList();
        try {
            this.theme = new Settings(new File(folder, "theme/theme.txt"));
        }
        catch (IOException e) {
            Base.showError("Problem loading theme.txt", "Could not load theme.txt, please re-install Processing", e);
        }
    }

    public File getContentFile(String path) {
        return new File(this.folder, path);
    }

    public InputStream getContentStream(String path) throws FileNotFoundException {
        return new FileInputStream(this.getContentFile(path));
    }

    public abstract String getTitle();

    public abstract Editor createEditor(Base var1, String var2, int[] var3);

    public File getExamplesFolder() {
        return this.examplesFolder;
    }

    public File getLibrariesFolder() {
        return this.librariesFolder;
    }

    public File getReferenceFolder() {
        return this.referenceFolder;
    }

    public void rebuildLibraryList() {
        this.importToLibraryTable = new HashMap();
        try {
            this.coreLibraries = Library.list(this.librariesFolder);
            this.contribLibraries = Library.list(this.base.getSketchbookLibrariesFolder());
            for (Library lib : this.coreLibraries) {
                lib.addPackageList(this.importToLibraryTable);
            }
            for (Library lib : this.contribLibraries) {
                lib.addPackageList(this.importToLibraryTable);
            }
        }
        catch (IOException e) {
            Base.showWarning("Unhappiness", "An error occurred while loading libraries.\nNot all the books will be in place.", e);
        }
    }

    public Library getLibrary(String name) {
        return this.importToLibraryTable.get(name);
    }

    public JMenu getToolbarMenu() {
        if (this.toolbarMenu == null) {
            this.rebuildToolbarMenu();
        }
        return this.toolbarMenu;
    }

    protected void rebuildToolbarMenu() {
        if (this.toolbarMenu == null) {
            this.toolbarMenu = new JMenu();
        } else {
            this.toolbarMenu.removeAll();
        }
        JMenuItem item = Base.newJMenuItem("Open...", 79);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Mode.this.base.handleOpenPrompt();
            }
        });
        this.toolbarMenu.add(item);
        item = new JMenuItem("Examples...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Mode.this.showExamplesFrame();
            }
        });
        this.toolbarMenu.add(item);
        this.toolbarMenu.addSeparator();
        try {
            this.base.addSketches(this.toolbarMenu, this.base.getSketchbookFolder(), true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JMenu getImportMenu() {
        if (this.importMenu == null) {
            this.rebuildImportMenu();
        }
        return this.importMenu;
    }

    public void rebuildImportMenu() {
        if (this.importMenu == null) {
            this.importMenu = new JMenu("Import Library...");
        } else {
            this.importMenu.removeAll();
        }
        this.rebuildLibraryList();
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Mode.this.base.activeEditor.handleImportLibrary(e.getActionCommand());
            }
        };
        if (this.coreLibraries.size() == 0) {
            JMenuItem item = new JMenuItem(this.getTitle() + " mode has no core libraries");
            item.setEnabled(false);
            this.importMenu.add(item);
        } else {
            for (Library library : this.coreLibraries) {
                JMenuItem item = new JMenuItem(library.getName());
                item.addActionListener(listener);
                item.setActionCommand(library.getJarPath());
                this.importMenu.add(item);
            }
        }
        if (this.contribLibraries.size() != 0) {
            this.importMenu.addSeparator();
            JMenuItem contrib = new JMenuItem("Contributed");
            contrib.setEnabled(false);
            this.importMenu.add(contrib);
            HashMap<String, JMenu> subfolders = new HashMap<String, JMenu>();
            for (Library library : this.contribLibraries) {
                JMenuItem item = new JMenuItem(library.getName());
                item.addActionListener(listener);
                item.setActionCommand(library.getJarPath());
                String group = library.getGroup();
                if (group != null) {
                    JMenu subMenu = (JMenu)subfolders.get(group);
                    if (subMenu == null) {
                        subMenu = new JMenu(group);
                        this.importMenu.add(subMenu);
                        subfolders.put(group, subMenu);
                    }
                    subMenu.add(item);
                    continue;
                }
                this.importMenu.add(item);
            }
        }
    }

    public File[] getExampleCategoryFolders() {
        return this.examplesFolder.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return dir.isDirectory() && name.charAt(0) != '.';
            }
        });
    }

    public JTree buildExamplesTree() {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Examples");
        JTree examplesTree = new JTree(node);
        try {
            File[] subfolders;
            for (File sub : subfolders = this.getExampleCategoryFolders()) {
                DefaultMutableTreeNode subNode = new DefaultMutableTreeNode(sub.getName());
                if (!this.base.addSketches(subNode, sub)) continue;
                node.add(subNode);
            }
            boolean any = false;
            DefaultMutableTreeNode libParent = new DefaultMutableTreeNode("Libraries");
            for (Library lib : this.coreLibraries) {
                if (!lib.hasExamples()) continue;
                DefaultMutableTreeNode libNode = new DefaultMutableTreeNode(lib.getName());
                any |= this.base.addSketches(libNode, lib.getExamplesFolder());
                libParent.add(libNode);
            }
            if (any) {
                node.add(libParent);
            }
            any = false;
            for (Library lib : this.contribLibraries) {
                if (!lib.hasExamples()) continue;
                any = true;
            }
            if (any) {
                DefaultMutableTreeNode contribParent = new DefaultMutableTreeNode("Contributed Libraries");
                for (Library lib : this.contribLibraries) {
                    if (!lib.hasExamples()) continue;
                    DefaultMutableTreeNode libNode = new DefaultMutableTreeNode(lib.getName());
                    this.base.addSketches(libNode, lib.getExamplesFolder());
                    contribParent.add(libNode);
                }
                node.add(contribParent);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return examplesTree;
    }

    public void resetExamples() {
        if (this.examplesFrame != null) {
            boolean visible = this.examplesFrame.isVisible();
            Rectangle bounds = null;
            if (visible) {
                bounds = this.examplesFrame.getBounds();
                this.examplesFrame.setVisible(false);
            }
            this.examplesFrame = null;
            if (visible) {
                this.showExamplesFrame();
                this.examplesFrame.setBounds(bounds);
            }
        }
    }

    public void showExamplesFrame() {
        if (this.examplesFrame == null) {
            this.examplesFrame = new JFrame(this.getTitle() + " Examples");
            final JTree tree = this.buildExamplesTree();
            tree.getSelectionModel().setSelectionMode(1);
            tree.setShowsRootHandles(true);
            tree.expandRow(0);
            tree.setRootVisible(false);
            for (int row = tree.getRowCount() - 1; row >= 0; --row) {
                tree.expandRow(row);
            }
            tree.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    DefaultMutableTreeNode node;
                    if (e.getClickCount() > 1 && (node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent()) != null && node.isLeaf()) {
                        SketchReference sketch = (SketchReference)node.getUserObject();
                        Mode.this.base.handleOpen(sketch.getPath());
                    }
                }
            });
            tree.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() == '\n') {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                        if (node != null && node.isLeaf()) {
                            SketchReference sketch = (SketchReference)node.getUserObject();
                            Mode.this.base.handleOpen(sketch.getPath());
                        }
                    } else if (e.getKeyChar() == '\u001b') {
                        Mode.this.examplesFrame.setVisible(false);
                    }
                }
            });
            tree.setBorder(new EmptyBorder(5, 5, 5, 5));
            JScrollPane treeView = new JScrollPane(tree);
            treeView.setPreferredSize(new Dimension(250, 450));
            this.examplesFrame.add(treeView);
            this.examplesFrame.pack();
        }
        if (this.base.activeEditor != null) {
            Point p = this.base.activeEditor.getLocation();
            this.examplesFrame.setLocation(p.x - this.examplesFrame.getWidth() - 20, p.y);
        } else {
            this.examplesFrame.setLocationRelativeTo(null);
        }
        this.examplesFrame.setVisible(true);
    }

    public Image loadImage(String filename) {
        File file = new File(this.folder, filename);
        return new ImageIcon(file.getAbsolutePath()).getImage();
    }

    public String lookupReference(String keyword) {
        return this.keywordToReference.get(keyword);
    }

    public TokenMarker getTokenMarker() {
        return this.tokenMarker;
    }

    public boolean getBoolean(String attribute) {
        return this.theme.getBoolean(attribute);
    }

    public int getInteger(String attribute) {
        return this.theme.getInteger(attribute);
    }

    public Color getColor(String attribute) {
        return this.theme.getColor(attribute);
    }

    public Font getFont(String attribute) {
        return this.theme.getFont(attribute);
    }

    public SyntaxStyle getStyle(String attribute) {
        return this.theme.getStyle(attribute);
    }

    public boolean hideExtension(String what) {
        return what.equals(this.getDefaultExtension());
    }

    public boolean isDefaultExtension(SketchCode code) {
        return code.getExtension().equals(this.getDefaultExtension());
    }

    public boolean isDefaultExtension(String what) {
        return what.equals(this.getDefaultExtension());
    }

    public boolean validExtension(String what) {
        String[] ext = this.getExtensions();
        for (int i = 0; i < ext.length; ++i) {
            if (!ext[i].equals(what)) continue;
            return true;
        }
        return false;
    }

    public abstract String getDefaultExtension();

    public abstract String[] getExtensions();

    public abstract String[] getIgnorable();

    public void prepareExportFolder(File targetFolder) {
        if (targetFolder != null) {
            if (Preferences.getBoolean("export.delete_target_folder")) {
                Base.removeDir(targetFolder);
            }
            targetFolder.mkdirs();
        }
    }
}

