/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.google.common.base.Charsets;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class Messages {
    private static final String BUNDLE_NAME = "com.adobe.epubcheck.util.messages";
    private static final Table<String, String, Messages> messageTable = HashBasedTable.create();
    private ResourceBundle bundle;
    private Locale locale;

    public static Messages getInstance() {
        return Messages.getInstance(null, null);
    }

    public static Messages getInstance(Locale locale) {
        return Messages.getInstance(locale, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Messages getInstance(Locale locale, Class<?> cls) {
        String localeKey;
        Messages instance = null;
        String bundleKey = cls == null ? BUNDLE_NAME : Messages.getBundleName(cls);
        if (messageTable.contains((Object)bundleKey, (Object)(localeKey = (locale = locale == null ? Locale.getDefault() : locale).getLanguage()))) {
            return (Messages)messageTable.get((Object)bundleKey, (Object)localeKey);
        }
        Class<Messages> clazz = Messages.class;
        synchronized (Messages.class) {
            if (instance != null) return instance;
            instance = new Messages(locale, bundleKey);
            messageTable.put((Object)bundleKey, (Object)localeKey, (Object)instance);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return instance;
        }
    }

    private static String getBundleName(Class<?> cls) {
        String className = cls.getName();
        int i = className.lastIndexOf(46);
        return (i > 0 ? className.substring(0, i + 1) : "") + "messages";
    }

    protected Messages() {
        this(null);
    }

    protected Messages(Locale locale) {
        this(locale, BUNDLE_NAME);
    }

    protected Messages(Locale locale, String bundleName) {
        this.locale = locale != null ? locale : Locale.getDefault();
        this.bundle = ResourceBundle.getBundle(bundleName, this.locale, new UTF8Control());
    }

    public String get(String key) {
        try {
            return this.bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public String get(String key, Object ... arguments) {
        return MessageFormat.format(this.get(key), arguments);
    }

    public Locale getLocale() {
        return this.locale;
    }

    private class UTF8Control
    extends ResourceBundle.Control {
        private UTF8Control() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            PropertyResourceBundle bundle = null;
            InputStream stream = null;
            if (reload) {
                URLConnection connection;
                URL url = loader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = loader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                try {
                    bundle = new PropertyResourceBundle(new BufferedReader(new InputStreamReader(stream, Charsets.UTF_8)));
                }
                finally {
                    stream.close();
                }
            }
            return bundle;
        }
    }
}

