/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ctc.epubpackage.EpubPackage;
import com.adobe.epubcheck.ctc.epubpackage.ManifestItem;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.util.FeatureEnum;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EpubRenditionCheck
implements DocumentValidator {
    private final Document doc;
    private final EpubPackage epack;
    private final Report report;

    public EpubRenditionCheck(EpubPackage epack, Report report) {
        this.epack = epack;
        this.doc = epack.getPackDoc();
        this.report = report;
    }

    @Override
    public boolean validate() {
        return this.isRenditionDefined(this.doc);
    }

    private boolean isRenditionDefined(Document doc) {
        NodeList mList;
        boolean result = false;
        NodeList nList = doc.getElementsByTagName("metadata");
        if (nList.getLength() > 0) {
            Node metadata = nList.item(0);
            NodeList metaNodes = metadata.getChildNodes();
            for (int i = 0; i < metaNodes.getLength(); ++i) {
                if (metaNodes.item(i).getNodeName().compareToIgnoreCase("meta") != 0) continue;
                Node n = metaNodes.item(i);
                String nodeValue = n.hasChildNodes() ? n.getFirstChild().getNodeValue() : n.getNodeValue();
                NamedNodeMap attrs = n.getAttributes();
                Node p = attrs.getNamedItem("property");
                if (p == null) continue;
                if (p.getNodeValue().contains("rendition:layout")) {
                    this.report.info(null, FeatureEnum.RENDITION_LAYOUT, nodeValue);
                    result = true;
                }
                if (p.getNodeValue().contains("rendition:orientation")) {
                    this.report.info(null, FeatureEnum.RENDITION_ORIENTATION, nodeValue);
                    result = true;
                }
                if (!p.getNodeValue().contains("rendition:spread")) continue;
                this.report.info(null, FeatureEnum.RENDITION_SPREAD, nodeValue);
                result = true;
            }
        }
        if ((mList = doc.getElementsByTagName("spine")).getLength() > 0) {
            Node manifest = mList.item(0);
            NodeList itemNodes = manifest.getChildNodes();
            String renditionLayout = "rendition:layout-";
            String renditionOrientation = "rendition:orientation-";
            String renditionSpread = "rendition:spread-";
            for (int i = 0; i < itemNodes.getLength(); ++i) {
                if (itemNodes.item(i).getNodeName().compareToIgnoreCase("itemref") != 0) continue;
                Node n = itemNodes.item(i);
                NamedNodeMap attrs = n.getAttributes();
                Node p = attrs.getNamedItem("properties");
                Node idrefNode = attrs.getNamedItem("idref");
                String href = "";
                if (idrefNode != null) {
                    String idref = idrefNode.getNodeValue();
                    ManifestItem manifestItem = this.epack.getManifest().getItem(idref);
                    if (manifestItem != null) {
                        href = this.epack.getManifestItemFileName(manifestItem);
                    }
                }
                if (p == null) continue;
                String nodeValue = p.hasChildNodes() ? p.getFirstChild().getNodeValue() : p.getNodeValue();
                if (p.getNodeValue().contains(renditionLayout)) {
                    this.report.info(href, FeatureEnum.RENDITION_LAYOUT, nodeValue.substring(renditionLayout.length()));
                    result = true;
                }
                if (p.getNodeValue().contains(renditionOrientation)) {
                    this.report.info(href, FeatureEnum.RENDITION_ORIENTATION, nodeValue.substring(renditionOrientation.length()));
                    result = true;
                }
                if (!p.getNodeValue().contains(renditionSpread)) continue;
                this.report.info(href, FeatureEnum.RENDITION_SPREAD, nodeValue.substring(renditionSpread.length()));
                result = true;
            }
        }
        return result;
    }
}

