/*	$OpenBSD: ogxreg.h,v 1.1 2019/11/04 14:58:40 visa Exp $	*/

/*
 * Copyright (c) 2019 Visa Hankala
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _OGXREG_H_
#define _OGXREG_H_

#define BGX_CMR_CONFIG			0x00000
#define   BGX_CMR_CONFIG_ENABLE			0x0000000000008000ULL
#define   BGX_CMR_CONFIG_DATA_PKT_RX_EN		0x0000000000004000ULL
#define   BGX_CMR_CONFIG_DATA_PKT_TX_EN		0x0000000000002000ULL
#define   BGX_CMR_CONFIG_INT_BEAT_GEN		0x0000000000001000ULL
#define   BGX_CMR_CONFIG_MIX_EN			0x0000000000000800ULL
#define   BGX_CMR_CONFIG_LMAC_TYPE_M		0x0000000000000700ULL
#define   BGX_CMR_CONFIG_LMAC_TYPE_S		8
#define   BGX_CMR_CONFIG_LANE_TO_SDS		0x00000000000000ffULL

#define BGX_CMR_RX_ID_MAP		0x00028
#define   BGX_CMR_RX_ID_MAP_RID_M		0x0000000000007f00ULL
#define   BGX_CMR_RX_ID_MAP_RID_S		8
#define   BGX_CMR_RX_ID_MAP_PKND_M		0x00000000000000ffULL
#define   BGX_CMR_RX_ID_MAP_PKND_S		0

#define BGX_CMR_RX_ADR_CTL		0x000a0
#define   BGX_CMR_RX_ADR_CTL_CAM_ACCEPT		0x0000000000000008ULL
#define   BGX_CMR_RX_ADR_CTL_MCST_MODE		0x0000000000000006ULL
#define   BGX_CMR_RX_ADR_CTL_MCST_MODE_ALL	0x0000000000000002ULL
#define   BGX_CMR_RX_ADR_CTL_MCST_MODE_CAM	0x0000000000000004ULL
#define   BGX_CMR_RX_ADR_CTL_BCST_ACCEPT	0x0000000000000001ULL

#define BGX_CMR_RX_FIFO_LEN		0x000c0

#define BGX_CMR_RX_ADR_CAM(i)		(0x00100 + (i) * 8)
#define   BGX_CMR_RX_ADR_CAM_ID			0x0030000000000000ULL
#define   BGX_CMR_RX_ADR_CAM_ID_S		52
#define   BGX_CMR_RX_ADR_CAM_EN			0x0001000000000000ULL
#define   BGX_CMR_RX_ADR_CAM_ADR		0x0000ffffffffffffULL

#define BGX_CMR_CHAN_MSK_AND		0x00200
#define BGX_CMR_CHAN_MSK_OR		0x00208

#define BGX_CMR_RX_LMACS		0x00308

#define BGX_CMR_TX_FIFO_LEN		0x00418

#define BGX_CMR_TX_LMACS		0x01000
#define   BGX_CMR_TX_LMACS_NUM_M		0x0000000000000007ULL
#define   BGX_CMR_TX_LMACS_NUM_S		0

#define BGX_GMP_PCS_MR_CONTROL		0x30000
#define   BGX_GMP_PCS_MR_CONTROL_RESET		0x0000000000008000ULL
#define   BGX_GMP_PCS_MR_CONTROL_LOOPBCK1	0x0000000000004000ULL
#define   BGX_GMP_PCS_MR_CONTROL_SPDLSB		0x0000000000002000ULL
#define   BGX_GMP_PCS_MR_CONTROL_AN_EN		0x0000000000001000ULL
#define   BGX_GMP_PCS_MR_CONTROL_PWR_DN		0x0000000000000800ULL
#define   BGX_GMP_PCS_MR_CONTROL_RST_AN		0x0000000000000200ULL
#define   BGX_GMP_PCS_MR_CONTROL_DUP		0x0000000000000100ULL
#define   BGX_GMP_PCS_MR_CONTROL_COLTST		0x0000000000000080ULL
#define   BGX_GMP_PCS_MR_CONTROL_SPDMSB		0x0000000000000040ULL
#define   BGX_GMP_PCS_MR_CONTROL_UNI		0x0000000000000020ULL

#define BGX_GMP_PCS_MR_STATUS		0x30008
#define   BGX_GMP_PCS_MR_STATUS_AN_CPT		0x0000000000000020ULL

#define BGX_GMP_PCS_LINK_TIMER		0x30040
#define   BGX_GMP_PCS_LINK_TIMER_COUNT_M	0x000000000000ffffULL

#define BGX_GMP_PCS_RX_SYNC		0x30050

#define BGX_GMP_SGM_LP_ADV		0x30070

#define BGX_GMP_PCS_MISC_CTL		0x30078
#define   BGX_GMP_PCS_MISC_CTL_SGMII		0x0000000000001000ULL
#define   BGX_GMP_PCS_MISC_CTL_GMXENO		0x0000000000000800ULL
#define   BGX_GMP_PCS_MISC_CTL_LOOPBCK2		0x0000000000000400ULL
#define   BGX_GMP_PCS_MISC_CTL_MAC_PHY		0x0000000000000200ULL
#define   BGX_GMP_PCS_MISC_CTL_MODE		0x0000000000000100ULL
#define   BGX_GMP_PCS_MISC_CTL_AN_OVRD		0x0000000000000080ULL
#define   BGX_GMP_PCS_MISC_CTL_SAMP_PT_M	0x000000000000007fULL
#define   BGX_GMP_PCS_MISC_CTL_SAMP_PT_S	0

#define BGX_GMP_PCS_INT			0x30080

#define BGX_GMP_GMI_PRT_CFG		0x38010
#define   BGX_GMP_GMI_PRT_CFG_TX_IDLE		0x0000000000002000ULL
#define   BGX_GMP_GMI_PRT_CFG_RX_IDLE		0x0000000000001000ULL
#define   BGX_GMP_GMI_PRT_CFG_SPEED_MSB		0x0000000000000100ULL
#define   BGX_GMP_GMI_PRT_CFG_SLOTTIME		0x0000000000000008ULL
#define   BGX_GMP_GMI_PRT_CFG_DUPLEX		0x0000000000000004ULL
#define   BGX_GMP_GMI_PRT_CFG_SPEED		0x0000000000000002ULL

#define BGX_GMP_GMI_TX_THRESH		0x38210
#define   BGX_GMP_GMI_TX_THRESH_M		0x00000000000007ffULL

#define BGX_GMP_GMI_TX_APPEND		0x38218
#define   BGX_GMP_GMI_TX_APPEND_FORCE_FCS	0x0000000000000008ULL
#define   BGX_GMP_GMI_TX_APPEND_FCS		0x0000000000000004ULL
#define   BGX_GMP_GMI_TX_APPEND_PAD		0x0000000000000002ULL
#define   BGX_GMP_GMI_TX_APPEND_PREAMBLE	0x0000000000000001ULL

#define BGX_GMP_GMI_TX_SLOT		0x38220
#define   BGX_GMP_GMI_TX_SLOT_M			0x000000000000ffffULL

#define BGX_GMP_GMI_TX_BURST		0x38228
#define   BGX_GMP_GMI_TX_BURST_M		0x000000000000ffffULL

#define BGX_GMP_GMI_TX_MIN_PKT		0x38240
#define   BGX_GMP_GMI_TX_MIN_PKT_M		0x00000000000000ffULL

#define BGX_GMP_GMI_TX_SGMII_CTL	0x38300
#define   BGX_GMP_GMI_TX_SGMII_CTL_ALIGN	0x0000000000000001ULL

#define FPA3_BASE		0x0001280000000000ULL
#define FPA3_SIZE		0x0000000100000000ULL

#define FPA3_LD_IO				0x0001000000000000ULL
#define FPA3_LD_DID				0x0000290000000000ULL
#define FPA3_LD_NODE_M				0x000000f000000000ULL
#define FPA3_LD_NODE_S				36
#define FPA3_LD_RED				0x0000000800000000ULL
#define FPA3_LD_AURA_M				0x0000000003ff0000ULL
#define FPA3_LD_AURA_S				16

#define FPA3_ST_IO				0x0001000000000000ULL
#define FPA3_ST_DID_FPA				0x0000290000000000ULL
#define FPA3_ST_DID_M				0x0000ff0000000000ULL
#define FPA3_ST_NODE_M				0x000000f000000000ULL
#define FPA3_ST_NODE_S				36
#define FPA3_ST_AURA_M				0x0000000003ff0000ULL
#define FPA3_ST_AURA_S				16
#define FPA3_ST_FABS				0x0000000000008000ULL
#define FPA3_ST_DWB_COUNT_M			0x0000000000000ff8ULL
#define FPA3_ST_DWB_COUNT_S			3

#define FPA3_POOL_CFG(i)		(0x10000000ULL + (i) * 8)
#define   FPA3_POOL_CFG_ENA			0x0000000000000001ULL
#define FPA3_POOL_START_ADDR(i)		(0x10500000ULL + (i) * 8)
#define FPA3_POOL_END_ADDR(i)		(0x10600000ULL + (i) * 8)
#define FPA3_POOL_STACK_BASE(i)		(0x10700000ULL + (i) * 8)
#define FPA3_POOL_STACK_END(i)		(0x10800000ULL + (i) * 8)
#define FPA3_POOL_STACK_ADDR(i)		(0x10900000ULL + (i) * 8)

#define FPA3_AURA_POOL(i)		(0x20000000ULL + (i) * 8)
#define FPA3_AURA_CFG(i)		(0x20100000ULL + (i) * 8)
#define FPA3_AURA_CNT(i)		(0x20200000ULL + (i) * 8)
#define FPA3_AURA_CNT_LIMIT(i)		(0x20400000ULL + (i) * 8)
#define FPA3_AURA_CNT_THRESHOLD(i)	(0x20500000ULL + (i) * 8)
#define FPA3_AURA_CNT_INT(i)		(0x20600000ULL + (i) * 8)
#define FPA3_AURA_POOL_LEVELS(i)	(0x20700000ULL + (i) * 8)
#define FPA3_AURA_CNT_LEVELS(i)		(0x20800000ULL + (i) * 8)

/*
 * PKO3 registers
 */

#define PKO3_BASE		0x0001540000000000ULL
#define PKO3_SIZE		0x0000000001000000ULL

#define PKO3_LD_IO				0x0001000000000000ULL
#define PKO3_LD_DID				0x0000510000000000ULL
#define PKO3_LD_NODE_M				0x000000f000000000ULL
#define PKO3_LD_NODE_S				36
#define PKO3_LD_OP_M				0x0000000300000000ULL
#define PKO3_LD_OP_S				32
#define PKO3_LD_DQ_M				0x0000000003ff0000ULL
#define PKO3_LD_DQ_S				16

#define PKO3_CHANNEL_LEVEL		(0x000800f0ULL)

#define PKO3_L1_SQ_SHAPE(i)		(0x00000010ULL + (i) * 512)
#define   PKO3_L1_SQ_SHAPE_LINK_M		0x000000000003e000ULL
#define   PKO3_L1_SQ_SHAPE_LINK_S		13

#define PKO3_L2_SQ_SHAPE(i)		(0x00080010ULL + (i) * 512)
#define PKO3_L3_SQ_SHAPE(i)		(0x00100010ULL + (i) * 512)

#define PKO3_L1_SQ_LINK(i)		(0x00000038ULL + (i) * 512)
#define   PKO3_L1_SQ_LINK_LINK_M		0x0001f00000000000ULL
#define   PKO3_L1_SQ_LINK_LINK_S		44
#define   PKO3_L1_SQ_LINK_CC_WORD_CNT_M		0x00000000fffff000ULL
#define   PKO3_L1_SQ_LINK_CC_WORD_CNT_S		12
#define   PKO3_L1_SQ_LINK_CC_PACKET_CNT_M	0x0000000000000ffcULL
#define   PKO3_L1_SQ_LINK_CC_PACKET_CNT_S	2
#define   PKO3_L1_SQ_LINK_CC_ENABLE		0x0000000000000002ULL

#define PKO3_DQ_WM_CTL(i)		(0x00000040ULL + (i) * 512)
#define   PKO3_DQ_WM_CTL_KIND			0x0002000000000000ULL

#define PKO3_L1_SQ_SW_XOFF(i)		(0x000000e0ULL + (i) * 512)
#define PKO3_DQ_SW_XOFF(i)		(0x002800e0ULL + (i) * 512)
#define   PKO3_LX_SQ_SW_XOFF_DRAIN_NULL_LINK	0x0000000000000004ULL
#define   PKO3_LX_SQ_SW_XOFF_DRAIN		0x0000000000000002ULL

#define PKO3_L1_SQ_SCHEDULE(i)		(0x00000008ULL + (i) * 512)
#define PKO3_L2_SQ_SCHEDULE(i)		(0x00080008ULL + (i) * 512)
#define PKO3_L3_SQ_SCHEDULE(i)		(0x00100008ULL + (i) * 512)
#define PKO3_L4_SQ_SCHEDULE(i)		(0x00180008ULL + (i) * 512)
#define PKO3_L5_SQ_SCHEDULE(i)		(0x00200008ULL + (i) * 512)
#define PKO3_DQ_SCHEDULE(i)		(0x00280008ULL + (i) * 512)
#define   PKO3_LX_SQ_SCHEDULE_PRIO_M		0x000000000f000000ULL
#define   PKO3_LX_SQ_SCHEDULE_PRIO_S		24
#define   PKO3_LX_SQ_SCHEDULE_RR_QUANTUM_M	0x0000000000ffffffULL
#define   PKO3_LX_SQ_SCHEDULE_RR_QUANTUM_S	0

#define PKO3_L1_SQ_TOPOLOGY(i)		(0x00080000ULL + (i) * 512)
#define   PKO3_L1_SQ_TOPOLOGY_PRIO_ANCHOR_M	0x000001ff00000000ULL
#define   PKO3_L1_SQ_TOPOLOGY_PRIO_ANCHOR_S	32
#define   PKO3_L1_SQ_TOPOLOGY_LINK_M		0x00000000001f0000ULL
#define   PKO3_L1_SQ_TOPOLOGY_LINK_S		16
#define   PKO3_L1_SQ_TOPOLOGY_RR_PRIO_M		0x000000000000001eULL
#define   PKO3_L1_SQ_TOPOLOGY_RR_PRIO_S		1

#define PKO3_L3_L2_SQ_CHANNEL(i)	(0x00080038ULL + (i) * 512)
#define   PKO3_L3_L2_SQ_CHANNEL_M		0x00000fff00000000ULL
#define   PKO3_L3_L2_SQ_CHANNEL_S		32
#define   PKO3_L3_L2_SQ_CHANNEL_CC_ENABLE	0x0000000000000002ULL

#define PKO3_L2_SQ_TOPOLOGY(i)		(0x00100000ULL + (i) * 512)
#define   PKO3_L2_SQ_TOPOLOGY_PRIO_ANCHOR_M	0x000001ff00000000ULL
#define   PKO3_L2_SQ_TOPOLOGY_PRIO_ANCHOR_S	32
#define   PKO3_L2_SQ_TOPOLOGY_PARENT_M		0x00000000001f0000ULL
#define   PKO3_L2_SQ_TOPOLOGY_PARENT_S		16
#define   PKO3_L2_SQ_TOPOLOGY_RR_PRIO_M		0x000000000000001eULL
#define   PKO3_L2_SQ_TOPOLOGY_RR_PRIO_S		1

#define PKO3_L3_SQ_TOPOLOGY(i)		(0x00180000ULL + (i) * 512)
#define   PKO3_L3_SQ_TOPOLOGY_PRIO_ANCHOR_M	0x000003ff00000000ULL
#define   PKO3_L3_SQ_TOPOLOGY_PRIO_ANCHOR_S	32
#define   PKO3_L3_SQ_TOPOLOGY_PARENT_M		0x0000000001ff0000ULL
#define   PKO3_L3_SQ_TOPOLOGY_PARENT_S		16
#define   PKO3_L3_SQ_TOPOLOGY_RR_PRIO_M		0x000000000000001eULL
#define   PKO3_L3_SQ_TOPOLOGY_RR_PRIO_S		1

#define PKO3_L4_SQ_TOPOLOGY(i)		(0x00200000ULL + (i) * 512)
#define   PKO3_L4_SQ_TOPOLOGY_PRIO_ANCHOR_M	0x000003ff00000000ULL
#define   PKO3_L4_SQ_TOPOLOGY_PRIO_ANCHOR_S	32
#define   PKO3_L4_SQ_TOPOLOGY_PARENT_M		0x0000000001ff0000ULL
#define   PKO3_L4_SQ_TOPOLOGY_PARENT_S		16
#define   PKO3_L4_SQ_TOPOLOGY_RR_PRIO_M		0x000000000000001eULL
#define   PKO3_L4_SQ_TOPOLOGY_RR_PRIO_S		1

#define PKO3_L5_SQ_TOPOLOGY(i)		(0x00280000ULL + (i) * 512)
#define   PKO3_L5_SQ_TOPOLOGY_PRIO_ANCHOR_M	0x000003ff00000000ULL
#define   PKO3_L5_SQ_TOPOLOGY_PRIO_ANCHOR_S	32
#define   PKO3_L5_SQ_TOPOLOGY_PARENT_M		0x0000000003ff0000ULL
#define   PKO3_L5_SQ_TOPOLOGY_PARENT_S		16
#define   PKO3_L5_SQ_TOPOLOGY_RR_PRIO_M		0x000000000000001eULL
#define   PKO3_L5_SQ_TOPOLOGY_RR_PRIO_S		1

#define PKO3_DQ_TOPOLOGY(i)		(0x00300000ULL + (i) * 512)
#define   PKO3_DQ_TOPOLOGY_PARENT_M		0x0000000003ff0000ULL
#define   PKO3_DQ_TOPOLOGY_PARENT_S		16

#define PKO3_PDM_CFG			0x00800000ULL
#define   PKO3_PDM_CFG_DIS_LPD_W2R_FILL		0x0000000000001000ULL
#define   PKO3_PDM_CFG_EN_FR_W2R_PTR_SWP	0x0000000000000800ULL
#define   PKO3_PDM_CFG_DIS_FLSH_CACHE		0x0000000000000400ULL
#define   PKO3_PDM_CFG_MIN_PAD_LEN_M		0x00000000000002f8ULL
#define   PKO3_PDM_CFG_MIN_PAD_LEN_S		3
#define   PKO3_PDM_CFG_DIAG_MODE		0x0000000000000004ULL
#define   PKO3_PDM_CFG_ALLOC_LDS		0x0000000000000002ULL
#define   PKO3_PDM_CFG_ALLOC_STS		0x0000000000000001ULL

#define PKO3_PDM_DQ_MINPAD(dq)		(0x008f0000ULL + (dq) * 8)
#define   PKO3_PDM_DQ_MINPAD_MINPAD		0x0000000000000001ULL

#define PKO3_MAC_CFG(mac)		(0x00900000ULL + (mac) * 8)
#define   PKO3_MAC_CFG_MIN_PAD_ENA		0x0000000000010000ULL
#define   PKO3_MAC_CFG_FCS_ENA			0x0000000000008000ULL
#define   PKO3_MAC_CFG_FCS_SOP_OFF_M		0x0000000000007f80ULL
#define   PKO3_MAC_CFG_FCS_SOP_OFF_S		7
#define   PKO3_MAC_CFG_SKID_MAX_CNT_M		0x0000000000000060ULL
#define   PKO3_MAC_CFG_SKID_MAX_CNT_S		5
#define   PKO3_MAC_CFG_FIFO_NUM_M		0x000000000000001fULL
#define   PKO3_MAC_CFG_FIFO_NUM_S		0

#define PKO3_PTGF_CFG(i)		(0x00900200ULL + (i) * 8)
#define   PKO3_PTGF_CFG_RESET			0x0000000000000040ULL
#define   PKO3_PTGF_CFG_RATE_M			0x0000000000000038ULL
#define   PKO3_PTGF_CFG_RATE_S			3
#define   PKO3_PTGF_CFG_SIZE_M			0x0000000000000007ULL
#define   PKO3_PTGF_CFG_SIZE_S			0

#define PKO3_PTF_IOBP_CFG		0x00900300ULL
#define   PKO3_PTF_IOBP_CFG_MAX_RD_SZ_M		0x000000000000007fULL
#define   PKO3_PTF_IOBP_CFG_MAX_RD_SZ_S		0

#define PKO3_MCI0_MAX_CRED(mac)		(0x00a00000ULL + (mac) * 8)
#define   PKO3_MCI0_MAC_CRED_LIMIT		0x0000000000000fffULL

#define PKO3_MCI1_MAX_CRED(mac)		(0x00a80000ULL + (mac) * 8)
#define PKO3_MCI1_CRED_CNT(mac)		(0x00a80100ULL + (mac) * 8)

#define PKO3_LUT(i)			(0x00b00000ULL + (i) * 8)
#define   PKO3_LUT_VALID			0x0000000000008000ULL
#define   PKO3_LUT_PQ_IDX_M			0x0000000000003e00ULL
#define   PKO3_LUT_PQ_IDX_S			9
#define   PKO3_LUT_QUEUE_NUM_M			0x00000000000001ffULL
#define   PKO3_LUT_QUEUE_NUM_S			0

#define PKO3_DPFI_FLUSH			0x00c00008ULL

#define PKO3_DPFI_FPA_AURA		0x00c00010ULL
#define   PKO3_DPFI_FPA_AURA_NODE_S		10
#define   PKO3_DPFI_FPA_AURA_AURA_S		0

#define PKO3_DPFI_FPA_ENA		0x00c00018ULL
#define   PKO3_DPFI_FPA_ENA_ENABLE		0x0000000000000001ULL

#define PKO3_STATUS			0x00d00000ULL
#define   PKO3_STATUS_PKO_RDY			0x8000000000000000ULL

#define PKO3_ENABLE			0x00d00008ULL
#define   PKO3_ENABLE_ENABLE			0x0000000000000001ULL

/*
 * PKO commands
 */

#define PKO3_SEND_HDR_AURA			0x0fff000000000000ULL
#define PKO3_SEND_HDR_CKL4			0x0000c00000000000ULL
#define PKO3_SEND_HDR_CKL3			0x0000200000000000ULL
#define PKO3_SEND_HDR_DS			0x0000100000000000ULL
#define PKO3_SEND_HDR_LE			0x0000080000000000ULL
#define PKO3_SEND_HDR_N2			0x0000040000000000ULL
#define PKO3_SEND_HDR_II			0x0000020000000000ULL
#define PKO3_SEND_HDR_DF			0x0000010000000000ULL
#define PKO3_SEND_HDR_FORMAT			0x0000007f00000000ULL
#define PKO3_SEND_HDR_L4PTR			0x00000000ff000000ULL
#define PKO3_SEND_HDR_L3PTR			0x0000000000ff0000ULL
#define PKO3_SEND_HDR_TOTAL_M			0x000000000000ffffULL
#define PKO3_SEND_HDR_TOTAL_S			0

#define PKO3_LMTDMA_SCRADDR_M			0xff00000000000000ULL
#define PKO3_LMTDMA_SCRADDR_S			56
#define PKO3_LMTDMA_RTNLEN_M			0x00ff000000000000ULL
#define PKO3_LMTDMA_RTNLEN_S			48
#define PKO3_LMTDMA_DID				0x0000510000000000ULL
#define PKO3_LMTDMA_DID_M			0x0000ff0000000000ULL
#define PKO3_LMTDMA_NODE			0x000000f000000000ULL
#define PKO3_LMTDMA_DQOP			0x0000000300000000ULL
#define PKO3_LMTDMA_DQ_M			0x0000000003ff0000ULL
#define PKO3_LMTDMA_DQ_S			16

#define PKO3_DQOP_SEND				0x0ULL
#define PKO3_DQOP_OPEN				0x1ULL
#define PKO3_DQOP_CLOSE				0x2ULL

#define PKO3_SUBDC3_SEND_GATHER			0x1ULL

#define PKO3_SEND_SUBDC4_CODE_S			44
#define PKO3_SEND_SUBDC4_WORK			0xaULL

#define PKO3_SEND_WORK_CODE			0xaULL

#define PKO3_SEND_WORK_GRP_S			52
#define PKO3_SEND_WORK_TT_S			50
#define PKO3_SEND_WORK_ADDR_S			0

#define PKO3_SEND_ADDR_M			0x000003ffffffffffULL
#define PKO3_SEND_ADDR_S			0

#define PKO3_SUBC_BUF_PTR_SIZE_M		0xffff000000000000ULL
#define PKO3_SUBC_BUF_PTR_SIZE_S		48
#define PKO3_SUBC_BUF_PTR_SUBDC3_M		0x0000e00000000000ULL
#define PKO3_SUBC_BUF_PTR_SUBDC3_S		45
#define PKO3_SUBC_BUF_PTR_ADDR_M		0x000003ffffffffffULL
#define PKO3_SUBC_BUF_PTR_ADDR_S		0

/*
 * PKI registers
 */

#define PKI_BASE		0x0001180044000000ULL
#define PKI_SIZE		0x0000000001000000ULL

#define PKI_ICG_CFG(i)			(0x0000a000ULL + (i) * 8)
#define   PKI_ICG_CFG_PENA			0x0000000001000000ULL

#define PKI_SFT_RST			0x00000010ULL
#define   PKI_SFT_RST_BUSY			0x8000000000000000ULL

#define PKI_BUF_CTL			0x00000100ULL
#define   PKI_BUF_CTL_PBP_EN			0x0000000000000001ULL
#define   PKI_BUF_CTL_PKI_EN			0x0000000000000001ULL

#define PKI_STAT_CTL			0x00000110ULL

#define PKI_GBL_PEN			0x00000200ULL
#define   PKI_GBL_PEN_M				0x00000000000003ffULL
#define   PKI_GBL_PEN_VIRT			0x0000000000000200ULL
#define   PKI_GBL_PEN_CLG			0x0000000000000100ULL
#define   PKI_GBL_PEN_CL2			0x0000000000000080ULL
#define   PKI_GBL_PEN_L4			0x0000000000000040ULL
#define   PKI_GBL_PEN_IL3			0x0000000000000020ULL
#define   PKI_GBL_PEN_L3			0x0000000000000010ULL
#define   PKI_GBL_PEN_MPLS			0x0000000000000008ULL
#define   PKI_GBL_PEN_FULC			0x0000000000000004ULL
#define   PKI_GBL_PEN_DSA			0x0000000000000002ULL
#define   PKI_GBL_PEN_HG			0x0000000000000001ULL

#define PKI_FRM_LEN_CHK(i)		(0x00004000ULL + (i) * 8)
#define   PKI_FRM_LEN_CHK_MAXLEN_M		0x00000000ffff0000ULL
#define   PKI_FRM_LEN_CHK_MAXLEN_S		16
#define   PKI_FRM_LEN_CHK_MINLEN_M		0x000000000000ffffULL
#define   PKI_FRM_LEN_CHK_MINLEN_S		0

#define PKI_LTYPE_MAP(i)		(0x00005000ULL + (i) * 8)

#define PKI_IMEM(i)			(0x00100000ULL + (i) * 8)

#define PKI_QPG_TBL(i)			(0x00800000ULL + (i) * 8)
#define   PKI_QPG_TBL_PADD			0x0fff000000000000ULL
#define   PKI_QPG_TBL_GRPTAG_OK			0x0000c00000000000ULL
#define   PKI_QPG_TBL_GRP_OK_M			0x000003ff00000000ULL
#define   PKI_QPG_TBL_GRP_OK_S			32
#define   PKI_QPG_TBL_GRPTAG_BAD		0x00000000c0000000ULL
#define   PKI_QPG_TBL_GRP_BAD_M			0x0000000003ff0000ULL
#define   PKI_QPG_TBL_GRP_BAD_S			16
#define   PKI_QPG_TBL_AURA_NODE_M		0x0000000000000c00ULL
#define   PKI_QPG_TBL_AURA_NODE_S		10
#define   PKI_QPG_TBL_LAURA_M			0x00000000000003ffULL
#define   PKI_QPG_TBL_LAURA_S			0

#define PKI_STAT_STAT0(i)		(0x00e00038ULL + (i) * 256)
#define   PKI_STAT_STAT0_PKTS_M			0x0000ffffffffffffULL
#define PKI_STAT_STAT1(i)		(0x00e00040ULL + (i) * 256)
#define   PKI_STAT_STAT0_PKTS_M			0x0000ffffffffffffULL
#define PKI_STAT_STAT3(i)		(0x00e00050ULL + (i) * 256)
#define   PKI_STAT_STAT3_PKTS			0x0000ffffffffffffULL

#define PKI_STYLE_BUF(style)		(0x0024000ULL + (style) * 8)
#define   PKI_STYLE_BUF_PKT_LEND		0x0000000100000000ULL
#define   PKI_STYLE_BUF_WQE_HSZ_M		0x00000000c0000000ULL
#define   PKI_STYLE_BUF_WQE_HSZ_S		30
#define   PKI_STYLE_BUF_WQE_SKIP_M		0x0000000030000000ULL
#define   PKI_STYLE_BUF_WQE_SKIP_S		28
#define   PKI_STYLE_BUF_FIRST_SKIP_M		0x000000000fc00000ULL
#define   PKI_STYLE_BUF_FIRST_SKIP_S		22
#define   PKI_STYLE_BUF_LATER_SKIP_M		0x00000000003f0000ULL
#define   PKI_STYLE_BUF_LATER_SKIP_S		16
#define   PKI_STYLE_BUF_OPC_MODE_M		0x000000000000c000ULL
#define   PKI_STYLE_BUF_OPC_MODE_S		14
#define   PKI_STYLE_BUF_DIS_WQ_DAT		0x0000000000002000ULL
#define   PKI_STYLE_BUF_MB_SIZE_M		0x0000000000001fffULL
#define   PKI_STYLE_BUF_MB_SIZE_S		0

#define PKI_CL_STYLE_CFG(cl, style)	(0x00500000ULL + (cl) * 0x10000 + \
					    (style) * 8)
#define   PKI_CL_STYLE_CFG_IP6_UDP_OPT		0x0000000100000000ULL
#define   PKI_CL_STYLE_CFG_LENERR_EN		0x0000000080000000ULL
#define   PKI_CL_STYLE_CFG_LENERR_EQPAD		0x0000000040000000ULL
#define   PKI_CL_STYLE_CFG_MINMAX_SEL		0x0000000020000000ULL
#define   PKI_CL_STYLE_CFG_MAXERR_EN		0x0000000010000000ULL
#define   PKI_CL_STYLE_CFG_MINERR_EN		0x0000000008000000ULL
#define   PKI_CL_STYLE_CFG_QPG_DIS_GRPTAG	0x0000000004000000ULL
#define   PKI_CL_STYLE_CFG_FCS_STRIP		0x0000000002000000ULL
#define   PKI_CL_STYLE_CFG_FCS_CHK		0x0000000001000000ULL
#define   PKI_CL_STYLE_CFG_RAWDRP		0x0000000000800000ULL
#define   PKI_CL_STYLE_CFG_DROP			0x0000000000400000ULL
#define   PKI_CL_STYLE_CFG_NODROP		0x0000000000200000ULL
#define   PKI_CL_STYLE_CFG_QPG_DIS_PADD		0x0000000000100000ULL
#define   PKI_CL_STYLE_CFG_QPG_DIS_GRP		0x0000000000080000ULL
#define   PKI_CL_STYLE_CFG_QPG_DIS_AURA		0x0000000000040000ULL
#define   PKI_CL_STYLE_CFG_QPG_BASE_M		0x00000000000007ffULL
#define   PKI_CL_STYLE_CFG_QPG_BASE_S		0

#define PKI_CL_PKIND_STYLE(cl, pkind)	(0x00300048ULL + (cl) * 0x10000 + \
					    (pkind) * 0x100)
#define   PKI_CL_PKIND_STYLE_PM_M		0x0000000000007f00ULL
#define   PKI_CL_PKIND_STYLE_PM_S		8
#define   PKI_CL_PKIND_STYLE_STYLE_M		0x00000000000000ffULL
#define   PKI_CL_PKIND_STYLE_STYLE_S		0

#define PKI_CL_STYLE_CFG2(cl, style)	(0x00500800ULL + (cl) * 0x10000 + \
					    (style) * 8)
#define PKI_CL_STYLE_ALG(cl, style)	(0x00501000ULL + (cl) * 0x10000 + \
					    (style) * 8)

#define PKI_CL_PCAM_TERM(cl, bank, i)	(0x00700000ULL + (cl) * 0x10000 + \
					    (bank) * 0x100 + (i) * 8)

/*
 * SSO registers
 */

#define SSO_BASE		0x0001670000000000ULL
#define SSO_SIZE		0x0000000100000000ULL

#define SSO_LD_IO				0x0001000000000000ULL
#define SSO_LD_DID				0x0000600000000000ULL
#define SSO_LD_NODE_M				0x000000f000000000ULL
#define SSO_LD_NODE_S				36
#define SSO_LD_INDEXED				0x0000000080000000ULL
#define SSO_LD_GROUPED				0x0000000040000000ULL
#define SSO_LD_RTNGRP				0x0000000020000000ULL
#define SSO_LD_INDEX_M				0x000000000000fff0ULL
#define SSO_LD_INDEX_S				4
#define SSO_LD_WAIT				0x0000000000000008ULL

/* SSO LD response */
#define SSO_LD_RTN_NO_WORK			0x8000000000000000ULL
#define SSO_LD_RTN_ADDR_M			0x000003ffffffffffULL

#define SSO_WQ_INT			0x00001000ULL

#define SSO_ERR0			0x00001240ULL
#define SSO_ERR1			0x00001248ULL

#define SSO_AW_CFG			0x000010f0ULL
#define   SSO_AW_CFG_STT			0x0000000000000008ULL
#define   SSO_AW_CFG_LDT			0x0000000000000004ULL
#define   SSO_AW_CFG_LDWB			0x0000000000000002ULL
#define   SSO_AW_CFG_RWEN			0x0000000000000001ULL

#define SSO_XAQ_AURA			0x00002100ULL
#define   SSO_XAQ_AURA_NODE_M			0x0000000000000c00ULL
#define   SSO_XAQ_AURA_NODE_S			10
#define   SSO_XAQ_AURA_LAURA_M			0x00000000000003ffULL
#define   SSO_XAQ_AURA_LAURA_S			0

#define SSO_XAQ_HEAD_PTR(i)		(0x00080000ULL + (i) * 8)
#define SSO_XAQ_TAIL_PTR(i)		(0x00090000ULL + (i) * 8)
#define SSO_XAQ_HEAD_NEXT(i)		(0x000a0000ULL + (i) * 8)
#define SSO_XAQ_TAIL_NEXT(i)		(0x000b0000ULL + (i) * 8)

#define SSO_GRP_PRI(group)		(0x20000200ULL + (group) * 0x10000)
#define   SSO_GRP_PRI_WEIGHT_M			0x00000000003f0000ULL
#define   SSO_GRP_PRI_WEIGHT_S			16

#define SSO_GRP_INT(group)		(0x20000400ULL + (group) * 0x10000)
#define   SSO_GRP_INT_EXE_DIS			0x8000000000000000ULL
#define   SSO_GRP_INT_EXE_INT			0x0000000000000002ULL

#define SSO_GRP_INT_THR(group)		(0x20000500ULL + (group) * 0x10000)
#define   SSO_GRP_INT_THR_IAQ_THR_M		0x0000000000001fffULL

#define SSO_GRP_AQ_CNT(group)		(0x20000700ULL + (group) * 0x10000)

#define SSO_PP_GRPMSK(core, set, i)	(0x40001000ULL + (core) * 0x10000 + \
					    (set) * 0x20 + (i) * 8)

#define PKI_WORD0_BUFS_M			0x00000000ff000000ULL
#define PKI_WORD0_BUFS_S			24
#define PKI_WORD0_PKIND_M			0x000000000000003fULL
#define PKI_WORD0_PKIND_S			0

#define PKI_WORD1_LEN_M				0xffff000000000000ULL
#define PKI_WORD1_LEN_S				48
#define PKI_WORD1_TAG_M				0x00000000ffffffffULL
#define PKI_WORD1_TAG_S				0

#define PKI_WORD2_SW_FLAG			0x8000000000000000ULL
#define PKI_WORD2_LG_HDR_TYPE			0x7c00000000000000ULL
#define PKI_WORD2_LF_HDR_TYPE			0x03e0000000000000ULL
#define PKI_WORD2_LE_HDR_TYPE			0x001f000000000000ULL
#define PKI_WORD2_LD_HDR_TYPE			0x0000f80000000000ULL
#define PKI_WORD2_LC_HDR_TYPE			0x000007c000000000ULL
#define PKI_WORD2_LB_HDR_TYPE			0x0000003e00000000ULL
#define PKI_WORD2_IS_LA_ETHER			0x0000000100000000ULL
#define PKI_WORD2_VLAN_VALID			0x0000000000800000ULL
#define PKI_WORD2_VLAN_STACKED			0x0000000000400000ULL
#define PKI_WORD2_STAT_INC			0x0000000000200000ULL
#define PKI_WORD2_PCAM_FLAG_M			0x00000000001e0000ULL
#define PKI_WORD2_IS_FRAG			0x0000000000010000ULL
#define PKI_WORD2_IS_L3_BCAST			0x0000000000008000ULL
#define PKI_WORD2_IS_L3_MCAST			0x0000000000004000ULL
#define PKI_WORD2_IS_L2_BCAST			0x0000000000002000ULL
#define PKI_WORD2_IS_L2_MCAST			0x0000000000001000ULL
#define PKI_WORD2_IS_RAW			0x0000000000000800ULL
#define PKI_WORD2_ERR_LEVEL_M			0x0000000000000700ULL
#define PKI_WORD2_ERR_LEVEL_S			8
#define PKI_WORD2_ERR_CODE_M			0x00000000000000ffULL
#define PKI_WORD2_ERR_CODE_S			0

#define PKI_WORD3_SIZE_M			0xffff000000000000ULL
#define PKI_WORD3_SIZE_S			48
#define PKI_WORD3_ADDR_M			0x000003ffffffffffULL
#define PKI_WORD3_ADDR_S			0

#define PKO3_L1_SQ_SHAPE_STATE(i)	(0x00000030ULL + (i) * 512)
#define PKO3_L2_SQ_SHAPE_STATE(i)	(0x00080030ULL + (i) * 512)
#define PKO3_L3_SQ_SHAPE_STATE(i)	(0x00100030ULL + (i) * 512)
#define PKO3_DQ_SHAPE_STATE(i)		(0x00280030ULL + (i) * 512)

#define PKO3_PTF_STATUS(i)		(0x00900100ULL + (i) * 8)

#endif /* !_OGXREG_H_ */
