<TeXmacs|1.0.1.11>

<style|tmdoc>

<\body>
  <expand|tmdoc-title|Architecture gnrale de <TeXmacs>>

  <section|Introduction>

  Le programme <apply|TeXmacs> a t crit en C++. Vous devez utiliser
  <verbatim|g++> et l'utilitaire <verbatim|makefile> pour compiler
  <apply|TeXmacs>.  l'heure actuelle, le source (situ dans le rpertoire
  <verbatim|src>) de <apply|TeXmacs> est ventil en plusieurs parties dans
  diffrents rpertoires :

  <\itemize>
    <item>Un jeu de structures de donnes de base et gnriques dans le
    rpertoire <verbatim|Basic>.

    <item>Des ressources standards pour <apply|TeXmacs>, tels les polices
    <apply|TeX>, les langages, encodages et dictionnaires dans le rpertoire
    <verbatim|Resource>.

    <item>Une bote  outils graphiques (avec sa documentation pas trs 
    jour) dans le rpertoire <verbatim|Window>.

    <item>Le langage d'extension pour <apply|TeXmacs> dans le rpertoire
    <verbatim|Prg>.

    <item>La partie typographique de l'diteur dans le rpertoire
    <verbatim|src/Typeset>.

    <item>L'diteur dans le rpertoire <verbatim|src/Edit>.

    <item>Le serveur <apply|TeXmacs> dans le rpertoire
    <verbatim|src/Server>.
  </itemize>

  Toutes ces parties utilisent les structures de donnes dfinies dans
  <verbatim|Basic>. La bote  outils graphiques dpend de
  <verbatim|Resource> en ce qui concerne les polices <apply|TeX>. Le langage
  d'extension est indpendant de <verbatim|Resource> et de <verbatim|Window>.
  La partie typographique s'appuie sur toutes les autres parties, sauf
  <verbatim|Prg>. L'diteur et le serveur <apply|TeXmacs> utilisent toutes
  les autres parties.

  Les donnes de <apply|TeXmacs> sont contenues dans le rpertoire
  <verbatim|edit> qui correspond  la distribution <apply|TeXmacs> sans code
  source. En gros, on a les types de donnes suivantes :

  <\itemize>
    <item>Donnes concernant les polices dans <verbatim|fonts> (encodage,
    fichiers<verbatim|.pk>, etc...).

    <item>Donnes concernant les langages dans <verbatim|languages> (modles
    de csure, dictionnaires, etc...).

    <item>Styles de document dans <verbatim|style>.

    <item>Initialisation et autres programmes <apply|scheme> dans
    <verbatim|progs>.
  </itemize>

  Le rpertoire <verbatim|misc> contient diverses donnes, telle l'icne
  d'dition (<verbatim|misc/pixmaps/traditional/--x17/edit.xpm>).

  <section|Reprsentation interne des textes>

  <apply|TeXmacs> reprsente tous les textes par des arbres (pour un texte
  donne, l'arbre correspondant est appel <em|arbre d'dition>). Les noeuds
  d'un tel arbre sont tiquets par des <em|oprateurs> standards dont la
  liste figure dans les fichiers <verbatim|Basic/Data/tree.hpp> et
  <verbatim|Basic/Data/tree.cpp>. Les tiquettes des feuilles des arbres sont
  des chanes, qui sont visibles (le texte rel) ou invisibles (telles les
  longueurs ou les dfinitions de macros).

  Le sens du texte et la manire dont il est typographi dpendent
  essentiellement de l'environnement actif. L'environnement consiste
  principalement en une table de hachage de type
  <verbatim|rel_hashmap\<less\>string,tree\<gtr\>>, c'est--dire une table de
  correspondance entre les variables d'environnement et leur valeur dans
  l'arbre. Le langage actif et la police courante sont des exemples de
  variables d'environnement ; de nouvelles variables peuvent tre dfinies
  par l'utilisateur.

  <subsection|Texte>

  Dans <apply|TeXmacs>, toutes les chanes de texte sont constitues de
  suites de symboles universels ou spciaux. Un symbole spcial est un
  caractre, diffrent de <verbatim|'\\0'>, <verbatim|'\<less\>'> ou
  <verbatim|'\<gtr\>'>. Son sens peut varier en fonction de la police avec
  laquelle il est utilis. Un symbole universel est une chane commenant par
  <verbatim|'\<less\>'>, suivi d'une suite arbitraire de caractres diffrent
  de <verbatim|'\\0'>, <verbatim|'\<less\>'> ou <verbatim|'\<gtr\>'>, et se
  terminant par <verbatim|'\<gtr\>'>. Le sens des caractres universels ne
  dpend pas de la police avec laquelle ils sont utiliss, mais des polices
  diffrentes peuvent les rendre de faon diffrente.

  <subsection|langage>

  Le langage d'un texte est capable de fournir une analyse smantique
  dtaille d'une phrase du texte. Il peut, au minimum, dcouper la phrase en
  <em|mots> (qui sont de plus petites phrases) et donner  l'outil
  typographique des informations sur les espaces dsires entre les mots et
  sur les csures  appliquer. Plus tard, il se peut qu'on ajoute d'autres
  smantiques aux langages. Par exemple, on pourrait implmenter des
  correcteurs orthographiques pour les langages naturels et des analyseurs
  syntaxiques pour les formules mathmatiques et les langages de
  programmation.

  <section|Composition des textes>

  En gros, l'outil typographique de <apply|TeXmacs> prend un arbre en entre
  et renvoie un cadre en accdant et en modifiant l'environnement
  typographique. La classe <verbatim|box> est multifonctionnelle. Sa mthode
  principale est utilise pour afficher le cadre sur un priphrique
  PostScript (soit l'cran, soit une imprimante). Mais elle contient aussi de
  nombreuses donnes de composition, tels les cadres logiques et les cadres
  d'encre, la position des scripts, etc...

  Les cadres servent aussi  passer d'un curseur physique (position sur
  l'cran)  un curseur logique (chemin dans l'arbre d'dition). En fait, les
  cadres sont, eux aussi, organiss sous forme d'arbre, ce qui facilite la
  conversion. Nanmoins, les routines de conversion peuvent tre trs
  complexes du fait de l'expansion des macros et des sauts de ligne et de
  page. Notez galement qu'en plus d'une position horizontale et verticale le
  curseur physique possde aussi une position horizontale infinitsimale. En
  gros, cette coordonne infinitsimale est utilise dans certains cadres
  (par exemple pour les changements de couleur) pour ajouter une largeur
  infinitsimale.

  <section|Modification du texte>

  Vous trouverez dans le rpertoire <verbatim|Edit/Modify> diffrentes
  routines de modification de l'arbre d'dition. Les modifications se
  droulent en plusieurs tapes :

  <\enumerate>
    <item>Un vnement en entre dclenche une action, comme par exemple
    <verbatim|make_fraction>, qui tente de modifier l'arbre d'dition.

    <item>Toutes les modifications que <verbatim|make_fraction> ou ses
    sous-routines appliquent  l'arbre d'dition sont, en fait, dcomposes
    en sept routines de modification lmentaires : <verbatim|assign>,
    <verbatim|insert>, <verbatim|remove>, <verbatim|split>, <verbatim|join>,
    <verbatim|ins_unary> et <verbatim|rem_unary>.

    <item>Avant d'excuter la modification demande, la routine de
    modification lmentaire envoie  toutes les vues du texte une
    notification concernant la modification.

    <item>Lors de la notification, chaque vue met  jour plusieurs lments,
    comme la position du curseur. Une notification est aussi envoye 
    l'outil de composition du texte, car il maintient une liste des
    paragraphes dj composs.

    <item>Lorsque toutes les vues ont reu notification de la modification,
    elle est alors rellement excute.

    <item>Chaque action utilisateur, tels la frappe sur une touche ou un clic
    de souris, est responsable de l'insertion de <em|points d'annulation>
    entre les suites de modifications lmentaires. Lorsqu'une modification
    est annule, l'dition revient au point d'annulation prcdent.
  </enumerate>

  <apply|tmdoc-copyright|1998--2003|Joris van der Hoeven|Michle Garoche>

  <expand|tmdoc-license|Permission is granted to copy, distribute and/or
  modify this document under the terms of the GNU Free Documentation License,
  Version 1.1 or any later version published by the Free Software Foundation;
  with no Invariant Sections, with no Front-Cover Texts, and with no
  Back-Cover Texts. A copy of the license is included in the section entitled
  "GNU Free Documentation License".>
</body>

<\initial>
  <\collection>
    <associate|paragraph width|150mm>
    <associate|odd page margin|30mm>
    <associate|shrinking factor|4>
    <associate|page right margin|30mm>
    <associate|page top margin|30mm>
    <associate|reduction page right margin|25mm>
    <associate|page type|a4>
    <associate|reduction page bottom margin|15mm>
    <associate|even page margin|30mm>
    <associate|reduction page left margin|25mm>
    <associate|page bottom margin|30mm>
    <associate|reduction page top margin|15mm>
    <associate|language|french>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|idx-1|<tuple|<uninit>|?>>
    <associate|toc-1|<tuple|1|?>>
    <associate|toc-2|<tuple|2|?>>
    <associate|idx-2|<tuple|<uninit>|?>>
    <associate|toc-3|<tuple|2.1|?>>
    <associate|toc-4|<tuple|2.2|?>>
    <associate|toc-5|<tuple|3|?>>
    <associate|toc-6|<tuple|4|?>>
    <associate|toc-7|<tuple|<uninit>|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|toc>
      <vspace*|1fn><with|font series|<quote|bold>|math font
      series|<quote|bold>|1<space|2spc>Introduction><value|toc-dots><pageref|toc-1><vspace|0.5fn>

      <vspace*|1fn><with|font series|<quote|bold>|math font
      series|<quote|bold>|2<space|2spc>Intern representation of
      texts><value|toc-dots><pageref|toc-2><vspace|0.5fn>

      2.1<space|2spc>Text<value|toc-dots><pageref|toc-3>

      2.2<space|2spc>The language<value|toc-dots><pageref|toc-4>

      <vspace*|1fn><with|font series|<quote|bold>|math font
      series|<quote|bold>|3<space|2spc>Typesetting
      texts><value|toc-dots><pageref|toc-5><vspace|0.5fn>

      <vspace*|1fn><with|font series|<quote|bold>|math font
      series|<quote|bold>|4<space|2spc>Making modifications in
      texts><value|toc-dots><pageref|toc-6><vspace|0.5fn>
    </associate>
  </collection>
</auxiliary>
