/**
*
* Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
* Requires jQuery and raphael.js
*
* Map of Corse for Mapael
* Equirectangular projection
* 
* @author CCM Benchmark Group
* @source http://fr.m.wikipedia.org/wiki/Fichier:France_location_map-Departements.svg
*/
(function($) {
	$.extend(true, $.fn.mapael, 
		{
			maps :  {
				france_region_94 : {
					width : 46.446445,
					height : 108.90127,
					getCoords : function (lat, lon) {
						var xfactor = 43.64246;
						var xoffset = -372.3068;
						var x = (lon * xfactor) + xoffset;
						
						var yfactor = -65.77758;
						var yoffset = 2828.4353;
						var y = (lat * yfactor) + yoffset;
						return {x : x, y : y};
					},
					elems : {
					    "department-2B" : "m 38,0.13 c -0.86,-0.02 -1.92,0.52 -1.53,1.54 -0.07,1.41 0.84,2.98 0.37,4.29 -1.02,0.63 -1.78,1.79 -1.08,2.97 0.31,1.25 -1.79,2.27 -0.43,3.42 1.03,1.77 1.09,4.03 0.87,5.99 -1.04,0.9 -0.68,2.46 -1.86,3.28 -0.55,0.85 -0.93,-0.81 -1.28,-1.08 -1.12,-2.41 -4.17,-2.24 -6.4,-2.1 -1.72,0.71 -3.34,2.33 -3.45,4.28 -0.49,0.75 -1.43,1.09 -2.19,1.5 -1.14,0.44 -2.33,0.58 -3.49,0.45 -1.27,0.09 -2.22,0.96 -3.12,1.69 -1.26,0.08 -2.73,0.73 -2.79,2.16 -0.17,0.84 -1.24,1.38 -1.95,1.07 -0.5,-0.83 -2.17,-0.44 -1.95,0.7 0.03,0.95 -0.24,2.04 -1.34,2.1 -1.06,0.43 -1.52,1.9 -1.26,2.91 0.55,0.03 0.75,0.45 0.43,0.95 -0.58,0.8 -0.29,1.95 -0.61,2.73 -0.95,-0.08 -2.64,0.12 -2.24,1.52 0.17,0.68 -1.48,0.75 -0.7,1.35 1,0.34 2.17,0.03 2.95,0.87 0.64,0.19 1.19,0.44 1.67,0.84 1.11,0.04 1.99,0.86 3.06,1 1.24,0.9 3.01,1.38 4.33,0.41 0.77,-0.11 0.17,1.27 0.48,1.72 0.24,0.68 1.13,0.91 0.94,1.76 0.01,1.01 1,1.42 1.81,1.42 0.54,0.67 1.03,1.52 2.01,1.51 0.95,0.85 2.04,1.85 3.41,1.78 0.81,0.66 0.07,2.09 1.02,2.71 0.51,0.73 0.31,1.7 0.58,2.38 0.82,0.94 2.43,1.07 2.54,2.56 0.08,1.41 0.1,3.38 1.72,3.95 0.77,0.31 2.51,-0.44 2.22,0.97 0.08,1.92 0.29,3.9 0.43,5.78 -0.75,1.03 0.98,1.01 1.14,1.77 -0.13,1.12 -1.42,2.33 -0.72,3.45 0.94,0.63 2.27,0.07 3.19,0.59 0.36,1.27 1.43,-0.32 1.94,-0.65 0.69,-0.89 2.17,-0.96 2.27,-2.27 0.41,-1.33 0.84,-2.87 -0.14,-4.05 1.28,-1.78 2.76,-3.65 3.53,-5.76 -0.18,-0.5 -1.18,-0.69 -0.53,-1.39 0.27,-0.72 0.81,-0.52 1.3,-0.18 1.13,-0.3 1.5,-1.8 2.21,-2.65 0.24,-0.46 1.18,-1.82 0.2,-1.93 -0.32,0.2 -1.24,0.4 -1.3,-0.03 0.83,-1.2 2.51,-2.04 1.99,-3.78 0,-3.75 0.33,-7.58 -0.83,-11.21 -0.44,-3.72 0.03,-7.52 -0.32,-11.27 -0.23,-0.96 0.23,-2.5 -0.7,-3.12 -0.69,0.83 -1.58,-0.5 -1.96,-1.06 -0.68,-1.08 -0.51,-2.43 -1.34,-3.45 -0.07,-0.74 0.43,-1.48 0.17,-2.25 0.09,-3.08 0.97,-6.12 1.82,-9.02 -0.1,-2.83 -1.09,-5.58 -1.05,-8.44 -0.51,-1.15 -0.27,-2.43 -0.58,-3.62 -0.71,-1.09 -2.3,-1.14 -3.47,-1.1 z",
					    "department-2A" : "m 0.43,41.82 c -0.96,0.22 0.16,1.27 -0.09,1.87 -0.26,0.78 0.55,1.05 0.89,0.33 0.84,-0.78 2.1,-0.24 2.66,0.64 -0.38,0.25 -2.07,0.91 -1.17,1.46 0.54,0.1 1.26,-0.09 1.36,0.59 0.94,0.46 2.04,1.2 2.26,2.23 -1.21,0.86 -2.67,0.94 -4,1.38 -0.75,0.43 -1.53,0.82 -2.35,1 -0.07,0.64 1.28,0.38 1.02,1.26 0.15,0.97 1.11,1.99 -0.03,2.74 -0.07,0.53 1.42,0.16 0.67,0.82 -0.95,0.18 -0.28,0.75 0.14,1.07 0.03,0.67 0.47,1.14 1.17,1.07 0.96,0.21 1.73,0.86 2.26,1.6 0.62,0.08 1.54,-0.78 1.77,0.26 0.37,1.33 1.26,2.39 2.05,3.39 -0.98,1.49 -3.77,1.26 -4.05,3.33 0.28,0.58 0.59,1.18 -0.18,1.59 -0.74,0.83 -2.43,-0.12 -2.92,0.84 0.37,0.93 1.98,1.58 1.15,2.73 -0.48,0.66 0.08,1.54 0.81,0.94 1.66,-0.37 3.76,0.29 4.92,-1.35 0.94,-0.7 2.23,0 2.52,1.07 0.84,0.92 -0.27,1.63 -0.59,2.43 0.03,0.56 0.78,1.61 -0.26,1.63 -0.56,-0.2 -1.15,0.41 -0.42,0.68 0.63,0.24 1.18,0.91 0.34,1.33 -0.65,0.87 -2.22,0.64 -2.64,1.63 0.95,1.48 -0.99,3.08 -2.46,2.85 -0.32,0.65 1.33,0.34 1.61,1.08 0.44,1.42 1.95,-0.12 2.92,-0.18 0.86,-0.46 0.88,0.55 0.75,1.14 -0.12,0.93 0.79,1.07 1.36,0.65 1.2,0.34 2.41,1.06 3.77,1.06 0.69,-0.12 1.67,0.59 0.96,1.2 -0.88,0.08 -1.57,0.66 -1.5,1.55 -0.78,0.66 -1.94,1.18 -2.96,1.26 -1.24,-0.36 -0.97,1.54 -1.16,2.25 -0.14,0.89 0.57,1.54 0.19,2.45 0.23,1.39 2.87,0.97 2.56,2.58 0.39,0.62 1.4,0.23 1.8,0.94 0.8,0.1 1.31,0.63 1.8,1.22 0.6,0.23 1.29,0.06 1.82,0.56 1,0.13 1.88,0.54 2.78,0.95 0.52,-0.07 0.69,0.84 1.22,0.28 0.27,-0.14 1.08,-1.21 0.9,-0.34 -0.27,0.72 -0.28,1.92 0.84,1.62 0.56,-0.02 1.59,0.4 0.94,1.11 -0.26,0.6 -1.29,2.11 -0.02,2.21 1.36,-0.01 2.29,1.1 3.2,1.91 1.25,0.61 2.31,-0.53 2.58,-1.7 0.22,-0.41 1.03,-1.91 0.02,-1.64 -0.14,0.16 -1.29,1.16 -1.02,0.41 0.66,-0.63 -0.15,-1.53 0.05,-2.14 1.48,-0.5 3.33,-2.12 2.6,-3.81 -0.26,-0.47 -0.53,-1.83 0.38,-1.85 0.78,-1.03 1.74,-1.78 2.68,-2.63 0.58,-0.57 0.9,-1.86 -0.25,-1.96 -0.79,-0.52 -1.28,0.22 -1.79,0.67 -0.97,0.39 -0.85,-0.86 -0.46,-1.35 0.21,-0.72 0.7,-1.51 1.52,-0.93 0.98,0.57 1.27,-0.33 1.3,-1.06 1.46,0.15 1.67,-1.66 1.06,-2.64 0.29,-0.98 1.97,-1.33 1.42,-2.65 -0.21,-3.01 0.22,-6.09 -0.26,-9.06 -0.6,-1.25 -1.82,0.32 -2.38,0.78 -0.6,0.62 -1.57,1.15 -2.05,0.22 -1.03,-0.08 -2.44,0.15 -3.17,-0.78 -0.33,-1.27 0.92,-2.26 0.78,-3.45 -0.17,-0.8 -2,-0.11 -1.41,-1.09 0.81,-0.8 -0.18,-1.9 0.13,-2.89 -0.12,-1.38 0.18,-3 -0.31,-4.23 -1.05,0.02 -2.6,0.57 -3.06,-0.77 -1.26,-1.34 0.01,-3.91 -1.83,-4.81 -1.66,-0.28 -1.44,-2.42 -2.15,-3.51 -0.87,-0.61 0.02,-2.75 -1.61,-2.49 -1.03,-0.32 -1.81,-1.14 -2.49,-1.85 -0.79,0.02 -1.49,-0.21 -1.73,-1.03 -0.49,-0.66 -1.54,-0.14 -1.86,-1.1 -0.52,-0.71 -0.33,-1.79 -1.26,-2.21 -0.4,-0.53 0.17,-2.18 -0.96,-1.68 -1.46,0.35 -3.05,-0.01 -4.24,-0.9 -1.05,0.03 -1.69,-1.07 -2.81,-0.86 -0.59,-0.13 -0.83,-0.88 -1.54,-0.8 -0.67,-0.69 -1.61,-0.71 -2.5,-0.73 -0.61,-0.3 -1.26,-0.51 -1.97,-0.4 z"
					}
				}
			}
		}
	);
})(jQuery);