function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import './index.scss';
import { TypesService } from './vis_types';
import { setUISettings, setTypes, setI18n, setApplication, setCapabilities, setHttp, setIndexPatterns, setSearch, setSavedObjects, setUsageCollector, setFilterManager, setExpressions, setUiActions, setSavedVisualizationsLoader, setTimeFilter, setAggs, setChrome, setOverlays, setSavedSearchLoader, setEmbeddable } from './services';
import { VISUALIZE_EMBEDDABLE_TYPE, VisualizeEmbeddableFactory, createVisEmbeddableFromObject } from './embeddable';
import { visualization as visualizationFunction } from './expressions/visualization_function';
import { visualization as visualizationRenderer } from './expressions/visualization_renderer';
import { range as rangeExpressionFunction } from './expression_functions/range';
import { visDimension as visDimensionExpressionFunction } from './expression_functions/vis_dimension';
import { createStartServicesGetter } from '../../kibana_utils/public';
import { createSavedVisLoader } from './saved_visualizations';
import { Vis } from './vis';
import { showNewVisModal } from './wizard';
import { convertFromSerializedVis, convertToSerializedVis } from './saved_visualizations/_saved_vis';
import { createSavedSearchesLoader } from '../../discover/public';
/**
 * Interface for this plugin's returned setup/start contracts.
 *
 * @public
 */

/**
 * Visualizations Plugin - public
 *
 * This plugin's stateful contracts are returned from the `setup` and `start` methods
 * below. The interfaces for these contracts are provided above.
 *
 * @internal
 */
export var VisualizationsPlugin = /*#__PURE__*/function () {
  function VisualizationsPlugin(initializerContext) {
    _classCallCheck(this, VisualizationsPlugin);

    _defineProperty(this, "types", new TypesService());

    _defineProperty(this, "getStartServicesOrDie", void 0);
  }

  _createClass(VisualizationsPlugin, [{
    key: "setup",
    value: function setup(core, _ref) {
      var expressions = _ref.expressions,
          embeddable = _ref.embeddable,
          usageCollection = _ref.usageCollection,
          data = _ref.data;
      var start = this.getStartServicesOrDie = createStartServicesGetter(core.getStartServices);
      setUISettings(core.uiSettings);
      setUsageCollector(usageCollection);
      expressions.registerFunction(visualizationFunction);
      expressions.registerRenderer(visualizationRenderer);
      expressions.registerFunction(rangeExpressionFunction);
      expressions.registerFunction(visDimensionExpressionFunction);
      var embeddableFactory = new VisualizeEmbeddableFactory({
        start: start
      });
      embeddable.registerEmbeddableFactory(VISUALIZE_EMBEDDABLE_TYPE, embeddableFactory);
      return _objectSpread({}, this.types.setup());
    }
  }, {
    key: "start",
    value: function start(core, _ref2) {
      var data = _ref2.data,
          expressions = _ref2.expressions,
          uiActions = _ref2.uiActions,
          embeddable = _ref2.embeddable;
      var types = this.types.start();
      setI18n(core.i18n);
      setTypes(types);
      setEmbeddable(embeddable);
      setApplication(core.application);
      setCapabilities(core.application.capabilities);
      setHttp(core.http);
      setSavedObjects(core.savedObjects);
      setIndexPatterns(data.indexPatterns);
      setSearch(data.search);
      setFilterManager(data.query.filterManager);
      setExpressions(expressions);
      setUiActions(uiActions);
      setTimeFilter(data.query.timefilter.timefilter);
      setAggs(data.search.aggs);
      setOverlays(core.overlays);
      setChrome(core.chrome);
      var savedVisualizationsLoader = createSavedVisLoader({
        savedObjectsClient: core.savedObjects.client,
        indexPatterns: data.indexPatterns,
        search: data.search,
        chrome: core.chrome,
        overlays: core.overlays,
        visualizationTypes: types
      });
      setSavedVisualizationsLoader(savedVisualizationsLoader);
      var savedSearchLoader = createSavedSearchesLoader({
        savedObjectsClient: core.savedObjects.client,
        indexPatterns: data.indexPatterns,
        search: data.search,
        chrome: core.chrome,
        overlays: core.overlays
      });
      setSavedSearchLoader(savedSearchLoader);
      return _objectSpread(_objectSpread({}, types), {}, {
        showNewVisModal: showNewVisModal,

        /**
         * creates new instance of Vis
         * @param {IIndexPattern} indexPattern - index pattern to use
         * @param {VisState} visState - visualization configuration
         */
        createVis: function () {
          var _createVis = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(visType, visState) {
            var vis;
            return regeneratorRuntime.wrap(function _callee$(_context) {
              while (1) {
                switch (_context.prev = _context.next) {
                  case 0:
                    vis = new Vis(visType);
                    _context.next = 3;
                    return vis.setState(visState);

                  case 3:
                    return _context.abrupt("return", vis);

                  case 4:
                  case "end":
                    return _context.stop();
                }
              }
            }, _callee);
          }));

          function createVis(_x, _x2) {
            return _createVis.apply(this, arguments);
          }

          return createVis;
        }(),
        convertToSerializedVis: convertToSerializedVis,
        convertFromSerializedVis: convertFromSerializedVis,
        savedVisualizationsLoader: savedVisualizationsLoader,
        __LEGACY: {
          createVisEmbeddableFromObject: createVisEmbeddableFromObject({
            start: this.getStartServicesOrDie
          })
        }
      });
    }
  }, {
    key: "stop",
    value: function stop() {
      this.types.stop();
    }
  }]);

  return VisualizationsPlugin;
}();