function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * @name Vis
 *
 * @description This class consists of aggs, params, listeners, title, and type.
 *  - Aggs: Instances of AggConfig.
 *  - Params: The settings in the Options tab.
 *
 * Not to be confused with vislib/vis.js.
 */
import { EventEmitter } from 'events';
import _ from 'lodash';
import { PersistedState } from '../../../../plugins/visualizations/public';
import { getTypes } from '../services';
export var ExprVis = /*#__PURE__*/function (_EventEmitter) {
  _inherits(ExprVis, _EventEmitter);

  var _super = _createSuper(ExprVis);

  function ExprVis() {
    var _this;

    var visState = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {
      type: 'histogram'
    };

    _classCallCheck(this, ExprVis);

    _this = _super.call(this);

    _defineProperty(_assertThisInitialized(_this), "title", '');

    _defineProperty(_assertThisInitialized(_this), "type", void 0);

    _defineProperty(_assertThisInitialized(_this), "params", {});

    _defineProperty(_assertThisInitialized(_this), "sessionState", {});

    _defineProperty(_assertThisInitialized(_this), "API", void 0);

    _defineProperty(_assertThisInitialized(_this), "eventsSubject", void 0);

    _defineProperty(_assertThisInitialized(_this), "uiState", void 0);

    _this.type = _this.getType(visState.type);
    _this.uiState = new PersistedState();

    _this.setState(visState);

    _this.API = {
      events: {
        filter: function filter(data) {
          if (!_this.eventsSubject) return;

          _this.eventsSubject.next({
            name: 'filterBucket',
            data: data.data ? {
              data: data.data,
              negate: data.negate
            } : {
              data: [data]
            }
          });
        },
        brush: function brush(data) {
          if (!_this.eventsSubject) return;

          _this.eventsSubject.next({
            name: 'brush',
            data: data
          });
        }
      }
    };
    return _this;
  }

  _createClass(ExprVis, [{
    key: "getType",
    value: function getType(type) {
      if (_.isString(type)) {
        var newType = getTypes().get(type);

        if (!newType) {
          throw new Error("Invalid type \"".concat(type, "\""));
        }

        return newType;
      } else {
        return type;
      }
    }
  }, {
    key: "setState",
    value: function setState(state) {
      this.title = state.title || '';

      if (state.type) {
        this.type = this.getType(state.type);
      }

      this.params = _.defaultsDeep({}, _.cloneDeep(state.params || {}), _.cloneDeep(this.type.visConfig.defaults || {}));
    }
  }, {
    key: "getState",
    value: function getState() {
      return {
        title: this.title,
        type: this.type.name,
        params: _.cloneDeep(this.params)
      };
    }
  }, {
    key: "updateState",
    value: function updateState() {
      this.emit('update');
    }
  }, {
    key: "forceReload",
    value: function forceReload() {
      this.emit('reload');
    }
  }, {
    key: "isHierarchical",
    value: function isHierarchical() {
      if (_.isFunction(this.type.hierarchicalData)) {
        return !!this.type.hierarchicalData(this);
      } else {
        return !!this.type.hierarchicalData;
      }
    }
  }, {
    key: "hasUiState",
    value: function hasUiState() {
      return !!this.uiState;
    }
  }, {
    key: "getUiState",
    value: function getUiState() {
      return this.uiState;
    }
  }, {
    key: "setUiState",
    value: function setUiState(state) {
      this.uiState = state;
    }
    /**
     * Currently this is only used to extract map-specific information
     * (e.g. mapZoom, mapCenter).
     */

  }, {
    key: "uiStateVal",
    value: function uiStateVal(key, val) {
      if (this.hasUiState()) {
        if (_.isUndefined(val)) {
          return this.uiState.get(key);
        }

        return this.uiState.set(key, val);
      }

      return val;
    }
  }]);

  return ExprVis;
}(EventEmitter);