function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { filter } from 'lodash';
import React, { useEffect, useState, useCallback } from 'react';
import { withRouter } from 'react-router-dom';
import { EuiFlexGroup, EuiFlexItem, EuiSpacer, EuiBadge, EuiText, EuiLink, EuiIcon, EuiCallOut, EuiPanel } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { useKibana } from '../../../../../plugins/kibana_react/public';
import { Tabs } from './tabs';
import { IndexHeader } from './index_header';
import { getIndexPatterns } from '../utils';
var mappingAPILink = i18n.translate('indexPatternManagement.editIndexPattern.timeFilterLabel.mappingAPILink', {
  defaultMessage: 'Mapping API'
});
var mappingConflictHeader = i18n.translate('indexPatternManagement.editIndexPattern.mappingConflictHeader', {
  defaultMessage: 'Mapping conflict'
});
var confirmMessage = i18n.translate('indexPatternManagement.editIndexPattern.refreshLabel', {
  defaultMessage: 'This action resets the popularity counter of each field.'
});
var confirmModalOptionsRefresh = {
  confirmButtonText: i18n.translate('indexPatternManagement.editIndexPattern.refreshButton', {
    defaultMessage: 'Refresh'
  }),
  title: i18n.translate('indexPatternManagement.editIndexPattern.refreshHeader', {
    defaultMessage: 'Refresh field list?'
  })
};
var confirmModalOptionsDelete = {
  confirmButtonText: i18n.translate('indexPatternManagement.editIndexPattern.deleteButton', {
    defaultMessage: 'Delete'
  }),
  title: i18n.translate('indexPatternManagement.editIndexPattern.deleteHeader', {
    defaultMessage: 'Delete index pattern?'
  })
};
export var EditIndexPattern = withRouter(function (_ref) {
  var indexPattern = _ref.indexPattern,
      history = _ref.history,
      location = _ref.location;
  var _useKibana$services = useKibana().services,
      uiSettings = _useKibana$services.uiSettings,
      indexPatternManagementStart = _useKibana$services.indexPatternManagementStart,
      overlays = _useKibana$services.overlays,
      savedObjects = _useKibana$services.savedObjects,
      chrome = _useKibana$services.chrome,
      data = _useKibana$services.data;

  var _useState = useState(indexPattern.getNonScriptedFields()),
      _useState2 = _slicedToArray(_useState, 2),
      fields = _useState2[0],
      setFields = _useState2[1];

  var _useState3 = useState(indexPattern.fields.filter(function (field) {
    return field.type === 'conflict';
  })),
      _useState4 = _slicedToArray(_useState3, 2),
      conflictedFields = _useState4[0],
      setConflictedFields = _useState4[1];

  var _useState5 = useState(uiSettings.get('defaultIndex')),
      _useState6 = _slicedToArray(_useState5, 2),
      defaultIndex = _useState6[0],
      setDefaultIndex = _useState6[1];

  var _useState7 = useState([]),
      _useState8 = _slicedToArray(_useState7, 2),
      tags = _useState8[0],
      setTags = _useState8[1];

  useEffect(function () {
    setFields(indexPattern.getNonScriptedFields());
    setConflictedFields(indexPattern.fields.filter(function (field) {
      return field.type === 'conflict';
    }));
  }, [indexPattern]);
  useEffect(function () {
    var indexPatternTags = indexPatternManagementStart.list.getIndexPatternTags(indexPattern, indexPattern.id === defaultIndex) || [];
    setTags(indexPatternTags);
  }, [defaultIndex, indexPattern, indexPatternManagementStart.list]);
  var setDefaultPattern = useCallback(function () {
    uiSettings.set('defaultIndex', indexPattern.id);
    setDefaultIndex(indexPattern.id || '');
  }, [uiSettings, indexPattern.id]);

  var refreshFields = function refreshFields() {
    overlays.openConfirm(confirmMessage, confirmModalOptionsRefresh).then( /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(isConfirmed) {
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                if (!isConfirmed) {
                  _context.next = 4;
                  break;
                }

                _context.next = 3;
                return indexPattern.init(true);

              case 3:
                setFields(indexPattern.getNonScriptedFields());

              case 4:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      return function (_x) {
        return _ref2.apply(this, arguments);
      };
    }());
  };

  var removePattern = function removePattern() {
    function doRemove() {
      return _doRemove.apply(this, arguments);
    }

    function _doRemove() {
      _doRemove = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
        var indexPatterns, otherPatterns;
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                if (!(indexPattern.id === defaultIndex)) {
                  _context2.next = 7;
                  break;
                }

                _context2.next = 3;
                return getIndexPatterns(savedObjects.client, uiSettings.get('defaultIndex'), indexPatternManagementStart);

              case 3:
                indexPatterns = _context2.sent;
                uiSettings.remove('defaultIndex');
                otherPatterns = filter(indexPatterns, function (pattern) {
                  return pattern.id !== indexPattern.id;
                });

                if (otherPatterns.length) {
                  uiSettings.set('defaultIndex', otherPatterns[0].id);
                }

              case 7:
                if (indexPattern.id) {
                  Promise.resolve(data.indexPatterns.delete(indexPattern.id)).then(function () {
                    history.push('');
                  });
                }

              case 8:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }));
      return _doRemove.apply(this, arguments);
    }

    overlays.openConfirm('', confirmModalOptionsDelete).then(function (isConfirmed) {
      if (isConfirmed) {
        doRemove();
      }
    });
  };

  var timeFilterHeader = i18n.translate('indexPatternManagement.editIndexPattern.timeFilterHeader', {
    defaultMessage: "Time Filter field name: '{timeFieldName}'",
    values: {
      timeFieldName: indexPattern.timeFieldName
    }
  });
  var mappingConflictLabel = i18n.translate('indexPatternManagement.editIndexPattern.mappingConflictLabel', {
    defaultMessage: '{conflictFieldsLength, plural, one {A field is} other {# fields are}} defined as several types (string, integer, etc) across the indices that match this pattern. You may still be able to use these conflict fields in parts of Kibana, but they will be unavailable for functions that require Kibana to know their type. Correcting this issue will require reindexing your data.',
    values: {
      conflictFieldsLength: conflictedFields.length
    }
  });
  var headingAriaLabel = i18n.translate('indexPatternManagement.editIndexPattern.detailsAria', {
    defaultMessage: 'Index pattern details'
  });
  chrome.docTitle.change(indexPattern.title);
  var showTagsSection = Boolean(indexPattern.timeFieldName || tags && tags.length > 0);
  return /*#__PURE__*/React.createElement(EuiPanel, {
    paddingSize: 'l'
  }, /*#__PURE__*/React.createElement("div", {
    "data-test-subj": "editIndexPattern",
    role: "region",
    "aria-label": headingAriaLabel
  }, /*#__PURE__*/React.createElement(EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(IndexHeader, {
    indexPattern: indexPattern,
    setDefault: setDefaultPattern,
    refreshFields: refreshFields,
    deleteIndexPatternClick: removePattern,
    defaultIndex: defaultIndex
  }), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), showTagsSection && /*#__PURE__*/React.createElement(EuiFlexGroup, {
    wrap: true
  }, Boolean(indexPattern.timeFieldName) && /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiBadge, {
    color: "warning"
  }, timeFilterHeader)), tags.map(function (tag) {
    return /*#__PURE__*/React.createElement(EuiFlexItem, {
      grow: false,
      key: tag.key
    }, /*#__PURE__*/React.createElement(EuiBadge, {
      color: "hollow"
    }, tag.name));
  })), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/React.createElement(EuiText, null, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.editIndexPattern.timeFilterLabel.timeFilterDetail",
    defaultMessage: "This page lists every field in the {indexPatternTitle} index and the field's associated core type as recorded by Elasticsearch. To change a field type, use the Elasticsearch",
    values: {
      indexPatternTitle: /*#__PURE__*/React.createElement("strong", null, indexPattern.title)
    }
  }), ' ', /*#__PURE__*/React.createElement(EuiLink, {
    href: "http://www.elastic.co/guide/en/elasticsearch/reference/current/mapping.html",
    target: "_blank"
  }, mappingAPILink, /*#__PURE__*/React.createElement(EuiIcon, {
    type: "link"
  })))), conflictedFields.length > 0 && /*#__PURE__*/React.createElement(EuiCallOut, {
    title: mappingConflictHeader,
    color: "warning",
    iconType: "alert"
  }, /*#__PURE__*/React.createElement("p", null, mappingConflictLabel))), /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(Tabs, {
    indexPattern: indexPattern,
    fields: fields,
    history: history,
    location: location
  })))));
});