function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { i18n } from '@kbn/i18n';
import { EuiToolTip } from '@elastic/eui';
var sortDirectionToIcon = {
  desc: 'fa fa-sort-down',
  asc: 'fa fa-sort-up',
  '': 'fa fa-sort'
};
export function TableHeaderColumn(_ref) {
  var colLeftIdx = _ref.colLeftIdx,
      colRightIdx = _ref.colRightIdx,
      displayName = _ref.displayName,
      isRemoveable = _ref.isRemoveable,
      isSortable = _ref.isSortable,
      name = _ref.name,
      onChangeSortOrder = _ref.onChangeSortOrder,
      onMoveColumn = _ref.onMoveColumn,
      onRemoveColumn = _ref.onRemoveColumn,
      sortOrder = _ref.sortOrder;

  var _ref2 = sortOrder.find(function (sortPair) {
    return name === sortPair[0];
  }) || [],
      _ref3 = _slicedToArray(_ref2, 2),
      _ref3$ = _ref3[1],
      sortDirection = _ref3$ === void 0 ? '' : _ref3$;

  var currentSortWithoutColumn = sortOrder.filter(function (pair) {
    return pair[0] !== name;
  });
  var currentColumnSort = sortOrder.find(function (pair) {
    return pair[0] === name;
  });
  var currentColumnSortDirection = currentColumnSort && currentColumnSort[1] || '';
  var btnSortIcon = sortDirectionToIcon[sortDirection];
  var btnSortClassName = sortDirection !== '' ? btnSortIcon : "kbnDocTableHeader__sortChange ".concat(btnSortIcon);

  var handleChangeSortOrder = function handleChangeSortOrder() {
    if (!onChangeSortOrder) return; // Cycle goes Unsorted -> Asc -> Desc -> Unsorted

    if (currentColumnSort === undefined) {
      onChangeSortOrder([].concat(_toConsumableArray(currentSortWithoutColumn), [[name, 'asc']]));
    } else if (currentColumnSortDirection === 'asc') {
      onChangeSortOrder([].concat(_toConsumableArray(currentSortWithoutColumn), [[name, 'desc']]));
    } else if (currentColumnSortDirection === 'desc' && currentSortWithoutColumn.length === 0) {
      // If we're at the end of the cycle and this is the only existing sort, we switch
      // back to ascending sort instead of removing it.
      onChangeSortOrder([[name, 'asc']]);
    } else {
      onChangeSortOrder(currentSortWithoutColumn);
    }
  };

  var getSortButtonAriaLabel = function getSortButtonAriaLabel() {
    var sortAscendingMessage = i18n.translate('discover.docTable.tableHeader.sortByColumnAscendingAriaLabel', {
      defaultMessage: 'Sort {columnName} ascending',
      values: {
        columnName: name
      }
    });
    var sortDescendingMessage = i18n.translate('discover.docTable.tableHeader.sortByColumnDescendingAriaLabel', {
      defaultMessage: 'Sort {columnName} descending',
      values: {
        columnName: name
      }
    });
    var stopSortingMessage = i18n.translate('discover.docTable.tableHeader.sortByColumnUnsortedAriaLabel', {
      defaultMessage: 'Stop sorting on {columnName}',
      values: {
        columnName: name
      }
    });

    if (currentColumnSort === undefined) {
      return sortAscendingMessage;
    } else if (sortDirection === 'asc') {
      return sortDescendingMessage;
    } else if (sortDirection === 'desc' && currentSortWithoutColumn.length === 0) {
      return sortAscendingMessage;
    } else {
      return stopSortingMessage;
    }
  }; // action buttons displayed on the right side of the column name


  var buttons = [// Sort Button
  {
    active: isSortable && typeof onChangeSortOrder === 'function',
    ariaLabel: getSortButtonAriaLabel(),
    className: btnSortClassName,
    onClick: handleChangeSortOrder,
    testSubject: "docTableHeaderFieldSort_".concat(name),
    tooltip: getSortButtonAriaLabel()
  }, // Remove Button
  {
    active: isRemoveable && typeof onRemoveColumn === 'function',
    ariaLabel: i18n.translate('discover.docTable.tableHeader.removeColumnButtonAriaLabel', {
      defaultMessage: 'Remove {columnName} column',
      values: {
        columnName: name
      }
    }),
    className: 'fa fa-remove kbnDocTableHeader__move',
    onClick: function onClick() {
      return onRemoveColumn && onRemoveColumn(name);
    },
    testSubject: "docTableRemoveHeader-".concat(name),
    tooltip: i18n.translate('discover.docTable.tableHeader.removeColumnButtonTooltip', {
      defaultMessage: 'Remove Column'
    })
  }, // Move Left Button
  {
    active: colLeftIdx >= 0 && typeof onMoveColumn === 'function',
    ariaLabel: i18n.translate('discover.docTable.tableHeader.moveColumnLeftButtonAriaLabel', {
      defaultMessage: 'Move {columnName} column to the left',
      values: {
        columnName: name
      }
    }),
    className: 'fa fa-angle-double-left kbnDocTableHeader__move',
    onClick: function onClick() {
      return onMoveColumn && onMoveColumn(name, colLeftIdx);
    },
    testSubject: "docTableMoveLeftHeader-".concat(name),
    tooltip: i18n.translate('discover.docTable.tableHeader.moveColumnLeftButtonTooltip', {
      defaultMessage: 'Move column to the left'
    })
  }, // Move Right Button
  {
    active: colRightIdx >= 0 && typeof onMoveColumn === 'function',
    ariaLabel: i18n.translate('discover.docTable.tableHeader.moveColumnRightButtonAriaLabel', {
      defaultMessage: 'Move {columnName} column to the right',
      values: {
        columnName: name
      }
    }),
    className: 'fa fa-angle-double-right kbnDocTableHeader__move',
    onClick: function onClick() {
      return onMoveColumn && onMoveColumn(name, colRightIdx);
    },
    testSubject: "docTableMoveRightHeader-".concat(name),
    tooltip: i18n.translate('discover.docTable.tableHeader.moveColumnRightButtonTooltip', {
      defaultMessage: 'Move column to the right'
    })
  }];
  return /*#__PURE__*/React.createElement("th", {
    "data-test-subj": "docTableHeaderField"
  }, /*#__PURE__*/React.createElement("span", {
    "data-test-subj": "docTableHeader-".concat(name)
  }, displayName, buttons.filter(function (button) {
    return button.active;
  }).map(function (button, idx) {
    return /*#__PURE__*/React.createElement(EuiToolTip, {
      id: "docTableHeader-".concat(name, "-tt"),
      content: button.tooltip,
      key: "button-".concat(idx)
    }, /*#__PURE__*/React.createElement("button", {
      "aria-label": button.ariaLabel,
      className: button.className,
      "data-test-subj": button.testSubject,
      onClick: button.onClick
    }));
  })));
}