function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { esFilters } from '../../data/public';
import { setStateToKbnUrl } from '../../kibana_utils/public';
export var STATE_STORAGE_KEY = '_a';
export var GLOBAL_STATE_STORAGE_KEY = '_g';
export var DASHBOARD_APP_URL_GENERATOR = 'DASHBOARD_APP_URL_GENERATOR';
export var createDashboardUrlGenerator = function createDashboardUrlGenerator(getStartServices) {
  return {
    id: DASHBOARD_APP_URL_GENERATOR,
    createUrl: function () {
      var _createUrl = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(state) {
        var _state$useHash;

        var startServices, useHash, appBasePath, hash, getSavedFiltersFromDestinationDashboardIfNeeded, cleanEmptyKeys, filters, appStateUrl;
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                _context2.next = 2;
                return getStartServices();

              case 2:
                startServices = _context2.sent;
                useHash = (_state$useHash = state.useHash) !== null && _state$useHash !== void 0 ? _state$useHash : startServices.useHashedUrl;
                appBasePath = startServices.appBasePath;
                hash = state.dashboardId ? "view/".concat(state.dashboardId) : "create";

                getSavedFiltersFromDestinationDashboardIfNeeded = /*#__PURE__*/function () {
                  var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
                    var _dashboard$searchSour, _dashboard$searchSour2, dashboard;

                    return regeneratorRuntime.wrap(function _callee$(_context) {
                      while (1) {
                        switch (_context.prev = _context.next) {
                          case 0:
                            if (!(state.preserveSavedFilters === false)) {
                              _context.next = 2;
                              break;
                            }

                            return _context.abrupt("return", []);

                          case 2:
                            if (state.dashboardId) {
                              _context.next = 4;
                              break;
                            }

                            return _context.abrupt("return", []);

                          case 4:
                            _context.prev = 4;
                            _context.next = 7;
                            return startServices.savedDashboardLoader.get(state.dashboardId);

                          case 7:
                            dashboard = _context.sent;
                            return _context.abrupt("return", (_dashboard$searchSour = dashboard === null || dashboard === void 0 ? void 0 : (_dashboard$searchSour2 = dashboard.searchSource) === null || _dashboard$searchSour2 === void 0 ? void 0 : _dashboard$searchSour2.getField('filter')) !== null && _dashboard$searchSour !== void 0 ? _dashboard$searchSour : []);

                          case 11:
                            _context.prev = 11;
                            _context.t0 = _context["catch"](4);
                            return _context.abrupt("return", []);

                          case 14:
                          case "end":
                            return _context.stop();
                        }
                      }
                    }, _callee, null, [[4, 11]]);
                  }));

                  return function getSavedFiltersFromDestinationDashboardIfNeeded() {
                    return _ref.apply(this, arguments);
                  };
                }();

                cleanEmptyKeys = function cleanEmptyKeys(stateObj) {
                  Object.keys(stateObj).forEach(function (key) {
                    if (stateObj[key] === undefined) {
                      delete stateObj[key];
                    }
                  });
                  return stateObj;
                }; // leave filters `undefined` if no filters was applied
                // in this case dashboard will restore saved filters on its own


                _context2.t0 = state.filters;

                if (!_context2.t0) {
                  _context2.next = 18;
                  break;
                }

                _context2.t1 = [];
                _context2.t2 = _toConsumableArray;
                _context2.next = 14;
                return getSavedFiltersFromDestinationDashboardIfNeeded();

              case 14:
                _context2.t3 = _context2.sent;
                _context2.t4 = (0, _context2.t2)(_context2.t3);
                _context2.t5 = _toConsumableArray(state.filters);
                _context2.t0 = _context2.t1.concat.call(_context2.t1, _context2.t4, _context2.t5);

              case 18:
                filters = _context2.t0;
                appStateUrl = setStateToKbnUrl(STATE_STORAGE_KEY, cleanEmptyKeys({
                  query: state.query,
                  filters: filters === null || filters === void 0 ? void 0 : filters.filter(function (f) {
                    return !esFilters.isFilterPinned(f);
                  }),
                  viewMode: state.viewMode
                }), {
                  useHash: useHash
                }, "".concat(appBasePath, "#/").concat(hash));
                return _context2.abrupt("return", setStateToKbnUrl(GLOBAL_STATE_STORAGE_KEY, cleanEmptyKeys({
                  time: state.timeRange,
                  filters: filters === null || filters === void 0 ? void 0 : filters.filter(function (f) {
                    return esFilters.isFilterPinned(f);
                  }),
                  refreshInterval: state.refreshInterval
                }), {
                  useHash: useHash
                }, appStateUrl));

              case 21:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }));

      function createUrl(_x) {
        return _createUrl.apply(this, arguments);
      }

      return createUrl;
    }()
  };
};