/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import './index.scss';
import { EuiIcon } from '@elastic/eui';
import angular from 'angular'; // required for `ngSanitize` angular module

import 'angular-sanitize';
import { i18nDirective, i18nFilter, I18nProvider } from '@kbn/i18n/angular';
// @ts-ignore
import { initDashboardApp } from './legacy_app';
import { configureAppAngularModule } from '../../../kibana_legacy/public';
// required for i18nIdDirective
import 'angular-sanitize'; // required for ngRoute

import 'angular-route';
var angularModuleInstance = null;
export var renderApp = function renderApp(element, appBasePath, deps) {
  if (!angularModuleInstance) {
    angularModuleInstance = createLocalAngularModule(); // global routing stuff

    configureAppAngularModule(angularModuleInstance, {
      core: deps.core,
      env: deps.pluginInitializerContext.env
    }, true, deps.scopedHistory);
    initDashboardApp(angularModuleInstance, deps);
  }

  var $injector = mountDashboardApp(appBasePath, element);
  return function () {
    $injector.get('kbnUrlStateStorage').cancel();
    $injector.get('$rootScope').$destroy();
  };
};

var mainTemplate = function mainTemplate(basePath) {
  return "<div ng-view class=\"dshAppContainer\">\n  <base href=\"".concat(basePath, "\" />\n</div>");
};

var moduleName = 'app/dashboard';
var thirdPartyAngularDependencies = ['ngSanitize', 'ngRoute', 'react'];

function mountDashboardApp(appBasePath, element) {
  var mountpoint = document.createElement('div');
  mountpoint.setAttribute('class', 'dshAppContainer'); // eslint-disable-next-line

  mountpoint.innerHTML = mainTemplate(appBasePath); // bootstrap angular into detached element and attach it later to
  // make angular-within-angular possible

  var $injector = angular.bootstrap(mountpoint, [moduleName]); // initialize global state handler

  element.appendChild(mountpoint);
  return $injector;
}

function createLocalAngularModule() {
  createLocalI18nModule();
  createLocalIconModule();
  var dashboardAngularModule = angular.module(moduleName, [].concat(thirdPartyAngularDependencies, ['app/dashboard/I18n', 'app/dashboard/icon']));
  return dashboardAngularModule;
}

function createLocalIconModule() {
  angular.module('app/dashboard/icon', ['react']).directive('icon', function (reactDirective) {
    return reactDirective(EuiIcon);
  });
}

function createLocalI18nModule() {
  angular.module('app/dashboard/I18n', []).provider('i18n', I18nProvider).filter('i18n', i18nFilter).directive('i18nId', i18nDirective);
}