function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useState } from 'react';
import { i18n } from '@kbn/i18n';
import { EuiFlexGroup, EuiFlexItem, EuiTitle, EuiPageContent } from '@elastic/eui';
import { ConsoleHistory } from '../console_history';
import { Editor } from '../editor';
import { Settings } from '../settings';
import { TopNavMenu, WelcomePanel, HelpPanel, SomethingWentWrongCallout, NetworkRequestStatusBar } from '../../components';
import { useServicesContext, useEditorReadContext, useRequestReadContext } from '../../contexts';
import { useDataInit } from '../../hooks';
import { getTopNavConfig } from './get_top_nav';
export function Main() {
  var _requestData;

  var _useServicesContext = useServicesContext(),
      storage = _useServicesContext.services.storage;

  var _useEditorReadContext = useEditorReadContext(),
      editorsReady = _useEditorReadContext.ready;

  var _useRequestReadContex = useRequestReadContext(),
      requestInProgress = _useRequestReadContex.requestInFlight,
      _useRequestReadContex2 = _useRequestReadContex.lastResult,
      requestData = _useRequestReadContex2.data,
      requestError = _useRequestReadContex2.error;

  var _useState = useState(function () {
    return storage.get('version_welcome_shown') !== '@@SENSE_REVISION';
  }),
      _useState2 = _slicedToArray(_useState, 2),
      showWelcome = _useState2[0],
      setShowWelcomePanel = _useState2[1];

  var _useState3 = useState(false),
      _useState4 = _slicedToArray(_useState3, 2),
      showingHistory = _useState4[0],
      setShowHistory = _useState4[1];

  var _useState5 = useState(false),
      _useState6 = _slicedToArray(_useState5, 2),
      showSettings = _useState6[0],
      setShowSettings = _useState6[1];

  var _useState7 = useState(false),
      _useState8 = _slicedToArray(_useState7, 2),
      showHelp = _useState8[0],
      setShowHelp = _useState8[1];

  var renderConsoleHistory = function renderConsoleHistory() {
    return editorsReady ? /*#__PURE__*/React.createElement(ConsoleHistory, {
      close: function close() {
        return setShowHistory(false);
      }
    }) : null;
  };

  var _useDataInit = useDataInit(),
      done = _useDataInit.done,
      error = _useDataInit.error,
      retry = _useDataInit.retry;

  if (error) {
    return /*#__PURE__*/React.createElement(EuiPageContent, null, /*#__PURE__*/React.createElement(SomethingWentWrongCallout, {
      onButtonClick: retry,
      error: error
    }));
  }

  var lastDatum = (_requestData = requestData === null || requestData === void 0 ? void 0 : requestData[requestData.length - 1]) !== null && _requestData !== void 0 ? _requestData : requestError;
  return /*#__PURE__*/React.createElement("div", {
    id: "consoleRoot"
  }, /*#__PURE__*/React.createElement(EuiFlexGroup, {
    className: "consoleContainer",
    gutterSize: "none",
    direction: "column",
    responsive: false
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    className: "euiScreenReaderOnly"
  }, /*#__PURE__*/React.createElement("h1", null, i18n.translate('console.pageHeading', {
    defaultMessage: 'Console'
  }))), /*#__PURE__*/React.createElement(EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(TopNavMenu, {
    disabled: !done,
    items: getTopNavConfig({
      onClickHistory: function onClickHistory() {
        return setShowHistory(!showingHistory);
      },
      onClickSettings: function onClickSettings() {
        return setShowSettings(true);
      },
      onClickHelp: function onClickHelp() {
        return setShowHelp(!showHelp);
      }
    })
  })), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false,
    className: "conApp__tabsExtension"
  }, /*#__PURE__*/React.createElement(NetworkRequestStatusBar, {
    requestInProgress: requestInProgress,
    requestResult: lastDatum ? {
      method: lastDatum.request.method.toUpperCase(),
      endpoint: lastDatum.request.path,
      statusCode: lastDatum.response.statusCode,
      statusText: lastDatum.response.statusText,
      timeElapsedMs: lastDatum.response.timeMs
    } : undefined
  })))), showingHistory ? /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, renderConsoleHistory()) : null, /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(Editor, {
    loading: !done
  }))), done && showWelcome ? /*#__PURE__*/React.createElement(WelcomePanel, {
    onDismiss: function onDismiss() {
      storage.set('version_welcome_shown', '@@SENSE_REVISION');
      setShowWelcomePanel(false);
    }
  }) : null, showSettings ? /*#__PURE__*/React.createElement(Settings, {
    onClose: function onClose() {
      return setShowSettings(false);
    }
  }) : null, showHelp ? /*#__PURE__*/React.createElement(HelpPanel, {
    onClose: function onClose() {
      return setShowHelp(false);
    }
  }) : null);
}