function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import _ from 'lodash';
import d3 from 'd3';
import { COLOR_MAPPING_SETTING } from '../../../common';
import { createColorPalette } from './color_palette';

var standardizeColor = function standardizeColor(color) {
  return d3.rgb(color).toString();
};
/**
 * Maintains a lookup table that associates the value (key) with a hex color (value)
 * across the visualizations.
 * Provides functions to interact with the lookup table
 */


export var MappedColors = /*#__PURE__*/function () {
  function MappedColors(uiSettings) {
    _classCallCheck(this, MappedColors);

    this.uiSettings = uiSettings;

    _defineProperty(this, "_oldMap", void 0);

    _defineProperty(this, "_mapping", void 0);

    this._oldMap = {};
    this._mapping = {};
  }

  _createClass(MappedColors, [{
    key: "getConfigColorMapping",
    value: function getConfigColorMapping() {
      return _.mapValues(this.uiSettings.get(COLOR_MAPPING_SETTING), standardizeColor);
    }
  }, {
    key: "get",
    value: function get(key) {
      return this.getConfigColorMapping()[key] || this._mapping[key];
    }
  }, {
    key: "flush",
    value: function flush() {
      this._oldMap = _.clone(this._mapping);
      this._mapping = {};
    }
  }, {
    key: "purge",
    value: function purge() {
      this._oldMap = {};
      this._mapping = {};
    }
  }, {
    key: "mapKeys",
    value: function mapKeys(keys) {
      var _this = this;

      var configMapping = this.getConfigColorMapping();

      var configColors = _.values(configMapping);

      var oldColors = _.values(this._oldMap);

      var keysToMap = [];

      _.each(keys, function (key) {
        // If this key is mapped in the config, it's unnecessary to have it mapped here
        if (configMapping[key]) delete _this._mapping[key]; // If this key is mapped to a color used by the config color mapping, we need to remap it

        if (_.includes(configColors, _this._mapping[key])) keysToMap.push(key); // if key exist in oldMap, move it to mapping

        if (_this._oldMap[key]) _this._mapping[key] = _this._oldMap[key]; // If this key isn't mapped, we need to map it

        if (_this.get(key) == null) keysToMap.push(key);
      }); // Generate a color palette big enough that all new keys can have unique color values


      var allColors = _(this._mapping).values().union(configColors).union(oldColors).value();

      var colorPalette = createColorPalette(allColors.length + keysToMap.length);

      var newColors = _.difference(colorPalette, allColors);

      while (keysToMap.length > newColors.length) {
        newColors = newColors.concat(_.sampleSize(allColors, keysToMap.length - newColors.length));
      }

      _.merge(this._mapping, _.zipObject(keysToMap, newColors));
    }
  }, {
    key: "oldMap",
    get: function get() {
      return this._oldMap;
    }
  }, {
    key: "mapping",
    get: function get() {
      return this._mapping;
    }
  }]);

  return MappedColors;
}();