"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusService = void 0;

var _rxjs = require("rxjs");

var _operators = require("rxjs/operators");

var _util = require("util");

var _get_summary_status = require("./get_summary_status");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class StatusService {
  constructor(coreContext) {
    _defineProperty(this, "logger", void 0);

    this.logger = coreContext.logger.get('status');
  }

  setup(core) {
    const core$ = this.setupCoreStatus(core);
    const overall$ = core$.pipe((0, _operators.map)(coreStatus => {
      const summary = (0, _get_summary_status.getSummaryStatus)(Object.entries(coreStatus));
      this.logger.debug(`Recalculated overall status`, {
        status: summary
      });
      return summary;
    }), (0, _operators.distinctUntilChanged)(_util.isDeepStrictEqual));
    return {
      core$,
      overall$
    };
  }

  start() {}

  stop() {}

  setupCoreStatus({
    elasticsearch,
    savedObjects
  }) {
    return (0, _rxjs.combineLatest)([elasticsearch.status$, savedObjects.status$]).pipe((0, _operators.map)(([elasticsearchStatus, savedObjectsStatus]) => ({
      elasticsearch: elasticsearchStatus,
      savedObjects: savedObjectsStatus
    })), (0, _operators.distinctUntilChanged)(_util.isDeepStrictEqual), (0, _operators.shareReplay)(1));
  }

}

exports.StatusService = StatusService;