function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useState } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { EuiOverlayMask } from '../overlay_mask';
import { EuiIcon } from '../icon';
import { EuiI18n } from '../i18n';
import { EuiFocusTrap } from '../focus_trap';
import { keys } from '../../services';
import { useInnerText } from '../inner_text';
var sizeToClassNameMap = {
  s: 'euiImage--small',
  m: 'euiImage--medium',
  l: 'euiImage--large',
  xl: 'euiImage--xlarge',
  fullWidth: 'euiImage--fullWidth',
  original: ''
};
export var SIZES = Object.keys(sizeToClassNameMap);
var fullScreenIconColorMap = {
  light: 'ghost',
  dark: 'default'
};
export var EuiImage = function EuiImage(_ref) {
  var className = _ref.className,
      url = _ref.url,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'original' : _ref$size,
      caption = _ref.caption,
      hasShadow = _ref.hasShadow,
      allowFullScreen = _ref.allowFullScreen,
      _ref$fullScreenIconCo = _ref.fullScreenIconColor,
      fullScreenIconColor = _ref$fullScreenIconCo === void 0 ? 'light' : _ref$fullScreenIconCo,
      alt = _ref.alt,
      style = _ref.style,
      rest = _objectWithoutProperties(_ref, ["className", "url", "size", "caption", "hasShadow", "allowFullScreen", "fullScreenIconColor", "alt", "style"]);

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isFullScreenActive = _useState2[0],
      setIsFullScreenActive = _useState2[1];

  var onKeyDown = function onKeyDown(event) {
    if (event.key === keys.ESCAPE) {
      event.preventDefault();
      event.stopPropagation();
      closeFullScreen();
    }
  };

  var closeFullScreen = function closeFullScreen() {
    setIsFullScreenActive(false);
  };

  var openFullScreen = function openFullScreen() {
    setIsFullScreenActive(true);
  };

  var customStyle = _objectSpread({}, style);

  var classes = classNames('euiImage', {
    'euiImage--hasShadow': hasShadow,
    'euiImage--allowFullScreen': allowFullScreen
  }, className);

  if (typeof size === 'string' && SIZES.includes(size)) {
    classes = "".concat(classes, " ").concat(sizeToClassNameMap[size]);
  } else {
    classes = "".concat(classes);
    customStyle.maxWidth = size;
    customStyle.maxHeight = size; // Set width back to auto to ensure aspect ratio is kept

    customStyle.width = 'auto';
  }

  var _useInnerText = useInnerText(),
      _useInnerText2 = _slicedToArray(_useInnerText, 2),
      optionalCaptionRef = _useInnerText2[0],
      optionalCaptionText = _useInnerText2[1];

  var optionalCaption;

  if (caption) {
    optionalCaption = React.createElement("figcaption", {
      ref: optionalCaptionRef,
      className: "euiImage__caption"
    }, caption);
  }

  var allowFullScreenIcon = React.createElement(EuiIcon, {
    type: "fullScreen",
    color: fullScreenIconColorMap[fullScreenIconColor],
    className: "euiImage__icon"
  });
  var fullScreenDisplay = React.createElement(EuiOverlayMask, {
    onClick: closeFullScreen
  }, React.createElement(EuiFocusTrap, {
    clickOutsideDisables: true
  }, React.createElement("figure", {
    className: "euiImage euiImage-isFullScreen",
    "aria-label": optionalCaptionText
  }, React.createElement(EuiI18n, {
    token: "euiImage.closeImage",
    values: {
      alt: alt
    },
    default: "Close full screen {alt} image"
  }, function (closeImage) {
    return React.createElement("button", {
      type: "button",
      "aria-label": closeImage,
      className: "euiImage__button",
      onClick: closeFullScreen,
      onKeyDown: onKeyDown
    }, React.createElement("img", _extends({
      src: url,
      alt: alt,
      className: "euiImage-isFullScreen__img"
    }, rest)), React.createElement(EuiIcon, {
      type: "cross",
      color: fullScreenIconColorMap[fullScreenIconColor],
      className: "euiImage-isFullScreen__icon"
    }));
  }), optionalCaption)));

  if (allowFullScreen) {
    return React.createElement("figure", {
      className: classes,
      "aria-label": optionalCaptionText
    }, React.createElement(EuiI18n, {
      token: "euiImage.openImage",
      values: {
        alt: alt
      },
      default: "Open full screen {alt} image"
    }, function (openImage) {
      return React.createElement("button", {
        type: "button",
        "aria-label": openImage,
        className: "euiImage__button",
        onClick: openFullScreen
      }, React.createElement("img", _extends({
        src: url,
        alt: alt,
        className: "euiImage__img",
        style: customStyle
      }, rest)), allowFullScreenIcon, isFullScreenActive && fullScreenDisplay);
    }), optionalCaption);
  } else {
    return React.createElement("figure", {
      className: classes,
      "aria-label": optionalCaptionText
    }, React.createElement("img", _extends({
      style: customStyle,
      src: url,
      className: "euiImage__img",
      alt: alt
    }, rest)), optionalCaption);
  }
};
EuiImage.propTypes = {
  /**
     * Sepearate from the caption is a title on the alt tag itself.
     * This one is required for accessibility.
     */
  alt: PropTypes.string.isRequired,

  /**
     * Accepts `s` / `m` / `l` / `xl` / `original` / `fullWidth` / or a CSS size of `number` or `string`.
     * `fullWidth` will set the figure to stretch to 100% of its container.
     * `string` and `number` types will max both the width or height, whichever is greater.
     */
  size: PropTypes.oneOfType([PropTypes.oneOf(["s", "m", "l", "xl", "fullWidth", "original"]).isRequired, PropTypes.number.isRequired, PropTypes.string.isRequired]),

  /**
     * Changes the color of the icon that floats above the image when it can be clicked to fullscreen.
     * The default value of `light` is fine unless your image has a white background, in which case you should change it to `dark`.
     */
  fullScreenIconColor: PropTypes.oneOf(["light", "dark"]),
  url: PropTypes.string.isRequired,

  /**
     * Provides the visible caption to the image
     */
  caption: PropTypes.node,

  /**
     * When set to `true` (default) will apply a slight shadow to the image
     */
  hasShadow: PropTypes.bool,

  /**
     * When set to `true` will make the image clickable to a larger version
     */
  allowFullScreen: PropTypes.bool,
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string
};
EuiImage.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiImage",
  "props": {
    "size": {
      "defaultValue": {
        "value": "'original'",
        "computed": false
      },
      "type": {
        "name": "union",
        "value": [{
          "name": "enum",
          "value": [{
            "value": "\"s\"",
            "computed": false
          }, {
            "value": "\"m\"",
            "computed": false
          }, {
            "value": "\"l\"",
            "computed": false
          }, {
            "value": "\"xl\"",
            "computed": false
          }, {
            "value": "\"fullWidth\"",
            "computed": false
          }, {
            "value": "\"original\"",
            "computed": false
          }]
        }, {
          "name": "number"
        }, {
          "name": "string"
        }]
      },
      "required": false,
      "description": "Accepts `s` / `m` / `l` / `xl` / `original` / `fullWidth` / or a CSS size of `number` or `string`.\n`fullWidth` will set the figure to stretch to 100% of its container.\n`string` and `number` types will max both the width or height, whichever is greater."
    },
    "fullScreenIconColor": {
      "defaultValue": {
        "value": "'light'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"light\"",
          "computed": false
        }, {
          "value": "\"dark\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Changes the color of the icon that floats above the image when it can be clicked to fullscreen.\nThe default value of `light` is fine unless your image has a white background, in which case you should change it to `dark`."
    },
    "alt": {
      "type": {
        "name": "string"
      },
      "required": true,
      "description": "Sepearate from the caption is a title on the alt tag itself.\nThis one is required for accessibility."
    },
    "url": {
      "type": {
        "name": "string"
      },
      "required": true,
      "description": ""
    },
    "caption": {
      "type": {
        "name": "node"
      },
      "required": false,
      "description": "Provides the visible caption to the image"
    },
    "hasShadow": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "When set to `true` (default) will apply a slight shadow to the image"
    },
    "allowFullScreen": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "When set to `true` will make the image clickable to a larger version"
    },
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    }
  }
};