"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SeriesTypes = Object.freeze({
    Area: 'area',
    Bar: 'bar',
    Line: 'line',
    Bubble: 'bubble',
});
exports.DEFAULT_GLOBAL_ID = '__global__';
exports.Fit = Object.freeze({
    None: 'none',
    Carry: 'carry',
    Lookahead: 'lookahead',
    Nearest: 'nearest',
    Average: 'average',
    Linear: 'linear',
    Zero: 'zero',
    Explicit: 'explicit',
});
exports.HistogramModeAlignments = Object.freeze({
    Start: 'start',
    Center: 'center',
    End: 'end',
});
exports.AnnotationTypes = Object.freeze({
    Line: 'line',
    Rectangle: 'rectangle',
    Text: 'text',
});
exports.AnnotationDomainTypes = Object.freeze({
    XDomain: 'xDomain',
    YDomain: 'yDomain',
});
function isLineAnnotation(spec) {
    return spec.annotationType === exports.AnnotationTypes.Line;
}
exports.isLineAnnotation = isLineAnnotation;
function isRectAnnotation(spec) {
    return spec.annotationType === exports.AnnotationTypes.Rectangle;
}
exports.isRectAnnotation = isRectAnnotation;
function isBarSeriesSpec(spec) {
    return spec.seriesType === exports.SeriesTypes.Bar;
}
exports.isBarSeriesSpec = isBarSeriesSpec;
function isBubbleSeriesSpec(spec) {
    return spec.seriesType === exports.SeriesTypes.Bubble;
}
exports.isBubbleSeriesSpec = isBubbleSeriesSpec;
function isLineSeriesSpec(spec) {
    return spec.seriesType === exports.SeriesTypes.Line;
}
exports.isLineSeriesSpec = isLineSeriesSpec;
function isAreaSeriesSpec(spec) {
    return spec.seriesType === exports.SeriesTypes.Area;
}
exports.isAreaSeriesSpec = isAreaSeriesSpec;
function isBandedSpec(y0Accessors) {
    return Boolean(y0Accessors && y0Accessors.length > 0);
}
exports.isBandedSpec = isBandedSpec;
//# sourceMappingURL=specs.js.map