(declare (block) (standard-bindings) (extended-bindings))
(begin
  (declare (not safe))
  (define std/net/httpd/handler#http-request::t
    (make-struct-type
     'std/net/httpd/handler#http-request::t
     '#f
     '9
     'http-request
     '((final: . #t))
     '#f
     '(buf client method url path params proto headers data)))
  (define std/net/httpd/handler#http-request?
    (make-struct-predicate std/net/httpd/handler#http-request::t))
  (define std/net/httpd/handler#make-http-request
    (lambda _$args151858_
      (apply make-struct-instance
             std/net/httpd/handler#http-request::t
             _$args151858_)))
  (define std/net/httpd/handler#http-request-buf
    (make-struct-field-accessor std/net/httpd/handler#http-request::t '0))
  (define std/net/httpd/handler#http-request-client
    (make-struct-field-accessor std/net/httpd/handler#http-request::t '1))
  (define std/net/httpd/handler#http-request-method
    (make-struct-field-accessor std/net/httpd/handler#http-request::t '2))
  (define std/net/httpd/handler#http-request-url
    (make-struct-field-accessor std/net/httpd/handler#http-request::t '3))
  (define std/net/httpd/handler#http-request-path
    (make-struct-field-accessor std/net/httpd/handler#http-request::t '4))
  (define std/net/httpd/handler#http-request-params
    (make-struct-field-accessor std/net/httpd/handler#http-request::t '5))
  (define std/net/httpd/handler#http-request-proto
    (make-struct-field-accessor std/net/httpd/handler#http-request::t '6))
  (define std/net/httpd/handler#http-request-headers
    (make-struct-field-accessor std/net/httpd/handler#http-request::t '7))
  (define std/net/httpd/handler#http-request-data
    (make-struct-field-accessor std/net/httpd/handler#http-request::t '8))
  (define std/net/httpd/handler#http-request-buf-set!
    (make-struct-field-mutator std/net/httpd/handler#http-request::t '0))
  (define std/net/httpd/handler#http-request-client-set!
    (make-struct-field-mutator std/net/httpd/handler#http-request::t '1))
  (define std/net/httpd/handler#http-request-method-set!
    (make-struct-field-mutator std/net/httpd/handler#http-request::t '2))
  (define std/net/httpd/handler#http-request-url-set!
    (make-struct-field-mutator std/net/httpd/handler#http-request::t '3))
  (define std/net/httpd/handler#http-request-path-set!
    (make-struct-field-mutator std/net/httpd/handler#http-request::t '4))
  (define std/net/httpd/handler#http-request-params-set!
    (make-struct-field-mutator std/net/httpd/handler#http-request::t '5))
  (define std/net/httpd/handler#http-request-proto-set!
    (make-struct-field-mutator std/net/httpd/handler#http-request::t '6))
  (define std/net/httpd/handler#http-request-headers-set!
    (make-struct-field-mutator std/net/httpd/handler#http-request::t '7))
  (define std/net/httpd/handler#http-request-data-set!
    (make-struct-field-mutator std/net/httpd/handler#http-request::t '8))
  (define std/net/httpd/handler#http-response::t
    (make-struct-type
     'std/net/httpd/handler#http-response::t
     '#f
     '3
     'http-response
     '((final: . #t))
     '#f
     '(buf output close?)))
  (define std/net/httpd/handler#http-response?
    (make-struct-predicate std/net/httpd/handler#http-response::t))
  (define std/net/httpd/handler#make-http-response
    (lambda _$args151855_
      (apply make-struct-instance
             std/net/httpd/handler#http-response::t
             _$args151855_)))
  (define std/net/httpd/handler#http-response-buf
    (make-struct-field-accessor std/net/httpd/handler#http-response::t '0))
  (define std/net/httpd/handler#http-response-output
    (make-struct-field-accessor std/net/httpd/handler#http-response::t '1))
  (define std/net/httpd/handler#http-response-close?
    (make-struct-field-accessor std/net/httpd/handler#http-response::t '2))
  (define std/net/httpd/handler#http-response-buf-set!
    (make-struct-field-mutator std/net/httpd/handler#http-response::t '0))
  (define std/net/httpd/handler#http-response-output-set!
    (make-struct-field-mutator std/net/httpd/handler#http-response::t '1))
  (define std/net/httpd/handler#http-response-close?-set!
    (make-struct-field-mutator std/net/httpd/handler#http-response::t '2))
  (define std/net/httpd/handler#http-request-handler
    (lambda (_get-handler151786_ _sock151787_ _addr151788_)
      (letrec* ((_ibuf151790_
                 (std/net/socket/buffer#open-ssocket-input-buffer__%
                  _sock151787_
                  std/net/httpd/handler#input-buffer-size))
                (_obuf151791_
                 (std/net/socket/buffer#open-ssocket-output-buffer__%
                  _sock151787_
                  std/net/httpd/handler#output-buffer-size))
                (_loop151792_
                 (lambda ()
                   (let ((_req151804_
                          (##structure
                           std/net/httpd/handler#http-request::t
                           _ibuf151790_
                           _addr151788_
                           '#f
                           '#f
                           '#f
                           '#f
                           '#f
                           '#f
                           '#!void))
                         (_res151805_
                          (##structure
                           std/net/httpd/handler#http-response::t
                           _obuf151791_
                           '#f
                           '#f)))
                     (std/net/socket/buffer#ssocket-input-buffer-timeout-set!
                      _ibuf151790_
                      std/net/httpd/handler#request-timeout)
                     (std/net/socket/buffer#ssocket-output-buffer-timeout-set!
                      _obuf151791_
                      std/net/httpd/handler#response-timeout)
                     (with-exception-catcher
                      (lambda (_g151806151808_)
                        (if ((lambda (_$obj151811_)
                               (##structure-instance-of?
                                _$obj151811_
                                'std/error#timeout-error::t))
                             _g151806151808_)
                            (let ((_e151814_ _g151806151808_))
                              (std/logger#log-error '"request error" _e151814_)
                              (##direct-structure-set!
                               _res151805_
                               '#t
                               '3
                               std/net/httpd/handler#http-response::t
                               '#f)
                              (std/net/httpd/handler#http-response-write
                               _res151805_
                               '408
                               '()
                               '#f)
                              (raise 'abort))
                            (if ((lambda (_$obj151816_)
                                   (##structure-instance-of?
                                    _$obj151816_
                                    'std/error#io-error::t))
                                 _g151806151808_)
                                (let ((_e151819_ _g151806151808_))
                                  (std/logger#log-error
                                   '"request error"
                                   _e151819_)
                                  (##direct-structure-set!
                                   _res151805_
                                   '#t
                                   '3
                                   std/net/httpd/handler#http-response::t
                                   '#f)
                                  (std/net/httpd/handler#http-response-write
                                   _res151805_
                                   '400
                                   '()
                                   '#f)
                                  (raise 'abort))
                                (raise _g151806151808_))))
                      (lambda ()
                        (std/net/httpd/handler#read-request! _req151804_)))
                     (let* ((_method151822_
                             (##direct-structure-ref
                              _req151804_
                              '3
                              std/net/httpd/handler#http-request::t
                              '#f))
                            (_path151824_
                             (##direct-structure-ref
                              _req151804_
                              '5
                              std/net/httpd/handler#http-request::t
                              '#f))
                            (_proto151826_
                             (##direct-structure-ref
                              _req151804_
                              '7
                              std/net/httpd/handler#http-request::t
                              '#f))
                            (_headers151828_
                             (##direct-structure-ref
                              _req151804_
                              '8
                              std/net/httpd/handler#http-request::t
                              '#f))
                            (_host151830_ (assget '"Host" _headers151828_))
                            (_close?151835_
                             (let ((_$e151832_ _proto151826_))
                               (if (equal? '"HTTP/1.1" _$e151832_)
                                   (equal? (assget '"Connection"
                                                   _headers151828_)
                                           '"close")
                                   (if (equal? '"HTTP/1.0" _$e151832_)
                                       (not (equal? (assget '"Connection"
                                                            _headers151828_)
                                                    '"Keep-Alive"))
                                       '#t)))))
                       (if _close?151835_
                           (##direct-structure-set!
                            _res151805_
                            '#t
                            '3
                            std/net/httpd/handler#http-response::t
                            '#f)
                           '#!void)
                       (if (not (member _proto151826_
                                        '("HTTP/1.1" "HTTP/1.0")))
                           (std/net/httpd/handler#http-response-write
                            _res151805_
                            '505
                            '()
                            '#f)
                           (if (not (symbol? _method151822_))
                               (std/net/httpd/handler#http-response-write
                                _res151805_
                                '501
                                '()
                                '#f)
                               (if (and (eq? _method151822_ 'OPTIONS)
                                        (equal? _path151824_ '"*"))
                                   (std/net/httpd/handler#http-response-write
                                    _res151805_
                                    '200
                                    '()
                                    '#f)
                                   (if (eq? _method151822_ 'TRACE)
                                       (std/net/httpd/handler#http-response-trace
                                        _res151805_
                                        _req151804_)
                                       (let ((_$e151838_
                                              (_get-handler151786_
                                               _host151830_
                                               _path151824_)))
                                         (if _$e151838_
                                             ((lambda (_handler151841_)
                                                (if (procedure?
                                                     _handler151841_)
                                                    (with-exception-catcher
                                                     (lambda (_g151842151844_)
                                                       (if ((lambda (_$obj151847_)
                                                              (##structure-instance-of?
                                                               _$obj151847_
                                                               'std/error#io-error::t))
                                                            _g151842151844_)
                                                           (let ((_e151850_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                          _g151842151844_))
                     (std/logger#log-error '"request i/o error" _e151850_)
                     (if (##direct-structure-ref
                          _res151805_
                          '2
                          std/net/httpd/handler#http-response::t
                          '#f)
                         '#!void
                         (begin
                           (##direct-structure-set!
                            _res151805_
                            '#t
                            '3
                            std/net/httpd/handler#http-response::t
                            '#f)
                           (std/net/httpd/handler#http-response-write
                            _res151805_
                            '500
                            '()
                            '#f)))
                     (raise 'abort))
                   (if '#t
                       (let ((_e151852_ _g151842151844_))
                         (std/logger#log-error
                          '"request handler error"
                          _e151852_)
                         (if (##direct-structure-ref
                              _res151805_
                              '2
                              std/net/httpd/handler#http-response::t
                              '#f)
                             (raise 'abort)
                             (std/net/httpd/handler#http-response-write
                              _res151805_
                              '500
                              '()
                              '#f)))
                       (raise _g151842151844_))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (lambda ()
                                                       (_handler151841_
                                                        _req151804_
                                                        _res151805_)))
                                                    (begin
                                                      (std/logger#warning
                                                       '"request handler is not a procedure: ~a ~a ~a"
                                                       _host151830_
                                                       _path151824_
                                                       _handler151841_)
                                                      (std/net/httpd/handler#http-response-write
                                                       _res151805_
                                                       '500
                                                       '()
                                                       '#f))))
                                              _$e151838_)
                                             (std/net/httpd/handler#http-response-write
                                              _res151805_
                                              '404
                                              '()
                                              '#f)))))))
                       (if _close?151835_
                           '#!void
                           (begin
                             (std/net/httpd/handler#http-request-skip-body
                              _req151804_)
                             (_loop151792_))))))))
        (with-unwind-protect
         (lambda ()
           (with-exception-catcher
            (lambda (_g151793151796_)
              (if '#t
                  (let ((_e151799_ _g151793151796_))
                    (if (memq _e151799_ '(abort eof))
                        '#!void
                        (begin
                          (std/logger#log-error
                           '"unhandled exception"
                           _e151799_)
                          (raise _e151799_)))
                    _e151799_)
                  (raise _g151793151796_)))
            (lambda () (_loop151792_))))
         (lambda () (std/net/socket/api#ssocket-close _sock151787_))))))
  (define std/net/httpd/handler#http-request-body
    (lambda (_req151713_)
      (let* ((_req151714151728_ _req151713_)
             (_E151716151732_
              (lambda () (error '"No clause matching" _req151714151728_)))
             (_K151717151748_
              (lambda (_data151735_
                       _headers151736_
                       _method151737_
                       _ibuf151738_)
                (if (eq? _data151735_ '#!void)
                    (let ((_$e151740_ _method151737_))
                      (if (or (eq? 'POST _$e151740_) (eq? 'PUT _$e151740_))
                          (let ((_data151746_
                                 (std/net/httpd/handler#read-request-body
                                  _ibuf151738_
                                  _headers151736_)))
                            (##direct-structure-set!
                             _req151713_
                             _data151746_
                             '9
                             std/net/httpd/handler#http-request::t
                             '#f)
                            _data151746_)
                          (begin
                            (std/net/httpd/handler#http-request-skip-body
                             _req151713_)
                            '#f)))
                    _data151735_))))
        (if (##structure-direct-instance-of?
             _req151714151728_
             'std/net/httpd/handler#http-request::t)
            (let* ((_e151718151751_ (##vector-ref _req151714151728_ '1))
                   (_ibuf151754_ _e151718151751_)
                   (_e151719151756_ (##vector-ref _req151714151728_ '2))
                   (_e151720151759_ (##vector-ref _req151714151728_ '3))
                   (_method151762_ _e151720151759_)
                   (_e151721151764_ (##vector-ref _req151714151728_ '4))
                   (_e151722151767_ (##vector-ref _req151714151728_ '5))
                   (_e151723151770_ (##vector-ref _req151714151728_ '6))
                   (_e151724151773_ (##vector-ref _req151714151728_ '7))
                   (_e151725151776_ (##vector-ref _req151714151728_ '8))
                   (_headers151779_ _e151725151776_)
                   (_e151726151781_ (##vector-ref _req151714151728_ '9))
                   (_data151784_ _e151726151781_))
              (_K151717151748_
               _data151784_
               _headers151779_
               _method151762_
               _ibuf151754_))
            (_E151716151732_)))))
  (define std/net/httpd/handler#http-request-timeout-set!
    (lambda (_req151688_ _timeo151689_)
      (let* ((_req151690151696_ _req151688_)
             (_E151692151700_
              (lambda () (error '"No clause matching" _req151690151696_)))
             (_K151693151705_
              (lambda (_ibuf151703_)
                (std/net/socket/buffer#ssocket-input-buffer-timeout-set!
                 _ibuf151703_
                 _timeo151689_))))
        (if (##structure-direct-instance-of?
             _req151690151696_
             'std/net/httpd/handler#http-request::t)
            (let* ((_e151694151708_ (##vector-ref _req151690151696_ '1))
                   (_ibuf151711_ _e151694151708_))
              (_K151693151705_ _ibuf151711_))
            (_E151692151700_)))))
  (define std/net/httpd/handler#http-response-write
    (lambda (_res151638_ _status151639_ _headers151640_ _body151641_)
      (let* ((_res151642151650_ _res151638_)
             (_E151644151654_
              (lambda () (error '"No clause matching" _res151642151650_)))
             (_K151645151670_
              (lambda (_close?151657_ _output151658_ _obuf151659_)
                (if _output151658_
                    (error '"duplicate response" _res151638_)
                    '#!void)
                (##direct-structure-set!
                 _res151638_
                 'END
                 '2
                 std/net/httpd/handler#http-response::t
                 '#f)
                (let* ((_len151661_
                        (if (u8vector? _body151641_)
                            (u8vector-length _body151641_)
                            (if (string? _body151641_)
                                (std/text/utf8#string-utf8-length__0
                                 _body151641_)
                                (if (not _body151641_)
                                    '0
                                    (error '"Bad response body; expected string, u8vector, or #f"
                                           _body151641_)))))
                       (_headers151663_
                        (cons (cons '"Content-Length"
                                    (number->string _len151661_))
                              _headers151640_))
                       (_headers151665_
                        (if _close?151657_
                            (cons '("Connection" . "close") _headers151663_)
                            _headers151663_))
                       (_headers151667_
                        (cons (cons '"Date" (std/net/httpd/handler#http-date))
                              _headers151665_)))
                  (std/net/httpd/handler#write-response-line
                   _obuf151659_
                   _status151639_)
                  (std/net/httpd/handler#write-response-headers
                   _obuf151659_
                   _headers151667_)
                  (std/net/httpd/handler#write-crlf _obuf151659_)
                  (if (u8vector? _body151641_)
                      (std/net/bio/output#bio-write-bytes
                       _body151641_
                       _obuf151659_)
                      (if (string? _body151641_)
                          (std/net/bio/output#bio-write-string
                           _body151641_
                           _obuf151659_)
                          '#!void))
                  (std/net/bio/output#bio-force-output _obuf151659_)))))
        (if (##structure-direct-instance-of?
             _res151642151650_
             'std/net/httpd/handler#http-response::t)
            (let* ((_e151646151673_ (##vector-ref _res151642151650_ '1))
                   (_obuf151676_ _e151646151673_)
                   (_e151647151678_ (##vector-ref _res151642151650_ '2))
                   (_output151681_ _e151647151678_)
                   (_e151648151683_ (##vector-ref _res151642151650_ '3))
                   (_close?151686_ _e151648151683_))
              (_K151645151670_ _close?151686_ _output151681_ _obuf151676_))
            (_E151644151654_)))))
  (define std/net/httpd/handler#http-response-begin
    (lambda (_res151591_ _status151592_ _headers151593_)
      (let* ((_res151594151602_ _res151591_)
             (_E151596151606_
              (lambda () (error '"No clause matching" _res151594151602_)))
             (_K151597151620_
              (lambda (_close?151609_ _output151610_ _obuf151611_)
                (if _output151610_
                    (error '"duplicate response" _res151591_)
                    '#!void)
                (##direct-structure-set!
                 _res151591_
                 'CHUNK
                 '2
                 std/net/httpd/handler#http-response::t
                 '#f)
                (let* ((_headers151613_
                        (cons '("Transfer-Encoding" . "chunked")
                              _headers151593_))
                       (_headers151615_
                        (if _close?151609_
                            (cons '("Connection" . "close") _headers151613_)
                            _headers151613_))
                       (_headers151617_
                        (cons (cons '"Date" (std/net/httpd/handler#http-date))
                              _headers151615_)))
                  (std/net/httpd/handler#write-response-line
                   _obuf151611_
                   _status151592_)
                  (std/net/httpd/handler#write-response-headers
                   _obuf151611_
                   _headers151617_)
                  (std/net/httpd/handler#write-crlf _obuf151611_)))))
        (if (##structure-direct-instance-of?
             _res151594151602_
             'std/net/httpd/handler#http-response::t)
            (let* ((_e151598151623_ (##vector-ref _res151594151602_ '1))
                   (_obuf151626_ _e151598151623_)
                   (_e151599151628_ (##vector-ref _res151594151602_ '2))
                   (_output151631_ _e151599151628_)
                   (_e151600151633_ (##vector-ref _res151594151602_ '3))
                   (_close?151636_ _e151600151633_))
              (_K151597151620_ _close?151636_ _output151631_ _obuf151626_))
            (_E151596151606_)))))
  (define std/net/httpd/handler#http-response-chunk__%
    (lambda (_res151536_ _chunk151537_ _start151538_ _end151539_)
      (let* ((_res151540151547_ _res151536_)
             (_E151542151551_
              (lambda () (error '"No clause matching" _res151540151547_)))
             (_K151543151557_
              (lambda (_output151554_ _obuf151555_)
                (if (eq? _output151554_ 'CHUNK)
                    '#!void
                    (error '"illegal response; not writing chunks"
                           _res151536_
                           _output151554_))
                (std/net/httpd/handler#write-chunk
                 _obuf151555_
                 _chunk151537_
                 _start151538_
                 _end151539_))))
        (if (##structure-direct-instance-of?
             _res151540151547_
             'std/net/httpd/handler#http-response::t)
            (let* ((_e151544151560_ (##vector-ref _res151540151547_ '1))
                   (_obuf151563_ _e151544151560_)
                   (_e151545151565_ (##vector-ref _res151540151547_ '2))
                   (_output151568_ _e151545151565_))
              (_K151543151557_ _output151568_ _obuf151563_))
            (_E151542151551_)))))
  (define std/net/httpd/handler#http-response-chunk__0
    (lambda (_res151573_ _chunk151574_)
      (let* ((_start151576_ '0) (_end151578_ '#f))
        (std/net/httpd/handler#http-response-chunk__%
         _res151573_
         _chunk151574_
         _start151576_
         _end151578_))))
  (define std/net/httpd/handler#http-response-chunk__1
    (lambda (_res151580_ _chunk151581_ _start151582_)
      (let ((_end151584_ '#f))
        (std/net/httpd/handler#http-response-chunk__%
         _res151580_
         _chunk151581_
         _start151582_
         _end151584_))))
  (define std/net/httpd/handler#http-response-chunk
    (lambda _g151861_
      (let ((_g151860_ (length _g151861_)))
        (cond ((##fx= _g151860_ 2)
               (apply std/net/httpd/handler#http-response-chunk__0 _g151861_))
              ((##fx= _g151860_ 3)
               (apply std/net/httpd/handler#http-response-chunk__1 _g151861_))
              ((##fx= _g151860_ 4)
               (apply std/net/httpd/handler#http-response-chunk__% _g151861_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/httpd/handler#http-response-chunk
                _g151861_))))))
  (define std/net/httpd/handler#http-response-end
    (lambda (_res151504_)
      (let* ((_res151505151512_ _res151504_)
             (_E151507151516_
              (lambda () (error '"No clause matching" _res151505151512_)))
             (_K151508151522_
              (lambda (_output151519_ _obuf151520_)
                (if (eq? _output151519_ 'CHUNK)
                    '#!void
                    (error '"illegal response; not writing chunks"
                           _res151504_
                           _output151519_))
                (##direct-structure-set!
                 _res151504_
                 'END
                 '2
                 std/net/httpd/handler#http-response::t
                 '#f)
                (std/net/httpd/handler#write-last-chunk _obuf151520_)
                (std/net/bio/output#bio-force-output _obuf151520_))))
        (if (##structure-direct-instance-of?
             _res151505151512_
             'std/net/httpd/handler#http-response::t)
            (let* ((_e151509151525_ (##vector-ref _res151505151512_ '1))
                   (_obuf151528_ _e151509151525_)
                   (_e151510151530_ (##vector-ref _res151505151512_ '2))
                   (_output151533_ _e151510151530_))
              (_K151508151522_ _output151533_ _obuf151528_))
            (_E151507151516_)))))
  (define std/net/httpd/handler#http-response-force-output
    (lambda (_res151502_)
      (std/net/bio/output#bio-force-output
       (##direct-structure-ref
        _res151502_
        '1
        std/net/httpd/handler#http-response::t
        '#f))))
  (define std/net/httpd/handler#http-response-timeout-set!
    (lambda (_res151477_ _timeo151478_)
      (let* ((_res151479151485_ _res151477_)
             (_E151481151489_
              (lambda () (error '"No clause matching" _res151479151485_)))
             (_K151482151494_
              (lambda (_obuf151492_)
                (std/net/socket/buffer#ssocket-output-buffer-timeout-set!
                 _obuf151492_
                 _timeo151478_))))
        (if (##structure-direct-instance-of?
             _res151479151485_
             'std/net/httpd/handler#http-response::t)
            (let* ((_e151483151497_ (##vector-ref _res151479151485_ '1))
                   (_obuf151500_ _e151483151497_))
              (_K151482151494_ _obuf151500_))
            (_E151481151489_)))))
  (define std/net/httpd/handler#http-request-skip-body
    (lambda (_req151475_)
      (if (eq? (##direct-structure-ref
                _req151475_
                '9
                std/net/httpd/handler#http-request::t
                '#f)
               '#!void)
          (begin
            (##direct-structure-set!
             _req151475_
             '#f
             '9
             std/net/httpd/handler#http-request::t
             '#f)
            (std/net/httpd/handler#skip-request-body
             (##direct-structure-ref
              _req151475_
              '1
              std/net/httpd/handler#http-request::t
              '#f)
             (##direct-structure-ref
              _req151475_
              '8
              std/net/httpd/handler#http-request::t
              '#f)))
          '#!void)))
  (define std/net/httpd/handler#http-response-trace
    (lambda (_res151405_ _req151406_)
      (let* ((_req151407151420_ _req151406_)
             (_E151409151424_
              (lambda () (error '"No clause matching" _req151407151420_)))
             (_K151410151440_
              (lambda (_headers151427_
                       _proto151428_
                       _url151429_
                       _method151430_)
                (let ((_xbuf151432_
                       (std/net/bio/buffer#open-chunked-output-buffer__0)))
                  (std/net/bio/output#bio-write-string
                   (symbol->string _method151430_)
                   _xbuf151432_)
                  (std/net/bio/output#bio-write-u8
                   std/net/httpd/handler#SPC
                   _xbuf151432_)
                  (std/net/bio/output#bio-write-string
                   _url151429_
                   _xbuf151432_)
                  (std/net/bio/output#bio-write-u8
                   std/net/httpd/handler#SPC
                   _xbuf151432_)
                  (std/net/bio/output#bio-write-string
                   _proto151428_
                   _xbuf151432_)
                  (std/net/httpd/handler#write-crlf _xbuf151432_)
                  (std/net/httpd/handler#write-response-headers
                   _xbuf151432_
                   _headers151427_)
                  (std/net/httpd/handler#write-crlf _xbuf151432_)
                  (let ((_chunks151434_
                         (std/net/bio/buffer#chunked-output-chunks
                          _xbuf151432_)))
                    (std/net/httpd/handler#http-response-begin
                     _res151405_
                     '200
                     '(("Content-Type" . "message/http")))
                    (for-each
                     (lambda (_g151435151437_)
                       (std/net/httpd/handler#http-response-chunk__0
                        _res151405_
                        _g151435151437_))
                     _chunks151434_)
                    (std/net/httpd/handler#http-response-end _res151405_))))))
        (if (##structure-direct-instance-of?
             _req151407151420_
             'std/net/httpd/handler#http-request::t)
            (let* ((_e151411151443_ (##vector-ref _req151407151420_ '1))
                   (_e151412151446_ (##vector-ref _req151407151420_ '2))
                   (_e151413151449_ (##vector-ref _req151407151420_ '3))
                   (_method151452_ _e151413151449_)
                   (_e151414151454_ (##vector-ref _req151407151420_ '4))
                   (_url151457_ _e151414151454_)
                   (_e151415151459_ (##vector-ref _req151407151420_ '5))
                   (_e151416151462_ (##vector-ref _req151407151420_ '6))
                   (_e151417151465_ (##vector-ref _req151407151420_ '7))
                   (_proto151468_ _e151417151465_)
                   (_e151418151470_ (##vector-ref _req151407151420_ '8))
                   (_headers151473_ _e151418151470_))
              (_K151410151440_
               _headers151473_
               _proto151468_
               _url151457_
               _method151452_))
            (_E151409151424_)))))
  (define-macro (define-guard guard defn)
    (if (eval `(cond-expand (,guard #t) (else #f)))
        '(begin)
        (begin (eval `(define-cond-expand-feature ,guard)) defn)))
  (define-macro (define-c-lambda id args ret #!optional (name #f))
    (let ((name (or name (symbol->string id))))
      `(define ,id (c-lambda ,args ,ret ,name))))
  (define-macro (define-const symbol)
    (let* ((str (symbol->string symbol))
           (ref (string-append "___return (" str ");")))
      `(define ,symbol ((c-lambda () int ,ref)))))
  (define-macro (define-const* symbol)
    (let* ((str (symbol->string symbol))
           (code (string-append
                  "#ifdef "
                  str
                  "\n"
                  "___return (___FIX ("
                  str
                  "));\n"
                  "#else \n"
                  "___return (___FAL);\n"
                  "#endif")))
      `(define ,symbol ((c-lambda () scheme-object ,code)))))
  (c-declare "#include <stdlib.h>")
  (c-declare "static ___SCMOBJ ffi_free (void *ptr);")
  (c-declare
   "#ifndef ___HAVE_FFI_U8VECTOR\n#define ___HAVE_FFI_U8VECTOR\n#define U8_DATA(obj) ___CAST (___U8*, ___BODY_AS (obj, ___tSUBTYPED))\n#define U8_LEN(obj) ___HD_BYTES (___HEADER (obj))\n#endif")
  (namespace ("std/net/httpd/handler#" http-date))
  (c-declare
   "#include <time.h>\n#include <string.h>\n__thread char buf[64];\nstatic char *ffi_httpd_date () {\n struct tm tm;\n time_t t = time(NULL);\n asctime_r (gmtime_r (&t, &tm), buf);\n // clobber newline\n buf[strlen(buf)-1] = 0;\n return buf;\n}")
  (define-c-lambda http-date () char-string "ffi_httpd_date")
  (c-declare
   "#ifndef ___HAVE_FFI_FREE\n#define ___HAVE_FFI_FREE\n___SCMOBJ ffi_free (void *ptr)\n{\n free (ptr);\n return ___FIX (___NO_ERR);\n}\n#endif")
  (define std/net/httpd/handler#request-timeout '60)
  (define std/net/httpd/handler#response-timeout '120)
  (define std/net/httpd/handler#max-request-headers '256)
  (define std/net/httpd/handler#max-token-length '1024)
  (define std/net/httpd/handler#max-request-body-length (expt '2 '20))
  (define std/net/httpd/handler#input-buffer-size '4096)
  (define std/net/httpd/handler#output-buffer-size '4096)
  (define std/net/httpd/handler#set-httpd-request-timeout!
    (lambda (_val151396_)
      (if (or (not _val151396_) (real? _val151396_) (time? _val151396_))
          (set! std/net/httpd/handler#request-timeout _val151396_)
          (error '"Cannot set httpd parameter; Bad argument" _val151396_))))
  (define std/net/httpd/handler#set-httpd-response-timeout!
    (lambda (_val151387_)
      (if (or (not _val151387_) (real? _val151387_) (time? _val151387_))
          (set! std/net/httpd/handler#response-timeout _val151387_)
          (error '"Cannot set httpd parameter; Bad argument" _val151387_))))
  (define std/net/httpd/handler#set-httpd-max-request-headers!
    (lambda (_val151384_)
      (if (and (fixnum? _val151384_) (fxpositive? _val151384_))
          (set! std/net/httpd/handler#max-request-headers _val151384_)
          (error '"Cannot set httpd parameter; Bad argument" _val151384_))))
  (define std/net/httpd/handler#set-httpd-max-token-length!
    (lambda (_val151381_)
      (if (and (fixnum? _val151381_) (fxpositive? _val151381_))
          (set! std/net/httpd/handler#max-token-length _val151381_)
          (error '"Cannot set httpd parameter; Bad argument" _val151381_))))
  (define std/net/httpd/handler#set-httpd-max-request-body-length!
    (lambda (_val151378_)
      (if (and (fixnum? _val151378_) (fxpositive? _val151378_))
          (set! std/net/httpd/handler#max-request-body-length _val151378_)
          (error '"Cannot set httpd parameter; Bad argument" _val151378_))))
  (define std/net/httpd/handler#set-httpd-input-buffer-size!
    (lambda (_val151375_)
      (if (and (fixnum? _val151375_) (fxpositive? _val151375_))
          (set! std/net/httpd/handler#input-buffer-size _val151375_)
          (error '"Cannot set httpd parameter; Bad argument" _val151375_))))
  (define std/net/httpd/handler#set-httpd-output-buffer-size!
    (lambda (_val151372_)
      (if (and (fixnum? _val151372_) (fxpositive? _val151372_))
          (set! std/net/httpd/handler#output-buffer-size _val151372_)
          (error '"Cannot set httpd parameter; Bad argument" _val151372_))))
  (define std/net/httpd/handler#read-request!
    (lambda (_req151358_)
      (let* ((_ibuf151360_
              (##direct-structure-ref
               _req151358_
               '1
               std/net/httpd/handler#http-request::t
               '#f))
             (_g151862_
              (std/net/httpd/handler#read-request-line _ibuf151360_)))
        (begin
          (let ((_g151863_
                 (if (##values? _g151862_) (##vector-length _g151862_) 1)))
            (if (not (##fx= _g151863_ 3))
                (error "Context expects 3 values" _g151863_)))
          (let ((_method151362_ (##vector-ref _g151862_ 0))
                (_url151363_ (##vector-ref _g151862_ 1))
                (_proto151364_ (##vector-ref _g151862_ 2)))
            (let ((_g151864_
                   (std/net/httpd/handler#split-request-url _url151363_)))
              (begin
                (let ((_g151865_
                       (if (##values? _g151864_)
                           (##vector-length _g151864_)
                           1)))
                  (if (not (##fx= _g151865_ 2))
                      (error "Context expects 2 values" _g151865_)))
                (let ((_path151366_ (##vector-ref _g151864_ 0))
                      (_params151367_ (##vector-ref _g151864_ 1)))
                  (let ((_headers151369_
                         (std/net/httpd/handler#read-request-headers
                          _ibuf151360_)))
                    (##direct-structure-set!
                     _req151358_
                     _method151362_
                     '3
                     std/net/httpd/handler#http-request::t
                     '#f)
                    (##direct-structure-set!
                     _req151358_
                     _url151363_
                     '4
                     std/net/httpd/handler#http-request::t
                     '#f)
                    (##direct-structure-set!
                     _req151358_
                     _path151366_
                     '5
                     std/net/httpd/handler#http-request::t
                     '#f)
                    (##direct-structure-set!
                     _req151358_
                     _params151367_
                     '6
                     std/net/httpd/handler#http-request::t
                     '#f)
                    (##direct-structure-set!
                     _req151358_
                     _proto151364_
                     '7
                     std/net/httpd/handler#http-request::t
                     '#f)
                    (##direct-structure-set!
                     _req151358_
                     _headers151369_
                     '8
                     std/net/httpd/handler#http-request::t
                     '#f))))))))))
  (define std/net/httpd/handler#split-request-url-rx
    (std/pregexp#pregexp '"^[^/]+://[^/]*(/.*)$"))
  (define std/net/httpd/handler#split-request-url
    (lambda (_url151311_)
      (let ((_$e151313_ (string-index _url151311_ '#\:)))
        (if _$e151313_
            ((lambda (_ix151316_)
               (let* ((_g151317151327_
                       (std/pregexp#pregexp-match
                        std/net/httpd/handler#split-request-url-rx
                        _url151311_))
                      (_else151319151335_
                       (lambda ()
                         (std/error#raise-io-error
                          'http-read-request
                          '"invalid url"
                          _url151311_)))
                      (_K151321151340_
                       (lambda (_base151338_)
                         (std/net/httpd/handler#split-request-url
                          _base151338_))))
                 (if (##pair? _g151317151327_)
                     (let ((_tl151323151343_ (##cdr _g151317151327_)))
                       (if (##pair? _tl151323151343_)
                           (let ((_hd151324151346_ (##car _tl151323151343_))
                                 (_tl151325151348_ (##cdr _tl151323151343_)))
                             (let ((_base151351_ _hd151324151346_))
                               (if (##null? _tl151325151348_)
                                   (std/net/httpd/handler#split-request-url
                                    _base151351_)
                                   (_else151319151335_))))
                           (_else151319151335_)))
                     (_else151319151335_))))
             _$e151313_)
            (let ((_$e151353_ (string-index _url151311_ '#\?)))
              (if _$e151353_
                  ((lambda (_ix151356_)
                     (values (substring _url151311_ '0 _ix151356_)
                             (substring
                              _url151311_
                              (fx+ _ix151356_ '1)
                              (string-length _url151311_))))
                   _$e151353_)
                  (values _url151311_ '#f)))))))
  (define std/net/httpd/handler#read-request-line
    (lambda (_ibuf151293_)
      (let* ((_g151866_
              (std/net/httpd/handler#read-skip*__1
               _ibuf151293_
               std/net/httpd/handler#CR
               std/net/httpd/handler#LF))
             (_method151296_
              (std/net/httpd/handler#read-token
               _ibuf151293_
               std/net/httpd/handler#SPC))
             (_g151867_
              (std/net/httpd/handler#read-skip__0
               _ibuf151293_
               std/net/httpd/handler#SPC))
             (_url151299_
              (std/net/httpd/handler#read-token
               _ibuf151293_
               std/net/httpd/handler#SPC))
             (_g151868_
              (std/net/httpd/handler#read-skip__0
               _ibuf151293_
               std/net/httpd/handler#SPC))
             (_proto151302_
              (std/net/httpd/handler#read-token
               _ibuf151293_
               std/net/httpd/handler#CR))
             (_g151869_
              (std/net/httpd/handler#read-skip__1
               _ibuf151293_
               std/net/httpd/handler#CR
               std/net/httpd/handler#LF))
             (_method151308_
              (let ((_$e151305_
                     (table-ref
                      std/net/httpd/handler#+http-request-methods+
                      _method151296_
                      '#f)))
                (if _$e151305_ _$e151305_ _method151296_))))
        (values _method151308_ _url151299_ _proto151302_))))
  (define std/net/httpd/handler#read-request-headers
    (lambda (_ibuf151282_)
      (let _lp151284_ ((_headers151286_ '()) (_count151287_ '0))
        (let ((_next151289_ (std/net/bio/input#bio-peek-u8 _ibuf151282_)))
          (if (eof-object? _next151289_)
              (raise 'eof)
              (if (eq? _next151289_ std/net/httpd/handler#CR)
                  (begin
                    (std/net/httpd/handler#read-skip__1
                     _ibuf151282_
                     std/net/httpd/handler#CR
                     std/net/httpd/handler#LF)
                    (std/srfi/1#reverse! _headers151286_))
                  (if (fx< _count151287_
                           std/net/httpd/handler#max-request-headers)
                      (let ((_hdr151291_
                             (std/net/httpd/handler#read-header _ibuf151282_)))
                        (_lp151284_
                         (cons _hdr151291_ _headers151286_)
                         (fx+ _count151287_ '1)))
                      (std/error#raise-io-error
                       'http-read-request
                       '"too many headers"
                       _count151287_))))))))
  (define std/net/httpd/handler#read-header
    (lambda (_ibuf151271_)
      (let* ((_key151273_
              (std/net/httpd/handler#read-token
               _ibuf151271_
               std/net/httpd/handler#COL))
             (_g151870_ (std/net/httpd/handler#header-titlecase! _key151273_))
             (_g151871_
              (std/net/httpd/handler#read-skip__0
               _ibuf151271_
               std/net/httpd/handler#COL))
             (_g151872_
              (std/net/httpd/handler#read-skip*__0
               _ibuf151271_
               std/net/httpd/handler#SPC))
             (_val151278_
              (std/net/httpd/handler#read-token
               _ibuf151271_
               std/net/httpd/handler#CR))
             (_g151873_
              (std/net/httpd/handler#read-skip__1
               _ibuf151271_
               std/net/httpd/handler#CR
               std/net/httpd/handler#LF)))
        (cons _key151273_ _val151278_))))
  (define std/net/httpd/handler#header-titlecase!
    (lambda (_str151258_)
      (let ((_len151260_ (string-length _str151258_)))
        (let _lp151262_ ((_i151264_ '0) (_upcase?151265_ '#t))
          (if (fx< _i151264_ _len151260_)
              (let ((_char151267_ (string-ref _str151258_ _i151264_)))
                (if (char-alphabetic? _char151267_)
                    (let ((_char151269_
                           (if _upcase?151265_
                               (char-upcase _char151267_)
                               (char-downcase _char151267_))))
                      (string-set! _str151258_ _i151264_ _char151269_)
                      (_lp151262_ (fx+ _i151264_ '1) '#f))
                    (_lp151262_ (fx+ _i151264_ '1) '#t)))
              _str151258_)))))
  (define std/net/httpd/handler#read-token
    (lambda (_ibuf151246_ _sep151247_)
      (let _lp151249_ ((_chars151251_ '()) (_count151252_ '0))
        (let ((_next151254_ (std/net/bio/input#bio-peek-u8 _ibuf151246_)))
          (if (eof-object? _next151254_)
              (raise 'eof)
              (if (eq? _next151254_ _sep151247_)
                  (std/net/httpd/handler#token-chars->string
                   _chars151251_
                   _count151252_)
                  (if (fx< _count151252_
                           std/net/httpd/handler#max-token-length)
                      (let ((_char151256_
                             (integer->char
                              (std/net/bio/input#bio-read-u8 _ibuf151246_))))
                        (_lp151249_
                         (cons _char151256_ _chars151251_)
                         (fx+ _count151252_ '1)))
                      (std/error#raise-io-error
                       'http-read-request
                       '"Maximum token length exceeded"
                       _count151252_))))))))
  (define std/net/httpd/handler#token-chars->string
    (lambda (_chars151234_ _count151235_)
      (let ((_str151237_ (make-string _count151235_)))
        (let _lp151239_ ((_i151241_ _count151235_)
                         (_rest151242_ _chars151234_))
          (if (fx> _i151241_ '0)
              (let ((_i151244_ (fx- _i151241_ '1)))
                (string-set! _str151237_ _i151244_ (car _rest151242_))
                (_lp151239_ _i151244_ (cdr _rest151242_)))
              _str151237_)))))
  (define std/net/httpd/handler#read-skip__0
    (lambda (_ibuf151225_ _c151226_)
      (let ((_next151228_ (std/net/bio/input#bio-read-u8 _ibuf151225_)))
        (if (eq? _c151226_ _next151228_)
            '#!void
            (std/error#raise-io-error
             'http-read-request
             '"Unexpected character"
             _next151228_)))))
  (define std/net/httpd/handler#read-skip__1
    (lambda (_ibuf151230_ _c1151231_ _c2151232_)
      (std/net/httpd/handler#read-skip__0 _ibuf151230_ _c1151231_)
      (std/net/httpd/handler#read-skip__0 _ibuf151230_ _c2151232_)))
  (define std/net/httpd/handler#read-skip
    (lambda _g151875_
      (let ((_g151874_ (length _g151875_)))
        (cond ((##fx= _g151874_ 2)
               (apply std/net/httpd/handler#read-skip__0 _g151875_))
              ((##fx= _g151874_ 3)
               (apply std/net/httpd/handler#read-skip__1 _g151875_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/httpd/handler#read-skip
                _g151875_))))))
  (define std/net/httpd/handler#read-skip*__0
    (lambda (_ibuf151208_ _c151209_)
      (let _lp151211_ ()
        (let ((_next151214_ (std/net/bio/input#bio-peek-u8 _ibuf151208_)))
          (if (eq? _next151214_ _c151209_)
              (begin (std/net/bio/input#bio-read-u8 _ibuf151208_) (_lp151211_))
              '#!void)))))
  (define std/net/httpd/handler#read-skip*__1
    (lambda (_ibuf151216_ _c1151217_ _c2151218_)
      (let _lp151220_ ()
        (let ((_next151223_ (std/net/bio/input#bio-peek-u8 _ibuf151216_)))
          (if (eq? _next151223_ _c1151217_)
              (begin
                (std/net/bio/input#bio-read-u8 _ibuf151216_)
                (std/net/httpd/handler#read-skip__0 _ibuf151216_ _c2151218_)
                (_lp151220_))
              '#!void)))))
  (define std/net/httpd/handler#read-skip*
    (lambda _g151877_
      (let ((_g151876_ (length _g151877_)))
        (cond ((##fx= _g151876_ 2)
               (apply std/net/httpd/handler#read-skip*__0 _g151877_))
              ((##fx= _g151876_ 3)
               (apply std/net/httpd/handler#read-skip*__1 _g151877_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/httpd/handler#read-skip*
                _g151877_))))))
  (define std/net/httpd/handler#read-request-body
    (lambda (_ibuf151186_ _headers151187_)
      (letrec ((_read-simple-body151189_
                (lambda ()
                  (let ((_$e151197_
                         (assget '"Content-Length" _headers151187_)))
                    (if _$e151197_
                        ((lambda (_len151200_)
                           (let* ((_len151202_ (string->number _len151200_))
                                  (_g151878_
                                   (if (fx<= _len151202_
                                             std/net/httpd/handler#max-request-body-length)
                                       '#!void
                                       (std/error#raise-io-error
                                        'http-request-body
                                        '"Maximum body length exceeded"
                                        _len151202_)))
                                  (_bytes151205_ (make-u8vector _len151202_)))
                             (std/net/bio/input#bio-read-bytes
                              _bytes151205_
                              _ibuf151186_)
                             _bytes151205_))
                         _$e151197_)
                        '#f)))))
        (let ((_$e151191_ (assget '"Transfer-Encoding" _headers151187_)))
          (if _$e151191_
              ((lambda (_tenc151194_)
                 (if (not (equal? '"identity" _tenc151194_))
                     (std/net/httpd/handler#read-request-chunks _ibuf151186_)
                     (_read-simple-body151189_)))
               _$e151191_)
              (_read-simple-body151189_))))))
  (define std/net/httpd/handler#read-request-chunks
    (lambda (_ibuf151169_)
      (let _lp151171_ ((_chunks151173_ '()) (_count151174_ '0))
        (let* ((_next151176_
                (std/net/httpd/handler#read-token
                 _ibuf151169_
                 std/net/httpd/handler#CR))
               (_g151879_
                (std/net/httpd/handler#read-skip__1
                 _ibuf151169_
                 std/net/httpd/handler#CR
                 std/net/httpd/handler#LF))
               (_len151179_ (string->number _next151176_ '16)))
          (if (fx> _len151179_ '0)
              (let ((_count151182_ (fx+ _count151174_ _len151179_)))
                (if (fx<= _count151182_
                          std/net/httpd/handler#max-request-body-length)
                    (let ((_chunk151184_ (make-u8vector _len151179_)))
                      (std/net/bio/input#bio-read-bytes
                       _chunk151184_
                       _ibuf151169_)
                      (std/net/httpd/handler#read-skip__1
                       _ibuf151169_
                       std/net/httpd/handler#CR
                       std/net/httpd/handler#LF)
                      (_lp151171_
                       (cons _chunk151184_ _chunks151173_)
                       _count151182_))
                    (std/error#raise-io-error
                     'http-request-body
                     '"Maximum body length exceeded"
                     _count151182_
                     _len151179_)))
              (append-u8vectors (std/srfi/1#reverse! _chunks151173_)))))))
  (define std/net/httpd/handler#skip-request-body
    (lambda (_ibuf151150_ _headers151151_)
      (letrec ((_skip-simple-body151153_
                (lambda ()
                  (let ((_clen151160151162_
                         (assget '"Content-Length" _headers151151_)))
                    (if _clen151160151162_
                        (let* ((_clen151165_ _clen151160151162_)
                               (_len151167_ (string->number _clen151165_)))
                          (if (fixnum? _len151167_)
                              (std/net/bio/input#bio-input-skip
                               _len151167_
                               _ibuf151150_)
                              (std/error#raise-io-error
                               'http-request-skip-body
                               '"Illegal body length"
                               _clen151165_)))
                        '#f)))))
        (let ((_$e151155_ (assget '"Transfer-Encoding" _headers151151_)))
          (if _$e151155_
              ((lambda (_tenc151158_)
                 (if (not (equal? '"identity" _tenc151158_))
                     (std/net/httpd/handler#skip-request-chunks _ibuf151150_)
                     (_skip-simple-body151153_)))
               _$e151155_)
              (_skip-simple-body151153_))))))
  (define std/net/httpd/handler#skip-request-chunks
    (lambda (_ibuf151142_)
      (let* ((_next151144_
              (std/net/httpd/handler#read-token
               _ibuf151142_
               std/net/httpd/handler#CR))
             (_g151880_
              (std/net/httpd/handler#read-skip__1
               _ibuf151142_
               std/net/httpd/handler#CR
               std/net/httpd/handler#LF))
             (_len151147_ (string->number _next151144_ '16)))
        (if (fx> _len151147_ '0)
            (begin
              (std/net/bio/input#bio-input-skip _len151147_ _ibuf151142_)
              (std/net/httpd/handler#read-skip__1
               _ibuf151142_
               std/net/httpd/handler#CR
               std/net/httpd/handler#LF)
              (std/net/httpd/handler#skip-request-chunks _ibuf151142_))
            '#!void))))
  (define std/net/httpd/handler#write-response-line
    (lambda (_obuf151134_ _status151135_)
      (let ((_text151140_
             (let ((_$e151137_
                    (table-ref
                     std/net/httpd/handler#+http-response-codes+
                     _status151135_
                     '#f)))
               (if _$e151137_ (values _$e151137_) '"Gremlins!"))))
        (std/net/bio/output#bio-write-string '"HTTP/1.1" _obuf151134_)
        (std/net/bio/output#bio-write-u8
         std/net/httpd/handler#SPC
         _obuf151134_)
        (std/net/bio/output#bio-write-string
         (number->string _status151135_)
         _obuf151134_)
        (std/net/bio/output#bio-write-u8
         std/net/httpd/handler#SPC
         _obuf151134_)
        (std/net/bio/output#bio-write-string _text151140_ _obuf151134_)
        (std/net/httpd/handler#write-crlf _obuf151134_))))
  (define std/net/httpd/handler#write-response-headers
    (lambda (_obuf151099_ _headers151100_)
      (letrec ((_write-header151102_
                (lambda (_hdr151104_)
                  (let* ((_hdr151105151112_ _hdr151104_)
                         (_E151107151116_
                          (lambda ()
                            (error '"No clause matching" _hdr151105151112_)))
                         (_K151108151122_
                          (lambda (_val151119_ _key151120_)
                            (if (string? _key151120_)
                                (if (string? _val151119_)
                                    (begin
                                      (std/net/bio/output#bio-write-string
                                       _key151120_
                                       _obuf151099_)
                                      (std/net/bio/output#bio-write-u8
                                       std/net/httpd/handler#COL
                                       _obuf151099_)
                                      (std/net/bio/output#bio-write-u8
                                       std/net/httpd/handler#SPC
                                       _obuf151099_)
                                      (std/net/bio/output#bio-write-string
                                       _val151119_
                                       _obuf151099_)
                                      (std/net/httpd/handler#write-crlf
                                       _obuf151099_))
                                    (error '"Bad header value; expected string"
                                           _hdr151104_
                                           _val151119_))
                                (error '"Bad header key; expected string"
                                       _hdr151104_
                                       _key151120_)))))
                    (if (##pair? _hdr151105151112_)
                        (let ((_hd151109151125_ (##car _hdr151105151112_))
                              (_tl151110151127_ (##cdr _hdr151105151112_)))
                          (let* ((_key151130_ _hd151109151125_)
                                 (_val151132_ _tl151110151127_))
                            (_K151108151122_ _val151132_ _key151130_)))
                        (_E151107151116_))))))
        (for-each _write-header151102_ _headers151100_))))
  (define std/net/httpd/handler#write-crlf
    (lambda (_obuf151097_)
      (std/net/bio/output#bio-write-u8 std/net/httpd/handler#CR _obuf151097_)
      (std/net/bio/output#bio-write-u8 std/net/httpd/handler#LF _obuf151097_)))
  (define std/net/httpd/handler#write-chunk
    (lambda (_obuf151087_ _chunk151088_ _start151089_ _end151090_)
      (let* ((_end151092_
              (if _end151090_
                  _end151090_
                  (if (u8vector? _chunk151088_)
                      (u8vector-length _chunk151088_)
                      (if (string? _chunk151088_)
                          (string-length _chunk151088_)
                          (if (not _chunk151088_)
                              '0
                              (error '"Bad chunk; expected u8vector or string"
                                     _chunk151088_))))))
             (_len151094_
              (if (u8vector? _chunk151088_)
                  (fx- _end151092_ _start151089_)
                  (if (string? _chunk151088_)
                      (std/text/utf8#string-utf8-length__%
                       _chunk151088_
                       _start151089_
                       _end151092_)
                      '0))))
        (if (fx> _len151094_ '0)
            (begin
              (std/net/bio/output#bio-write-string
               (number->string _len151094_ '16)
               _obuf151087_)
              (std/net/httpd/handler#write-crlf _obuf151087_)
              (if (u8vector? _chunk151088_)
                  (std/net/bio/output#bio-write-subu8vector
                   _chunk151088_
                   _start151089_
                   _end151092_
                   _obuf151087_)
                  (if (string? _chunk151088_)
                      (std/net/bio/output#bio-write-substring
                       _chunk151088_
                       _start151089_
                       _end151092_
                       _obuf151087_)
                      '#!void))
              (std/net/httpd/handler#write-crlf _obuf151087_))
            '#!void))))
  (define std/net/httpd/handler#write-last-chunk
    (lambda (_obuf151085_)
      (std/net/bio/output#bio-write-u8 std/net/httpd/handler#C0 _obuf151085_)
      (std/net/httpd/handler#write-crlf _obuf151085_)
      (std/net/httpd/handler#write-crlf _obuf151085_)))
  (define std/net/httpd/handler#C0 (char->integer '#\0))
  (define std/net/httpd/handler#CR (char->integer '#\return))
  (define std/net/httpd/handler#LF (char->integer '#\newline))
  (define std/net/httpd/handler#COL (char->integer '#\:))
  (define std/net/httpd/handler#SPC (char->integer '#\space))
  (define std/net/httpd/handler#QMARK (char->integer '#\?))
  (define std/net/httpd/handler#+http-request-methods+
    (let ((_ht151082_ (make-table 'size: '7)))
      (table-set! _ht151082_ '"GET" 'GET)
      (table-set! _ht151082_ '"HEAD" 'HEAD)
      (table-set! _ht151082_ '"POST" 'POST)
      (table-set! _ht151082_ '"PUT" 'PUT)
      (table-set! _ht151082_ '"DELETE" 'DELETE)
      (table-set! _ht151082_ '"TRACE" 'TRACE)
      (table-set! _ht151082_ '"OPTIONS" 'OPTIONS)
      _ht151082_))
  (define std/net/httpd/handler#+http-response-codes+
    (let ((_ht151079_ (make-table 'test: eq? 'size: '40)))
      (table-set! _ht151079_ '100 '"Continue")
      (table-set! _ht151079_ '101 '"Switching Protocols")
      (table-set! _ht151079_ '200 '"OK")
      (table-set! _ht151079_ '201 '"Created")
      (table-set! _ht151079_ '202 '"Accepted")
      (table-set! _ht151079_ '203 '"Non-Authoritative Information")
      (table-set! _ht151079_ '204 '"No Content")
      (table-set! _ht151079_ '205 '"Reset Content")
      (table-set! _ht151079_ '206 '"Partial Content")
      (table-set! _ht151079_ '300 '"Multiple Choices")
      (table-set! _ht151079_ '301 '"Moved Permanently")
      (table-set! _ht151079_ '302 '"Found")
      (table-set! _ht151079_ '303 '"See Other")
      (table-set! _ht151079_ '304 '"Not Modified")
      (table-set! _ht151079_ '305 '"Use Proxy")
      (table-set! _ht151079_ '307 '"Temporary Redirect")
      (table-set! _ht151079_ '400 '"Bad Request")
      (table-set! _ht151079_ '401 '"Unauthorized")
      (table-set! _ht151079_ '402 '"Payment Required")
      (table-set! _ht151079_ '403 '"Forbidden")
      (table-set! _ht151079_ '404 '"Not Found")
      (table-set! _ht151079_ '405 '"Method Not Allowed")
      (table-set! _ht151079_ '406 '"Not Acceptable")
      (table-set! _ht151079_ '407 '"Proxy Authentication Required")
      (table-set! _ht151079_ '408 '"Request Timeout")
      (table-set! _ht151079_ '409 '"Conflict")
      (table-set! _ht151079_ '410 '"Gone")
      (table-set! _ht151079_ '411 '"Length Required")
      (table-set! _ht151079_ '412 '"Precondition Failed")
      (table-set! _ht151079_ '413 '"Request Entity Too Large")
      (table-set! _ht151079_ '414 '"Request-URI Too Long")
      (table-set! _ht151079_ '415 '"Unsupported Media Type")
      (table-set! _ht151079_ '416 '"Requested Range Not Satisfiable")
      (table-set! _ht151079_ '417 '"Expectation Failed")
      (table-set! _ht151079_ '500 '"Internal Server Error")
      (table-set! _ht151079_ '501 '"Not Implemented")
      (table-set! _ht151079_ '502 '"Bad Gateway")
      (table-set! _ht151079_ '503 '"Service Unavailable")
      (table-set! _ht151079_ '504 '"Gateway Timeout")
      (table-set! _ht151079_ '505 '"HTTP Version Not Supported")
      _ht151079_)))
