// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Geom_SweptSurface_HeaderFile
#define _Geom_SweptSurface_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Geom_SweptSurface.hxx>

#include <Handle_Geom_Curve.hxx>
#include <gp_Dir.hxx>
#include <GeomAbs_Shape.hxx>
#include <Geom_Surface.hxx>
class Geom_Curve;
class gp_Dir;


//! Describes the common behavior for surfaces
//! constructed by sweeping a curve with another curve.
//! The Geom package provides two concrete derived
//! surfaces: surface of revolution (a revolved surface),
//! and surface of linear extrusion (an extruded surface).
class Geom_SweptSurface : public Geom_Surface
{

public:

  

  //! returns the continuity of the surface :
  //! C0 : only geometric continuity,
  //! C1 : continuity of the first derivative all along the surface,
  //! C2 : continuity of the second derivative all along the surface,
  //! C3 : continuity of the third derivative all along the surface,
  //! G1 : tangency continuity all along the surface,
  //! G2 : curvature continuity all along the surface,
  //! CN : the order of continuity is infinite.
  Standard_EXPORT   GeomAbs_Shape Continuity()  const;
  

  //! Returns the reference direction of the swept surface.
  //! For a surface of revolution it is the direction of the
  //! revolution axis, for a surface of linear extrusion it is
  //! the direction of extrusion.
  Standard_EXPORT  const  gp_Dir& Direction()  const;
  

  //! Returns the referenced curve of the surface.
  //! For a surface of revolution it is the revolution curve,
  //! for a surface of linear extrusion it is the extruded curve.
  Standard_EXPORT   Handle(Geom_Curve) BasisCurve()  const;




  DEFINE_STANDARD_RTTI(Geom_SweptSurface)

protected:


  Handle(Geom_Curve) basisCurve;
  gp_Dir direction;
  GeomAbs_Shape smooth;


private: 




};







#endif // _Geom_SweptSurface_HeaderFile
