/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import ch.csnc.extension.httpclient.SSLContextManager;
import edu.umass.cs.benchlab.har.HarEntries;
import edu.umass.cs.benchlab.har.HarLog;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.tree.TreeNode;
import javax.xml.transform.stream.StreamSource;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.proxy.ProxyParam;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.extension.option.OptionsParamCertificate;
import org.parosproxy.paros.extension.report.ReportGenerator;
import org.parosproxy.paros.extension.report.ReportLastScan;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SessionListener;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.alert.AlertParam;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiOther;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseConversionUtils;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.dynssl.ExtensionDynSSL;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.model.SessionUtils;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.network.DomainMatcher;
import org.zaproxy.zap.network.HttpRedirectionValidator;
import org.zaproxy.zap.network.HttpRequestConfig;
import org.zaproxy.zap.utils.ApiUtils;
import org.zaproxy.zap.utils.HarUtils;

public class CoreAPI
extends ApiImplementor
implements SessionListener {
    private static final Logger logger = Logger.getLogger(CoreAPI.class);
    private static final String PREFIX = "core";
    private static final String ACTION_LOAD_SESSION = "loadSession";
    private static final String ACTION_NEW_SESSION = "newSession";
    private static final String ACTION_SAVE_SESSION = "saveSession";
    private static final String ACTION_SNAPSHOT_SESSION = "snapshotSession";
    private static final String ACTION_ACCESS_URL = "accessUrl";
    private static final String ACTION_SHUTDOWN = "shutdown";
    private static final String ACTION_EXCLUDE_FROM_PROXY = "excludeFromProxy";
    private static final String ACTION_CLEAR_EXCLUDED_FROM_PROXY = "clearExcludedFromProxy";
    private static final String ACTION_SET_HOME_DIRECTORY = "setHomeDirectory";
    private static final String ACTION_GENERATE_ROOT_CA = "generateRootCA";
    private static final String ACTION_SEND_REQUEST = "sendRequest";
    private static final String ACTION_DELETE_ALL_ALERTS = "deleteAllAlerts";
    private static final String ACTION_DELETE_ALERT = "deleteAlert";
    private static final String ACTION_COLLECT_GARBAGE = "runGarbageCollection";
    private static final String ACTION_SET_MODE = "setMode";
    private static final String ACTION_DELETE_SITE_NODE = "deleteSiteNode";
    private static final String ACTION_ADD_PROXY_CHAIN_EXCLUDED_DOMAIN = "addProxyChainExcludedDomain";
    private static final String ACTION_MODIFY_PROXY_CHAIN_EXCLUDED_DOMAIN = "modifyProxyChainExcludedDomain";
    private static final String ACTION_REMOVE_PROXY_CHAIN_EXCLUDED_DOMAIN = "removeProxyChainExcludedDomain";
    private static final String ACTION_ENABLE_ALL_PROXY_CHAIN_EXCLUDED_DOMAINS = "enableAllProxyChainExcludedDomains";
    private static final String ACTION_DISABLE_ALL_PROXY_CHAIN_EXCLUDED_DOMAINS = "disableAllProxyChainExcludedDomains";
    private static final String ACTION_OPTION_MAXIMUM_ALERT_INSTANCES = "setOptionMaximumAlertInstances";
    private static final String ACTION_OPTION_MERGE_RELATED_ALERTS = "setOptionMergeRelatedAlerts";
    private static final String ACTION_OPTION_ALERT_OVERRIDES_FILE_PATH = "setOptionAlertOverridesFilePath";
    private static final String ACTION_OPTION_USE_PROXY_CHAIN = "setOptionUseProxyChain";
    private static final String ACTION_ENABLE_PKCS12_CLIENT_CERTIFICATE = "enablePKCS12ClientCertificate";
    private static final String ACTION_DISABLE_CLIENT_CERTIFICATE = "disableClientCertificate";
    private static final String VIEW_ALERT = "alert";
    private static final String VIEW_ALERTS = "alerts";
    private static final String VIEW_ALERTS_SUMMARY = "alertsSummary";
    private static final String VIEW_NUMBER_OF_ALERTS = "numberOfAlerts";
    private static final String VIEW_HOSTS = "hosts";
    private static final String VIEW_SITES = "sites";
    private static final String VIEW_URLS = "urls";
    private static final String VIEW_CHILD_NODES = "childNodes";
    private static final String VIEW_MESSAGE = "message";
    private static final String VIEW_MESSAGES = "messages";
    private static final String VIEW_MESSAGES_BY_ID = "messagesById";
    private static final String VIEW_MODE = "mode";
    private static final String VIEW_NUMBER_OF_MESSAGES = "numberOfMessages";
    private static final String VIEW_VERSION = "version";
    private static final String VIEW_EXCLUDED_FROM_PROXY = "excludedFromProxy";
    private static final String VIEW_HOME_DIRECTORY = "homeDirectory";
    private static final String VIEW_SESSION_LOCATION = "sessionLocation";
    private static final String VIEW_PROXY_CHAIN_EXCLUDED_DOMAINS = "proxyChainExcludedDomains";
    private static final String VIEW_OPTION_PROXY_CHAIN_SKIP_NAME = "optionProxyChainSkipName";
    private static final String VIEW_OPTION_PROXY_EXCLUDED_DOMAINS = "optionProxyExcludedDomains";
    private static final String VIEW_OPTION_PROXY_EXCLUDED_DOMAINS_ENABLED = "optionProxyExcludedDomainsEnabled";
    private static final String VIEW_ZAP_HOME_PATH = "zapHomePath";
    private static final String VIEW_OPTION_MAXIMUM_ALERT_INSTANCES = "optionMaximumAlertInstances";
    private static final String VIEW_OPTION_MERGE_RELATED_ALERTS = "optionMergeRelatedAlerts";
    private static final String VIEW_OPTION_ALERT_OVERRIDES_FILE_PATH = "optionAlertOverridesFilePath";
    private static final String OTHER_PROXY_PAC = "proxy.pac";
    private static final String OTHER_SET_PROXY = "setproxy";
    private static final String OTHER_ROOT_CERT = "rootcert";
    private static final String OTHER_XML_REPORT = "xmlreport";
    private static final String OTHER_HTML_REPORT = "htmlreport";
    private static final String OTHER_JSON_REPORT = "jsonreport";
    private static final String OTHER_MD_REPORT = "mdreport";
    private static final String OTHER_MESSAGE_HAR = "messageHar";
    private static final String OTHER_MESSAGES_HAR = "messagesHar";
    private static final String OTHER_MESSAGES_HAR_BY_ID = "messagesHarById";
    private static final String OTHER_SEND_HAR_REQUEST = "sendHarRequest";
    private static final String OTHER_SCRIPT_JS = "script.js";
    private static final String PARAM_BASE_URL = "baseurl";
    private static final String PARAM_COUNT = "count";
    private static final String PARAM_DIR = "dir";
    private static final String PARAM_SESSION = "name";
    private static final String PARAM_OVERWRITE_SESSION = "overwrite";
    private static final String PARAM_REGEX = "regex";
    private static final String PARAM_START = "start";
    private static final String PARAM_PROXY_DETAILS = "proxy";
    private static final String PARAM_ID = "id";
    private static final String PARAM_IDS = "ids";
    private static final String PARAM_REQUEST = "request";
    private static final String PARAM_FOLLOW_REDIRECTS = "followRedirects";
    private static final String PARAM_MODE = "mode";
    private static final String PARAM_URL = "url";
    private static final String PARAM_METHOD = "method";
    private static final String PARAM_POST_DATA = "postData";
    private static final String PARAM_VALUE = "value";
    private static final String PARAM_IDX = "idx";
    private static final String PARAM_IS_REGEX = "isRegex";
    private static final String PARAM_IS_ENABLED = "isEnabled";
    private static final String PARAM_RISK = "riskId";
    private static final String PARAM_NUMBER_OF_INSTANCES = "numberOfInstances";
    private static final String PARAM_ENABLED = "enabled";
    private static final String PARAM_FILE_PATH = "filePath";
    private static final String PARAM_PASSWORD = "password";
    private static final String PARAM_INDEX = "index";
    protected static final int API_SCRIPT_VERSION = 2;
    private static final String API_SCRIPT = "function submitScript() {\n  var button=document.getElementById('button');\n  var component=button.getAttribute('zap-component')\n  var type=button.getAttribute('zap-type')\n  var name=button.getAttribute('zap-name')\n  var format\n  if (type == 'other') {\n    format = 'OTHER'\n  } else {\n    format = document.getElementById('zapapiformat').value\n  }\n  \n  var url = '/' + format + '/' + component + '/' + type + '/' + name + '/'\n  var form=document.getElementById('zapform');\n  form.action = url;\n  form.method = document.getElementById('formMethod').value;\n  form.submit();\n}\ndocument.addEventListener('DOMContentLoaded', function () {\n  var button=document.getElementById('button');\n  if (button) {\n    document.getElementById('button').addEventListener('click',  function(e) {submitScript();}, false);\n  }\n});\n";
    private static final String API_SCRIPT_CACHE_CONTROL = "max-age=86400";
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private boolean savingSession = false;
    private static ExtensionHistory extHistory;
    private ConnectionParam connectionParam;

    public CoreAPI(ConnectionParam connectionParam) {
        this.connectionParam = connectionParam;
        this.addApiAction(new ApiAction(ACTION_ACCESS_URL, new String[]{PARAM_URL}, new String[]{PARAM_FOLLOW_REDIRECTS}));
        this.addApiAction(new ApiAction(ACTION_SHUTDOWN));
        this.addApiAction(new ApiAction(ACTION_NEW_SESSION, null, new String[]{PARAM_SESSION, PARAM_OVERWRITE_SESSION}));
        this.addApiAction(new ApiAction(ACTION_LOAD_SESSION, new String[]{PARAM_SESSION}));
        this.addApiAction(new ApiAction(ACTION_SAVE_SESSION, new String[]{PARAM_SESSION}, new String[]{PARAM_OVERWRITE_SESSION}));
        this.addApiAction(new ApiAction(ACTION_SNAPSHOT_SESSION, null, new String[]{PARAM_SESSION, PARAM_OVERWRITE_SESSION}));
        this.addApiAction(new ApiAction(ACTION_CLEAR_EXCLUDED_FROM_PROXY));
        this.addApiAction(new ApiAction(ACTION_EXCLUDE_FROM_PROXY, new String[]{PARAM_REGEX}));
        this.addApiAction(new ApiAction(ACTION_SET_HOME_DIRECTORY, new String[]{PARAM_DIR}));
        this.addApiAction(new ApiAction(ACTION_SET_MODE, new String[]{"mode"}));
        this.addApiAction(new ApiAction(ACTION_GENERATE_ROOT_CA));
        this.addApiAction(new ApiAction(ACTION_SEND_REQUEST, new String[]{PARAM_REQUEST}, new String[]{PARAM_FOLLOW_REDIRECTS}));
        this.addApiAction(new ApiAction(ACTION_COLLECT_GARBAGE));
        this.addApiAction(new ApiAction(ACTION_DELETE_SITE_NODE, new String[]{PARAM_URL}, new String[]{PARAM_METHOD, PARAM_POST_DATA}));
        this.addApiAction(new ApiAction(ACTION_ADD_PROXY_CHAIN_EXCLUDED_DOMAIN, new String[]{PARAM_VALUE}, new String[]{PARAM_IS_REGEX, PARAM_IS_ENABLED}));
        this.addApiAction(new ApiAction(ACTION_MODIFY_PROXY_CHAIN_EXCLUDED_DOMAIN, new String[]{PARAM_IDX}, new String[]{PARAM_VALUE, PARAM_IS_REGEX, PARAM_IS_ENABLED}));
        this.addApiAction(new ApiAction(ACTION_REMOVE_PROXY_CHAIN_EXCLUDED_DOMAIN, new String[]{PARAM_IDX}));
        this.addApiAction(new ApiAction(ACTION_ENABLE_ALL_PROXY_CHAIN_EXCLUDED_DOMAINS));
        this.addApiAction(new ApiAction(ACTION_DISABLE_ALL_PROXY_CHAIN_EXCLUDED_DOMAINS));
        this.addApiAction(new ApiAction(ACTION_OPTION_MAXIMUM_ALERT_INSTANCES, new String[]{PARAM_NUMBER_OF_INSTANCES}));
        this.addApiAction(new ApiAction(ACTION_OPTION_MERGE_RELATED_ALERTS, new String[]{PARAM_ENABLED}));
        this.addApiAction(new ApiAction(ACTION_OPTION_ALERT_OVERRIDES_FILE_PATH, null, new String[]{PARAM_FILE_PATH}));
        this.addApiAction(new ApiAction(ACTION_ENABLE_PKCS12_CLIENT_CERTIFICATE, new String[]{PARAM_FILE_PATH, PARAM_PASSWORD}, new String[]{PARAM_INDEX}));
        this.addApiAction(new ApiAction(ACTION_DISABLE_CLIENT_CERTIFICATE));
        this.addApiAction(this.depreciatedAlertApi(new ApiAction(ACTION_DELETE_ALL_ALERTS)));
        this.addApiAction(this.depreciatedAlertApi(new ApiAction(ACTION_DELETE_ALERT, new String[]{PARAM_ID})));
        this.addApiView(new ApiView(VIEW_HOSTS));
        this.addApiView(new ApiView(VIEW_SITES));
        this.addApiView(new ApiView(VIEW_URLS, null, new String[]{PARAM_BASE_URL}));
        this.addApiView(new ApiView(VIEW_CHILD_NODES, null, new String[]{PARAM_URL}));
        this.addApiView(new ApiView(VIEW_MESSAGE, new String[]{PARAM_ID}));
        this.addApiView(new ApiView(VIEW_MESSAGES, null, new String[]{PARAM_BASE_URL, PARAM_START, PARAM_COUNT}));
        this.addApiView(new ApiView(VIEW_MESSAGES_BY_ID, new String[]{PARAM_IDS}));
        this.addApiView(new ApiView(VIEW_NUMBER_OF_MESSAGES, null, new String[]{PARAM_BASE_URL}));
        this.addApiView(new ApiView("mode"));
        this.addApiView(new ApiView(VIEW_VERSION));
        this.addApiView(new ApiView(VIEW_EXCLUDED_FROM_PROXY));
        this.addApiView(new ApiView(VIEW_HOME_DIRECTORY));
        this.addApiView(new ApiView(VIEW_SESSION_LOCATION));
        this.addApiView(new ApiView(VIEW_PROXY_CHAIN_EXCLUDED_DOMAINS));
        ApiView apiView = new ApiView(VIEW_OPTION_PROXY_CHAIN_SKIP_NAME);
        apiView.setDeprecated(true);
        this.addApiView(apiView);
        apiView = new ApiView(VIEW_OPTION_PROXY_EXCLUDED_DOMAINS);
        apiView.setDeprecated(true);
        this.addApiView(apiView);
        apiView = new ApiView(VIEW_OPTION_PROXY_EXCLUDED_DOMAINS_ENABLED);
        apiView.setDeprecated(true);
        this.addApiView(apiView);
        this.addApiView(new ApiView(VIEW_ZAP_HOME_PATH));
        this.addApiView(new ApiView(VIEW_OPTION_MAXIMUM_ALERT_INSTANCES));
        this.addApiView(new ApiView(VIEW_OPTION_MERGE_RELATED_ALERTS));
        this.addApiView(new ApiView(VIEW_OPTION_ALERT_OVERRIDES_FILE_PATH));
        this.addApiView(this.depreciatedAlertApi(new ApiView(VIEW_ALERT, new String[]{PARAM_ID})));
        this.addApiView(this.depreciatedAlertApi(new ApiView(VIEW_ALERTS, null, new String[]{PARAM_BASE_URL, PARAM_START, PARAM_COUNT, PARAM_RISK})));
        this.addApiView(this.depreciatedAlertApi(new ApiView(VIEW_ALERTS_SUMMARY, null, new String[]{PARAM_BASE_URL})));
        this.addApiView(this.depreciatedAlertApi(new ApiView(VIEW_NUMBER_OF_ALERTS, null, new String[]{PARAM_BASE_URL, PARAM_RISK})));
        this.addApiOthers(new ApiOther(OTHER_PROXY_PAC, false));
        this.addApiOthers(new ApiOther(OTHER_ROOT_CERT, false));
        this.addApiOthers(new ApiOther(OTHER_SET_PROXY, new String[]{PARAM_PROXY_DETAILS}));
        this.addApiOthers(new ApiOther(OTHER_XML_REPORT));
        this.addApiOthers(new ApiOther(OTHER_HTML_REPORT));
        this.addApiOthers(new ApiOther(OTHER_JSON_REPORT));
        this.addApiOthers(new ApiOther(OTHER_MD_REPORT));
        this.addApiOthers(new ApiOther(OTHER_MESSAGE_HAR, new String[]{PARAM_ID}));
        this.addApiOthers(new ApiOther(OTHER_MESSAGES_HAR, null, new String[]{PARAM_BASE_URL, PARAM_START, PARAM_COUNT}));
        this.addApiOthers(new ApiOther(OTHER_MESSAGES_HAR_BY_ID, new String[]{PARAM_IDS}));
        this.addApiOthers(new ApiOther(OTHER_SEND_HAR_REQUEST, new String[]{PARAM_REQUEST}, new String[]{PARAM_FOLLOW_REDIRECTS}));
        this.addApiShortcut(OTHER_PROXY_PAC);
        this.addApiShortcut(OTHER_SET_PROXY);
        this.addApiShortcut(OTHER_SCRIPT_JS);
        this.addApiOptions(this.connectionParam);
    }

    private <T extends ApiElement> T depreciatedAlertApi(T element) {
        element.setDeprecated(true);
        element.setDeprecatedDescription(Constant.messages.getString("core.api.depreciated.alert"));
        return element;
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        Session session = Model.getSingleton().getSession();
        if (ACTION_ACCESS_URL.equals(name)) {
            URI uri;
            try {
                uri = new URI(params.getString(PARAM_URL), true);
            }
            catch (URIException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL, e);
            }
            try {
                HttpMessage request = new HttpMessage(new HttpRequestHeader("GET", uri, "HTTP/1.1"));
                return this.sendHttpMessage(request, this.getParam(params, PARAM_FOLLOW_REDIRECTS, false), name);
            }
            catch (HttpMalformedHeaderException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL, e);
            }
        }
        if (ACTION_SHUTDOWN.equals(name)) {
            Thread thread = new Thread("ZAP-Shutdown"){

                @Override
                public void run() {
                    try {
                        1.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        Control.getSingleton().shutdown(Model.getSingleton().getOptionsParam().getDatabaseParam().isCompactDatabase());
                        logger.info((Object)(Constant.PROGRAM_TITLE + " terminated."));
                    }
                    catch (Throwable e) {
                        logger.error((Object)"An error occurred while shutting down:", e);
                    }
                    finally {
                        System.exit(0);
                    }
                }
            };
            thread.start();
            return ApiResponseElement.OK;
        }
        if (ACTION_SAVE_SESSION.equalsIgnoreCase(name)) {
            Path sessionPath = SessionUtils.getSessionPath(params.getString(PARAM_SESSION));
            String filename = sessionPath.toAbsolutePath().toString();
            boolean overwrite = this.getParam(params, PARAM_OVERWRITE_SESSION, false);
            if (Files.exists(sessionPath, new LinkOption[0])) {
                boolean sameSession = false;
                if (overwrite && !session.isNewState()) {
                    try {
                        sameSession = Files.isSameFile(Paths.get(session.getFileName(), new String[0]), sessionPath);
                    }
                    catch (IOException e) {
                        logger.error((Object)"Failed to check if same session path:", (Throwable)e);
                        throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                    }
                }
                if (!overwrite || sameSession) {
                    throw new ApiException(ApiException.Type.ALREADY_EXISTS, filename);
                }
            }
            this.savingSession = true;
            try {
                Control.getSingleton().saveSession(filename, this);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to save the session:", (Throwable)e);
                this.savingSession = false;
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
            }
            try {
                while (this.savingSession) {
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException e) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            logger.debug((Object)"Can now return after saving session");
            return ApiResponseElement.OK;
        }
        if (ACTION_SNAPSHOT_SESSION.equalsIgnoreCase(name)) {
            if (session.isNewState()) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
            }
            List<String> actions = Control.getSingleton().getExtensionLoader().getActiveActions();
            if (!actions.isEmpty()) {
                throw new ApiException(ApiException.Type.BAD_STATE, "Active actions prevent the session snapshot: " + actions);
            }
            String fileName = ApiUtils.getOptionalStringParam(params, PARAM_SESSION);
            if (fileName == null || fileName.isEmpty()) {
                fileName = session.getFileName();
                if (fileName.endsWith(".session")) {
                    fileName = fileName.substring(0, fileName.length() - 8);
                }
                fileName = fileName + "-" + this.dateFormat.format(new Date()) + ".session";
            } else {
                Path sessionPath = SessionUtils.getSessionPath(fileName);
                fileName = sessionPath.toAbsolutePath().toString();
                if (Files.exists(sessionPath, new LinkOption[0])) {
                    boolean overwrite = this.getParam(params, PARAM_OVERWRITE_SESSION, false);
                    boolean sameSession = false;
                    try {
                        sameSession = Files.isSameFile(Paths.get(session.getFileName(), new String[0]), sessionPath);
                    }
                    catch (IOException e) {
                        logger.error((Object)"Failed to check if same session path:", (Throwable)e);
                        throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                    }
                    if (!overwrite || sameSession) {
                        throw new ApiException(ApiException.Type.ALREADY_EXISTS, fileName);
                    }
                }
            }
            this.savingSession = true;
            try {
                Control.getSingleton().snapshotSession(fileName, this);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to snapshot the session:", (Throwable)e);
                this.savingSession = false;
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
            }
            try {
                while (this.savingSession) {
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException e) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            logger.debug((Object)"Can now return after saving session");
            return ApiResponseElement.OK;
        }
        if (ACTION_LOAD_SESSION.equalsIgnoreCase(name)) {
            Path sessionPath = SessionUtils.getSessionPath(params.getString(PARAM_SESSION));
            String filename = sessionPath.toAbsolutePath().toString();
            if (!Files.exists(sessionPath, new LinkOption[0])) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, filename);
            }
            try {
                Control.getSingleton().runCommandLineOpenSession(filename);
                return ApiResponseElement.OK;
            }
            catch (Exception e) {
                logger.error((Object)"Failed to load the session:", (Throwable)e);
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
            }
        }
        if (ACTION_NEW_SESSION.equalsIgnoreCase(name)) {
            String sessionName = null;
            try {
                sessionName = params.getString(PARAM_SESSION);
            }
            catch (Exception filename) {
                // empty catch block
            }
            if (sessionName == null || sessionName.length() == 0) {
                Control.getSingleton().discardSession();
                try {
                    Control.getSingleton().newSession();
                    return ApiResponseElement.OK;
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to create a new session:", (Throwable)e);
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                }
            } else {
                Path sessionPath = SessionUtils.getSessionPath(sessionName);
                String filename = sessionPath.toAbsolutePath().toString();
                boolean overwrite = this.getParam(params, PARAM_OVERWRITE_SESSION, false);
                if (Files.exists(sessionPath, new LinkOption[0]) && !overwrite) {
                    throw new ApiException(ApiException.Type.ALREADY_EXISTS, filename);
                }
                try {
                    Control.getSingleton().runCommandLineNewSession(filename);
                    return ApiResponseElement.OK;
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to create a new session:", (Throwable)e);
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                }
            }
        }
        if (ACTION_CLEAR_EXCLUDED_FROM_PROXY.equals(name)) {
            try {
                session.setExcludeFromProxyRegexs(new ArrayList<String>());
                return ApiResponseElement.OK;
            }
            catch (DatabaseException e) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
            }
        }
        if (ACTION_EXCLUDE_FROM_PROXY.equals(name)) {
            String regex = params.getString(PARAM_REGEX);
            try {
                session.addExcludeFromProxyRegex(regex);
                return ApiResponseElement.OK;
            }
            catch (DatabaseException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
            }
            catch (PatternSyntaxException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_REGEX);
            }
        }
        if (ACTION_SET_HOME_DIRECTORY.equals(name)) {
            File f = new File(params.getString(PARAM_DIR));
            if (!f.exists() || !f.isDirectory()) throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_DIR);
            Model.getSingleton().getOptionsParam().setUserDirectory(f);
            return ApiResponseElement.OK;
        }
        if (ACTION_SET_MODE.equals(name)) {
            try {
                Control.Mode mode = Control.Mode.valueOf(params.getString("mode").toLowerCase());
                if (View.isInitialised()) {
                    View.getSingleton().getMainFrame().getMainToolbarPanel().setMode(mode);
                    View.getSingleton().getMainFrame().getMainMenuBar().setMode(mode);
                    return ApiResponseElement.OK;
                }
                Control.getSingleton().setMode(mode);
                return ApiResponseElement.OK;
            }
            catch (Exception e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "mode");
            }
        }
        if (ACTION_GENERATE_ROOT_CA.equals(name)) {
            ExtensionDynSSL extDyn = Control.getSingleton().getExtensionLoader().getExtension(ExtensionDynSSL.class);
            if (extDyn == null) return ApiResponseElement.OK;
            try {
                extDyn.createNewRootCa();
                return ApiResponseElement.OK;
            }
            catch (Exception e) {
                logger.error((Object)"Failed to create the new Root CA cert:", (Throwable)e);
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
            }
        }
        if (ACTION_SEND_REQUEST.equals(name)) {
            HttpMessage request;
            try {
                request = CoreAPI.createRequest(params.getString(PARAM_REQUEST));
            }
            catch (HttpMalformedHeaderException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_REQUEST, e);
            }
            CoreAPI.validateForCurrentMode(request);
            return this.sendHttpMessage(request, this.getParam(params, PARAM_FOLLOW_REDIRECTS, false), name);
        }
        if (ACTION_DELETE_ALL_ALERTS.equals(name)) {
            return API.getInstance().getImplementors().get(VIEW_ALERT).handleApiAction(name, params);
        }
        if (ACTION_DELETE_ALERT.equals(name)) {
            return API.getInstance().getImplementors().get(VIEW_ALERT).handleApiAction(name, params);
        }
        if (ACTION_COLLECT_GARBAGE.equals(name)) {
            System.gc();
            return ApiResponseElement.OK;
        }
        if (ACTION_DELETE_SITE_NODE.equals(name)) {
            try {
                String url = params.getString(PARAM_URL);
                String method = this.getParam(params, PARAM_METHOD, "GET");
                String postData = this.getParam(params, PARAM_POST_DATA, "");
                URI uri = new URI(url, true);
                SiteMap siteMap = session.getSiteTree();
                SiteNode siteNode = siteMap.findNode(uri, method, postData);
                if (siteNode == null) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_URL);
                }
                if (CoreAPI.getExtHistory() == null) return ApiResponseElement.OK;
                CoreAPI.getExtHistory().purge(siteMap, siteNode);
                return ApiResponseElement.OK;
            }
            catch (URIException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL, e);
            }
        }
        if (ACTION_ADD_PROXY_CHAIN_EXCLUDED_DOMAIN.equals(name)) {
            try {
                ConnectionParam connectionParam = Model.getSingleton().getOptionsParam().getConnectionParam();
                String value = params.getString(PARAM_VALUE);
                DomainMatcher domain = this.getParam(params, PARAM_IS_REGEX, false) ? new DomainMatcher(DomainMatcher.createPattern(value)) : new DomainMatcher(value);
                domain.setEnabled(this.getParam(params, PARAM_IS_ENABLED, true));
                ArrayList<DomainMatcher> domains = new ArrayList<DomainMatcher>(connectionParam.getProxyExcludedDomains());
                domains.add(domain);
                connectionParam.setProxyExcludedDomains(domains);
                return ApiResponseElement.OK;
            }
            catch (IllegalArgumentException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_VALUE, e);
            }
        }
        if (ACTION_MODIFY_PROXY_CHAIN_EXCLUDED_DOMAIN.equals(name)) {
            try {
                ConnectionParam connectionParam = Model.getSingleton().getOptionsParam().getConnectionParam();
                int idx = params.getInt(PARAM_IDX);
                if (idx < 0 || idx >= connectionParam.getProxyExcludedDomains().size()) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX);
                }
                DomainMatcher oldDomain = connectionParam.getProxyExcludedDomains().get(idx);
                String value = this.getParam(params, PARAM_VALUE, oldDomain.getValue());
                if (value.isEmpty()) {
                    value = oldDomain.getValue();
                }
                DomainMatcher newDomain = this.getParam(params, PARAM_IS_REGEX, oldDomain.isRegex()) ? new DomainMatcher(DomainMatcher.createPattern(value)) : new DomainMatcher(value);
                newDomain.setEnabled(this.getParam(params, PARAM_IS_ENABLED, oldDomain.isEnabled()));
                if (oldDomain.equals(newDomain)) return ApiResponseElement.OK;
                ArrayList<DomainMatcher> domains = new ArrayList<DomainMatcher>(connectionParam.getProxyExcludedDomains());
                domains.set(idx, newDomain);
                connectionParam.setProxyExcludedDomains(domains);
                return ApiResponseElement.OK;
            }
            catch (JSONException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX, e);
            }
            catch (IllegalArgumentException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_VALUE, e);
            }
        }
        if (ACTION_REMOVE_PROXY_CHAIN_EXCLUDED_DOMAIN.equals(name)) {
            try {
                ConnectionParam connectionParam = Model.getSingleton().getOptionsParam().getConnectionParam();
                int idx = params.getInt(PARAM_IDX);
                if (idx < 0 || idx >= connectionParam.getProxyExcludedDomains().size()) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX);
                }
                ArrayList<DomainMatcher> domains = new ArrayList<DomainMatcher>(connectionParam.getProxyExcludedDomains());
                domains.remove(idx);
                connectionParam.setProxyExcludedDomains(domains);
                return ApiResponseElement.OK;
            }
            catch (JSONException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX, e);
            }
        }
        if (ACTION_ENABLE_ALL_PROXY_CHAIN_EXCLUDED_DOMAINS.equals(name)) {
            this.setProxyChainExcludedDomainsEnabled(true);
            return ApiResponseElement.OK;
        }
        if (ACTION_DISABLE_ALL_PROXY_CHAIN_EXCLUDED_DOMAINS.equals(name)) {
            this.setProxyChainExcludedDomainsEnabled(false);
            return ApiResponseElement.OK;
        }
        if (ACTION_OPTION_MAXIMUM_ALERT_INSTANCES.equals(name)) {
            try {
                this.getAlertParam(ApiException.Type.BAD_ACTION).setMaximumInstances(params.getInt(PARAM_NUMBER_OF_INSTANCES));
                return ApiResponseElement.OK;
            }
            catch (JSONException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_NUMBER_OF_INSTANCES, e);
            }
        }
        if (ACTION_OPTION_MERGE_RELATED_ALERTS.equals(name)) {
            try {
                this.getAlertParam(ApiException.Type.BAD_ACTION).setMergeRelatedIssues(params.getBoolean(PARAM_ENABLED));
                return ApiResponseElement.OK;
            }
            catch (JSONException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_ENABLED, e);
            }
        }
        if (ACTION_OPTION_ALERT_OVERRIDES_FILE_PATH.equals(name)) {
            File file;
            String filePath = this.getParam(params, PARAM_FILE_PATH, "");
            if (!(filePath.isEmpty() || (file = new File(filePath)).isFile() && file.canRead())) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_FILE_PATH);
            }
            this.getAlertParam(ApiException.Type.BAD_ACTION).setOverridesFilename(filePath);
            if (Control.getSingleton().getExtensionLoader().getExtension(ExtensionAlert.class).reloadOverridesFile()) return ApiResponseElement.OK;
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_FILE_PATH);
        }
        if (ACTION_ENABLE_PKCS12_CLIENT_CERTIFICATE.equals(name)) {
            File file;
            String filePath = this.getParam(params, PARAM_FILE_PATH, "");
            if (!(filePath.isEmpty() || (file = new File(filePath)).isFile() && file.canRead())) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_FILE_PATH);
            }
            String password = this.getParam(params, PARAM_PASSWORD, "");
            if (password.isEmpty()) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_PASSWORD);
            }
            int certIndex = this.getParam(params, PARAM_INDEX, 0);
            if (certIndex < 0) {
                certIndex = 0;
            }
            OptionsParamCertificate certParams = Model.getSingleton().getOptionsParam().getCertificateParam();
            try {
                SSLContextManager contextManager = certParams.getSSLContextManager();
                int ksIndex = contextManager.loadPKCS12Certificate(filePath, password);
                contextManager.unlockKey(ksIndex, certIndex, password);
                contextManager.setDefaultKey(ksIndex, certIndex);
                certParams.setActiveCertificate();
                certParams.setEnableCertificate(true);
                logger.info((Object)"Client Certificate enabled from API");
                return ApiResponseElement.OK;
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                logger.error((Object)"The certificate could not be enabled due to an error", (Throwable)ex);
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)ex);
            }
        }
        if (!ACTION_DISABLE_CLIENT_CERTIFICATE.equals(name)) throw new ApiException(ApiException.Type.BAD_ACTION);
        Model.getSingleton().getOptionsParam().getCertificateParam().setEnableCertificate(false);
        logger.info((Object)"Client Certificate disabled from API");
        return ApiResponseElement.OK;
    }

    @Override
    public ApiResponse handleApiOptionAction(String name, JSONObject params) throws ApiException {
        if (ACTION_OPTION_USE_PROXY_CHAIN.equals(name)) {
            boolean enabled = params.getBoolean("Boolean");
            if (enabled && (this.connectionParam.getProxyChainName() == null || this.connectionParam.getProxyChainName().isEmpty())) {
                return ApiResponseElement.FAIL;
            }
            this.connectionParam.setUseProxyChain(enabled);
            return ApiResponseElement.OK;
        }
        return super.handleApiOptionAction(name, params);
    }

    private void setProxyChainExcludedDomainsEnabled(boolean enabled) {
        ConnectionParam connectionParam = Model.getSingleton().getOptionsParam().getConnectionParam();
        List<DomainMatcher> domains = connectionParam.getProxyExcludedDomains();
        for (DomainMatcher domain : domains) {
            domain.setEnabled(enabled);
        }
        connectionParam.setProxyExcludedDomains(domains);
    }

    private AlertParam getAlertParam(ApiException.Type type) throws ApiException {
        AlertParam alertOptions = Model.getSingleton().getOptionsParam().getParamSet(AlertParam.class);
        if (alertOptions == null) {
            throw new ApiException(type);
        }
        return alertOptions;
    }

    private static void validateForCurrentMode(HttpMessage request) throws ApiException {
        if (!CoreAPI.isValidForCurrentMode(request.getRequestHeader().getURI())) {
            throw new ApiException(ApiException.Type.MODE_VIOLATION);
        }
    }

    private static boolean isValidForCurrentMode(URI uri) {
        switch (Control.getSingleton().getMode()) {
            case safe: {
                return false;
            }
            case protect: {
                return Model.getSingleton().getSession().isInScope(uri.toString());
            }
        }
        return true;
    }

    private ApiResponse sendHttpMessage(HttpMessage request, boolean followRedirects, String apiResponseName) throws ApiException {
        final ApiResponseList resultList = new ApiResponseList(apiResponseName);
        try {
            CoreAPI.sendRequest(request, followRedirects, new Processor<HttpMessage>(){

                @Override
                public void process(HttpMessage msg) {
                    int id = -1;
                    int type = -1;
                    HistoryReference hRef = msg.getHistoryRef();
                    if (hRef != null) {
                        id = hRef.getHistoryId();
                        type = hRef.getHistoryType();
                    }
                    resultList.addItem(ApiResponseConversionUtils.httpMessageToSet(id, type, msg));
                }
            });
            return resultList;
        }
        catch (ApiException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to send the HTTP request:", (Throwable)e);
            throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
        }
    }

    private static ExtensionHistory getExtHistory() {
        if (extHistory == null) {
            extHistory = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class);
        }
        return extHistory;
    }

    private static HttpMessage createRequest(String request) throws HttpMalformedHeaderException {
        HttpMessage requestMsg = new HttpMessage();
        String[] parts = request.split(Pattern.quote("\r\n\r\n"), 2);
        requestMsg.setRequestHeader(parts[0]);
        if (parts.length > 1) {
            requestMsg.setRequestBody(parts[1]);
        } else {
            requestMsg.setRequestBody("");
        }
        return requestMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendRequest(HttpMessage request, boolean followRedirects, Processor<HttpMessage> processor) throws IOException, ApiException {
        HttpSender sender = null;
        try {
            sender = CoreAPI.createHttpSender();
            if (followRedirects) {
                ModeRedirectionValidator redirector = new ModeRedirectionValidator(processor);
                sender.sendAndReceive(request, HttpRequestConfig.builder().setRedirectionValidator(redirector).build());
                if (!redirector.isRequestValid()) {
                    throw new ApiException(ApiException.Type.MODE_VIOLATION);
                }
            } else {
                sender.sendAndReceive(request, false);
                CoreAPI.persistMessage(request);
                processor.process(request);
            }
        }
        finally {
            if (sender != null) {
                sender.shutdown();
            }
        }
    }

    private static HttpSender createHttpSender() {
        return new HttpSender(Model.getSingleton().getOptionsParam().getConnectionParam(), true, 6);
    }

    private static void persistMessage(final HttpMessage message) {
        HistoryReference historyRef;
        try {
            historyRef = new HistoryReference(Model.getSingleton().getSession(), 15, message);
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return;
        }
        if (CoreAPI.getExtHistory() != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CoreAPI.getExtHistory().addHistory(historyRef);
                    Model.getSingleton().getSession().getSiteTree().addPath(historyRef, message);
                }
            });
        }
    }

    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        ApiResponse result = null;
        Session session = Model.getSingleton().getSession();
        if (VIEW_HOSTS.equals(name)) {
            result = new ApiResponseList(name);
            SiteNode root = session.getSiteTree().getRoot();
            Enumeration<TreeNode> en = root.children();
            while (en.hasMoreElements()) {
                String site = ((SiteNode)en.nextElement()).getNodeName();
                if (site.indexOf("//") >= 0) {
                    site = site.substring(site.indexOf("//") + 2);
                }
                if (site.indexOf(":") >= 0) {
                    site = site.substring(0, site.indexOf(":"));
                }
                result.addItem(new ApiResponseElement("host", site));
            }
        } else if (VIEW_SITES.equals(name)) {
            ApiResponseList sitesList = new ApiResponseList(name);
            StructuralNode root = SessionStructure.getRootNode();
            if (root != null) {
                Iterator<StructuralNode> it = root.getChildIterator();
                while (it.hasNext()) {
                    sitesList.addItem(new ApiResponseElement("site", it.next().getName()));
                }
            }
            result = sitesList;
        } else if (VIEW_URLS.equals(name)) {
            result = new ApiResponseList(name);
            SiteNode root = session.getSiteTree().getRoot();
            CoreAPI.addUrlsToList(this.getParam(params, PARAM_BASE_URL, ""), root, new HashSet<String>(), result);
        } else if (VIEW_CHILD_NODES.equals(name)) {
            StructuralNode node;
            String url = this.getParam(params, PARAM_URL, "");
            if (url.trim().length() == 0) {
                node = SessionStructure.getRootNode();
            } else {
                try {
                    node = SessionStructure.find(session.getSessionId(), new URI(url, false), null, null);
                }
                catch (URIException e) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL, e);
                }
                catch (DatabaseException e) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)e);
                }
            }
            if (node == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_URL);
            }
            result = new ApiResponseList(name);
            Iterator<StructuralNode> iter = node.getChildIterator();
            while (iter.hasNext()) {
                result.addItem(this.structuralNodeToResponse(iter.next()));
            }
        } else {
            if (VIEW_ALERT.equals(name)) {
                return API.getInstance().getImplementors().get(VIEW_ALERT).handleApiView(name, params);
            }
            if (VIEW_ALERTS.equals(name)) {
                return API.getInstance().getImplementors().get(VIEW_ALERT).handleApiView(name, params);
            }
            if (VIEW_NUMBER_OF_ALERTS.equals(name)) {
                return API.getInstance().getImplementors().get(VIEW_ALERT).handleApiView(name, params);
            }
            if (VIEW_ALERTS_SUMMARY.equals(name)) {
                return API.getInstance().getImplementors().get(VIEW_ALERT).handleApiView(name, params);
            }
            if (VIEW_MESSAGE.equals(name)) {
                TableHistory tableHistory = Model.getSingleton().getDb().getTableHistory();
                RecordHistory recordHistory = this.getRecordHistory(tableHistory, this.getParam(params, PARAM_ID, -1));
                result = new ApiResponseElement(ApiResponseConversionUtils.httpMessageToSet(recordHistory.getHistoryId(), recordHistory.getHistoryType(), recordHistory.getHttpMessage()));
            } else if (VIEW_MESSAGES.equals(name)) {
                final ApiResponseList resultList = new ApiResponseList(name);
                this.processHttpMessages(this.getParam(params, PARAM_BASE_URL, null), this.getParam(params, PARAM_START, -1), this.getParam(params, PARAM_COUNT, -1), new Processor<RecordHistory>(){

                    @Override
                    public void process(RecordHistory recordHistory) {
                        resultList.addItem(ApiResponseConversionUtils.httpMessageToSet(recordHistory.getHistoryId(), recordHistory.getHistoryType(), recordHistory.getHttpMessage()));
                    }
                });
                result = resultList;
            } else if (VIEW_NUMBER_OF_MESSAGES.equals(name)) {
                CounterProcessor<RecordHistory> counter = new CounterProcessor<RecordHistory>();
                this.processHttpMessages(this.getParam(params, PARAM_BASE_URL, null), this.getParam(params, PARAM_START, -1), this.getParam(params, PARAM_COUNT, -1), counter);
                result = new ApiResponseElement(name, Integer.toString(counter.getCount()));
            } else if (VIEW_MESSAGES_BY_ID.equals(name)) {
                ApiResponseList resultList = new ApiResponseList(name);
                TableHistory tableHistory = Model.getSingleton().getDb().getTableHistory();
                for (Integer id : CoreAPI.getIds(params)) {
                    RecordHistory recordHistory = this.getRecordHistory(tableHistory, id);
                    resultList.addItem(ApiResponseConversionUtils.httpMessageToSet(recordHistory.getHistoryId(), recordHistory.getHistoryType(), recordHistory.getHttpMessage()));
                }
                result = resultList;
            } else if ("mode".equals(name)) {
                result = new ApiResponseElement(name, Control.getSingleton().getMode().name());
            } else if (VIEW_VERSION.equals(name)) {
                result = new ApiResponseElement(name, Constant.PROGRAM_VERSION);
            } else if (VIEW_EXCLUDED_FROM_PROXY.equals(name)) {
                result = new ApiResponseList(name);
                List<String> regexs = session.getExcludeFromProxyRegexs();
                for (String regex : regexs) {
                    result.addItem(new ApiResponseElement(PARAM_REGEX, regex));
                }
            } else if (VIEW_HOME_DIRECTORY.equals(name)) {
                result = new ApiResponseElement(name, Model.getSingleton().getOptionsParam().getUserDirectory().getAbsolutePath());
            } else if (VIEW_SESSION_LOCATION.equals(name)) {
                result = new ApiResponseElement(name, session.getFileName());
            } else if (VIEW_PROXY_CHAIN_EXCLUDED_DOMAINS.equals(name) || VIEW_OPTION_PROXY_EXCLUDED_DOMAINS.equals(name) || VIEW_OPTION_PROXY_CHAIN_SKIP_NAME.equals(name)) {
                result = this.proxyChainExcludedDomainsToApiResponseList(name, Model.getSingleton().getOptionsParam().getConnectionParam().getProxyExcludedDomains(), false);
            } else if (VIEW_OPTION_PROXY_EXCLUDED_DOMAINS_ENABLED.equals(name)) {
                result = this.proxyChainExcludedDomainsToApiResponseList(name, Model.getSingleton().getOptionsParam().getConnectionParam().getProxyExcludedDomains(), true);
            } else if (VIEW_ZAP_HOME_PATH.equals(name)) {
                result = new ApiResponseElement(name, Constant.getZapHome());
            } else if (VIEW_OPTION_MAXIMUM_ALERT_INSTANCES.equals(name)) {
                result = new ApiResponseElement(name, String.valueOf(this.getAlertParam(ApiException.Type.BAD_VIEW).getMaximumInstances()));
            } else if (VIEW_OPTION_MERGE_RELATED_ALERTS.equals(name)) {
                result = new ApiResponseElement(name, String.valueOf(this.getAlertParam(ApiException.Type.BAD_VIEW).isMergeRelatedIssues()));
            } else if (VIEW_OPTION_ALERT_OVERRIDES_FILE_PATH.equals(name)) {
                result = new ApiResponseElement(name, this.getAlertParam(ApiException.Type.BAD_VIEW).getOverridesFilename());
            } else {
                throw new ApiException(ApiException.Type.BAD_VIEW);
            }
        }
        return result;
    }

    private RecordHistory getRecordHistory(TableHistory tableHistory, Integer id) throws ApiException {
        RecordHistory recordHistory;
        try {
            recordHistory = tableHistory.read(id);
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            logger.error((Object)"Failed to read the history record:", (Throwable)e);
            throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)e);
        }
        if (recordHistory == null) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, Integer.toString(id));
        }
        return recordHistory;
    }

    private ApiResponseSet<Object> structuralNodeToResponse(StructuralNode node) {
        HashMap<String, Object> nodeData = new HashMap<String, Object>();
        nodeData.put(PARAM_SESSION, node.getName());
        nodeData.put(PARAM_METHOD, node.getMethod());
        nodeData.put("uri", node.getURI().toString());
        nodeData.put("isLeaf", node.isLeaf());
        nodeData.put("hrefId", node.getHistoryReference().getHistoryId());
        return new ApiResponseSet<Object>("node", nodeData);
    }

    private ApiResponse proxyChainExcludedDomainsToApiResponseList(String name, List<DomainMatcher> domains, boolean excludeDisabled) {
        ApiResponseList apiResponse = new ApiResponseList(name);
        for (int i = 0; i < domains.size(); ++i) {
            DomainMatcher domain = domains.get(i);
            if (!domain.isEnabled() && excludeDisabled) continue;
            HashMap<String, Object> domainData = new HashMap<String, Object>();
            domainData.put(PARAM_IDX, i);
            domainData.put(PARAM_VALUE, domain.getValue());
            domainData.put(PARAM_REGEX, domain.isRegex());
            domainData.put(PARAM_ENABLED, domain.isEnabled());
            apiResponse.addItem(new ApiResponseSet("domain", domainData));
        }
        return apiResponse;
    }

    @Override
    public HttpMessage handleApiOther(HttpMessage msg, String name, JSONObject params) throws ApiException {
        if (OTHER_PROXY_PAC.equals(name)) {
            ProxyParam proxyParam = Model.getSingleton().getOptionsParam().getProxyParam();
            int port = proxyParam.getProxyPort();
            try {
                String localDomain;
                String domain = null;
                if (proxyParam.isProxyIpAnyLocalAddress() && !"zap".equals(localDomain = msg.getRequestHeader().getHostName())) {
                    domain = localDomain;
                }
                if (domain == null) {
                    domain = proxyParam.getProxyIp();
                }
                String response = this.getPacFile(domain, port);
                msg.setResponseHeader(API.getDefaultResponseHeader("text/html", response.length()));
                msg.setResponseBody(response);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return msg;
        }
        if (OTHER_SET_PROXY.equals(name)) {
            String proxyDetails = params.getString(PARAM_PROXY_DETAILS);
            String response = "OK";
            try {
                try {
                    JSONObject json = JSONObject.fromObject((Object)proxyDetails);
                    if (json.getInt("type") == 1) {
                        JSONObject httpJson = JSONObject.fromObject((Object)json.get("http"));
                        String proxyHost = httpJson.getString("host");
                        int proxyPort = httpJson.getInt("port");
                        if (proxyHost != null && proxyHost.length() > 0 && proxyPort > 0) {
                            Model.getSingleton().getOptionsParam().getConnectionParam().setProxyChainName(proxyHost);
                            Model.getSingleton().getOptionsParam().getConnectionParam().setProxyChainPort(proxyPort);
                        }
                    }
                }
                catch (JSONException e) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_PROXY_DETAILS);
                }
                msg.setResponseHeader(API.getDefaultResponseHeader("text/html", response.length()));
                msg.setResponseBody(response);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return msg;
        }
        if (OTHER_ROOT_CERT.equals(name)) {
            ExtensionDynSSL extDynSSL = Control.getSingleton().getExtensionLoader().getExtension(ExtensionDynSSL.class);
            if (extDynSSL != null) {
                try {
                    Certificate rootCA = extDynSSL.getRootCA();
                    if (rootCA == null) {
                        throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
                    }
                    StringWriter sw = new StringWriter();
                    try (PemWriter pw = new PemWriter((Writer)sw);){
                        pw.writeObject((PemObjectGenerator)new JcaMiscPEMGenerator(rootCA));
                        pw.flush();
                    }
                    String response = sw.toString();
                    msg.setResponseHeader(API.getDefaultResponseHeader("application/pkix-cert;", response.length()));
                    msg.setResponseBody(response);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR);
                }
            }
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
            return msg;
        }
        if (OTHER_XML_REPORT.equals(name)) {
            try {
                CoreAPI.writeReportLastScanTo(msg, ScanReportType.XML);
                return msg;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new ApiException(ApiException.Type.INTERNAL_ERROR);
            }
        }
        if (OTHER_HTML_REPORT.equals(name)) {
            try {
                CoreAPI.writeReportLastScanTo(msg, ScanReportType.HTML);
                return msg;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new ApiException(ApiException.Type.INTERNAL_ERROR);
            }
        }
        if (OTHER_JSON_REPORT.equals(name)) {
            try {
                CoreAPI.writeReportLastScanTo(msg, ScanReportType.JSON);
                return msg;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new ApiException(ApiException.Type.INTERNAL_ERROR);
            }
        }
        if (OTHER_MD_REPORT.equals(name)) {
            try {
                CoreAPI.writeReportLastScanTo(msg, ScanReportType.MD);
                return msg;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new ApiException(ApiException.Type.INTERNAL_ERROR);
            }
        }
        if (OTHER_MESSAGE_HAR.equals(name)) {
            byte[] responseBody;
            try {
                HarEntries entries = new HarEntries();
                TableHistory tableHistory = Model.getSingleton().getDb().getTableHistory();
                RecordHistory recordHistory = this.getRecordHistory(tableHistory, this.getParam(params, PARAM_ID, -1));
                CoreAPI.addHarEntry(entries, recordHistory);
                HarLog harLog = HarUtils.createZapHarLog();
                harLog.setEntries(entries);
                responseBody = HarUtils.harLogToByteArray(harLog);
            }
            catch (ApiException e) {
                responseBody = e.toString(API.Format.JSON, this.incErrorDetails()).getBytes(StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                ApiException apiException = new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                responseBody = apiException.toString(API.Format.JSON, this.incErrorDetails()).getBytes(StandardCharsets.UTF_8);
            }
            try {
                msg.setResponseHeader(API.getDefaultResponseHeader("application/json; charset=UTF-8", responseBody.length));
            }
            catch (HttpMalformedHeaderException e) {
                logger.error((Object)("Failed to create response header: " + e.getMessage()), (Throwable)e);
            }
            msg.setResponseBody(responseBody);
            return msg;
        }
        if (OTHER_MESSAGES_HAR_BY_ID.equals(name) || OTHER_MESSAGES_HAR.equals(name)) {
            byte[] responseBody;
            try {
                HarEntries entries = new HarEntries();
                if (OTHER_MESSAGES_HAR_BY_ID.equals(name)) {
                    TableHistory tableHistory = Model.getSingleton().getDb().getTableHistory();
                    for (Integer id : CoreAPI.getIds(params)) {
                        RecordHistory recordHistory = this.getRecordHistory(tableHistory, id);
                        CoreAPI.addHarEntry(entries, recordHistory);
                    }
                } else {
                    this.processHttpMessages(this.getParam(params, PARAM_BASE_URL, null), this.getParam(params, PARAM_START, -1), this.getParam(params, PARAM_COUNT, -1), rh -> CoreAPI.addHarEntry(entries, rh));
                }
                HarLog harLog = HarUtils.createZapHarLog();
                harLog.setEntries(entries);
                responseBody = HarUtils.harLogToByteArray(harLog);
            }
            catch (ApiException e) {
                responseBody = e.toString(API.Format.JSON, this.incErrorDetails()).getBytes(StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                ApiException apiException = new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                responseBody = apiException.toString(API.Format.JSON, this.incErrorDetails()).getBytes(StandardCharsets.UTF_8);
            }
            try {
                msg.setResponseHeader(API.getDefaultResponseHeader("application/json; charset=UTF-8", responseBody.length));
            }
            catch (HttpMalformedHeaderException e) {
                logger.error((Object)("Failed to create response header: " + e.getMessage()), (Throwable)e);
            }
            msg.setResponseBody(responseBody);
            return msg;
        }
        if (OTHER_SEND_HAR_REQUEST.equals(name)) {
            byte[] responseBody = new byte[]{};
            HttpMessage request = null;
            try {
                request = HarUtils.createHttpMessage(params.getString(PARAM_REQUEST));
            }
            catch (IOException e) {
                ApiException apiException = new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_REQUEST, e);
                responseBody = apiException.toString(API.Format.JSON, this.incErrorDetails()).getBytes(StandardCharsets.UTF_8);
            }
            if (request != null) {
                if (!CoreAPI.isValidForCurrentMode(request.getRequestHeader().getURI())) {
                    ApiException apiException = new ApiException(ApiException.Type.MODE_VIOLATION);
                    responseBody = apiException.toString(API.Format.JSON, this.incErrorDetails()).getBytes(StandardCharsets.UTF_8);
                } else {
                    boolean followRedirects = this.getParam(params, PARAM_FOLLOW_REDIRECTS, false);
                    try {
                        HarEntries entries = new HarEntries();
                        CoreAPI.sendRequest(request, followRedirects, httpMessage -> {
                            HistoryReference hRef = httpMessage.getHistoryRef();
                            entries.addEntry(HarUtils.createHarEntry(hRef.getHistoryId(), hRef.getHistoryType(), httpMessage));
                        });
                        HarLog harLog = HarUtils.createZapHarLog();
                        harLog.setEntries(entries);
                        responseBody = HarUtils.harLogToByteArray(harLog);
                    }
                    catch (ApiException e) {
                        responseBody = e.toString(API.Format.JSON, this.incErrorDetails()).getBytes(StandardCharsets.UTF_8);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        ApiException apiException = new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                        responseBody = apiException.toString(API.Format.JSON, this.incErrorDetails()).getBytes(StandardCharsets.UTF_8);
                    }
                }
            }
            try {
                msg.setResponseHeader(API.getDefaultResponseHeader("application/json; charset=UTF-8", responseBody.length));
            }
            catch (HttpMalformedHeaderException e) {
                logger.error((Object)("Failed to create response header: " + e.getMessage()), (Throwable)e);
            }
            msg.setResponseBody(responseBody);
            return msg;
        }
        if (OTHER_SCRIPT_JS.equals(name)) {
            try {
                msg.setResponseBody(API_SCRIPT);
                msg.setResponseHeader(API.getDefaultResponseHeader("text/javascript", API_SCRIPT.length(), true));
                msg.getResponseHeader().addHeader("Cache-Control", API_SCRIPT_CACHE_CONTROL);
            }
            catch (HttpMalformedHeaderException e) {
                logger.error((Object)("Failed to create response header: " + e.getMessage()), (Throwable)e);
            }
            return msg;
        }
        throw new ApiException(ApiException.Type.BAD_OTHER);
    }

    private static List<Integer> getIds(JSONObject params) throws ApiException {
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        for (String id : params.getString(PARAM_IDS).split(",")) {
            try {
                listIds.add(Integer.valueOf(id.trim()));
            }
            catch (NumberFormatException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDS, e);
            }
        }
        if (listIds.isEmpty()) {
            throw new ApiException(ApiException.Type.MISSING_PARAMETER, PARAM_IDS);
        }
        return listIds;
    }

    private static void addHarEntry(HarEntries entries, RecordHistory recordHistory) {
        entries.addEntry(HarUtils.createHarEntry(recordHistory.getHistoryId(), recordHistory.getHistoryType(), recordHistory.getHttpMessage()));
    }

    private boolean incErrorDetails() {
        return Model.getSingleton().getOptionsParam().getApiParam().isIncErrorDetails();
    }

    private static void writeReportLastScanTo(HttpMessage msg, ScanReportType reportType) throws Exception {
        String response;
        ReportLastScan rls = new ReportLastScan();
        StringBuilder report = new StringBuilder();
        rls.generate(report);
        if (ScanReportType.XML == reportType) {
            msg.setResponseHeader(API.getDefaultResponseHeader("text/xml; charset=UTF-8"));
            response = report.toString();
        } else if (ScanReportType.MD == reportType) {
            msg.setResponseHeader(API.getDefaultResponseHeader("text/markdown; charset=UTF-8"));
            response = CoreAPI.generateReportWithXsl(report.toString(), "report.md.xsl");
        } else if (ScanReportType.JSON == reportType) {
            msg.setResponseHeader(API.getDefaultResponseHeader("application/json; charset=UTF-8"));
            response = ReportGenerator.stringToJson(report.toString());
        } else {
            msg.setResponseHeader(API.getDefaultResponseHeader("text/html; charset=UTF-8"));
            response = CoreAPI.generateReportWithXsl(report.toString(), "report.html.xsl");
        }
        msg.setResponseBody(response);
        msg.getResponseHeader().setContentLength(msg.getResponseBody().length());
    }

    private static String generateReportWithXsl(String report, String xslFileName) throws IOException {
        Path xslFile = Paths.get(Constant.getZapInstall(), "xml", xslFileName);
        if (Files.exists(xslFile, new LinkOption[0])) {
            return ReportGenerator.stringToHtml(report, xslFile.toString());
        }
        String path = "/org/zaproxy/zap/resources/xml/" + xslFileName;
        try (InputStream is = ReportLastScan.class.getResourceAsStream(path);){
            if (is == null) {
                logger.error((Object)("Bundled file not found: " + path));
                String string = "";
                return string;
            }
            String string = ReportGenerator.stringToHtml(report, new StreamSource(is));
            return string;
        }
    }

    @Override
    public HttpMessage handleShortcut(HttpMessage msg) throws ApiException {
        try {
            if (msg.getRequestHeader().getURI().getPath().startsWith("/proxy.pac")) {
                return this.handleApiOther(msg, OTHER_PROXY_PAC, new JSONObject());
            }
            if (msg.getRequestHeader().getURI().getPath().startsWith("/setproxy")) {
                JSONObject params = new JSONObject();
                params.put((Object)PARAM_PROXY_DETAILS, (Object)msg.getRequestBody().toString());
                return this.handleApiOther(msg, OTHER_SET_PROXY, params);
            }
            if (msg.getRequestHeader().getURI().getPath().startsWith("/script.js")) {
                return this.handleApiOther(msg, OTHER_SCRIPT_JS, new JSONObject());
            }
        }
        catch (URIException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ApiException(ApiException.Type.INTERNAL_ERROR);
        }
        throw new ApiException(ApiException.Type.URL_NOT_FOUND, msg.getRequestHeader().getURI().toString());
    }

    private String getPacFile(String host, int port) {
        StringBuilder sb = new StringBuilder(100);
        sb.append("function FindProxyForURL(url, host) {\n");
        sb.append("  return \"PROXY ").append(host).append(':').append(port).append("\";\n");
        sb.append("} // End of function\n");
        return sb.toString();
    }

    private static void addUrlsToList(String baseUrl, SiteNode parent, Set<String> addedUrls, ApiResponseList list) {
        Enumeration<TreeNode> en = parent.children();
        while (en.hasMoreElements()) {
            SiteNode child = (SiteNode)en.nextElement();
            String uri = child.getHistoryReference().getURI().toString();
            if (!addedUrls.contains(uri) && (baseUrl.isEmpty() || uri.startsWith(baseUrl))) {
                list.addItem(new ApiResponseElement(PARAM_URL, uri));
                addedUrls.add(uri);
            }
            CoreAPI.addUrlsToList(baseUrl, child, addedUrls, list);
        }
    }

    private void processHttpMessages(String baseUrl, int start, int count, Processor<RecordHistory> processor) throws ApiException {
        try {
            TableHistory tableHistory = Model.getSingleton().getDb().getTableHistory();
            List<Integer> historyIds = tableHistory.getHistoryIds(Model.getSingleton().getSession().getSessionId());
            PaginationConstraintsChecker pcc = new PaginationConstraintsChecker(start, count);
            for (Integer id : historyIds) {
                RecordHistory recHistory = tableHistory.read(id);
                HttpMessage msg = recHistory.getHttpMessage();
                if (msg.getRequestHeader().isImage() || msg.getResponseHeader().isImage() || baseUrl != null && !msg.getRequestHeader().getURI().toString().startsWith(baseUrl)) continue;
                pcc.recordProcessed();
                if (!pcc.hasPageStarted()) continue;
                processor.process(recHistory);
                if (!pcc.hasPageEnded()) continue;
                break;
            }
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ApiException(ApiException.Type.INTERNAL_ERROR);
        }
    }

    @Override
    public void sessionOpened(File file, Exception e) {
    }

    @Override
    public void sessionSaved(Exception e) {
        logger.debug((Object)"Saved session notification");
        this.savingSession = false;
    }

    @Override
    public void sessionSnapshot(Exception e) {
        logger.debug((Object)"Snapshot session notification");
        this.savingSession = false;
    }

    private static class ModeRedirectionValidator
    implements HttpRedirectionValidator {
        private final Processor<HttpMessage> processor;
        private boolean isRequestValid;

        public ModeRedirectionValidator(Processor<HttpMessage> processor) {
            this.processor = processor;
            this.isRequestValid = true;
        }

        @Override
        public void notifyMessageReceived(HttpMessage message) {
            CoreAPI.persistMessage(message);
            this.processor.process(message);
        }

        @Override
        public boolean isValid(URI redirection) {
            this.isRequestValid = CoreAPI.isValidForCurrentMode(redirection);
            return this.isRequestValid;
        }

        public boolean isRequestValid() {
            return this.isRequestValid;
        }
    }

    private static class PaginationConstraintsChecker {
        private boolean pageStarted;
        private boolean pageEnded;
        private final int startRecord;
        private final boolean hasEnd;
        private final int finalRecord;
        private int recordsProcessed = 0;

        public PaginationConstraintsChecker(int start, int count) {
            if (start > 0) {
                this.pageStarted = false;
                this.startRecord = start;
            } else {
                this.pageStarted = true;
                this.startRecord = 0;
            }
            if (count > 0) {
                this.hasEnd = true;
                this.finalRecord = !this.pageStarted ? start + count - 1 : count;
            } else {
                this.hasEnd = false;
                this.finalRecord = 0;
            }
            this.pageEnded = false;
        }

        public void recordProcessed() {
            ++this.recordsProcessed;
            if (!this.pageStarted) {
                boolean bl = this.pageStarted = this.recordsProcessed >= this.startRecord;
            }
            if (this.hasEnd && !this.pageEnded) {
                this.pageEnded = this.recordsProcessed >= this.finalRecord;
            }
        }

        public boolean hasPageStarted() {
            return this.pageStarted;
        }

        public boolean hasPageEnded() {
            return this.pageEnded;
        }
    }

    private static class CounterProcessor<T>
    implements Processor<T> {
        private int count = 0;

        @Override
        public void process(T object) {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }

    private static interface Processor<T> {
        public void process(T var1);
    }

    private static enum ScanReportType {
        HTML,
        JSON,
        XML,
        MD;

    }
}

