/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.issueLinks;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Font;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class IssueLinkHtmlRenderer {
    private IssueLinkHtmlRenderer() {
    }

    @NotNull
    public static String formatTextIntoHtml(@NotNull Project project, @NotNull String c) {
        if (project == null) {
            IssueLinkHtmlRenderer.$$$reportNull$$$0(0);
        }
        if (c == null) {
            IssueLinkHtmlRenderer.$$$reportNull$$$0(1);
        }
        String string = "<html><head>" + UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont(), (Color)UIUtil.getLabelForeground(), (Color)JBUI.CurrentTheme.Link.linkColor(), null) + "</head><body>" + IssueLinkHtmlRenderer.formatTextWithLinks(project, c) + "</body></html>";
        if (string == null) {
            IssueLinkHtmlRenderer.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String formatTextWithLinks(@NotNull Project project, @NotNull String str, @NotNull Convertor<? super String, String> convertor) {
        if (project == null) {
            IssueLinkHtmlRenderer.$$$reportNull$$$0(3);
        }
        if (str == null) {
            IssueLinkHtmlRenderer.$$$reportNull$$$0(4);
        }
        if (convertor == null) {
            IssueLinkHtmlRenderer.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)str)) {
            return "";
        }
        String comment = XmlStringUtil.escapeString((String)VcsUtil.trimCommitMessageToSaneSize((String)str), (boolean)false);
        StringBuilder commentBuilder = new StringBuilder();
        IssueNavigationConfiguration config = IssueNavigationConfiguration.getInstance((Project)project);
        List list = config.findIssueLinks((CharSequence)comment);
        int pos = 0;
        for (IssueNavigationConfiguration.LinkMatch match : list) {
            TextRange range = match.getRange();
            commentBuilder.append((String)convertor.convert((Object)comment.substring(pos, range.getStartOffset()))).append("<a href=\"").append(match.getTargetUrl()).append("\">");
            commentBuilder.append(range.substring(comment)).append("</a>");
            pos = range.getEndOffset();
        }
        commentBuilder.append((String)convertor.convert((Object)comment.substring(pos)));
        comment = commentBuilder.toString();
        String string = comment.replace("\n", "<br>");
        if (string == null) {
            IssueLinkHtmlRenderer.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String formatTextWithLinks(@NotNull Project project, @NotNull String c) {
        if (project == null) {
            IssueLinkHtmlRenderer.$$$reportNull$$$0(7);
        }
        if (c == null) {
            IssueLinkHtmlRenderer.$$$reportNull$$$0(8);
        }
        return IssueLinkHtmlRenderer.formatTextWithLinks(project, c, (Convertor<? super String, String>)Convertor.self());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/issueLinks/IssueLinkHtmlRenderer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/issueLinks/IssueLinkHtmlRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTextIntoHtml";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTextWithLinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatTextIntoHtml";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "formatTextWithLinks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

