/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SynchronizeCurrentFileAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SynchronizeCurrentFileAction.$$$reportNull$$$0(0);
        }
        List files2 = SynchronizeCurrentFileAction.getFiles(e).take(2).toList();
        Project project = e.getProject();
        if (project == null || files2.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setEnabledAndVisible(true);
        }
    }

    @NotNull
    private static String getMessage(@NotNull Project project, @NotNull List<? extends VirtualFile> files2) {
        if (project == null) {
            SynchronizeCurrentFileAction.$$$reportNull$$$0(1);
        }
        if (files2 == null) {
            SynchronizeCurrentFileAction.$$$reportNull$$$0(2);
        }
        VirtualFile single = files2.size() == 1 ? files2.get(0) : null;
        String string = single != null ? IdeBundle.message((String)"action.synchronize.file", (Object[])new Object[]{VfsPresentationUtil.getPresentableNameForAction(project, single)}) : IdeBundle.message((String)"action.synchronize.selected.files", (Object[])new Object[0]);
        if (string == null) {
            SynchronizeCurrentFileAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SynchronizeCurrentFileAction.$$$reportNull$$$0(4);
        }
        Project project = SynchronizeCurrentFileAction.getEventProject((AnActionEvent)e);
        List files2 = SynchronizeCurrentFileAction.getFiles(e).toList();
        if (project == null || files2.isEmpty()) {
            return;
        }
        for (VirtualFile file2 : files2) {
            if (file2.isDirectory()) {
                file2.getChildren();
            }
            if (!(file2 instanceof NewVirtualFile)) continue;
            ((NewVirtualFile)file2).markClean();
            ((NewVirtualFile)file2).markDirtyRecursively();
        }
        RefreshQueue.getInstance().refresh(true, true, () -> SynchronizeCurrentFileAction.postRefresh(project, files2), (Collection)files2);
    }

    private static void postRefresh(Project project, List<? extends VirtualFile> files2) {
        VcsFacade.getInstance().markFilesDirty(project, files2);
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
        if (statusBar != null) {
            statusBar.setInfo(IdeBundle.message((String)"action.sync.completed.successfully", (Object[])new Object[]{SynchronizeCurrentFileAction.getMessage(project, files2)}));
        }
    }

    @NotNull
    private static JBIterable<VirtualFile> getFiles(@NotNull AnActionEvent e) {
        if (e == null) {
            SynchronizeCurrentFileAction.$$$reportNull$$$0(5);
        }
        JBIterable jBIterable = JBIterable.of((Object[])((VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(o -> o.isInLocalFileSystem());
        if (jBIterable == null) {
            SynchronizeCurrentFileAction.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/SynchronizeCurrentFileAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/SynchronizeCurrentFileAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

