/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.util.text.StringSearcher;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IncrementalSearchHandler {
    private static final Key<PerEditorSearchData> SEARCH_DATA_IN_EDITOR_VIEW_KEY = Key.create((String)"IncrementalSearchHandler.SEARCH_DATA_IN_EDITOR_VIEW_KEY");
    private static final Key<PerHintSearchData> SEARCH_DATA_IN_HINT_KEY = Key.create((String)"IncrementalSearchHandler.SEARCH_DATA_IN_HINT_KEY");
    private static final Logger LOG = Logger.getInstance(IncrementalSearchHandler.class);
    private static boolean ourActionsRegistered = false;

    public static boolean isHintVisible(Editor editor) {
        PerEditorSearchData data2 = (PerEditorSearchData)editor.getUserData(SEARCH_DATA_IN_EDITOR_VIEW_KEY);
        return data2 != null && data2.hint != null && data2.hint.isVisible();
    }

    public void invoke(Project project, final Editor editor) {
        if (!ourActionsRegistered) {
            EditorActionManager actionManager = EditorActionManager.getInstance();
            TypedAction typedAction = TypedAction.getInstance();
            typedAction.setupRawHandler((TypedActionHandler)new MyTypedHandler(typedAction.getRawHandler()));
            actionManager.setActionHandler("EditorBackSpace", (EditorActionHandler)new BackSpaceHandler(actionManager.getActionHandler("EditorBackSpace")));
            actionManager.setActionHandler("EditorUp", (EditorActionHandler)new UpHandler(actionManager.getActionHandler("EditorUp")));
            actionManager.setActionHandler("EditorDown", (EditorActionHandler)new DownHandler(actionManager.getActionHandler("EditorDown")));
            ourActionsRegistered = true;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.incremental.search");
        String selection = editor.getSelectionModel().getSelectedText();
        MyLabel label2 = new MyLabel(selection == null ? "" : selection);
        PerEditorSearchData data2 = (PerEditorSearchData)editor.getUserData(SEARCH_DATA_IN_EDITOR_VIEW_KEY);
        if (data2 == null) {
            data2 = new PerEditorSearchData();
        } else if (data2.hint != null) {
            if (data2.lastSearch != null) {
                PerHintSearchData hintData = (PerHintSearchData)data2.hint.getUserData(SEARCH_DATA_IN_HINT_KEY);
                if ("".equals(hintData.label.getText())) {
                    label2 = new MyLabel(data2.lastSearch);
                }
            }
            data2.hint.hide();
        }
        MyLabel label1 = new MyLabel(" " + CodeInsightBundle.message((String)"incremental.search.tooltip.prefix", (Object[])new Object[0]));
        label1.setFont(UIUtil.getLabelFont().deriveFont(1));
        MyPanel panel2 = new MyPanel(label1);
        panel2.add((Component)label1, "West");
        panel2.add((Component)label2, "Center");
        panel2.setBorder(BorderFactory.createLineBorder(Color.black));
        final DocumentListener[] documentListener = new DocumentListener[1];
        final CaretListener[] caretListener2 = new CaretListener[1];
        final Document document = editor.getDocument();
        final LightweightHint hint = new LightweightHint(panel2){

            @Override
            public void hide() {
                PerHintSearchData data2 = (PerHintSearchData)this.getUserData(SEARCH_DATA_IN_HINT_KEY);
                LOG.assertTrue(data2 != null);
                String prefix = data2.label.getText();
                super.hide();
                if (data2.segmentHighlighter != null) {
                    data2.segmentHighlighter.dispose();
                }
                PerEditorSearchData editorData = (PerEditorSearchData)editor.getUserData(SEARCH_DATA_IN_EDITOR_VIEW_KEY);
                editorData.hint = null;
                editorData.lastSearch = prefix;
                if (documentListener[0] != null) {
                    document.removeDocumentListener(documentListener[0]);
                    documentListener[0] = null;
                }
                if (caretListener2[0] != null) {
                    CaretListener listener2 = caretListener2[0];
                    editor.getCaretModel().removeCaretListener(listener2);
                }
            }
        };
        documentListener[0] = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!hint.isVisible()) {
                    return;
                }
                hint.hide();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/navigation/IncrementalSearchHandler$2", "documentChanged"));
            }
        };
        document.addDocumentListener(documentListener[0]);
        caretListener2[0] = new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                PerHintSearchData data2;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((data2 = (PerHintSearchData)hint.getUserData(SEARCH_DATA_IN_HINT_KEY)) != null && data2.ignoreCaretMove) {
                    return;
                }
                if (!hint.isVisible()) {
                    return;
                }
                hint.hide();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/navigation/IncrementalSearchHandler$3", "caretPositionChanged"));
            }
        };
        CaretListener listener2 = caretListener2[0];
        editor.getCaretModel().addCaretListener(listener2);
        JComponent component2 = editor.getComponent();
        int x = SwingUtilities.convertPoint((Component)component2, (int)0, (int)0, (Component)component2).x;
        int y = -hint.getComponent().getPreferredSize().height;
        Point p = SwingUtilities.convertPoint(component2, x, y, component2.getRootPane().getLayeredPane());
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, p, 9, 0, false, new HintHint(editor, p).setAwtTooltip(false));
        PerHintSearchData hintData = new PerHintSearchData(project, label2);
        hintData.searchStart = editor.getCaretModel().getOffset();
        hint.putUserData(SEARCH_DATA_IN_HINT_KEY, hintData);
        data2.hint = hint;
        editor.putUserData(SEARCH_DATA_IN_EDITOR_VIEW_KEY, (Object)data2);
        if (!hintData.label.getText().isEmpty()) {
            IncrementalSearchHandler.updatePosition(editor, hintData, true, false);
        }
    }

    private static boolean acceptableRegExp(String pattern) {
        int len = pattern.length();
        for (int i2 = 0; i2 < len; ++i2) {
            if (pattern.charAt(i2) != '*') continue;
            return true;
        }
        return false;
    }

    private static void updatePosition(Editor editor, PerHintSearchData data2, boolean nothingIfFailed, boolean searchBack) {
        int index;
        int matchLength;
        block21: {
            String prefix = data2.label.getText();
            matchLength = prefix.length();
            if (matchLength == 0) {
                index = data2.searchStart;
            } else {
                Document document = editor.getDocument();
                CharSequence text = document.getCharsSequence();
                int length = document.getTextLength();
                boolean caseSensitive = IncrementalSearchHandler.detectSmartCaseSensitive(prefix);
                if (IncrementalSearchHandler.acceptableRegExp(prefix)) {
                    StringBuilder buf = new StringBuilder(prefix.length());
                    int len = prefix.length();
                    for (int i2 = 0; i2 < len; ++i2) {
                        char ch = prefix.charAt(i2);
                        if (ch == '*' && i2 != 0 && i2 != len - 1) {
                            buf.append("\\w");
                        } else if ("{}[].+^$*()?".indexOf(ch) != -1) {
                            buf.append('\\');
                        }
                        buf.append(ch);
                    }
                    try {
                        Pattern pattern = Pattern.compile(buf.toString(), caseSensitive ? 0 : 2);
                        Matcher matcher = pattern.matcher(text);
                        if (searchBack) {
                            int lastStart = -1;
                            int lastEnd = -1;
                            while (matcher.find() && matcher.start() < data2.searchStart) {
                                lastStart = matcher.start();
                                lastEnd = matcher.end();
                            }
                            index = lastStart;
                            matchLength = lastEnd - lastStart;
                            break block21;
                        }
                        if (matcher.find(data2.searchStart) || !nothingIfFailed && matcher.find(0)) {
                            index = matcher.start();
                            matchLength = matcher.end() - matcher.start();
                            break block21;
                        }
                        index = -1;
                    }
                    catch (PatternSyntaxException ex) {
                        index = -1;
                    }
                } else {
                    StringSearcher searcher = new StringSearcher(prefix, caseSensitive, !searchBack);
                    if (searchBack) {
                        index = searcher.scan(text, 0, data2.searchStart);
                    } else {
                        index = searcher.scan(text, data2.searchStart, length);
                        int n = index = index < 0 ? -1 : index;
                    }
                    if (index < 0 && !nothingIfFailed) {
                        index = searcher.scan(text);
                    }
                }
            }
        }
        if (nothingIfFailed && index < 0) {
            return;
        }
        if (data2.segmentHighlighter != null) {
            data2.segmentHighlighter.dispose();
            data2.segmentHighlighter = null;
        }
        if (index < 0) {
            data2.label.setForeground((Color)JBColor.RED);
        } else {
            data2.label.setForeground(JBColor.foreground());
            if (matchLength > 0) {
                data2.segmentHighlighter = editor.getMarkupModel().addRangeHighlighter(EditorColors.SEARCH_RESULT_ATTRIBUTES, index, index + matchLength, 6001, HighlighterTargetArea.EXACT_RANGE);
            }
            data2.ignoreCaretMove = true;
            editor.getCaretModel().moveToOffset(index);
            editor.getSelectionModel().removeSelection();
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
            data2.ignoreCaretMove = false;
            IdeDocumentHistory.getInstance(data2.project).includeCurrentCommandAsNavigation();
        }
    }

    private static boolean detectSmartCaseSensitive(String prefix) {
        boolean hasUpperCase = false;
        for (int i2 = 0; i2 < prefix.length(); ++i2) {
            char c = prefix.charAt(i2);
            if (!Character.isUpperCase(c) || Character.toUpperCase(c) == Character.toLowerCase(c)) continue;
            hasUpperCase = true;
            break;
        }
        return hasUpperCase;
    }

    public static final class DownHandler
    extends EditorActionHandler {
        private final EditorActionHandler myOriginalHandler;

        public DownHandler(EditorActionHandler originalHandler) {
            this.myOriginalHandler = originalHandler;
        }

        public void doExecute(@NotNull Editor editor, Caret caret, DataContext dataContext) {
            PerEditorSearchData data2;
            if (editor == null) {
                DownHandler.$$$reportNull$$$0(0);
            }
            if ((data2 = (PerEditorSearchData)editor.getUserData(SEARCH_DATA_IN_EDITOR_VIEW_KEY)) == null || data2.hint == null) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            } else {
                LightweightHint hint = data2.hint;
                PerHintSearchData hintData = (PerHintSearchData)hint.getUserData(SEARCH_DATA_IN_HINT_KEY);
                String prefix = hintData.label.getText();
                if (prefix == null) {
                    return;
                }
                hintData.searchStart = editor.getCaretModel().getOffset();
                if (hintData.searchStart == editor.getDocument().getTextLength()) {
                    return;
                }
                ++hintData.searchStart;
                IncrementalSearchHandler.updatePosition(editor, hintData, true, false);
                hintData.searchStart = editor.getCaretModel().getOffset();
            }
        }

        public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            PerEditorSearchData data2;
            if (editor == null) {
                DownHandler.$$$reportNull$$$0(1);
            }
            if (caret == null) {
                DownHandler.$$$reportNull$$$0(2);
            }
            return (data2 = (PerEditorSearchData)editor.getUserData(SEARCH_DATA_IN_EDITOR_VIEW_KEY)) != null && data2.hint != null || this.myOriginalHandler.isEnabled(editor, caret, dataContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/navigation/IncrementalSearchHandler$DownHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UpHandler
    extends EditorActionHandler {
        private final EditorActionHandler myOriginalHandler;

        public UpHandler(EditorActionHandler originalHandler) {
            this.myOriginalHandler = originalHandler;
        }

        public void doExecute(@NotNull Editor editor, Caret caret, DataContext dataContext) {
            PerEditorSearchData data2;
            if (editor == null) {
                UpHandler.$$$reportNull$$$0(0);
            }
            if ((data2 = (PerEditorSearchData)editor.getUserData(SEARCH_DATA_IN_EDITOR_VIEW_KEY)) == null || data2.hint == null) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            } else {
                LightweightHint hint = data2.hint;
                PerHintSearchData hintData = (PerHintSearchData)hint.getUserData(SEARCH_DATA_IN_HINT_KEY);
                String prefix = hintData.label.getText();
                if (prefix == null) {
                    return;
                }
                hintData.searchStart = editor.getCaretModel().getOffset();
                if (hintData.searchStart == 0) {
                    return;
                }
                --hintData.searchStart;
                IncrementalSearchHandler.updatePosition(editor, hintData, true, true);
                hintData.searchStart = editor.getCaretModel().getOffset();
            }
        }

        public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            PerEditorSearchData data2;
            if (editor == null) {
                UpHandler.$$$reportNull$$$0(1);
            }
            if (caret == null) {
                UpHandler.$$$reportNull$$$0(2);
            }
            return (data2 = (PerEditorSearchData)editor.getUserData(SEARCH_DATA_IN_EDITOR_VIEW_KEY)) != null && data2.hint != null || this.myOriginalHandler.isEnabled(editor, caret, dataContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/navigation/IncrementalSearchHandler$UpHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BackSpaceHandler
    extends EditorActionHandler {
        private final EditorActionHandler myOriginalHandler;

        public BackSpaceHandler(EditorActionHandler originalAction) {
            this.myOriginalHandler = originalAction;
        }

        public void doExecute(@NotNull Editor editor, Caret caret, DataContext dataContext) {
            PerEditorSearchData data2;
            if (editor == null) {
                BackSpaceHandler.$$$reportNull$$$0(0);
            }
            if ((data2 = (PerEditorSearchData)editor.getUserData(SEARCH_DATA_IN_EDITOR_VIEW_KEY)) == null || data2.hint == null) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            } else {
                LightweightHint hint = data2.hint;
                PerHintSearchData hintData = (PerHintSearchData)hint.getUserData(SEARCH_DATA_IN_HINT_KEY);
                String text = hintData.label.getText();
                if (!text.isEmpty()) {
                    text = text.substring(0, text.length() - 1);
                }
                hintData.label.setText(text);
                IncrementalSearchHandler.updatePosition(editor, hintData, false, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/IncrementalSearchHandler$BackSpaceHandler", "doExecute"));
        }
    }

    public static class MyTypedHandler
    extends TypedActionHandlerBase {
        public MyTypedHandler(@Nullable TypedActionHandler originalHandler) {
            super(originalHandler);
        }

        public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
            PerEditorSearchData data2;
            if (editor == null) {
                MyTypedHandler.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                MyTypedHandler.$$$reportNull$$$0(1);
            }
            if ((data2 = (PerEditorSearchData)editor.getUserData(SEARCH_DATA_IN_EDITOR_VIEW_KEY)) == null || data2.hint == null) {
                if (this.myOriginalHandler != null) {
                    this.myOriginalHandler.execute(editor, charTyped, dataContext);
                }
            } else {
                LightweightHint hint = data2.hint;
                PerHintSearchData hintData = (PerHintSearchData)hint.getUserData(SEARCH_DATA_IN_HINT_KEY);
                String text = hintData.label.getText();
                text = text + charTyped;
                hintData.label.setText(text);
                MyPanel comp = (MyPanel)hint.getComponent();
                if (comp.getTruePreferredSize().width > comp.getSize().width) {
                    Rectangle bounds2 = hint.getBounds();
                    hint.pack();
                    hint.updateLocation(bounds2.x, bounds2.y);
                }
                IncrementalSearchHandler.updatePosition(editor, hintData, false, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataContext";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/navigation/IncrementalSearchHandler$MyTypedHandler";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyPanel
    extends JPanel {
        private final Component myLeft;

        MyPanel(Component left) {
            super(new BorderLayout());
            this.myLeft = left;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            Dimension lSize = this.myLeft.getPreferredSize();
            return new Dimension(size.width + lSize.width, size.height);
        }

        public Dimension getTruePreferredSize() {
            return super.getPreferredSize();
        }
    }

    private static class MyLabel
    extends JLabel {
        MyLabel(String text) {
            super(text);
            this.setBackground(HintUtil.getInformationColor());
            this.setForeground(JBColor.foreground());
            this.setOpaque(true);
        }
    }

    private static class PerEditorSearchData {
        LightweightHint hint;
        String lastSearch;

        private PerEditorSearchData() {
        }
    }

    private static class PerHintSearchData {
        final Project project;
        final JLabel label;
        int searchStart;
        RangeHighlighter segmentHighlighter;
        boolean ignoreCaretMove = false;

        PerHintSearchData(Project project, JLabel label2) {
            this.project = project;
            this.label = label2;
        }
    }
}

