/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.preview;

import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewEditor;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewResult;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewUnsupportedOperationException;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00122\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u0012B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\n\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\r\u001a\u0004\u0018\u00010\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewComputable;", "Ljava/util/concurrent/Callable;", "Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewResult;", "project", "Lcom/intellij/openapi/project/Project;", "action", "Lcom/intellij/codeInsight/intention/IntentionAction;", "originalFile", "Lcom/intellij/psi/PsiFile;", "originalEditor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/codeInsight/intention/IntentionAction;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)V", "call", "generatePreview", "mapInjectedOffsetToUnescaped", "", "injectedFile", "injectedOffset", "Companion", "intellij.platform.lang.impl"})
public final class IntentionPreviewComputable
implements Callable<IntentionPreviewResult> {
    private final Project project;
    private final IntentionAction action;
    private final PsiFile originalFile;
    private final Editor originalEditor;
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    @Nullable
    public IntentionPreviewResult call() {
        try {
            return this.generatePreview();
        }
        catch (IntentionPreviewUnsupportedOperationException e) {
            return null;
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            LOG.debug("There are exceptions on invocation the intention: '" + this.action.getText() + "' on a copy of the file.", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IntentionPreviewResult generatePreview() {
        Pair<PsiFile, Editor> pair = ShowIntentionActionsHandler.chooseFileForAction(this.originalFile, this.originalEditor, this.action);
        if (pair == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull(pair, (String)"ShowIntentionActionsHand\u2026r, action) ?: return null");
        Pair<PsiFile, Editor> origPair = pair;
        PsiFile origFile = null;
        int caretOffset = 0;
        if (Intrinsics.areEqual((Object)((PsiFile)origPair.first), (Object)this.originalFile) ^ true) {
            InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)this.project);
            PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)this.project);
            Object object = origPair.first;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"origPair.first");
            String string = ((PsiFile)object).getName();
            Object object2 = origPair.first;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"origPair.first");
            PsiFile psiFile = psiFileFactory.createFileFromText(string, ((PsiFile)object2).getFileType(), (CharSequence)manager.getUnescapedText((PsiElement)origPair.first));
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"PsiFileFactory.getInstan\u2026apedText(origPair.first))");
            origFile = psiFile;
            Object object3 = origPair.first;
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"origPair.first");
            PsiFile psiFile2 = (PsiFile)object3;
            Object object4 = origPair.second;
            Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"origPair.second");
            CaretModel caretModel = ((Editor)object4).getCaretModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"origPair.second.caretModel");
            caretOffset = this.mapInjectedOffsetToUnescaped(psiFile2, caretModel.getOffset());
        } else {
            origFile = this.originalFile;
            CaretModel caretModel = this.originalEditor.getCaretModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"originalEditor.caretModel");
            caretOffset = caretModel.getOffset();
        }
        PsiElement psiElement = origFile.copy();
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiFile");
        }
        PsiFile psiFileCopy = (PsiFile)psiElement;
        ProgressManager.checkCanceled();
        IntentionPreviewEditor editorCopy = new IntentionPreviewEditor(psiFileCopy, caretOffset);
        IntentionAction intentionAction = IntentionPreviewComputable.Companion.findCopyIntention(this.project, editorCopy, psiFileCopy, this.action);
        if (intentionAction == null) {
            return null;
        }
        IntentionAction action2 = intentionAction;
        Document document = this.originalEditor.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"originalEditor.document");
        boolean writable = document.isWritable();
        try {
            this.originalEditor.getDocument().setReadOnly(true);
            ProgressManager.checkCanceled();
            action2.invoke(this.project, (Editor)editorCopy, psiFileCopy);
            ProgressManager.checkCanceled();
        }
        catch (Throwable throwable) {
            this.originalEditor.getDocument().setReadOnly(!writable);
            throw throwable;
        }
        this.originalEditor.getDocument().setReadOnly(!writable);
        ComparisonManager comparisonManager = ComparisonManager.getInstance();
        CharSequence charSequence = origFile.getText();
        Document document2 = editorCopy.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"editorCopy.document");
        List list2 = comparisonManager.compareLines(charSequence, (CharSequence)document2.getText(), ComparisonPolicy.TRIM_WHITESPACES, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ComparisonManager.getIns\u2026ogressIndicator.INSTANCE)");
        return new IntentionPreviewResult(psiFileCopy, origFile, list2);
    }

    /*
     * WARNING - void declaration
     */
    private final int mapInjectedOffsetToUnescaped(PsiFile injectedFile, int injectedOffset) {
        void escapedOffset;
        void unescapedOffset;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        Ref.IntRef intRef2 = new Ref.IntRef();
        intRef2.element = 0;
        injectedFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((Ref.IntRef)unescapedOffset, (Ref.IntRef)escapedOffset, injectedOffset){
            final /* synthetic */ Ref.IntRef $unescapedOffset;
            final /* synthetic */ Ref.IntRef $escapedOffset;
            final /* synthetic */ int $injectedOffset;

            public void visitElement(@NotNull PsiElement element2) {
                Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                String leafText = InjectedLanguageUtil.getUnescapedLeafText(element2, false);
                if (leafText != null) {
                    this.$unescapedOffset.element += leafText.length();
                    this.$escapedOffset.element += element2.getTextLength();
                    if (this.$escapedOffset.element >= this.$injectedOffset) {
                        this.$unescapedOffset.element -= this.$escapedOffset.element - this.$injectedOffset;
                        this.stopWalking();
                    }
                }
                super.visitElement(element2);
            }
            {
                this.$unescapedOffset = $captured_local_variable$0;
                this.$escapedOffset = $captured_local_variable$1;
                this.$injectedOffset = $captured_local_variable$2;
            }
        });
        return unescapedOffset.element;
    }

    public IntentionPreviewComputable(@NotNull Project project, @NotNull IntentionAction action2, @NotNull PsiFile originalFile, @NotNull Editor originalEditor) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)action2, (String)"action");
        Intrinsics.checkParameterIsNotNull((Object)originalFile, (String)"originalFile");
        Intrinsics.checkParameterIsNotNull((Object)originalEditor, (String)"originalEditor");
        this.project = project;
        this.action = action2;
        this.originalFile = originalFile;
        this.originalEditor = originalEditor;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(IntentionPreviewComputable.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Inten\u2026ewComputable::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewComputable$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "findCopyIntention", "Lcom/intellij/codeInsight/intention/IntentionAction;", "project", "Lcom/intellij/openapi/project/Project;", "editorCopy", "Lcom/intellij/openapi/editor/Editor;", "psiFileCopy", "Lcom/intellij/psi/PsiFile;", "originalAction", "getFixes", "Lkotlin/sequences/Sequence;", "Lcom/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching;", "cachedIntentions", "Lcom/intellij/codeInsight/intention/impl/CachedIntentions;", "intellij.platform.lang.impl"})
    public static final class Companion {
        @NotNull
        public final Sequence<IntentionActionWithTextCaching> getFixes(@NotNull CachedIntentions cachedIntentions) {
            Intrinsics.checkParameterIsNotNull((Object)cachedIntentions, (String)"cachedIntentions");
            Sequence sequence = SequencesKt.sequenceOf((Object[])new IntentionActionWithTextCaching[0]);
            Set<IntentionActionWithTextCaching> set = cachedIntentions.getIntentions();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"cachedIntentions.intentions");
            Sequence sequence2 = SequencesKt.plus((Sequence)sequence, (Iterable)set);
            Set<IntentionActionWithTextCaching> set2 = cachedIntentions.getInspectionFixes();
            Intrinsics.checkExpressionValueIsNotNull(set2, (String)"cachedIntentions.inspectionFixes");
            Sequence sequence3 = SequencesKt.plus((Sequence)sequence2, (Iterable)set2);
            Set<IntentionActionWithTextCaching> set3 = cachedIntentions.getErrorFixes();
            Intrinsics.checkExpressionValueIsNotNull(set3, (String)"cachedIntentions.errorFixes");
            return SequencesKt.plus((Sequence)sequence3, (Iterable)set3);
        }

        private final IntentionAction findCopyIntention(Project project, Editor editorCopy, PsiFile psiFileCopy, IntentionAction originalAction) {
            Object v3;
            block3: {
                IntentionAction transferred;
                FileModifier fileModifier = originalAction.getFileModifierForPreview(psiFileCopy);
                if (!(fileModifier instanceof IntentionAction)) {
                    fileModifier = null;
                }
                if ((transferred = (IntentionAction)fileModifier) != null) {
                    return transferred;
                }
                ShowIntentionsPass.IntentionsInfo intentionsInfo = ShowIntentionsPass.getActionsToShow(editorCopy, psiFileCopy, false);
                Intrinsics.checkExpressionValueIsNotNull((Object)intentionsInfo, (String)"ShowIntentionsPass.getAc\u2026Copy, psiFileCopy, false)");
                ShowIntentionsPass.IntentionsInfo actionsToShow = intentionsInfo;
                CachedIntentions cachedIntentions = CachedIntentions.createAndUpdateActions(project, psiFileCopy, editorCopy, actionsToShow);
                Intrinsics.checkExpressionValueIsNotNull((Object)cachedIntentions, (String)"CachedIntentions.createA\u2026ditorCopy, actionsToShow)");
                CachedIntentions cachedIntentions2 = cachedIntentions;
                Sequence<IntentionActionWithTextCaching> sequence = this.getFixes(cachedIntentions2);
                boolean bl = false;
                Sequence<IntentionActionWithTextCaching> sequence2 = sequence;
                boolean bl2 = false;
                for (Object e : sequence2) {
                    IntentionActionWithTextCaching it = (IntentionActionWithTextCaching)e;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getText(), (Object)originalAction.getText())) continue;
                    v3 = e;
                    break block3;
                }
                v3 = null;
            }
            IntentionActionWithTextCaching intentionActionWithTextCaching = v3;
            return intentionActionWithTextCaching != null ? intentionActionWithTextCaching.getAction() : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

