/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.ide.actions.TemplateKindCombo;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Trinity;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.impl.TaskUiUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TaskStateCombo
extends JPanel {
    private final JBLabel myHintLabel;
    private Project myProject;
    private Task myTask;
    private final TemplateKindCombo myKindCombo = new TemplateKindCombo();

    public static boolean stateUpdatesSupportedFor(@Nullable Task task) {
        if (task == null || !task.isIssue()) {
            return false;
        }
        TaskRepository repository = task.getRepository();
        return repository != null && repository.isSupported(8);
    }

    public TaskStateCombo() {
        this(null, null);
    }

    public TaskStateCombo(Project project, Task task) {
        this.myProject = project;
        this.myTask = task;
        this.myHintLabel = new JBLabel();
        this.myHintLabel.setIcon(PlatformIcons.UP_DOWN_ARROWS);
        this.myHintLabel.setToolTipText("Pressing Up or Down arrows while in editor changes the state");
        JComboBox comboBox = this.myKindCombo.getComboBox();
        comboBox.setPreferredSize(new Dimension(300, comboBox.getPreferredSize().height));
        this.setLayout(new BoxLayout(this, 2));
        this.add((Component)this.myKindCombo);
        this.add((Component)this.myHintLabel);
    }

    public boolean scheduleUpdateOnce() {
        if (this.myProject != null && TaskStateCombo.stateUpdatesSupportedFor(this.myTask) && this.myKindCombo.getComboBox().getItemCount() == 0) {
            JComboBox comboBox = this.myKindCombo.getComboBox();
            final TaskRepository repository = this.myTask.getRepository();
            assert (repository != null);
            new TaskUiUtil.ComboBoxUpdater<CustomStateTrinityAdapter>(this.myProject, "Fetching available task states...", comboBox){

                @Override
                @NotNull
                protected List<CustomStateTrinityAdapter> fetch(@NotNull ProgressIndicator indicator) throws Exception {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    List<CustomStateTrinityAdapter> list = CustomStateTrinityAdapter.wrapList(repository.getAvailableTaskStates(TaskStateCombo.this.myTask));
                    if (list == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return list;
                }

                @Override
                @Nullable
                public CustomStateTrinityAdapter getSelectedItem() {
                    CustomTaskState state = TaskStateCombo.this.getPreferredState(repository, CustomStateTrinityAdapter.unwrapList((Collection)this.myResult));
                    return state != null ? new CustomStateTrinityAdapter(state) : null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/tasks/impl/TaskStateCombo$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/tasks/impl/TaskStateCombo$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "fetch";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "fetch";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }.queue();
            return true;
        }
        return false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myKindCombo.setEnabled(enabled);
    }

    public void showHintLabel(boolean show) {
        this.myHintLabel.setVisible(show);
    }

    @Nullable
    public CustomTaskState getSelectedState() {
        CustomStateTrinityAdapter item = (CustomStateTrinityAdapter)((Object)this.myKindCombo.getComboBox().getSelectedItem());
        if (item == null) {
            return null;
        }
        return item.myState;
    }

    public void registerUpDownAction(@NotNull JComponent focusable) {
        if (focusable == null) {
            TaskStateCombo.$$$reportNull$$$0(0);
        }
        this.myKindCombo.registerUpDownHint(focusable);
    }

    @NotNull
    public JComboBox getComboBox() {
        JComboBox jComboBox = this.myKindCombo.getComboBox();
        if (jComboBox == null) {
            TaskStateCombo.$$$reportNull$$$0(1);
        }
        return jComboBox;
    }

    public void setProject(@NotNull Project project) {
        if (project == null) {
            TaskStateCombo.$$$reportNull$$$0(2);
        }
        this.myProject = project;
    }

    public void setTask(@NotNull Task task) {
        if (task == null) {
            TaskStateCombo.$$$reportNull$$$0(3);
        }
        this.myTask = task;
    }

    @Nullable
    protected abstract CustomTaskState getPreferredState(@NotNull TaskRepository var1, @NotNull Collection<CustomTaskState> var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/impl/TaskStateCombo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/impl/TaskStateCombo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerUpDownAction";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setProject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CustomStateTrinityAdapter
    extends Trinity<String, Icon, String> {
        final CustomTaskState myState;

        CustomStateTrinityAdapter(@NotNull CustomTaskState state) {
            if (state == null) {
                CustomStateTrinityAdapter.$$$reportNull$$$0(0);
            }
            super((Object)state.getPresentableName(), null, (Object)state.getId());
            this.myState = state;
        }

        @NotNull
        static List<CustomStateTrinityAdapter> wrapList(@NotNull Collection<? extends CustomTaskState> states) {
            if (states == null) {
                CustomStateTrinityAdapter.$$$reportNull$$$0(1);
            }
            List list = ContainerUtil.map(states, state -> new CustomStateTrinityAdapter((CustomTaskState)state));
            if (list == null) {
                CustomStateTrinityAdapter.$$$reportNull$$$0(2);
            }
            return list;
        }

        @NotNull
        static List<CustomTaskState> unwrapList(@NotNull Collection<? extends CustomStateTrinityAdapter> wrapped) {
            if (wrapped == null) {
                CustomStateTrinityAdapter.$$$reportNull$$$0(3);
            }
            List list = ContainerUtil.map(wrapped, adapter -> adapter.myState);
            if (list == null) {
                CustomStateTrinityAdapter.$$$reportNull$$$0(4);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "states";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/tasks/impl/TaskStateCombo$CustomStateTrinityAdapter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrapped";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/tasks/impl/TaskStateCombo$CustomStateTrinityAdapter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "wrapList";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unwrapList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "wrapList";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "unwrapList";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

