/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * distance(dvec2(-0.1lf, -1.2lf), dvec2(-0.1lf, -1.2lf)) => 0.0lf
 * distance(dvec2(-0.1lf, -1.2lf), dvec2(-0.42lf, 0.48lf)) => 1.710204666114556lf
 * distance(dvec2(-0.42lf, 0.48lf), dvec2(-0.1lf, -1.2lf)) => 1.710204666114556lf
 * distance(dvec2(-0.42lf, 0.48lf), dvec2(-0.42lf, 0.48lf)) => 0.0lf
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[0.0 <= distance(dvec2(-0.1lf, -1.2lf), dvec2(-0.1lf, -1.2lf)) && distance(dvec2(-0.1lf, -1.2lf), dvec2(-0.1lf, -1.2lf)) <= 0.0 ? 1 : -1] array0;
  double[1.71018756407 <= distance(dvec2(-0.1lf, -1.2lf), dvec2(-0.42lf, 0.48lf)) && distance(dvec2(-0.1lf, -1.2lf), dvec2(-0.42lf, 0.48lf)) <= 1.71022176816 ? 1 : -1] array1;
  double[1.71018756407 <= distance(dvec2(-0.42lf, 0.48lf), dvec2(-0.1lf, -1.2lf)) && distance(dvec2(-0.42lf, 0.48lf), dvec2(-0.1lf, -1.2lf)) <= 1.71022176816 ? 1 : -1] array2;
  double[0.0 <= distance(dvec2(-0.42lf, 0.48lf), dvec2(-0.42lf, 0.48lf)) && distance(dvec2(-0.42lf, 0.48lf), dvec2(-0.42lf, 0.48lf)) <= 0.0 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
