function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { render as _render, unmountComponentAtNode } from 'react-dom';
import { getI18n, getUISettings } from '../services';
export var ReactVisController = /*#__PURE__*/function () {
  function ReactVisController(element, vis) {
    _classCallCheck(this, ReactVisController);

    _defineProperty(this, "el", void 0);

    _defineProperty(this, "vis", void 0);

    this.el = element;
    this.vis = vis;
  }

  _createClass(ReactVisController, [{
    key: "render",
    value: function render(visData, visParams) {
      var _this = this;

      var I18nContext = getI18n().Context;
      return new Promise(function (resolve, reject) {
        if (!_this.vis.type || !_this.vis.type.visConfig || !_this.vis.type.visConfig.component) {
          reject('Missing component for ReactVisType');
        }

        var Component = _this.vis.type.visConfig.component;
        var config = getUISettings();

        _render( /*#__PURE__*/React.createElement(I18nContext, null, /*#__PURE__*/React.createElement(Component, {
          config: config,
          vis: _this.vis,
          visData: visData,
          visParams: visParams,
          renderComplete: resolve
        })), _this.el);
      });
    }
  }, {
    key: "destroy",
    value: function destroy() {
      unmountComponentAtNode(this.el);
    }
  }]);

  return ReactVisController;
}();