function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import { first } from 'rxjs/operators';
import { ErrorEmbeddable } from '../../../embeddable/public';
import { VISUALIZE_EMBEDDABLE_TYPE } from './constants';
import { Vis } from '../vis';
import { getCapabilities, getTypes, getUISettings, getSavedVisualizationsLoader } from '../services';
import { showNewVisModal } from '../wizard';
import { convertToSerializedVis } from '../saved_visualizations/_saved_vis';
import { createVisEmbeddableFromObject } from './create_vis_embeddable_from_object';
import { VISUALIZE_ENABLE_LABS_SETTING } from '../../common/constants';
export var VisualizeEmbeddableFactory = /*#__PURE__*/function () {
  function VisualizeEmbeddableFactory(deps) {
    _classCallCheck(this, VisualizeEmbeddableFactory);

    this.deps = deps;

    _defineProperty(this, "type", VISUALIZE_EMBEDDABLE_TYPE);

    _defineProperty(this, "savedObjectMetaData", {
      name: i18n.translate('visualizations.savedObjectName', {
        defaultMessage: 'Visualization'
      }),
      includeFields: ['visState'],
      type: 'visualization',
      getIconForSavedObject: function getIconForSavedObject(savedObject) {
        return getTypes().get(JSON.parse(savedObject.attributes.visState).type).icon || 'visualizeApp';
      },
      getTooltipForSavedObject: function getTooltipForSavedObject(savedObject) {
        return "".concat(savedObject.attributes.title, " (").concat(getTypes().get(JSON.parse(savedObject.attributes.visState).type).title, ")");
      },
      showSavedObject: function showSavedObject(savedObject) {
        var typeName = JSON.parse(savedObject.attributes.visState).type;
        var visType = getTypes().get(typeName);

        if (!visType) {
          return false;
        }

        if (getUISettings().get(VISUALIZE_ENABLE_LABS_SETTING)) {
          return true;
        }

        return visType.stage !== 'experimental';
      }
    });
  }

  _createClass(VisualizeEmbeddableFactory, [{
    key: "isEditable",
    value: function () {
      var _isEditable = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                return _context.abrupt("return", getCapabilities().visualize.save);

              case 1:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      function isEditable() {
        return _isEditable.apply(this, arguments);
      }

      return isEditable;
    }()
  }, {
    key: "getDisplayName",
    value: function getDisplayName() {
      return i18n.translate('visualizations.displayName', {
        defaultMessage: 'visualization'
      });
    }
  }, {
    key: "getCurrentAppId",
    value: function () {
      var _getCurrentAppId = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                _context2.next = 2;
                return this.deps.start().core.application.currentAppId$.pipe(first()).toPromise();

              case 2:
                return _context2.abrupt("return", _context2.sent);

              case 3:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function getCurrentAppId() {
        return _getCurrentAppId.apply(this, arguments);
      }

      return getCurrentAppId;
    }()
  }, {
    key: "createFromSavedObject",
    value: function () {
      var _createFromSavedObject = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(savedObjectId, input, parent) {
        var savedVisualizations, savedObject, visState, vis;
        return regeneratorRuntime.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                savedVisualizations = getSavedVisualizationsLoader();
                _context3.prev = 1;
                _context3.next = 4;
                return savedVisualizations.get(savedObjectId);

              case 4:
                savedObject = _context3.sent;
                visState = convertToSerializedVis(savedObject);
                vis = new Vis(savedObject.visState.type, visState);
                _context3.next = 9;
                return vis.setState(visState);

              case 9:
                return _context3.abrupt("return", createVisEmbeddableFromObject(this.deps)(vis, input, parent));

              case 12:
                _context3.prev = 12;
                _context3.t0 = _context3["catch"](1);
                console.error(_context3.t0); // eslint-disable-line no-console

                return _context3.abrupt("return", new ErrorEmbeddable(_context3.t0, input, parent));

              case 16:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this, [[1, 12]]);
      }));

      function createFromSavedObject(_x, _x2, _x3) {
        return _createFromSavedObject.apply(this, arguments);
      }

      return createFromSavedObject;
    }()
  }, {
    key: "create",
    value: function () {
      var _create = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4(input, parent) {
        var visState, vis;
        return regeneratorRuntime.wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                if (!input.savedVis) {
                  _context4.next = 8;
                  break;
                }

                visState = input.savedVis;
                vis = new Vis(visState.type, visState);
                _context4.next = 5;
                return vis.setState(visState);

              case 5:
                return _context4.abrupt("return", createVisEmbeddableFromObject(this.deps)(vis, input, parent));

              case 8:
                _context4.t0 = showNewVisModal;
                _context4.next = 11;
                return this.getCurrentAppId();

              case 11:
                _context4.t1 = _context4.sent;
                _context4.t2 = {
                  originatingApp: _context4.t1,
                  outsideVisualizeApp: true
                };
                (0, _context4.t0)(_context4.t2);
                return _context4.abrupt("return", undefined);

              case 15:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4, this);
      }));

      function create(_x4, _x5) {
        return _create.apply(this, arguments);
      }

      return create;
    }()
  }]);

  return VisualizeEmbeddableFactory;
}();