function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback, useState } from 'react';
import { EuiButton, EuiButtonEmpty, EuiButtonIcon, EuiFlexGroup, EuiFlexItem, EuiIcon, EuiPopover, EuiPopoverTitle, EuiText, EuiTitle, EuiToolTip } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { i18n } from '@kbn/i18n';
import { useKibana } from '../../../../kibana_react/public';
export function LinkedSearch(_ref) {
  var savedSearch = _ref.savedSearch,
      eventEmitter = _ref.eventEmitter;

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      showPopover = _useState2[0],
      setShowPopover = _useState2[1];

  var _useKibana = useKibana(),
      application = _useKibana.services.application;

  var closePopover = useCallback(function () {
    return setShowPopover(false);
  }, []);
  var onClickButtonLink = useCallback(function () {
    return setShowPopover(function (v) {
      return !v;
    });
  }, []);
  var onClickUnlikFromSavedSearch = useCallback(function () {
    setShowPopover(false);
    eventEmitter.emit('unlinkFromSavedSearch');
  }, [eventEmitter]);
  var onClickViewInDiscover = useCallback(function () {
    application.navigateToApp('discover', {
      path: "#/view/".concat(savedSearch.id)
    });
  }, [application, savedSearch.id]);
  var linkButtonAriaLabel = i18n.translate('visDefaultEditor.sidebar.savedSearch.linkButtonAriaLabel', {
    defaultMessage: 'Link to saved search. Click to learn more or break link.'
  });
  return /*#__PURE__*/React.createElement(EuiFlexGroup, {
    alignItems: "center",
    className: "visEditorSidebar__titleContainer visEditorSidebar__linkedSearch",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiIcon, {
    type: "search"
  })), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false,
    className: "eui-textTruncate"
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xs",
    className: "eui-textTruncate"
  }, /*#__PURE__*/React.createElement("h2", {
    title: i18n.translate('visDefaultEditor.sidebar.savedSearch.titleAriaLabel', {
      defaultMessage: 'Saved search: {title}',
      values: {
        title: savedSearch.title
      }
    })
  }, savedSearch.title))), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiPopover, {
    anchorPosition: "downRight",
    button: /*#__PURE__*/React.createElement(EuiToolTip, {
      content: linkButtonAriaLabel
    }, /*#__PURE__*/React.createElement(EuiButtonIcon, {
      "aria-label": linkButtonAriaLabel,
      "data-test-subj": "showUnlinkSavedSearchPopover",
      iconType: "link",
      onClick: onClickButtonLink
    })),
    isOpen: showPopover,
    closePopover: closePopover,
    panelPaddingSize: "s"
  }, /*#__PURE__*/React.createElement(EuiPopoverTitle, null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visDefaultEditor.sidebar.savedSearch.popoverTitle",
    defaultMessage: "Linked to saved search"
  })), /*#__PURE__*/React.createElement("div", {
    style: {
      width: 260
    }
  }, /*#__PURE__*/React.createElement(EuiText, {
    size: "s"
  }, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    "data-test-subj": "viewSavedSearch",
    flush: "left",
    onClick: onClickViewInDiscover,
    size: "xs"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visDefaultEditor.sidebar.savedSearch.goToDiscoverButtonText",
    defaultMessage: "View this search in Discover"
  }))), /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visDefaultEditor.sidebar.savedSearch.popoverHelpText",
    defaultMessage: "Subsequent modifications to this saved search are reflected in the visualization. To disable automatic updates, remove the link."
  })), /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(EuiButton, {
    color: "danger",
    "data-test-subj": "unlinkSavedSearch",
    fullWidth: true,
    onClick: onClickUnlikFromSavedSearch,
    size: "s"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visDefaultEditor.sidebar.savedSearch.unlinkSavedSearchButtonText",
    defaultMessage: "Remove link to saved search"
  }))))))));
}

function SidebarTitle(_ref2) {
  var savedSearch = _ref2.savedSearch,
      vis = _ref2.vis,
      isLinkedSearch = _ref2.isLinkedSearch,
      eventEmitter = _ref2.eventEmitter;
  return isLinkedSearch && savedSearch ? /*#__PURE__*/React.createElement(LinkedSearch, {
    savedSearch: savedSearch,
    eventEmitter: eventEmitter
  }) : vis.type.options.showIndexSelection ? /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xs",
    className: "visEditorSidebar__titleContainer eui-textTruncate"
  }, /*#__PURE__*/React.createElement("h2", {
    title: i18n.translate('visDefaultEditor.sidebar.indexPatternAriaLabel', {
      defaultMessage: 'Index pattern: {title}',
      values: {
        title: vis.data.indexPattern.title
      }
    })
  }, vis.data.indexPattern.title)) : /*#__PURE__*/React.createElement("div", {
    className: "visEditorSidebar__indexPatternPlaceholder"
  });
}

export { SidebarTitle };