function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useState, useEffect, Fragment, useCallback } from 'react';
import { isEmpty, isEqual, mapValues, omitBy, pick } from 'lodash';
import { EuiButtonIcon, EuiFlexGroup, EuiFlexItem, EuiSpacer, htmlIdGenerator, EuiButtonEmpty } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
var generateId = htmlIdGenerator();

var validateValue = function validateValue(inputValue, InputObject) {
  var result = {
    model: inputValue || '',
    isInvalid: false
  };

  if (!inputValue) {
    result.isInvalid = false;
    return result;
  }

  try {
    result.model = new InputObject(inputValue).toString();
    result.isInvalid = false;
    return result;
  } catch (e) {
    result.isInvalid = true;
    return result;
  }
};

function InputList(_ref) {
  var config = _ref.config,
      list = _ref.list,
      onChange = _ref.onChange,
      setValidity = _ref.setValidity;
  var defaultValue = config.defaultValue,
      getModelValue = config.getModelValue,
      modelNames = config.modelNames,
      onChangeFn = config.onChangeFn,
      validateClass = config.validateClass;

  var _useState = useState(function () {
    return list.map(function (item) {
      return _objectSpread({
        id: generateId()
      }, getModelValue(item));
    });
  }),
      _useState2 = _slicedToArray(_useState, 2),
      models = _useState2[0],
      setModels = _useState2[1];

  var hasInvalidValues = models.some(config.hasInvalidValuesFn);
  var updateValues = useCallback(function (modelList) {
    setModels(modelList);
    onChange(modelList.map(onChangeFn));
  }, [onChangeFn, onChange]);
  var onChangeValue = useCallback(function (index, value, modelName) {
    var _validateValue = validateValue(value, validateClass),
        model = _validateValue.model,
        isInvalid = _validateValue.isInvalid;

    updateValues(models.map(function (range, arrayIndex) {
      return arrayIndex === index ? _objectSpread(_objectSpread({}, range), {}, _defineProperty({}, modelName, {
        value: value,
        model: model,
        isInvalid: isInvalid
      })) : range;
    }));
  }, [models, updateValues, validateClass]);
  var onDelete = useCallback(function (id) {
    return updateValues(models.filter(function (model) {
      return model.id !== id;
    }));
  }, [models, updateValues]);
  var onAdd = useCallback(function () {
    return updateValues([].concat(_toConsumableArray(models), [_objectSpread({
      id: generateId()
    }, getModelValue())]));
  }, [getModelValue, models, updateValues]);
  useEffect(function () {
    // resposible for setting up an initial value when there is no default value
    if (!list.length) {
      updateValues([_objectSpread({
        id: generateId()
      }, defaultValue)]);
    }
  }, [defaultValue, list.length, updateValues]);
  useEffect(function () {
    setValidity(!hasInvalidValues);
  }, [hasInvalidValues, setValidity]);
  useEffect(function () {
    // responsible for discarding changes
    if (list.length !== models.length || list.some(function (item, index) {
      // make model to be the same shape as stored value
      var model = mapValues(pick(models[index], modelNames), 'model'); // we need to skip empty values since they are not stored in saved object

      return !isEqual(item, omitBy(model, isEmpty));
    })) {
      setModels(list.map(function (item) {
        return _objectSpread({
          id: generateId()
        }, getModelValue(item));
      }));
    }
  }, [getModelValue, list, modelNames, models]);
  return /*#__PURE__*/React.createElement(React.Fragment, null, models.map(function (item, index) {
    return /*#__PURE__*/React.createElement(Fragment, {
      key: item.id
    }, /*#__PURE__*/React.createElement(EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      responsive: false
    }, config.renderInputRow(item, index, onChangeValue), /*#__PURE__*/React.createElement(EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/React.createElement(EuiButtonIcon, {
      "aria-label": config.getRemoveBtnAriaLabel(item),
      title: config.getRemoveBtnAriaLabel(item),
      disabled: models.length === 1,
      color: "danger",
      iconType: "trash",
      onClick: function onClick() {
        return onDelete(item.id);
      }
    }))), /*#__PURE__*/React.createElement(EuiSpacer, {
      size: "xs"
    }));
  }), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    iconType: "plusInCircleFilled",
    onClick: onAdd,
    size: "xs"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visDefaultEditor.controls.ipRanges.addRangeButtonLabel",
    defaultMessage: "Add range"
  }))));
}

export { InputList };