function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { METRIC_TYPE } from '@kbn/analytics';
import { Subject, merge } from 'rxjs';
import { Storage } from '../../kibana_utils/public';
import { createReporter } from './services';
import { reportApplicationUsage } from './services/application_usage';
export function isUnauthenticated(http) {
  var anonymousPaths = http.anonymousPaths;
  return anonymousPaths.isAnonymous(window.location.pathname);
}
export var UsageCollectionPlugin = /*#__PURE__*/function () {
  function UsageCollectionPlugin(initializerContext) {
    _classCallCheck(this, UsageCollectionPlugin);

    _defineProperty(this, "legacyAppId$", new Subject());

    _defineProperty(this, "trackUserAgent", true);

    _defineProperty(this, "reporter", void 0);

    _defineProperty(this, "config", void 0);

    this.config = initializerContext.config.get();
  }

  _createClass(UsageCollectionPlugin, [{
    key: "setup",
    value: function setup(_ref) {
      var _this = this;

      var http = _ref.http;
      var localStorage = new Storage(window.localStorage);
      var debug = this.config.uiMetric.debug;
      this.reporter = createReporter({
        localStorage: localStorage,
        debug: debug,
        fetch: http
      });
      return {
        allowTrackUserAgent: function allowTrackUserAgent(allow) {
          _this.trackUserAgent = allow;
        },
        reportUiStats: this.reporter.reportUiStats,
        METRIC_TYPE: METRIC_TYPE,
        __LEGACY: {
          appChanged: function appChanged(appId) {
            return _this.legacyAppId$.next(appId);
          }
        }
      };
    }
  }, {
    key: "start",
    value: function start(_ref2) {
      var http = _ref2.http,
          application = _ref2.application;

      if (!this.reporter) {
        throw new Error('Usage collection reporter not set up correctly');
      }

      if (this.config.uiMetric.enabled && !isUnauthenticated(http)) {
        this.reporter.start();
      }

      if (this.trackUserAgent) {
        this.reporter.reportUserAgent('kibana');
      }

      reportApplicationUsage(merge(application.currentAppId$, this.legacyAppId$), this.reporter);
      return {
        reportUiStats: this.reporter.reportUiStats,
        METRIC_TYPE: METRIC_TYPE
      };
    }
  }, {
    key: "stop",
    value: function stop() {}
  }]);

  return UsageCollectionPlugin;
}();