function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import { debounce } from 'lodash'; // @ts-expect-error

import { saveAs } from '@elastic/filesaver';
import { EuiSpacer, Query, EuiInMemoryTable, EuiIcon, EuiConfirmModal, EuiLoadingKibana, EuiOverlayMask, EUI_MODAL_CONFIRM_BUTTON, EuiCheckboxGroup, EuiToolTip, EuiPageContent, EuiSwitch, EuiModal, EuiModalHeader, EuiModalBody, EuiModalFooter, EuiButtonEmpty, EuiButton, EuiModalHeaderTitle, EuiFormRow, EuiFlexGroup, EuiFlexItem } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { RedirectAppLinks } from '../../../../kibana_react/public';
import { parseQuery, getSavedObjectCounts, getRelationships, getSavedObjectLabel, fetchExportObjects, fetchExportByTypeAndSearch, findObjects, extractExportDetails } from '../../lib';
import { Header, Table, Flyout, Relationships } from './components';
export var SavedObjectsTable = /*#__PURE__*/function (_Component) {
  _inherits(SavedObjectsTable, _Component);

  var _super = _createSuper(SavedObjectsTable);

  function SavedObjectsTable(props) {
    var _this;

    _classCallCheck(this, SavedObjectsTable);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "_isMounted", false);

    _defineProperty(_assertThisInitialized(_this), "fetchCounts", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      var allowedTypes, _parseQuery, queryText, visibleTypes, filteredTypes, filteredSavedObjectCounts, exportAllOptions, exportAllSelectedOptions, savedObjectCounts;

      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              allowedTypes = _this.props.allowedTypes;
              _parseQuery = parseQuery(_this.state.activeQuery), queryText = _parseQuery.queryText, visibleTypes = _parseQuery.visibleTypes;
              filteredTypes = allowedTypes.filter(function (type) {
                return !visibleTypes || visibleTypes.includes(type);
              }); // These are the saved objects visible in the table.

              _context.next = 5;
              return getSavedObjectCounts(_this.props.http, filteredTypes, queryText);

            case 5:
              filteredSavedObjectCounts = _context.sent;
              exportAllOptions = [];
              exportAllSelectedOptions = {};
              Object.keys(filteredSavedObjectCounts).forEach(function (id) {
                // Add this type as a bulk-export option.
                exportAllOptions.push({
                  id: id,
                  label: "".concat(id, " (").concat(filteredSavedObjectCounts[id] || 0, ")")
                }); // Select it by default.

                exportAllSelectedOptions[id] = true;
              }); // Fetch all the saved objects that exist so we can accurately populate the counts within
              // the table filter dropdown.

              _context.next = 11;
              return getSavedObjectCounts(_this.props.http, allowedTypes, queryText);

            case 11:
              savedObjectCounts = _context.sent;

              _this.setState(function (state) {
                return _objectSpread(_objectSpread({}, state), {}, {
                  savedObjectCounts: savedObjectCounts,
                  exportAllOptions: exportAllOptions,
                  exportAllSelectedOptions: exportAllSelectedOptions
                });
              });

            case 13:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));

    _defineProperty(_assertThisInitialized(_this), "fetchSavedObjects", function () {
      _this.setState({
        isSearching: true
      }, _this.debouncedFetch);
    });

    _defineProperty(_assertThisInitialized(_this), "debouncedFetch", debounce( /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
      var _this$state, query, page, perPage, _this$props, notifications, http, allowedTypes, _parseQuery2, queryText, visibleTypes, findOptions, resp;

      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              _this$state = _this.state, query = _this$state.activeQuery, page = _this$state.page, perPage = _this$state.perPage;
              _this$props = _this.props, notifications = _this$props.notifications, http = _this$props.http, allowedTypes = _this$props.allowedTypes;
              _parseQuery2 = parseQuery(query), queryText = _parseQuery2.queryText, visibleTypes = _parseQuery2.visibleTypes; // "searchFields" is missing from the "findOptions" but gets injected via the API.
              // The API extracts the fields from each uiExports.savedObjectsManagement "defaultSearchField" attribute

              findOptions = {
                search: queryText ? "".concat(queryText, "*") : undefined,
                perPage: perPage,
                page: page + 1,
                fields: ['id'],
                type: allowedTypes.filter(function (type) {
                  return !visibleTypes || visibleTypes.includes(type);
                })
              };

              if (findOptions.type.length > 1) {
                findOptions.sortField = 'type';
              }

              _context2.prev = 5;
              _context2.next = 8;
              return findObjects(http, findOptions);

            case 8:
              resp = _context2.sent;

              if (_this._isMounted) {
                _context2.next = 11;
                break;
              }

              return _context2.abrupt("return");

            case 11:
              _this.setState(function (_ref3) {
                var activeQuery = _ref3.activeQuery;

                // ignore results for old requests
                if (activeQuery.text !== query.text) {
                  return null;
                }

                return {
                  savedObjects: resp.savedObjects,
                  filteredItemCount: resp.total,
                  isSearching: false
                };
              });

              _context2.next = 18;
              break;

            case 14:
              _context2.prev = 14;
              _context2.t0 = _context2["catch"](5);

              if (_this._isMounted) {
                _this.setState({
                  isSearching: false
                });
              }

              notifications.toasts.addDanger({
                title: i18n.translate('savedObjectsManagement.objectsTable.unableFindSavedObjectsNotificationMessage', {
                  defaultMessage: 'Unable find saved objects'
                }),
                text: "".concat(_context2.t0)
              });

            case 18:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2, null, [[5, 14]]);
    })), 300));

    _defineProperty(_assertThisInitialized(_this), "refreshData", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
      return regeneratorRuntime.wrap(function _callee3$(_context3) {
        while (1) {
          switch (_context3.prev = _context3.next) {
            case 0:
              _context3.next = 2;
              return Promise.all([_this.fetchSavedObjects(), _this.fetchCounts()]);

            case 2:
            case "end":
              return _context3.stop();
          }
        }
      }, _callee3);
    })));

    _defineProperty(_assertThisInitialized(_this), "onSelectionChanged", function (selection) {
      _this.setState({
        selectedSavedObjects: selection
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onQueryChange", function (_ref5) {
      var query = _ref5.query;

      // TODO: Use isSameQuery to compare new query with state.activeQuery to avoid re-fetching the
      // same data we already have.
      _this.setState({
        activeQuery: query,
        page: 0,
        // Reset this on each query change
        selectedSavedObjects: []
      }, function () {
        _this.fetchSavedObjects();

        _this.fetchCounts();
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onTableChange", /*#__PURE__*/function () {
      var _ref6 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4(table) {
        var _ref7, page, perPage;

        return regeneratorRuntime.wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                _ref7 = table.page || {}, page = _ref7.index, perPage = _ref7.size;

                _this.setState({
                  page: page,
                  perPage: perPage,
                  selectedSavedObjects: []
                }, _this.fetchSavedObjects);

              case 2:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4);
      }));

      return function (_x) {
        return _ref6.apply(this, arguments);
      };
    }());

    _defineProperty(_assertThisInitialized(_this), "onShowRelationships", function (object) {
      _this.setState({
        isShowingRelationships: true,
        relationshipObject: object
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onHideRelationships", function () {
      _this.setState({
        isShowingRelationships: false,
        relationshipObject: undefined
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onExport", /*#__PURE__*/function () {
      var _ref8 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5(includeReferencesDeep) {
        var selectedSavedObjects, _this$props2, notifications, http, objectsToExport, blob, exportDetails;

        return regeneratorRuntime.wrap(function _callee5$(_context5) {
          while (1) {
            switch (_context5.prev = _context5.next) {
              case 0:
                selectedSavedObjects = _this.state.selectedSavedObjects;
                _this$props2 = _this.props, notifications = _this$props2.notifications, http = _this$props2.http;
                objectsToExport = selectedSavedObjects.map(function (obj) {
                  return {
                    id: obj.id,
                    type: obj.type
                  };
                });
                _context5.prev = 3;
                _context5.next = 6;
                return fetchExportObjects(http, objectsToExport, includeReferencesDeep);

              case 6:
                blob = _context5.sent;
                _context5.next = 13;
                break;

              case 9:
                _context5.prev = 9;
                _context5.t0 = _context5["catch"](3);
                notifications.toasts.addDanger({
                  title: i18n.translate('savedObjectsManagement.objectsTable.export.dangerNotification', {
                    defaultMessage: 'Unable to generate export'
                  })
                });
                throw _context5.t0;

              case 13:
                saveAs(blob, 'export.ndjson');
                _context5.next = 16;
                return extractExportDetails(blob);

              case 16:
                exportDetails = _context5.sent;

                _this.showExportSuccessMessage(exportDetails);

              case 18:
              case "end":
                return _context5.stop();
            }
          }
        }, _callee5, null, [[3, 9]]);
      }));

      return function (_x2) {
        return _ref8.apply(this, arguments);
      };
    }());

    _defineProperty(_assertThisInitialized(_this), "onExportAll", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee6() {
      var _this$state2, exportAllSelectedOptions, isIncludeReferencesDeepChecked, activeQuery, _this$props3, notifications, http, _parseQuery3, queryText, exportTypes, blob, exportDetails;

      return regeneratorRuntime.wrap(function _callee6$(_context6) {
        while (1) {
          switch (_context6.prev = _context6.next) {
            case 0:
              _this$state2 = _this.state, exportAllSelectedOptions = _this$state2.exportAllSelectedOptions, isIncludeReferencesDeepChecked = _this$state2.isIncludeReferencesDeepChecked, activeQuery = _this$state2.activeQuery;
              _this$props3 = _this.props, notifications = _this$props3.notifications, http = _this$props3.http;
              _parseQuery3 = parseQuery(activeQuery), queryText = _parseQuery3.queryText;
              exportTypes = Object.entries(exportAllSelectedOptions).reduce(function (accum, _ref10) {
                var _ref11 = _slicedToArray(_ref10, 2),
                    id = _ref11[0],
                    selected = _ref11[1];

                if (selected) {
                  accum.push(id);
                }

                return accum;
              }, []);
              _context6.prev = 4;
              _context6.next = 7;
              return fetchExportByTypeAndSearch(http, exportTypes, queryText ? "".concat(queryText, "*") : undefined, isIncludeReferencesDeepChecked);

            case 7:
              blob = _context6.sent;
              _context6.next = 14;
              break;

            case 10:
              _context6.prev = 10;
              _context6.t0 = _context6["catch"](4);
              notifications.toasts.addDanger({
                title: i18n.translate('savedObjectsManagement.objectsTable.export.dangerNotification', {
                  defaultMessage: 'Unable to generate export'
                })
              });
              throw _context6.t0;

            case 14:
              saveAs(blob, 'export.ndjson');
              _context6.next = 17;
              return extractExportDetails(blob);

            case 17:
              exportDetails = _context6.sent;

              _this.showExportSuccessMessage(exportDetails);

              _this.setState({
                isShowingExportAllOptionsModal: false
              });

            case 20:
            case "end":
              return _context6.stop();
          }
        }
      }, _callee6, null, [[4, 10]]);
    })));

    _defineProperty(_assertThisInitialized(_this), "showExportSuccessMessage", function (exportDetails) {
      var notifications = _this.props.notifications;

      if (exportDetails && exportDetails.missingReferences.length > 0) {
        notifications.toasts.addWarning({
          title: i18n.translate('savedObjectsManagement.objectsTable.export.successWithMissingRefsNotification', {
            defaultMessage: 'Your file is downloading in the background. ' + 'Some related objects could not be found. ' + 'Please see the last line in the exported file for a list of missing objects.'
          })
        });
      } else {
        notifications.toasts.addSuccess({
          title: i18n.translate('savedObjectsManagement.objectsTable.export.successNotification', {
            defaultMessage: 'Your file is downloading in the background'
          })
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "finishImport", function () {
      _this.hideImportFlyout();

      _this.fetchSavedObjects();

      _this.fetchCounts();
    });

    _defineProperty(_assertThisInitialized(_this), "showImportFlyout", function () {
      _this.setState({
        isShowingImportFlyout: true
      });
    });

    _defineProperty(_assertThisInitialized(_this), "hideImportFlyout", function () {
      _this.setState({
        isShowingImportFlyout: false
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onDelete", function () {
      _this.setState({
        isShowingDeleteConfirmModal: true
      });
    });

    _defineProperty(_assertThisInitialized(_this), "delete", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee7() {
      var savedObjectsClient, _this$state3, selectedSavedObjects, isDeleting, indexPatterns, objects, deletes;

      return regeneratorRuntime.wrap(function _callee7$(_context7) {
        while (1) {
          switch (_context7.prev = _context7.next) {
            case 0:
              savedObjectsClient = _this.props.savedObjectsClient;
              _this$state3 = _this.state, selectedSavedObjects = _this$state3.selectedSavedObjects, isDeleting = _this$state3.isDeleting;

              if (!isDeleting) {
                _context7.next = 4;
                break;
              }

              return _context7.abrupt("return");

            case 4:
              _this.setState({
                isDeleting: true
              });

              indexPatterns = selectedSavedObjects.filter(function (object) {
                return object.type === 'index-pattern';
              });

              if (!indexPatterns.length) {
                _context7.next = 9;
                break;
              }

              _context7.next = 9;
              return _this.props.indexPatterns.clearCache();

            case 9:
              _context7.next = 11;
              return savedObjectsClient.bulkGet(selectedSavedObjects);

            case 11:
              objects = _context7.sent;
              deletes = objects.savedObjects.map(function (object) {
                return savedObjectsClient.delete(object.type, object.id);
              });
              _context7.next = 15;
              return Promise.all(deletes);

            case 15:
              // Unset this
              _this.setState({
                selectedSavedObjects: []
              }); // Fetching all data


              _context7.next = 18;
              return _this.fetchSavedObjects();

            case 18:
              _context7.next = 20;
              return _this.fetchCounts();

            case 20:
              // Allow the user to interact with the table once the saved objects have been re-fetched.
              _this.setState({
                isShowingDeleteConfirmModal: false,
                isDeleting: false
              });

            case 21:
            case "end":
              return _context7.stop();
          }
        }
      }, _callee7);
    })));

    _defineProperty(_assertThisInitialized(_this), "getRelationships", /*#__PURE__*/function () {
      var _ref13 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee8(type, id) {
        var _this$props4, allowedTypes, http;

        return regeneratorRuntime.wrap(function _callee8$(_context8) {
          while (1) {
            switch (_context8.prev = _context8.next) {
              case 0:
                _this$props4 = _this.props, allowedTypes = _this$props4.allowedTypes, http = _this$props4.http;
                _context8.next = 3;
                return getRelationships(http, type, id, allowedTypes);

              case 3:
                return _context8.abrupt("return", _context8.sent);

              case 4:
              case "end":
                return _context8.stop();
            }
          }
        }, _callee8);
      }));

      return function (_x3, _x4) {
        return _ref13.apply(this, arguments);
      };
    }());

    _defineProperty(_assertThisInitialized(_this), "changeIncludeReferencesDeep", function () {
      _this.setState(function (state) {
        return {
          isIncludeReferencesDeepChecked: !state.isIncludeReferencesDeepChecked
        };
      });
    });

    _defineProperty(_assertThisInitialized(_this), "closeExportAllModal", function () {
      _this.setState({
        isShowingExportAllOptionsModal: false
      });
    });

    _this.state = {
      totalCount: 0,
      page: 0,
      perPage: props.perPageConfig || 50,
      savedObjects: [],
      savedObjectCounts: props.allowedTypes.reduce(function (typeToCountMap, type) {
        typeToCountMap[type] = 0;
        return typeToCountMap;
      }, {}),
      activeQuery: Query.parse(''),
      selectedSavedObjects: [],
      isShowingImportFlyout: false,
      isSearching: false,
      filteredItemCount: 0,
      isShowingRelationships: false,
      relationshipObject: undefined,
      isShowingDeleteConfirmModal: false,
      isShowingExportAllOptionsModal: false,
      isDeleting: false,
      exportAllOptions: [],
      exportAllSelectedOptions: {},
      isIncludeReferencesDeepChecked: true
    };
    return _this;
  }

  _createClass(SavedObjectsTable, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this._isMounted = true;
      this.fetchSavedObjects();
      this.fetchCounts();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this._isMounted = false;
      this.debouncedFetch.cancel();
    }
  }, {
    key: "renderFlyout",
    value: function renderFlyout() {
      if (!this.state.isShowingImportFlyout) {
        return null;
      }

      var applications = this.props.applications;
      var newIndexPatternUrl = applications.getUrlForApp('management', {
        path: 'kibana/indexPatterns'
      });
      return /*#__PURE__*/React.createElement(Flyout, {
        close: this.hideImportFlyout,
        done: this.finishImport,
        http: this.props.http,
        serviceRegistry: this.props.serviceRegistry,
        indexPatterns: this.props.indexPatterns,
        newIndexPatternUrl: newIndexPatternUrl,
        allowedTypes: this.props.allowedTypes,
        overlays: this.props.overlays,
        search: this.props.search
      });
    }
  }, {
    key: "renderRelationships",
    value: function renderRelationships() {
      if (!this.state.isShowingRelationships) {
        return null;
      }

      return /*#__PURE__*/React.createElement(Relationships, {
        basePath: this.props.http.basePath,
        savedObject: this.state.relationshipObject,
        getRelationships: this.getRelationships,
        close: this.onHideRelationships,
        goInspectObject: this.props.goInspectObject,
        canGoInApp: this.props.canGoInApp
      });
    }
  }, {
    key: "renderDeleteConfirmModal",
    value: function renderDeleteConfirmModal() {
      var _this2 = this;

      var _this$state4 = this.state,
          isShowingDeleteConfirmModal = _this$state4.isShowingDeleteConfirmModal,
          isDeleting = _this$state4.isDeleting,
          selectedSavedObjects = _this$state4.selectedSavedObjects;

      if (!isShowingDeleteConfirmModal) {
        return null;
      }

      var modal;

      if (isDeleting) {
        // Block the user from interacting with the table while its contents are being deleted.
        modal = /*#__PURE__*/React.createElement(EuiLoadingKibana, {
          size: "xl"
        });
      } else {
        var onCancel = function onCancel() {
          _this2.setState({
            isShowingDeleteConfirmModal: false
          });
        };

        var onConfirm = function onConfirm() {
          _this2.delete();
        };

        modal = /*#__PURE__*/React.createElement(EuiConfirmModal, {
          title: /*#__PURE__*/React.createElement(FormattedMessage, {
            id: "savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModalTitle",
            defaultMessage: "Delete saved objects"
          }),
          onCancel: onCancel,
          onConfirm: onConfirm,
          buttonColor: "danger",
          cancelButtonText: /*#__PURE__*/React.createElement(FormattedMessage, {
            id: "savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModal.cancelButtonLabel",
            defaultMessage: "Cancel"
          }),
          confirmButtonText: isDeleting ? /*#__PURE__*/React.createElement(FormattedMessage, {
            id: "savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModal.deleteProcessButtonLabel",
            defaultMessage: "Deleting\u2026"
          }) : /*#__PURE__*/React.createElement(FormattedMessage, {
            id: "savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModal.deleteButtonLabel",
            defaultMessage: "Delete"
          }),
          defaultFocusedButton: EUI_MODAL_CONFIRM_BUTTON
        }, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "savedObjectsManagement.deleteSavedObjectsConfirmModalDescription",
          defaultMessage: "This action will delete the following saved objects:"
        })), /*#__PURE__*/React.createElement(EuiInMemoryTable, {
          items: selectedSavedObjects,
          columns: [{
            field: 'type',
            name: i18n.translate('savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModal.typeColumnName', {
              defaultMessage: 'Type'
            }),
            width: '50px',
            render: function render(type, object) {
              return /*#__PURE__*/React.createElement(EuiToolTip, {
                position: "top",
                content: getSavedObjectLabel(type)
              }, /*#__PURE__*/React.createElement(EuiIcon, {
                type: object.meta.icon || 'apps'
              }));
            }
          }, {
            field: 'id',
            name: i18n.translate('savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModal.idColumnName', {
              defaultMessage: 'Id'
            })
          }, {
            field: 'meta.title',
            name: i18n.translate('savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModal.titleColumnName', {
              defaultMessage: 'Title'
            })
          }],
          pagination: true,
          sorting: false
        }));
      }

      return /*#__PURE__*/React.createElement(EuiOverlayMask, null, modal);
    }
  }, {
    key: "renderExportAllOptionsModal",
    value: function renderExportAllOptionsModal() {
      var _this3 = this;

      var _this$state5 = this.state,
          isShowingExportAllOptionsModal = _this$state5.isShowingExportAllOptionsModal,
          filteredItemCount = _this$state5.filteredItemCount,
          exportAllOptions = _this$state5.exportAllOptions,
          exportAllSelectedOptions = _this$state5.exportAllSelectedOptions,
          isIncludeReferencesDeepChecked = _this$state5.isIncludeReferencesDeepChecked;

      if (!isShowingExportAllOptionsModal) {
        return null;
      }

      return /*#__PURE__*/React.createElement(EuiOverlayMask, null, /*#__PURE__*/React.createElement(EuiModal, {
        onClose: this.closeExportAllModal
      }, /*#__PURE__*/React.createElement(EuiModalHeader, null, /*#__PURE__*/React.createElement(EuiModalHeaderTitle, null, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "savedObjectsManagement.objectsTable.exportObjectsConfirmModalTitle",
        defaultMessage: "Export {filteredItemCount, plural, one{# object} other {# objects}}",
        values: {
          filteredItemCount: filteredItemCount
        }
      }))), /*#__PURE__*/React.createElement(EuiModalBody, null, /*#__PURE__*/React.createElement(EuiFormRow, {
        label: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "savedObjectsManagement.objectsTable.exportObjectsConfirmModalDescription",
          defaultMessage: "Select which types to export"
        }),
        labelType: "legend"
      }, /*#__PURE__*/React.createElement(EuiCheckboxGroup, {
        options: exportAllOptions,
        idToSelectedMap: exportAllSelectedOptions,
        onChange: function onChange(optionId) {
          var newExportAllSelectedOptions = _objectSpread(_objectSpread({}, exportAllSelectedOptions), _defineProperty({}, optionId, !exportAllSelectedOptions[optionId]));

          _this3.setState({
            exportAllSelectedOptions: newExportAllSelectedOptions
          });
        }
      })), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/React.createElement(EuiSwitch, {
        name: "includeReferencesDeep",
        label: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "savedObjectsManagement.objectsTable.exportObjectsConfirmModal.includeReferencesDeepLabel",
          defaultMessage: "Include related objects"
        }),
        checked: isIncludeReferencesDeepChecked,
        onChange: this.changeIncludeReferencesDeep
      })), /*#__PURE__*/React.createElement(EuiModalFooter, null, /*#__PURE__*/React.createElement(EuiFlexGroup, {
        justifyContent: "flexEnd"
      }, /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiFlexGroup, null, /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
        onClick: this.closeExportAllModal
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "savedObjectsManagement.objectsTable.exportObjectsConfirmModal.cancelButtonLabel",
        defaultMessage: "Cancel"
      }))), /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiButton, {
        fill: true,
        onClick: this.onExportAll
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "savedObjectsManagement.objectsTable.exportObjectsConfirmModal.exportAllButtonLabel",
        defaultMessage: "Export all"
      })))))))));
    }
  }, {
    key: "render",
    value: function render() {
      var _this4 = this;

      var _this$state6 = this.state,
          selectedSavedObjects = _this$state6.selectedSavedObjects,
          page = _this$state6.page,
          perPage = _this$state6.perPage,
          savedObjects = _this$state6.savedObjects,
          filteredItemCount = _this$state6.filteredItemCount,
          isSearching = _this$state6.isSearching,
          savedObjectCounts = _this$state6.savedObjectCounts;
      var _this$props5 = this.props,
          http = _this$props5.http,
          allowedTypes = _this$props5.allowedTypes,
          applications = _this$props5.applications;
      var selectionConfig = {
        onSelectionChange: this.onSelectionChanged
      };
      var filterOptions = allowedTypes.map(function (type) {
        return {
          value: type,
          name: type,
          view: "".concat(type, " (").concat(savedObjectCounts[type] || 0, ")")
        };
      });
      return /*#__PURE__*/React.createElement(EuiPageContent, {
        horizontalPosition: "center"
      }, this.renderFlyout(), this.renderRelationships(), this.renderDeleteConfirmModal(), this.renderExportAllOptionsModal(), /*#__PURE__*/React.createElement(Header, {
        onExportAll: function onExportAll() {
          return _this4.setState({
            isShowingExportAllOptionsModal: true
          });
        },
        onImport: this.showImportFlyout,
        onRefresh: this.refreshData,
        filteredCount: filteredItemCount
      }), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "xs"
      }), /*#__PURE__*/React.createElement(RedirectAppLinks, {
        application: applications
      }, /*#__PURE__*/React.createElement(Table, {
        basePath: http.basePath,
        itemId: 'id',
        actionRegistry: this.props.actionRegistry,
        selectionConfig: selectionConfig,
        selectedSavedObjects: selectedSavedObjects,
        onQueryChange: this.onQueryChange,
        onTableChange: this.onTableChange,
        filterOptions: filterOptions,
        onExport: this.onExport,
        canDelete: applications.capabilities.savedObjectsManagement.delete,
        onDelete: this.onDelete,
        goInspectObject: this.props.goInspectObject,
        pageIndex: page,
        pageSize: perPage,
        items: savedObjects,
        totalItemCount: filteredItemCount,
        isSearching: isSearching,
        onShowRelationships: this.onShowRelationships,
        canGoInApp: this.props.canGoInApp
      })));
    }
  }]);

  return SavedObjectsTable;
}(Component);