function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import * as Rx from 'rxjs';
import { catchError, takeUntil } from 'rxjs/operators';
import ReactDOM from 'react-dom';
import React from 'react';
import moment from 'moment';
import { I18nProvider } from '@kbn/i18n/react';
import { NewsfeedNavButton } from './components/newsfeed_header_nav_button';
import { getApi } from './lib/api';
export var NewsfeedPublicPlugin = /*#__PURE__*/function () {
  function NewsfeedPublicPlugin(initializerContext) {
    _classCallCheck(this, NewsfeedPublicPlugin);

    _defineProperty(this, "kibanaVersion", void 0);

    _defineProperty(this, "config", void 0);

    _defineProperty(this, "stop$", new Rx.ReplaySubject(1));

    this.kibanaVersion = initializerContext.env.packageInfo.version;
    var config = initializerContext.config.get();
    this.config = Object.freeze(_objectSpread(_objectSpread({}, config), {}, {
      // We need wrap them in moment.duration because exposeToBrowser stringifies it.
      mainInterval: moment.duration(config.mainInterval),
      fetchInterval: moment.duration(config.fetchInterval)
    }));
  }

  _createClass(NewsfeedPublicPlugin, [{
    key: "setup",
    value: function setup(core) {
      return {};
    }
  }, {
    key: "start",
    value: function start(core) {
      var _this = this;

      var api$ = this.fetchNewsfeed(core);
      core.chrome.navControls.registerRight({
        order: 1000,
        mount: function mount(target) {
          return _this.mount(api$, target);
        }
      });
      return {};
    }
  }, {
    key: "stop",
    value: function stop() {
      this.stop$.next();
    }
  }, {
    key: "fetchNewsfeed",
    value: function fetchNewsfeed(core) {
      var http = core.http;
      return getApi(http, this.config, this.kibanaVersion).pipe(takeUntil(this.stop$), // stop the interval when stop method is called
      catchError(function () {
        return Rx.of(null);
      }) // do not throw error
      );
    }
  }, {
    key: "mount",
    value: function mount(api$, targetDomElement) {
      ReactDOM.render( /*#__PURE__*/React.createElement(I18nProvider, null, /*#__PURE__*/React.createElement(NewsfeedNavButton, {
        apiFetchResult: api$
      })), targetDomElement);
      return function () {
        return ReactDOM.unmountComponentAtNode(targetDomElement);
      };
    }
  }]);

  return NewsfeedPublicPlugin;
}();