function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useState } from 'react';
import { i18n } from '@kbn/i18n';
import { sortBy } from 'lodash';
import { EuiIcon, EuiSideNav, EuiScreenReaderOnly, EuiFlexGroup, EuiFlexItem, EuiToolTip } from '@elastic/eui';
import './management_sidebar_nav.scss';
import { reactRouterNavigate } from '../../../../kibana_react/public';
var headerLabel = i18n.translate('management.nav.label', {
  defaultMessage: 'Management'
});
var navMenuLabel = i18n.translate('management.nav.menu', {
  defaultMessage: 'Management menu'
});
/** @internal **/

export var ManagementSidebarNav = function ManagementSidebarNav(_ref) {
  var selectedId = _ref.selectedId,
      sections = _ref.sections,
      history = _ref.history;
  var HEADER_ID = 'stack-management-nav-header';

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isSideNavOpenOnMobile = _useState2[0],
      setIsSideNavOpenOnMobile = _useState2[1];

  var toggleOpenOnMobile = function toggleOpenOnMobile() {
    return setIsSideNavOpenOnMobile(!isSideNavOpenOnMobile);
  };

  var sectionsToNavItems = function sectionsToNavItems(managementSections) {
    var sortedManagementSections = sortBy(managementSections, 'order');
    return sortedManagementSections.reduce(function (acc, section) {
      var apps = sortBy(section.getAppsEnabled(), 'order');

      if (apps.length) {
        acc.push(_objectSpread({}, createNavItem(section, {
          items: appsToNavItems(apps)
        })));
      }

      return acc;
    }, []);
  };

  var appsToNavItems = function appsToNavItems(managementApps) {
    return managementApps.map(function (app) {
      return _objectSpread({}, createNavItem(app, _objectSpread({}, reactRouterNavigate(history, app.basePath))));
    });
  };

  var TooltipWrapper = function TooltipWrapper(_ref2) {
    var text = _ref2.text,
        tip = _ref2.tip;
    return /*#__PURE__*/React.createElement(EuiToolTip, {
      content: tip,
      position: "right"
    }, /*#__PURE__*/React.createElement(EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false
    }, /*#__PURE__*/React.createElement(EuiFlexItem, {
      grow: false
    }, text), /*#__PURE__*/React.createElement(EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/React.createElement(EuiIcon, {
      type: "questionInCircle"
    }))));
  };

  var createNavItem = function createNavItem(item) {
    var customParams = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var iconType = item.euiIconType || item.icon;
    return _objectSpread({
      id: item.id,
      name: item.tip ? /*#__PURE__*/React.createElement(TooltipWrapper, {
        text: item.title,
        tip: item.tip
      }) : item.title,
      isSelected: item.id === selectedId,
      icon: iconType ? /*#__PURE__*/React.createElement(EuiIcon, {
        type: iconType,
        size: "m"
      }) : undefined,
      'data-test-subj': item.id
    }, customParams);
  };

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiScreenReaderOnly, null, /*#__PURE__*/React.createElement("h2", {
    id: HEADER_ID
  }, headerLabel)), /*#__PURE__*/React.createElement(EuiSideNav, {
    "aria-labelledby": HEADER_ID,
    mobileTitle: navMenuLabel,
    toggleOpenOnMobile: toggleOpenOnMobile,
    isOpenOnMobile: isSideNavOpenOnMobile,
    items: sectionsToNavItems(sections),
    className: "mgtSideBarNav"
  }));
};