/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import { ManagementSectionId } from '../types';
var ingestTitle = i18n.translate('management.sections.ingestTitle', {
  defaultMessage: 'Ingest'
});
var ingestTip = i18n.translate('management.sections.ingestTip', {
  defaultMessage: 'Manage how to transform data and load it into the cluster'
});
var dataTitle = i18n.translate('management.sections.dataTitle', {
  defaultMessage: 'Data'
});
var dataTip = i18n.translate('management.sections.dataTip', {
  defaultMessage: 'Manage your cluster data and backups'
});
var insightsAndAlertingTitle = i18n.translate('management.sections.insightsAndAlertingTitle', {
  defaultMessage: 'Alerts and Insights'
});
var insightsAndAlertingTip = i18n.translate('management.sections.insightsAndAlertingTip', {
  defaultMessage: 'Manage how to detect changes in your data'
});
var sectionTitle = i18n.translate('management.sections.section.title', {
  defaultMessage: 'Security'
});
var sectionTip = i18n.translate('management.sections.section.tip', {
  defaultMessage: 'Control access to features and data'
});
var kibanaTitle = i18n.translate('management.sections.kibanaTitle', {
  defaultMessage: 'Kibana'
});
var kibanaTip = i18n.translate('management.sections.kibanaTip', {
  defaultMessage: 'Customize Kibana and manage saved objects'
});
var stackTitle = i18n.translate('management.sections.stackTitle', {
  defaultMessage: 'Stack'
});
var stackTip = i18n.translate('management.sections.stackTip', {
  defaultMessage: 'Manage your license and upgrade the Stack'
});
export var IngestSection = {
  id: ManagementSectionId.Ingest,
  title: ingestTitle,
  tip: ingestTip,
  order: 0
};
export var DataSection = {
  id: ManagementSectionId.Data,
  title: dataTitle,
  tip: dataTip,
  order: 1
};
export var InsightsAndAlertingSection = {
  id: ManagementSectionId.InsightsAndAlerting,
  title: insightsAndAlertingTitle,
  tip: insightsAndAlertingTip,
  order: 2
};
export var SecuritySection = {
  id: 'security',
  title: sectionTitle,
  tip: sectionTip,
  order: 3
};
export var KibanaSection = {
  id: ManagementSectionId.Kibana,
  title: kibanaTitle,
  tip: kibanaTip,
  order: 4
};
export var StackSection = {
  id: ManagementSectionId.Stack,
  title: stackTitle,
  tip: stackTip,
  order: 4
};
export var managementSections = [IngestSection, DataSection, InsightsAndAlertingSection, SecuritySection, KibanaSection, StackSection];