function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Children, useRef, useState, useCallback, useEffect } from 'react';
import { keys } from '@elastic/eui';
import { PanelContextProvider } from '../context';
import { Resizer } from '../components/resizer';
import { PanelRegistry } from '../registry';
var initialState = {
  isDragging: false,
  currentResizerPos: -1
};

var pxToPercent = function pxToPercent(proportion, whole) {
  return proportion / whole * 100;
};

export function PanelsContainer(_ref) {
  var children = _ref.children,
      className = _ref.className,
      onPanelWidthChange = _ref.onPanelWidthChange,
      resizerClassName = _ref.resizerClassName;
  var childrenArray = Children.toArray(children);

  var _childrenArray = _slicedToArray(childrenArray, 2),
      firstChild = _childrenArray[0],
      secondChild = _childrenArray[1];

  var registryRef = useRef(new PanelRegistry());
  var containerRef = useRef(null);

  var _useState = useState(initialState),
      _useState2 = _slicedToArray(_useState, 2),
      state = _useState2[0],
      setState = _useState2[1];

  var getContainerWidth = function getContainerWidth() {
    return containerRef.current.getBoundingClientRect().width;
  };

  var handleMouseDown = useCallback(function (event) {
    setState(_objectSpread(_objectSpread({}, state), {}, {
      isDragging: true,
      currentResizerPos: event.clientX
    }));
  }, [state]);
  var handleKeyDown = useCallback(function (ev) {
    var key = ev.key;

    if (key === keys.ARROW_LEFT || key === keys.ARROW_RIGHT) {
      ev.preventDefault();
      var registry = registryRef.current;

      var _registry$getPanels = registry.getPanels(),
          _registry$getPanels2 = _slicedToArray(_registry$getPanels, 2),
          left = _registry$getPanels2[0],
          right = _registry$getPanels2[1];

      var leftPercent = left.width - (key === keys.ARROW_LEFT ? 1 : -1);
      var rightPercent = right.width - (key === keys.ARROW_RIGHT ? 1 : -1);
      left.setWidth(leftPercent);
      right.setWidth(rightPercent);

      if (onPanelWidthChange) {
        onPanelWidthChange([leftPercent, rightPercent]);
      }
    }
  }, [onPanelWidthChange]);
  useEffect(function () {
    if (process.env.NODE_ENV !== 'production') {
      // For now we only support bi-split
      if (childrenArray.length > 2) {
        // eslint-disable-next-line no-console
        console.warn('[Split Panels Container] Detected more than two children; ignoring additional children.');
      }
    }
  }, [childrenArray.length]);
  var childrenWithResizer = [firstChild, /*#__PURE__*/React.createElement(Resizer, {
    key: 'resizer',
    className: resizerClassName,
    onKeyDown: handleKeyDown,
    onMouseDown: handleMouseDown
  }), secondChild];
  return /*#__PURE__*/React.createElement(PanelContextProvider, {
    registry: registryRef.current
  }, /*#__PURE__*/React.createElement("div", {
    className: className,
    ref: containerRef,
    style: {
      display: 'flex',
      height: '100%',
      width: '100%'
    },
    onMouseMove: function onMouseMove(event) {
      if (state.isDragging) {
        var x = event.clientX;
        var registry = registryRef.current;

        var _registry$getPanels3 = registry.getPanels(),
            _registry$getPanels4 = _slicedToArray(_registry$getPanels3, 2),
            left = _registry$getPanels4[0],
            right = _registry$getPanels4[1];

        var delta = x - state.currentResizerPos;
        var containerWidth = getContainerWidth();
        var leftPercent = pxToPercent(left.getWidth() + delta, containerWidth);
        var rightPercent = pxToPercent(right.getWidth() - delta, containerWidth);
        left.setWidth(leftPercent);
        right.setWidth(rightPercent);

        if (onPanelWidthChange) {
          onPanelWidthChange([leftPercent, rightPercent]);
        }

        setState(_objectSpread(_objectSpread({}, state), {}, {
          currentResizerPos: x
        }));
      }
    },
    onMouseUp: function onMouseUp() {
      setState(initialState);
    }
  }, childrenWithResizer));
}