function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import { EuiCallOut, EuiFlexGroup, EuiFlexItem, EuiTitle, EuiSpacer, EuiLoadingSpinner, EuiHorizontalRule } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { ensureMinimumTime, extractTimeFields } from '../../lib';
import { Header } from './components/header';
import { TimeField } from './components/time_field';
import { AdvancedOptions } from './components/advanced_options';
import { ActionButtons } from './components/action_buttons';
import { context } from '../../../../../../kibana_react/public';
export var StepTimeField = /*#__PURE__*/function (_Component) {
  _inherits(StepTimeField, _Component);

  var _super = _createSuper(StepTimeField);

  function StepTimeField(props) {
    var _this;

    _classCallCheck(this, StepTimeField);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "context", void 0);

    _defineProperty(_assertThisInitialized(_this), "state", {
      error: '',
      timeFields: [],
      selectedTimeField: undefined,
      timeFieldSet: false,
      isAdvancedOptionsVisible: false,
      isFetchingTimeFields: false,
      isCreating: false,
      indexPatternId: '',
      indexPatternType: '',
      indexPatternName: ''
    });

    _defineProperty(_assertThisInitialized(_this), "mounted", false);

    _defineProperty(_assertThisInitialized(_this), "fetchTimeFields", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      var pattern, getFetchForWildcardOptions, indexPattern, fields, timeFields;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              pattern = _this.props.indexPattern;
              getFetchForWildcardOptions = _this.props.indexPatternCreationType.getFetchForWildcardOptions;
              _context.next = 4;
              return _this.context.services.data.indexPatterns.make();

            case 4:
              indexPattern = _context.sent;
              indexPattern.title = pattern;

              _this.setState({
                isFetchingTimeFields: true
              });

              _context.next = 9;
              return ensureMinimumTime(indexPattern.fieldsFetcher.fetchForWildcard(pattern, getFetchForWildcardOptions()));

            case 9:
              fields = _context.sent;
              timeFields = extractTimeFields(fields);

              _this.setState({
                timeFields: timeFields,
                isFetchingTimeFields: false
              });

            case 12:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));

    _defineProperty(_assertThisInitialized(_this), "onTimeFieldChanged", function (e) {
      var value = e.target.value; // Find the time field based on the selected value

      var timeField = _this.state.timeFields.find(function (timeFld) {
        return timeFld.fieldName === value;
      }); // If the value is an empty string, it's not a valid selection


      var validSelection = value !== '';

      _this.setState({
        selectedTimeField: timeField ? timeField.fieldName : undefined,
        timeFieldSet: validSelection
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onChangeIndexPatternId", function (e) {
      _this.setState({
        indexPatternId: e.target.value
      });
    });

    _defineProperty(_assertThisInitialized(_this), "toggleAdvancedOptions", function () {
      _this.setState(function (state) {
        return {
          isAdvancedOptionsVisible: !state.isAdvancedOptionsVisible
        };
      });
    });

    _defineProperty(_assertThisInitialized(_this), "createIndexPattern", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
      var createIndexPattern, _this$state, selectedTimeField, indexPatternId;

      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              createIndexPattern = _this.props.createIndexPattern;
              _this$state = _this.state, selectedTimeField = _this$state.selectedTimeField, indexPatternId = _this$state.indexPatternId;

              _this.setState({
                isCreating: true
              });

              _context2.prev = 3;
              _context2.next = 6;
              return createIndexPattern(selectedTimeField, indexPatternId);

            case 6:
              _context2.next = 13;
              break;

            case 8:
              _context2.prev = 8;
              _context2.t0 = _context2["catch"](3);

              if (_this.mounted) {
                _context2.next = 12;
                break;
              }

              return _context2.abrupt("return");

            case 12:
              _this.setState({
                error: _context2.t0 instanceof Error ? _context2.t0.message : String(_context2.t0),
                isCreating: false
              });

            case 13:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2, null, [[3, 8]]);
    })));

    _this.state.indexPatternType = props.indexPatternCreationType.getIndexPatternType() || '';
    _this.state.indexPatternName = props.indexPatternCreationType.getIndexPatternName();
    _this.state.selectedTimeField = props.selectedTimeField;

    if (props.selectedTimeField) {
      _this.state.timeFieldSet = true;
    }

    return _this;
  }

  _createClass(StepTimeField, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.mounted = true;
      this.fetchTimeFields();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.mounted = false;
    }
  }, {
    key: "formatErrorMessage",
    value: function formatErrorMessage(message) {
      // `createIndexPattern` throws "Conflict" when index pattern ID already exists.
      return message === 'Conflict' ? /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.createIndexPattern.stepTime.patterAlreadyExists",
        defaultMessage: "Custom index pattern ID already exists."
      }) : message;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$state2 = this.state,
          timeFields = _this$state2.timeFields,
          selectedTimeField = _this$state2.selectedTimeField,
          timeFieldSet = _this$state2.timeFieldSet,
          isAdvancedOptionsVisible = _this$state2.isAdvancedOptionsVisible,
          indexPatternId = _this$state2.indexPatternId,
          isCreating = _this$state2.isCreating,
          isFetchingTimeFields = _this$state2.isFetchingTimeFields,
          indexPatternName = _this$state2.indexPatternName;

      if (isCreating) {
        return /*#__PURE__*/React.createElement(EuiFlexGroup, {
          justifyContent: "center",
          alignItems: "center",
          direction: "column",
          gutterSize: "s"
        }, /*#__PURE__*/React.createElement(EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/React.createElement(EuiTitle, {
          size: "s"
        }, /*#__PURE__*/React.createElement("h3", {
          className: "eui-textCenter"
        }, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.createIndexPattern.stepTime.creatingLabel",
          defaultMessage: "Creating index pattern\u2026"
        })))), /*#__PURE__*/React.createElement(EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/React.createElement(EuiLoadingSpinner, {
          size: "l"
        })));
      }

      var _this$props = this.props,
          indexPattern = _this$props.indexPattern,
          goToPreviousStep = _this$props.goToPreviousStep;
      var timeFieldOptions = timeFields.length > 0 ? [{
        text: '',
        value: ''
      }].concat(_toConsumableArray(timeFields.map(function (timeField) {
        return {
          text: timeField.display,
          value: timeField.fieldName,
          disabled: timeFields.isDisabled
        };
      }))) : [];
      var showTimeField = !timeFields || timeFields.length > 1;
      var submittable = !showTimeField || timeFieldSet;
      var error = this.state.error ? /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiCallOut, {
        title: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.createIndexPattern.stepTime.error",
          defaultMessage: "Error"
        }),
        color: "danger",
        iconType: "cross"
      }, /*#__PURE__*/React.createElement("p", null, this.formatErrorMessage(this.state.error))), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "m"
      })) : null;
      return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Header, {
        indexPattern: indexPattern,
        indexPatternName: indexPatternName
      }), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/React.createElement(TimeField, {
        isVisible: showTimeField,
        fetchTimeFields: this.fetchTimeFields,
        timeFieldOptions: timeFieldOptions,
        isLoading: isFetchingTimeFields,
        selectedTimeField: selectedTimeField,
        onTimeFieldChanged: this.onTimeFieldChanged
      }), /*#__PURE__*/React.createElement(EuiHorizontalRule, null), /*#__PURE__*/React.createElement(AdvancedOptions, {
        isVisible: isAdvancedOptionsVisible,
        indexPatternId: indexPatternId,
        toggleAdvancedOptions: this.toggleAdvancedOptions,
        onChangeIndexPatternId: this.onChangeIndexPatternId
      }), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "m"
      }), error, /*#__PURE__*/React.createElement(ActionButtons, {
        goToPreviousStep: goToPreviousStep,
        submittable: submittable,
        createIndexPattern: this.createIndexPattern
      }));
    }
  }]);

  return StepTimeField;
}(Component);

_defineProperty(StepTimeField, "contextType", context);