function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import { METRIC_TYPES } from '../';
import { getParsedValue } from '../utils/get_parsed_value';
var fnName = 'aggBucketMin';
export var aggBucketMin = function aggBucketMin() {
  return {
    name: fnName,
    help: i18n.translate('data.search.aggs.function.metrics.bucket_min.help', {
      defaultMessage: 'Generates a serialized agg config for a Min Bucket agg'
    }),
    type: 'agg_type',
    args: {
      id: {
        types: ['string'],
        help: i18n.translate('data.search.aggs.metrics.bucket_min.id.help', {
          defaultMessage: 'ID for this aggregation'
        })
      },
      enabled: {
        types: ['boolean'],
        default: true,
        help: i18n.translate('data.search.aggs.metrics.bucket_min.enabled.help', {
          defaultMessage: 'Specifies whether this aggregation should be enabled'
        })
      },
      schema: {
        types: ['string'],
        help: i18n.translate('data.search.aggs.metrics.bucket_min.schema.help', {
          defaultMessage: 'Schema to use for this aggregation'
        })
      },
      customBucket: {
        types: ['agg_type'],
        help: i18n.translate('data.search.aggs.metrics.bucket_min.customBucket.help', {
          defaultMessage: 'Agg config to use for building sibling pipeline aggregations'
        })
      },
      customMetric: {
        types: ['agg_type'],
        help: i18n.translate('data.search.aggs.metrics.bucket_min.customMetric.help', {
          defaultMessage: 'Agg config to use for building sibling pipeline aggregations'
        })
      },
      json: {
        types: ['string'],
        help: i18n.translate('data.search.aggs.metrics.bucket_min.json.help', {
          defaultMessage: 'Advanced json to include when the agg is sent to Elasticsearch'
        })
      },
      customLabel: {
        types: ['string'],
        help: i18n.translate('data.search.aggs.metrics.bucket_min.customLabel.help', {
          defaultMessage: 'Represents a custom label for this aggregation'
        })
      }
    },
    fn: function fn(input, args) {
      var _args$customBucket, _args$customMetric;

      var id = args.id,
          enabled = args.enabled,
          schema = args.schema,
          rest = _objectWithoutProperties(args, ["id", "enabled", "schema"]);

      return {
        type: 'agg_type',
        value: {
          id: id,
          enabled: enabled,
          schema: schema,
          type: METRIC_TYPES.MIN_BUCKET,
          params: _objectSpread(_objectSpread({}, rest), {}, {
            customBucket: (_args$customBucket = args.customBucket) === null || _args$customBucket === void 0 ? void 0 : _args$customBucket.value,
            customMetric: (_args$customMetric = args.customMetric) === null || _args$customMetric === void 0 ? void 0 : _args$customMetric.value,
            json: getParsedValue(args, 'json')
          })
        }
      };
    }
  };
};