function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import _ from 'lodash';
import { Subject, BehaviorSubject } from 'rxjs';
import moment from 'moment';
import { areRefreshIntervalsDifferent, areTimeRangesDifferent } from './lib/diff_time_picker_vals';
import { getForceNow } from './lib/get_force_now';
import { calculateBounds as _calculateBounds, getTime } from '../../../common';
// TODO: remove!
export var Timefilter = /*#__PURE__*/function () {
  // Fired when isTimeRangeSelectorEnabled \ isAutoRefreshSelectorEnabled are toggled
  // Fired when a user changes the timerange
  // Fired when a user changes the the autorefresh settings
  // Used when an auto refresh is triggered
  function Timefilter(config, timeHistory) {
    var _this = this;

    _classCallCheck(this, Timefilter);

    _defineProperty(this, "enabledUpdated$", new BehaviorSubject(false));

    _defineProperty(this, "timeUpdate$", new Subject());

    _defineProperty(this, "refreshIntervalUpdate$", new Subject());

    _defineProperty(this, "autoRefreshFetch$", new Subject());

    _defineProperty(this, "fetch$", new Subject());

    _defineProperty(this, "_time", void 0);

    _defineProperty(this, "_refreshInterval", void 0);

    _defineProperty(this, "_history", void 0);

    _defineProperty(this, "_isTimeRangeSelectorEnabled", false);

    _defineProperty(this, "_isAutoRefreshSelectorEnabled", false);

    _defineProperty(this, "_autoRefreshIntervalId", 0);

    _defineProperty(this, "timeDefaults", void 0);

    _defineProperty(this, "refreshIntervalDefaults", void 0);

    _defineProperty(this, "getEnabledUpdated$", function () {
      return _this.enabledUpdated$.asObservable();
    });

    _defineProperty(this, "getTimeUpdate$", function () {
      return _this.timeUpdate$.asObservable();
    });

    _defineProperty(this, "getRefreshIntervalUpdate$", function () {
      return _this.refreshIntervalUpdate$.asObservable();
    });

    _defineProperty(this, "getAutoRefreshFetch$", function () {
      return _this.autoRefreshFetch$.asObservable();
    });

    _defineProperty(this, "getFetch$", function () {
      return _this.fetch$.asObservable();
    });

    _defineProperty(this, "getTime", function () {
      var _this$_time = _this._time,
          from = _this$_time.from,
          to = _this$_time.to;
      return _objectSpread(_objectSpread({}, _this._time), {}, {
        from: moment.isMoment(from) ? from.toISOString() : from,
        to: moment.isMoment(to) ? to.toISOString() : to
      });
    });

    _defineProperty(this, "setTime", function (time) {
      // Object.assign used for partially composed updates
      var newTime = Object.assign(_this.getTime(), time);

      if (areTimeRangesDifferent(_this.getTime(), newTime)) {
        _this._time = {
          from: newTime.from,
          to: newTime.to
        };

        _this._history.add(_this._time);

        _this.timeUpdate$.next();

        _this.fetch$.next();
      }
    });

    _defineProperty(this, "getRefreshInterval", function () {
      return _.clone(_this._refreshInterval);
    });

    _defineProperty(this, "setRefreshInterval", function (refreshInterval) {
      var prevRefreshInterval = _this.getRefreshInterval();

      var newRefreshInterval = _objectSpread(_objectSpread({}, prevRefreshInterval), refreshInterval); // If the refresh interval is <= 0 handle that as a paused refresh


      if (newRefreshInterval.value <= 0) {
        newRefreshInterval.value = 0;
        newRefreshInterval.pause = true;
      }

      _this._refreshInterval = {
        value: newRefreshInterval.value,
        pause: newRefreshInterval.pause
      }; // Only send out an event if we already had a previous refresh interval (not for the initial set)
      // and the old and new refresh interval are actually different.

      if (prevRefreshInterval && areRefreshIntervalsDifferent(prevRefreshInterval, newRefreshInterval)) {
        _this.refreshIntervalUpdate$.next();

        if (!newRefreshInterval.pause && newRefreshInterval.value !== 0) {
          _this.fetch$.next();
        }
      } // Clear the previous auto refresh interval and start a new one (if not paused)


      clearInterval(_this._autoRefreshIntervalId);

      if (!newRefreshInterval.pause) {
        _this._autoRefreshIntervalId = window.setInterval(function () {
          return _this.autoRefreshFetch$.next();
        }, newRefreshInterval.value);
      }
    });

    _defineProperty(this, "createFilter", function (indexPattern, timeRange) {
      return getTime(indexPattern, timeRange ? timeRange : _this._time, {
        forceNow: _this.getForceNow()
      });
    });

    _defineProperty(this, "enableTimeRangeSelector", function () {
      _this._isTimeRangeSelectorEnabled = true;

      _this.enabledUpdated$.next(true);
    });

    _defineProperty(this, "disableTimeRangeSelector", function () {
      _this._isTimeRangeSelectorEnabled = false;

      _this.enabledUpdated$.next(false);
    });

    _defineProperty(this, "enableAutoRefreshSelector", function () {
      _this._isAutoRefreshSelectorEnabled = true;

      _this.enabledUpdated$.next(true);
    });

    _defineProperty(this, "disableAutoRefreshSelector", function () {
      _this._isAutoRefreshSelectorEnabled = false;

      _this.enabledUpdated$.next(false);
    });

    _defineProperty(this, "getForceNow", function () {
      return getForceNow();
    });

    this._history = timeHistory;
    this.timeDefaults = config.timeDefaults;
    this.refreshIntervalDefaults = config.refreshIntervalDefaults;
    this._time = config.timeDefaults;
    this.setRefreshInterval(config.refreshIntervalDefaults);
  }

  _createClass(Timefilter, [{
    key: "isTimeRangeSelectorEnabled",
    value: function isTimeRangeSelectorEnabled() {
      return this._isTimeRangeSelectorEnabled;
    }
  }, {
    key: "isAutoRefreshSelectorEnabled",
    value: function isAutoRefreshSelectorEnabled() {
      return this._isAutoRefreshSelectorEnabled;
    }
  }, {
    key: "getBounds",
    value: function getBounds() {
      return this.calculateBounds(this._time);
    }
  }, {
    key: "calculateBounds",
    value: function calculateBounds(timeRange) {
      return _calculateBounds(timeRange, {
        forceNow: this.getForceNow()
      });
    }
  }, {
    key: "getActiveBounds",
    value: function getActiveBounds() {
      if (this.isTimeRangeSelectorEnabled()) {
        return this.getBounds();
      }
    }
    /**
     * Show the time bounds selector part of the time filter
     */

  }, {
    key: "getTimeDefaults",
    value: function getTimeDefaults() {
      return _.cloneDeep(this.timeDefaults);
    }
  }, {
    key: "getRefreshIntervalDefaults",
    value: function getRefreshIntervalDefaults() {
      return _.cloneDeep(this.refreshIntervalDefaults);
    }
  }]);

  return Timefilter;
}();