/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * Filters:
 */
import { buildEmptyFilter, buildExistsFilter, buildPhraseFilter, buildPhrasesFilter, buildQueryFilter, buildRangeFilter, disableFilter, FILTERS, FilterStateStore, getDisplayValueFromFilter, getPhraseFilterField, getPhraseFilterValue, isExistsFilter, isFilterPinned, isMatchAllFilter, isMissingFilter, isPhraseFilter, isPhrasesFilter, isQueryStringFilter, isRangeFilter, toggleFilterNegated, compareFilters, COMPARE_ALL_OPTIONS } from '../common';
import { FilterLabel } from './ui/filter_bar';
import { generateFilters, onlyDisabledFiltersChanged, changeTimeFilter, mapAndFlattenFilters, extractTimeFilter, convertRangeFilterToTimeRangeString } from './query'; // Filter helpers namespace:

export var esFilters = {
  FilterLabel: FilterLabel,
  FILTERS: FILTERS,
  FilterStateStore: FilterStateStore,
  buildEmptyFilter: buildEmptyFilter,
  buildPhrasesFilter: buildPhrasesFilter,
  buildExistsFilter: buildExistsFilter,
  buildPhraseFilter: buildPhraseFilter,
  buildQueryFilter: buildQueryFilter,
  buildRangeFilter: buildRangeFilter,
  isPhraseFilter: isPhraseFilter,
  isExistsFilter: isExistsFilter,
  isPhrasesFilter: isPhrasesFilter,
  isRangeFilter: isRangeFilter,
  isMatchAllFilter: isMatchAllFilter,
  isMissingFilter: isMissingFilter,
  isQueryStringFilter: isQueryStringFilter,
  isFilterPinned: isFilterPinned,
  toggleFilterNegated: toggleFilterNegated,
  disableFilter: disableFilter,
  getPhraseFilterField: getPhraseFilterField,
  getPhraseFilterValue: getPhraseFilterValue,
  getDisplayValueFromFilter: getDisplayValueFromFilter,
  compareFilters: compareFilters,
  COMPARE_ALL_OPTIONS: COMPARE_ALL_OPTIONS,
  generateFilters: generateFilters,
  onlyDisabledFiltersChanged: onlyDisabledFiltersChanged,
  changeTimeFilter: changeTimeFilter,
  convertRangeFilterToTimeRangeString: convertRangeFilterToTimeRangeString,
  mapAndFlattenFilters: mapAndFlattenFilters,
  extractTimeFilter: extractTimeFilter
};
export { RangeFilter, RangeFilterMeta, RangeFilterParams, ExistsFilter, PhrasesFilter, PhraseFilter, CustomFilter, MatchAllFilter } from '../common';
/*
 * esQuery and esKuery:
 */

import { fromKueryExpression, toElasticsearchQuery, nodeTypes, buildEsQuery, getEsQueryConfig, buildQueryFromFilters, luceneStringToDsl, decorateQuery } from '../common';
export var esKuery = {
  nodeTypes: nodeTypes,
  fromKueryExpression: fromKueryExpression,
  toElasticsearchQuery: toElasticsearchQuery
};
export var esQuery = {
  buildEsQuery: buildEsQuery,
  getEsQueryConfig: getEsQueryConfig,
  buildQueryFromFilters: buildQueryFromFilters,
  luceneStringToDsl: luceneStringToDsl,
  decorateQuery: decorateQuery
};
export { EsQueryConfig, KueryNode } from '../common';
/*
 * Field Formatters:
 */

import { FieldFormat, FieldFormatsRegistry, DEFAULT_CONVERTER_COLOR, HTML_CONTEXT_TYPE, TEXT_CONTEXT_TYPE, FIELD_FORMAT_IDS, BoolFormat, BytesFormat, ColorFormat, DurationFormat, IpFormat, NumberFormat, PercentFormat, RelativeDateFormat, SourceFormat, StaticLookupFormat, UrlFormat, StringFormat, TruncateFormat } from '../common/field_formats';
import { DateNanosFormat, DateFormat } from './field_formats';
export { baseFormattersPublic } from './field_formats'; // Field formats helpers namespace:

export var fieldFormats = {
  FieldFormat: FieldFormat,
  FieldFormatsRegistry: FieldFormatsRegistry,
  // exported only for tests. Consider mock.
  DEFAULT_CONVERTER_COLOR: DEFAULT_CONVERTER_COLOR,
  HTML_CONTEXT_TYPE: HTML_CONTEXT_TYPE,
  TEXT_CONTEXT_TYPE: TEXT_CONTEXT_TYPE,
  FIELD_FORMAT_IDS: FIELD_FORMAT_IDS,
  BoolFormat: BoolFormat,
  BytesFormat: BytesFormat,
  ColorFormat: ColorFormat,
  DateFormat: DateFormat,
  DateNanosFormat: DateNanosFormat,
  DurationFormat: DurationFormat,
  IpFormat: IpFormat,
  NumberFormat: NumberFormat,
  PercentFormat: PercentFormat,
  RelativeDateFormat: RelativeDateFormat,
  SourceFormat: SourceFormat,
  StaticLookupFormat: StaticLookupFormat,
  UrlFormat: UrlFormat,
  StringFormat: StringFormat,
  TruncateFormat: TruncateFormat
};
export { IFieldFormat, FieldFormatInstanceType, IFieldFormatsRegistry, FieldFormatsContentType, FieldFormatsGetConfigFn, FieldFormatConfig, FieldFormatId, FieldFormat } from '../common';
/*
 * Index patterns:
 */

import { isNestedField, isFilterable } from '../common';
import { ILLEGAL_CHARACTERS_KEY, CONTAINS_SPACES_KEY, ILLEGAL_CHARACTERS_VISIBLE, ILLEGAL_CHARACTERS, isDefault, validateIndexPattern, getFromSavedObject, flattenHitWrapper, formatHitProvider } from './index_patterns'; // Index patterns namespace:

export var indexPatterns = {
  ILLEGAL_CHARACTERS_KEY: ILLEGAL_CHARACTERS_KEY,
  CONTAINS_SPACES_KEY: CONTAINS_SPACES_KEY,
  ILLEGAL_CHARACTERS_VISIBLE: ILLEGAL_CHARACTERS_VISIBLE,
  ILLEGAL_CHARACTERS: ILLEGAL_CHARACTERS,
  isDefault: isDefault,
  isFilterable: isFilterable,
  isNestedField: isNestedField,
  validate: validateIndexPattern,
  getFromSavedObject: getFromSavedObject,
  flattenHitWrapper: flattenHitWrapper,
  formatHitProvider: formatHitProvider
};
export { IndexPatternsContract, IndexPattern, IIndexPatternFieldList, Field as IndexPatternField, getIndexPatternFieldListCreator } from './index_patterns';
export { IIndexPattern, IFieldType, IFieldSubType, ES_FIELD_TYPES, KBN_FIELD_TYPES, IndexPatternAttributes, UI_SETTINGS, TypeMeta as IndexPatternTypeMeta, AggregationRestrictions as IndexPatternAggRestrictions } from '../common';
/*
 * Autocomplete query suggestions:
 */

export { QuerySuggestion, QuerySuggestionTypes, QuerySuggestionGetFn, QuerySuggestionGetFnArgs, QuerySuggestionBasic, QuerySuggestionField } from './autocomplete';
/*
 * Search:
 */

import { // aggs
CidrMask, intervalOptions, isDateHistogramBucketAggConfig, isNumberType, isStringType, isType, parentPipelineType, propFilter, siblingPipelineType, termsAggFilter // expressions utils
, getRequestInspectorStats, getResponseInspectorStats // tabify
, tabifyAggResponse, tabifyGetColumns } from './search';
import { dateHistogramInterval, InvalidEsCalendarIntervalError, InvalidEsIntervalFormatError, Ipv4Address, isValidEsInterval, isValidInterval, parseEsInterval, parseInterval, toAbsoluteDates } from '../common';
export { EsaggsExpressionFunctionDefinition, ParsedInterval } from '../common';
export { // aggs
AggGroupLabels, AggGroupName, AggGroupNames, AggParam, AggParamOption, AggParamType, AggConfigOptions, BUCKET_TYPES, IAggConfig, IAggConfigs, IAggType, IFieldParamType, IMetricAggType, METRIC_TYPES, OptionedParamType, OptionedValueProp // search
, ES_SEARCH_STRATEGY, getEsPreference, getSearchErrorType, ISearch, ISearchOptions, ISearchGeneric, IEsSearchResponse, IEsSearchRequest, IKibanaSearchResponse, IKibanaSearchRequest, SearchRequest, SearchResponse, SearchError, ISearchSource, parseSearchSourceJSON, injectSearchSourceReferences, getSearchParamsFromRequest, extractSearchSourceReferences, SearchSourceFields, EsQuerySortValue, SortDirection, FetchOptions // tabify
, TabbedAggColumn, TabbedAggRow, TabbedTable, SearchInterceptor, SearchInterceptorDeps, RequestTimeoutError } from './search'; // Search namespace

export var search = {
  aggs: {
    CidrMask: CidrMask,
    dateHistogramInterval: dateHistogramInterval,
    intervalOptions: intervalOptions,
    InvalidEsCalendarIntervalError: InvalidEsCalendarIntervalError,
    InvalidEsIntervalFormatError: InvalidEsIntervalFormatError,
    Ipv4Address: Ipv4Address,
    isDateHistogramBucketAggConfig: isDateHistogramBucketAggConfig,
    // TODO: remove in build_pipeline refactor
    isNumberType: isNumberType,
    isStringType: isStringType,
    isType: isType,
    isValidEsInterval: isValidEsInterval,
    isValidInterval: isValidInterval,
    parentPipelineType: parentPipelineType,
    parseEsInterval: parseEsInterval,
    parseInterval: parseInterval,
    propFilter: propFilter,
    siblingPipelineType: siblingPipelineType,
    termsAggFilter: termsAggFilter,
    toAbsoluteDates: toAbsoluteDates
  },
  getRequestInspectorStats: getRequestInspectorStats,
  getResponseInspectorStats: getResponseInspectorStats,
  tabifyAggResponse: tabifyAggResponse,
  tabifyGetColumns: tabifyGetColumns
};
/*
 * UI components
 */

export { SearchBar, SearchBarProps, StatefulSearchBarProps, FilterBar, QueryStringInput, IndexPatternSelect } from './ui';
/**
 * Types to be shared externally
 * @public
 */

export { Filter, Query, RefreshInterval, TimeRange } from '../common';
export { createSavedQueryService, connectToQueryState, syncQueryStateWithUrl, QueryState, getDefaultQuery, FilterManager, SavedQuery, SavedQueryService, SavedQueryTimeFilter, InputTimeRange, TimeHistory, TimefilterContract, TimeHistoryContract } from './query';
export { getTime // kbn field types
, castEsToKbnFieldTypeName, getKbnTypeNames } from '../common';
export { isTimeRange, isQuery, isFilter, isFilters } from '../common';
export * from '../common/field_mapping';
/*
 * Plugin setup
 */

import { DataPublicPlugin } from './plugin';
export function plugin(initializerContext) {
  return new DataPublicPlugin(initializerContext);
}
export { DataPublicPluginSetup, DataPublicPluginStart, IDataPluginServices } from './types'; // Export plugin after all other imports

export { DataPublicPlugin as Plugin };