/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import useObservable from 'react-use/lib/useObservable';
import classNames from 'classnames';
export var AppWrapper = function AppWrapper(_ref) {
  var chromeVisible$ = _ref.chromeVisible$,
      children = _ref.children;
  var visible = useObservable(chromeVisible$);
  return /*#__PURE__*/React.createElement("div", {
    className: classNames('app-wrapper', {
      'hidden-chrome': !visible
    })
  }, children);
};
export var AppContainer = function AppContainer(_ref2) {
  var classes$ = _ref2.classes$,
      children = _ref2.children;
  var classes = useObservable(classes$);
  return /*#__PURE__*/React.createElement("div", {
    className: classNames('application', classes)
  }, children);
};