function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useState, useLayoutEffect } from 'react';
import ReactDOM from 'react-dom';
import { i18n } from '@kbn/i18n';
import { I18nProvider } from '@kbn/i18n/react';
import { EuiEmptyPrompt, EuiPage, EuiPageBody, EuiPageContent } from '@elastic/eui';
import { UrlOverflowUi } from './url_overflow_ui';

var ErrorPage = function ErrorPage(_ref) {
  var _title;

  var title = _ref.title,
      children = _ref.children;
  title = (_title = title) !== null && _title !== void 0 ? _title : i18n.translate('core.application.appRenderError.defaultTitle', {
    defaultMessage: 'Application error'
  });
  return /*#__PURE__*/React.createElement(EuiPage, {
    style: {
      minHeight: '100%'
    },
    "data-test-subj": "appRenderErrorPageContent"
  }, /*#__PURE__*/React.createElement(EuiPageBody, null, /*#__PURE__*/React.createElement(EuiPageContent, {
    verticalPosition: "center",
    horizontalPosition: "center"
  }, /*#__PURE__*/React.createElement(EuiEmptyPrompt, {
    iconType: "alert",
    iconColor: "danger",
    title: /*#__PURE__*/React.createElement("h2", null, title),
    body: children
  }))));
};

var ErrorApp = function ErrorApp(_ref2) {
  var basePath = _ref2.basePath,
      history = _ref2.history;

  var _useState = useState(history.location),
      _useState2 = _slicedToArray(_useState, 2),
      currentLocation = _useState2[0],
      setCurrentLocation = _useState2[1];

  useLayoutEffect(function () {
    return history.listen(function (location) {
      return setCurrentLocation(location);
    });
  }, [history]);
  var searchParams = new URLSearchParams(currentLocation.search);
  var errorType = searchParams.get('errorType');

  if (errorType === 'urlOverflow') {
    return /*#__PURE__*/React.createElement(ErrorPage, {
      title: i18n.translate('core.ui.errorUrlOverflow.errorTitle', {
        defaultMessage: "The URL for this object is too long, and we can't display it"
      })
    }, /*#__PURE__*/React.createElement(UrlOverflowUi, {
      basePath: basePath
    }));
  }

  return /*#__PURE__*/React.createElement(ErrorPage, null);
};

/**
 * Renders UI for displaying error messages.
 * @internal
 */
export var renderApp = function renderApp(_ref3, _ref4) {
  var element = _ref3.element,
      history = _ref3.history;
  var basePath = _ref4.basePath;
  ReactDOM.render( /*#__PURE__*/React.createElement(I18nProvider, null, /*#__PURE__*/React.createElement(ErrorApp, {
    history: history,
    basePath: basePath
  })), element);
  return function () {
    ReactDOM.unmountComponentAtNode(element);
  };
};