"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiToolTipPopover = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf3 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiToolTipPopover =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(EuiToolTipPopover, _Component);

  function EuiToolTipPopover() {
    var _getPrototypeOf2;

    var _this;

    (0, _classCallCheck2.default)(this, EuiToolTipPopover);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = (0, _possibleConstructorReturn2.default)(this, (_getPrototypeOf2 = (0, _getPrototypeOf3.default)(EuiToolTipPopover)).call.apply(_getPrototypeOf2, [this].concat(args)));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "popover", void 0);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "updateDimensions", function () {
      requestAnimationFrame(function () {
        // Because of this delay, sometimes `positionToolTip` becomes unavailable.
        if (_this.popover) {
          _this.props.positionToolTip();
        }
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setPopoverRef", function (ref) {
      _this.popover = ref;

      if (_this.props.popoverRef) {
        _this.props.popoverRef(ref);
      }
    });
    return _this;
  }

  (0, _createClass2.default)(EuiToolTipPopover, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      document.body.classList.add('euiBody-hasPortalContent');
      window.addEventListener('resize', this.updateDimensions);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      document.body.classList.remove('euiBody-hasPortalContent');
      window.removeEventListener('resize', this.updateDimensions);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          title = _this$props.title,
          className = _this$props.className,
          positionToolTip = _this$props.positionToolTip,
          popoverRef = _this$props.popoverRef,
          rest = (0, _objectWithoutProperties2.default)(_this$props, ["children", "title", "className", "positionToolTip", "popoverRef"]);
      var classes = (0, _classnames.default)('euiToolTipPopover', className);
      var optionalTitle;

      if (title) {
        optionalTitle = _react.default.createElement("div", {
          className: "euiToolTip__title"
        }, title);
      }

      return _react.default.createElement("div", (0, _extends2.default)({
        className: classes,
        ref: this.setPopoverRef
      }, rest), optionalTitle, children);
    }
  }]);
  return EuiToolTipPopover;
}(_react.Component);

exports.EuiToolTipPopover = EuiToolTipPopover;
EuiToolTipPopover.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  positionToolTip: _propTypes.default.func.isRequired,
  children: _propTypes.default.node,
  title: _propTypes.default.node,
  popoverRef: _propTypes.default.func
};
EuiToolTipPopover.__docgenInfo = {
  "description": "",
  "methods": [{
    "name": "updateDimensions",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "setPopoverRef",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "ref",
      "type": null
    }],
    "returns": null
  }],
  "displayName": "EuiToolTipPopover",
  "props": {
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "positionToolTip": {
      "type": {
        "name": "func"
      },
      "required": true,
      "description": ""
    },
    "children": {
      "type": {
        "name": "node"
      },
      "required": false,
      "description": ""
    },
    "title": {
      "type": {
        "name": "node"
      },
      "required": false,
      "description": ""
    },
    "popoverRef": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": ""
    }
  }
};