"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTourStep = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _beacon = require("../beacon");

var _button = require("../button");

var _flex = require("../flex");

var _i18n = require("../i18n");

var _popover = require("../popover");

var _title = require("../title");

var _tour_step_indicator = require("./tour_step_indicator");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var EuiTourStep = function EuiTourStep(_ref) {
  var _ref$anchorPosition = _ref.anchorPosition,
      anchorPosition = _ref$anchorPosition === void 0 ? 'leftUp' : _ref$anchorPosition,
      children = _ref.children,
      className = _ref.className,
      _ref$closePopover = _ref.closePopover,
      closePopover = _ref$closePopover === void 0 ? function () {} : _ref$closePopover,
      content = _ref.content,
      _ref$isStepOpen = _ref.isStepOpen,
      isStepOpen = _ref$isStepOpen === void 0 ? false : _ref$isStepOpen,
      _ref$minWidth = _ref.minWidth,
      minWidth = _ref$minWidth === void 0 ? true : _ref$minWidth,
      onFinish = _ref.onFinish,
      _ref$step = _ref.step,
      step = _ref$step === void 0 ? 1 : _ref$step,
      stepsTotal = _ref.stepsTotal,
      style = _ref.style,
      subtitle = _ref.subtitle,
      title = _ref.title,
      _ref$decoration = _ref.decoration,
      decoration = _ref$decoration === void 0 ? 'beacon' : _ref$decoration,
      footerAction = _ref.footerAction,
      rest = _objectWithoutProperties(_ref, ["anchorPosition", "children", "className", "closePopover", "content", "isStepOpen", "minWidth", "onFinish", "step", "stepsTotal", "style", "subtitle", "title", "decoration", "footerAction"]);

  if (step === 0) {
    console.warn('EuiTourStep `step` should 1-based indexing. Please update to eliminate 0 indexes.');
  }

  var newStyle;
  var widthClassName;

  if (minWidth === true) {
    widthClassName = 'euiTour--minWidth-default';
  } else if (minWidth !== false) {
    var value = typeof minWidth === 'number' ? "".concat(minWidth, "px") : minWidth;
    newStyle = _objectSpread({}, style, {
      minWidth: value
    });
  }

  var classes = (0, _classnames.default)('euiTour', widthClassName, className);
  var finishButtonProps = {
    color: 'text',
    flush: 'right',
    size: 'xs'
  };

  var footer = _react.default.createElement(_flex.EuiFlexGroup, {
    responsive: false,
    justifyContent: stepsTotal > 1 ? 'spaceBetween' : 'flexEnd'
  }, stepsTotal > 1 && _react.default.createElement(_flex.EuiFlexItem, {
    grow: false
  }, _react.default.createElement("ul", {
    className: "euiTourFooter__stepList"
  }, _toConsumableArray(Array(stepsTotal).keys()).map(function (_, i) {
    var status = 'complete';

    if (step === i + 1) {
      status = 'active';
    } else if (step <= i) {
      status = 'incomplete';
    }

    return _react.default.createElement(_tour_step_indicator.EuiTourStepIndicator, {
      key: i,
      number: i + 1,
      status: status
    });
  }))), footerAction ? _react.default.createElement(_flex.EuiFlexItem, {
    grow: false
  }, footerAction) : _react.default.createElement(_flex.EuiFlexItem, {
    grow: false
  }, _react.default.createElement(_i18n.EuiI18n, {
    tokens: ['euiTourStep.endTour', 'euiTourStep.skipTour', 'euiTourStep.closeTour'],
    defaults: ['End tour', 'Skip tour', 'Close']
  }, function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 3),
        endTour = _ref3[0],
        skipTour = _ref3[1],
        closeTour = _ref3[2];

    var content = closeTour;

    if (stepsTotal > 1) {
      content = stepsTotal === step ? endTour : skipTour;
    }

    return _react.default.createElement(_button.EuiButtonEmpty, _extends({
      onClick: onFinish
    }, finishButtonProps), content);
  })));

  var hasBeacon = decoration === 'beacon';
  return _react.default.createElement(_popover.EuiPopover, _extends({
    anchorPosition: anchorPosition,
    button: children,
    closePopover: closePopover,
    isOpen: isStepOpen,
    panelClassName: classes,
    panelStyle: newStyle || style,
    offset: hasBeacon ? 10 : 0,
    arrowChildren: hasBeacon && _react.default.createElement(_beacon.EuiBeacon, {
      className: "euiTour__beacon"
    }),
    withTitle: true
  }, rest), _react.default.createElement(_popover.EuiPopoverTitle, {
    className: "euiTourHeader"
  }, _react.default.createElement(_title.EuiTitle, {
    size: "xxxs",
    className: "euiTourHeader__subtitle"
  }, _react.default.createElement("h1", null, subtitle)), _react.default.createElement(_title.EuiTitle, {
    size: "xxs",
    className: "euiTourHeader__title"
  }, _react.default.createElement("h2", null, title))), _react.default.createElement("div", {
    className: "euiTour__content"
  }, content), _react.default.createElement(_popover.EuiPopoverFooter, {
    className: "euiTourFooter"
  }, footer));
};

exports.EuiTourStep = EuiTourStep;
EuiTourStep.propTypes = {
  /**
     * Element to which the tour step popover attaches when open
     */
  children: _propTypes.default.element.isRequired,

  /**
     * Contents of the tour step popover
     */
  content: _propTypes.default.node.isRequired,

  /**
     * Step will display if set to `true`
     */
  isStepOpen: _propTypes.default.bool,

  /**
     * Sets the min-width of the tour popover,
     * set to `true` to use the default size,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  minWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),

  /**
     * Function to call for 'Skip tour' and 'End tour' actions
     */
  onFinish: _propTypes.default.func.isRequired,

  /**
     * The number of the step within the parent tour. 1-based indexing.
     */
  step: _propTypes.default.number.isRequired,

  /**
     * The total number of steps in the tour
     */
  stepsTotal: _propTypes.default.number.isRequired,

  /**
     * Optional, standard DOM `style` attribute. Passed to the EuiPopover panel.
     */
  style: _propTypes.default.any,

  /**
     * Smaller title text that appears atop each step in the tour
     */
  subtitle: _propTypes.default.string.isRequired,

  /**
     * Larger title text specific to this step
     */
  title: _propTypes.default.string.isRequired,

  /**
     * Extra visual indication of step location
     */
  decoration: _propTypes.default.oneOf(["none", "beacon"]),

  /**
     * Element to replace the 'Skip tour' link in the footer
     */
  footerAction: _propTypes.default.element,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};
EuiTourStep.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiTourStep",
  "props": {
    "anchorPosition": {
      "defaultValue": {
        "value": "'leftUp'",
        "computed": false
      },
      "required": false
    },
    "closePopover": {
      "defaultValue": {
        "value": "() => {}",
        "computed": false
      },
      "required": false
    },
    "isStepOpen": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Step will display if set to `true`"
    },
    "minWidth": {
      "defaultValue": {
        "value": "true",
        "computed": false
      },
      "type": {
        "name": "union",
        "value": [{
          "name": "bool"
        }, {
          "name": "number"
        }, {
          "name": "string"
        }]
      },
      "required": false,
      "description": "Sets the min-width of the tour popover,\nset to `true` to use the default size,\nset to `false` to not restrict the width,\nset to a number for a custom width in px,\nset to a string for a custom width in custom measurement."
    },
    "step": {
      "defaultValue": {
        "value": "1",
        "computed": false
      },
      "type": {
        "name": "number"
      },
      "required": false,
      "description": "The number of the step within the parent tour. 1-based indexing."
    },
    "decoration": {
      "defaultValue": {
        "value": "'beacon'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"none\"",
          "computed": false
        }, {
          "value": "\"beacon\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Extra visual indication of step location"
    },
    "children": {
      "type": {
        "name": "element"
      },
      "required": true,
      "description": "Element to which the tour step popover attaches when open"
    },
    "content": {
      "type": {
        "name": "node"
      },
      "required": true,
      "description": "Contents of the tour step popover"
    },
    "onFinish": {
      "type": {
        "name": "func"
      },
      "required": true,
      "description": "Function to call for 'Skip tour' and 'End tour' actions"
    },
    "stepsTotal": {
      "type": {
        "name": "number"
      },
      "required": true,
      "description": "The total number of steps in the tour"
    },
    "style": {
      "type": {
        "name": "any"
      },
      "required": false,
      "description": "Optional, standard DOM `style` attribute. Passed to the EuiPopover panel."
    },
    "subtitle": {
      "type": {
        "name": "string"
      },
      "required": true,
      "description": "Smaller title text that appears atop each step in the tour"
    },
    "title": {
      "type": {
        "name": "string"
      },
      "required": true,
      "description": "Larger title text specific to this step"
    },
    "footerAction": {
      "type": {
        "name": "element"
      },
      "required": false,
      "description": "Element to replace the 'Skip tour' link in the footer"
    },
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    }
  }
};