"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_redux_1 = require("react-redux");
var redux_1 = require("redux");
var mouse_1 = require("../state/actions/mouse");
var get_chart_type_components_1 = require("../state/selectors/get_chart_type_components");
var get_internal_cursor_pointer_1 = require("../state/selectors/get_internal_cursor_pointer");
var get_internal_is_brushing_1 = require("../state/selectors/get_internal_is_brushing");
var get_internal_is_brushing_available_1 = require("../state/selectors/get_internal_is_brushing_available");
var get_internal_is_intialized_1 = require("../state/selectors/get_internal_is_intialized");
var get_settings_specs_1 = require("../state/selectors/get_settings_specs");
var is_chart_empty_1 = require("../state/selectors/is_chart_empty");
var fast_deep_equal_1 = require("../utils/fast_deep_equal");
var ChartContainerComponent = (function (_super) {
    __extends(ChartContainerComponent, _super);
    function ChartContainerComponent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.handleMouseMove = function (_a) {
            var _b = _a.nativeEvent, offsetX = _b.offsetX, offsetY = _b.offsetY, timeStamp = _b.timeStamp;
            var _c = _this.props, isChartEmpty = _c.isChartEmpty, onPointerMove = _c.onPointerMove;
            if (isChartEmpty) {
                return;
            }
            onPointerMove({
                x: offsetX,
                y: offsetY,
            }, timeStamp);
        };
        _this.handleMouseLeave = function (_a) {
            var timeStamp = _a.nativeEvent.timeStamp;
            var _b = _this.props, isChartEmpty = _b.isChartEmpty, onPointerMove = _b.onPointerMove, isBrushing = _b.isBrushing;
            if (isChartEmpty) {
                return;
            }
            if (isBrushing) {
                return;
            }
            onPointerMove({ x: -1, y: -1 }, timeStamp);
        };
        _this.handleMouseDown = function (_a) {
            var _b = _a.nativeEvent, offsetX = _b.offsetX, offsetY = _b.offsetY, timeStamp = _b.timeStamp;
            var _c = _this.props, isChartEmpty = _c.isChartEmpty, onMouseDown = _c.onMouseDown, isBrushingAvailable = _c.isBrushingAvailable;
            if (isChartEmpty) {
                return;
            }
            if (isBrushingAvailable) {
                window.addEventListener('mouseup', _this.handleBrushEnd);
            }
            onMouseDown({
                x: offsetX,
                y: offsetY,
            }, timeStamp);
        };
        _this.handleMouseUp = function (_a) {
            var _b = _a.nativeEvent, offsetX = _b.offsetX, offsetY = _b.offsetY, timeStamp = _b.timeStamp;
            var _c = _this.props, isChartEmpty = _c.isChartEmpty, onMouseUp = _c.onMouseUp;
            if (isChartEmpty) {
                return;
            }
            onMouseUp({
                x: offsetX,
                y: offsetY,
            }, timeStamp);
        };
        _this.handleBrushEnd = function () {
            var onMouseUp = _this.props.onMouseUp;
            window.removeEventListener('mouseup', _this.handleBrushEnd);
            requestAnimationFrame(function () {
                onMouseUp({
                    x: -1,
                    y: -1,
                }, Date.now());
            });
        };
        return _this;
    }
    ChartContainerComponent.prototype.shouldComponentUpdate = function (nextProps) {
        return !fast_deep_equal_1.deepEqual(this.props, nextProps);
    };
    ChartContainerComponent.prototype.render = function () {
        var _a = this.props, initialized = _a.initialized, isChartEmpty = _a.isChartEmpty;
        if (initialized === get_internal_is_intialized_1.InitStatus.ParentSizeInvalid
            || initialized === get_internal_is_intialized_1.InitStatus.SpecNotInitialized
            || initialized === get_internal_is_intialized_1.InitStatus.ChartNotInitialized) {
            return null;
        }
        if (initialized === get_internal_is_intialized_1.InitStatus.MissingChartType || isChartEmpty === true) {
            return (react_1.default.createElement("div", { className: "echReactiveChart_unavailable" },
                react_1.default.createElement("p", null, "No data to display")));
        }
        var _b = this.props, pointerCursor = _b.pointerCursor, internalChartRenderer = _b.internalChartRenderer, getChartContainerRef = _b.getChartContainerRef, forwardStageRef = _b.forwardStageRef;
        return (react_1.default.createElement("div", { className: "echChartPointerContainer", style: {
                cursor: pointerCursor,
            }, onMouseMove: this.handleMouseMove, onMouseLeave: this.handleMouseLeave, onMouseDown: this.handleMouseDown, onMouseUp: this.handleMouseUp }, internalChartRenderer(getChartContainerRef, forwardStageRef)));
    };
    ChartContainerComponent.displayName = 'ChartContainer';
    return ChartContainerComponent;
}(react_1.default.Component));
var mapDispatchToProps = function (dispatch) {
    return redux_1.bindActionCreators({
        onPointerMove: mouse_1.onPointerMove,
        onMouseUp: mouse_1.onMouseUp,
        onMouseDown: mouse_1.onMouseDown,
    }, dispatch);
};
var mapStateToProps = function (state) {
    var status = get_internal_is_intialized_1.getInternalIsInitializedSelector(state);
    if (status !== get_internal_is_intialized_1.InitStatus.Initialized) {
        return {
            initialized: status,
            isChartEmpty: undefined,
            pointerCursor: 'default',
            isBrushingAvailable: false,
            isBrushing: false,
            internalChartRenderer: function () { return null; },
        };
    }
    return {
        initialized: status,
        isChartEmpty: is_chart_empty_1.isInternalChartEmptySelector(state),
        pointerCursor: get_internal_cursor_pointer_1.getInternalPointerCursor(state),
        isBrushingAvailable: get_internal_is_brushing_available_1.getInternalIsBrushingAvailableSelector(state),
        isBrushing: get_internal_is_brushing_1.getInternalIsBrushingSelector(state),
        internalChartRenderer: get_chart_type_components_1.getInternalChartRendererSelector(state),
        settings: get_settings_specs_1.getSettingsSpecSelector(state),
    };
};
exports.ChartContainer = react_redux_1.connect(mapStateToProps, mapDispatchToProps)(ChartContainerComponent);
//# sourceMappingURL=chart_container.js.map