/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import com.android.dex.ClassData;
import jadx.core.dex.attributes.nodes.LineAttrNode;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.ICodeNode;
import jadx.core.dex.nodes.RootNode;

public class FieldNode
extends LineAttrNode
implements ICodeNode {
    private final ClassNode parent;
    private final FieldInfo fieldInfo;
    private AccessInfo accFlags;
    private ArgType type;

    public FieldNode(ClassNode cls, ClassData.Field field) {
        this(cls, FieldInfo.fromDex(cls.dex(), field.getFieldIndex()), field.getAccessFlags());
    }

    public FieldNode(ClassNode cls, FieldInfo fieldInfo, int accessFlags) {
        this.parent = cls;
        this.fieldInfo = fieldInfo;
        this.type = fieldInfo.getType();
        this.accFlags = new AccessInfo(accessFlags, AccessInfo.AFType.FIELD);
    }

    public FieldInfo getFieldInfo() {
        return this.fieldInfo;
    }

    @Override
    public AccessInfo getAccessFlags() {
        return this.accFlags;
    }

    @Override
    public void setAccessFlags(AccessInfo accFlags) {
        this.accFlags = accFlags;
    }

    public String getName() {
        return this.fieldInfo.getName();
    }

    public String getAlias() {
        return this.fieldInfo.getAlias();
    }

    public ArgType getType() {
        return this.type;
    }

    public void setType(ArgType type) {
        this.type = type;
    }

    public ClassNode getParentClass() {
        return this.parent;
    }

    @Override
    public String typeName() {
        return "field";
    }

    @Override
    public DexNode dex() {
        return this.parent.dex();
    }

    @Override
    public RootNode root() {
        return this.parent.root();
    }

    public int hashCode() {
        return this.fieldInfo.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FieldNode other = (FieldNode)obj;
        return this.fieldInfo.equals(other.fieldInfo);
    }

    public String toString() {
        return this.fieldInfo.getDeclClass() + "." + this.fieldInfo.getName() + " :" + this.type;
    }
}

